/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.langserver;

import java.io.Serializable;
import sbt.internal.langserver.Diagnostic$;
import sbt.internal.langserver.Range;
import scala.Option;
import scala.Option$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;

public final class Diagnostic
implements Serializable {
    private final Range range;
    private final Option<Object> severity;
    private final Option<String> code;
    private final Option<String> source;
    private final String message;

    public static Diagnostic apply(Range range, long l, String string, String string2, String string3) {
        return Diagnostic$.MODULE$.apply(range, l, string, string2, string3);
    }

    public static Diagnostic apply(Range range, Option<Object> option, Option<String> option2, Option<String> option3, String string) {
        return Diagnostic$.MODULE$.apply(range, option, option2, option3, string);
    }

    public Diagnostic(Range range, Option<Object> severity, Option<String> code, Option<String> source, String message) {
        this.range = range;
        this.severity = severity;
        this.code = code;
        this.source = source;
        this.message = message;
    }

    public Range range() {
        return this.range;
    }

    public Option<Object> severity() {
        return this.severity;
    }

    public Option<String> code() {
        return this.code;
    }

    public Option<String> source() {
        return this.source;
    }

    public String message() {
        return this.message;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) return true;
        Object object = o;
        if (!(object instanceof Diagnostic)) return false;
        Diagnostic x = (Diagnostic)object;
        Range range = this.range();
        Range range2 = x.range();
        if (range == null) {
            if (range2 != null) {
                return false;
            }
        } else if (!((Object)range).equals(range2)) return false;
        Option<Object> option = this.severity();
        Option<Object> option2 = x.severity();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Option<String> option3 = this.code();
        Option<String> option4 = x.code();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        Option<String> option5 = this.source();
        Option<String> option6 = x.source();
        if (option5 == null) {
            if (option6 != null) {
                return false;
            }
        } else if (!option5.equals(option6)) return false;
        String string = this.message();
        String string2 = x.message();
        if (string == null) {
            if (string2 == null) return true;
            return false;
        } else {
            if (!string.equals(string2)) return false;
            return true;
        }
    }

    public int hashCode() {
        return 37 * (37 * (37 * (37 * (37 * (37 * (17 + Statics.anyHash((Object)"sbt.internal.langserver.Diagnostic")) + Statics.anyHash((Object)this.range())) + Statics.anyHash(this.severity())) + Statics.anyHash(this.code())) + Statics.anyHash(this.source())) + Statics.anyHash((Object)this.message()));
    }

    public String toString() {
        return new StringBuilder(20).append("Diagnostic(").append(this.range()).append(", ").append(this.severity()).append(", ").append(this.code()).append(", ").append(this.source()).append(", ").append(this.message()).append(")").toString();
    }

    private Diagnostic copy(Range range, Option<Object> severity, Option<String> code, Option<String> source, String message) {
        return new Diagnostic(range, severity, code, source, message);
    }

    private Range copy$default$1() {
        return this.range();
    }

    private Option<Object> copy$default$2() {
        return this.severity();
    }

    private Option<String> copy$default$3() {
        return this.code();
    }

    private Option<String> copy$default$4() {
        return this.source();
    }

    private String copy$default$5() {
        return this.message();
    }

    public Diagnostic withRange(Range range) {
        return this.copy(range, this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5());
    }

    public Diagnostic withSeverity(Option<Object> severity) {
        return this.copy(this.copy$default$1(), severity, this.copy$default$3(), this.copy$default$4(), this.copy$default$5());
    }

    public Diagnostic withSeverity(long severity) {
        Option option = Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)severity));
        Range range = this.copy$default$1();
        Option<String> option2 = this.copy$default$3();
        Option<String> option3 = this.copy$default$4();
        String string = this.copy$default$5();
        return this.copy(range, (Option<Object>)option, option2, option3, string);
    }

    public Diagnostic withCode(Option<String> code) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), code, this.copy$default$4(), this.copy$default$5());
    }

    public Diagnostic withCode(String code) {
        Option option = Option$.MODULE$.apply((Object)code);
        Range range = this.copy$default$1();
        Option<Object> option2 = this.copy$default$2();
        Option<String> option3 = this.copy$default$4();
        String string = this.copy$default$5();
        return this.copy(range, option2, (Option<String>)option, option3, string);
    }

    public Diagnostic withSource(Option<String> source) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), source, this.copy$default$5());
    }

    public Diagnostic withSource(String source) {
        Option option = Option$.MODULE$.apply((Object)source);
        Range range = this.copy$default$1();
        Option<Object> option2 = this.copy$default$2();
        Option<String> option3 = this.copy$default$3();
        String string = this.copy$default$5();
        return this.copy(range, option2, option3, (Option<String>)option, string);
    }

    public Diagnostic withMessage(String message) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), message);
    }
}

