/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.bsp;

import java.io.Serializable;
import java.net.URI;
import sbt.internal.bsp.BuildTargetIdentifier;
import sbt.internal.bsp.JvmEnvironmentItem$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Vector;
import scala.runtime.Statics;

public final class JvmEnvironmentItem
implements Serializable {
    private final BuildTargetIdentifier target;
    private final Vector<URI> classpath;
    private final Vector<String> jvmOptions;
    private final String workingDirectory;
    private final Map<String, String> environmentVariables;

    public static JvmEnvironmentItem apply(BuildTargetIdentifier buildTargetIdentifier, Vector<URI> vector, Vector<String> vector2, String string, Map<String, String> map) {
        return JvmEnvironmentItem$.MODULE$.apply(buildTargetIdentifier, vector, vector2, string, map);
    }

    public JvmEnvironmentItem(BuildTargetIdentifier target, Vector<URI> classpath, Vector<String> jvmOptions, String workingDirectory, Map<String, String> environmentVariables) {
        this.target = target;
        this.classpath = classpath;
        this.jvmOptions = jvmOptions;
        this.workingDirectory = workingDirectory;
        this.environmentVariables = environmentVariables;
    }

    public BuildTargetIdentifier target() {
        return this.target;
    }

    public Vector<URI> classpath() {
        return this.classpath;
    }

    public Vector<String> jvmOptions() {
        return this.jvmOptions;
    }

    public String workingDirectory() {
        return this.workingDirectory;
    }

    public Map<String, String> environmentVariables() {
        return this.environmentVariables;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) return true;
        Object object = o;
        if (!(object instanceof JvmEnvironmentItem)) return false;
        JvmEnvironmentItem x = (JvmEnvironmentItem)object;
        BuildTargetIdentifier buildTargetIdentifier = this.target();
        BuildTargetIdentifier buildTargetIdentifier2 = x.target();
        if (buildTargetIdentifier == null) {
            if (buildTargetIdentifier2 != null) {
                return false;
            }
        } else if (!((Object)buildTargetIdentifier).equals(buildTargetIdentifier2)) return false;
        Vector<URI> vector = this.classpath();
        Vector<URI> vector2 = x.classpath();
        if (vector == null) {
            if (vector2 != null) {
                return false;
            }
        } else if (!vector.equals(vector2)) return false;
        Vector<String> vector3 = this.jvmOptions();
        Vector<String> vector4 = x.jvmOptions();
        if (vector3 == null) {
            if (vector4 != null) {
                return false;
            }
        } else if (!vector3.equals(vector4)) return false;
        String string = this.workingDirectory();
        String string2 = x.workingDirectory();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        Map<String, String> map = this.environmentVariables();
        Map<String, String> map2 = x.environmentVariables();
        if (map == null) {
            if (map2 == null) return true;
            return false;
        } else {
            if (!map.equals(map2)) return false;
            return true;
        }
    }

    public int hashCode() {
        return 37 * (37 * (37 * (37 * (37 * (37 * (17 + Statics.anyHash((Object)"sbt.internal.bsp.JvmEnvironmentItem")) + Statics.anyHash((Object)this.target())) + Statics.anyHash(this.classpath())) + Statics.anyHash(this.jvmOptions())) + Statics.anyHash((Object)this.workingDirectory())) + Statics.anyHash(this.environmentVariables()));
    }

    public String toString() {
        return new StringBuilder(28).append("JvmEnvironmentItem(").append(this.target()).append(", ").append(this.classpath()).append(", ").append(this.jvmOptions()).append(", ").append(this.workingDirectory()).append(", ").append(this.environmentVariables()).append(")").toString();
    }

    private JvmEnvironmentItem copy(BuildTargetIdentifier target, Vector<URI> classpath, Vector<String> jvmOptions, String workingDirectory, Map<String, String> environmentVariables) {
        return new JvmEnvironmentItem(target, classpath, jvmOptions, workingDirectory, environmentVariables);
    }

    private BuildTargetIdentifier copy$default$1() {
        return this.target();
    }

    private Vector<URI> copy$default$2() {
        return this.classpath();
    }

    private Vector<String> copy$default$3() {
        return this.jvmOptions();
    }

    private String copy$default$4() {
        return this.workingDirectory();
    }

    private Map<String, String> copy$default$5() {
        return this.environmentVariables();
    }

    public JvmEnvironmentItem withTarget(BuildTargetIdentifier target) {
        return this.copy(target, this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5());
    }

    public JvmEnvironmentItem withClasspath(Vector<URI> classpath) {
        return this.copy(this.copy$default$1(), classpath, this.copy$default$3(), this.copy$default$4(), this.copy$default$5());
    }

    public JvmEnvironmentItem withJvmOptions(Vector<String> jvmOptions) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), jvmOptions, this.copy$default$4(), this.copy$default$5());
    }

    public JvmEnvironmentItem withWorkingDirectory(String workingDirectory) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), workingDirectory, this.copy$default$5());
    }

    public JvmEnvironmentItem withEnvironmentVariables(Map<String, String> environmentVariables) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), environmentVariables);
    }
}

