/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.bsp;

import java.io.Serializable;
import java.net.URI;
import sbt.internal.bsp.BuildTargetIdentifier;
import sbt.internal.bsp.JavacOptionsItem$;
import scala.Option;
import scala.Option$;
import scala.collection.immutable.Vector;
import scala.runtime.Statics;

public final class JavacOptionsItem
implements Serializable {
    private final BuildTargetIdentifier target;
    private final Vector<String> options;
    private final Vector<URI> classpath;
    private final Option<URI> classDirectory;

    public static JavacOptionsItem apply(BuildTargetIdentifier buildTargetIdentifier, Vector<String> vector, Vector<URI> vector2, Option<URI> option) {
        return JavacOptionsItem$.MODULE$.apply(buildTargetIdentifier, vector, vector2, option);
    }

    public static JavacOptionsItem apply(BuildTargetIdentifier buildTargetIdentifier, Vector<String> vector, Vector<URI> vector2, URI uRI) {
        return JavacOptionsItem$.MODULE$.apply(buildTargetIdentifier, vector, vector2, uRI);
    }

    public JavacOptionsItem(BuildTargetIdentifier target, Vector<String> options, Vector<URI> classpath, Option<URI> classDirectory) {
        this.target = target;
        this.options = options;
        this.classpath = classpath;
        this.classDirectory = classDirectory;
    }

    public BuildTargetIdentifier target() {
        return this.target;
    }

    public Vector<String> options() {
        return this.options;
    }

    public Vector<URI> classpath() {
        return this.classpath;
    }

    public Option<URI> classDirectory() {
        return this.classDirectory;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) return true;
        Object object = o;
        if (!(object instanceof JavacOptionsItem)) return false;
        JavacOptionsItem x = (JavacOptionsItem)object;
        BuildTargetIdentifier buildTargetIdentifier = this.target();
        BuildTargetIdentifier buildTargetIdentifier2 = x.target();
        if (buildTargetIdentifier == null) {
            if (buildTargetIdentifier2 != null) {
                return false;
            }
        } else if (!((Object)buildTargetIdentifier).equals(buildTargetIdentifier2)) return false;
        Vector<String> vector = this.options();
        Vector<String> vector2 = x.options();
        if (vector == null) {
            if (vector2 != null) {
                return false;
            }
        } else if (!vector.equals(vector2)) return false;
        Vector<URI> vector3 = this.classpath();
        Vector<URI> vector4 = x.classpath();
        if (vector3 == null) {
            if (vector4 != null) {
                return false;
            }
        } else if (!vector3.equals(vector4)) return false;
        Option<URI> option = this.classDirectory();
        Option<URI> option2 = x.classDirectory();
        if (option == null) {
            if (option2 == null) return true;
            return false;
        } else {
            if (!option.equals(option2)) return false;
            return true;
        }
    }

    public int hashCode() {
        return 37 * (37 * (37 * (37 * (37 * (17 + Statics.anyHash((Object)"sbt.internal.bsp.JavacOptionsItem")) + Statics.anyHash((Object)this.target())) + Statics.anyHash(this.options())) + Statics.anyHash(this.classpath())) + Statics.anyHash(this.classDirectory()));
    }

    public String toString() {
        return new StringBuilder(24).append("JavacOptionsItem(").append(this.target()).append(", ").append(this.options()).append(", ").append(this.classpath()).append(", ").append(this.classDirectory()).append(")").toString();
    }

    private JavacOptionsItem copy(BuildTargetIdentifier target, Vector<String> options, Vector<URI> classpath, Option<URI> classDirectory) {
        return new JavacOptionsItem(target, options, classpath, classDirectory);
    }

    private BuildTargetIdentifier copy$default$1() {
        return this.target();
    }

    private Vector<String> copy$default$2() {
        return this.options();
    }

    private Vector<URI> copy$default$3() {
        return this.classpath();
    }

    private Option<URI> copy$default$4() {
        return this.classDirectory();
    }

    public JavacOptionsItem withTarget(BuildTargetIdentifier target) {
        return this.copy(target, this.copy$default$2(), this.copy$default$3(), this.copy$default$4());
    }

    public JavacOptionsItem withOptions(Vector<String> options) {
        return this.copy(this.copy$default$1(), options, this.copy$default$3(), this.copy$default$4());
    }

    public JavacOptionsItem withClasspath(Vector<URI> classpath) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), classpath, this.copy$default$4());
    }

    public JavacOptionsItem withClassDirectory(Option<URI> classDirectory) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), classDirectory);
    }

    public JavacOptionsItem withClassDirectory(URI classDirectory) {
        Option option = Option$.MODULE$.apply((Object)classDirectory);
        BuildTargetIdentifier buildTargetIdentifier = this.copy$default$1();
        Vector<String> vector = this.copy$default$2();
        Vector<URI> vector2 = this.copy$default$3();
        return this.copy(buildTargetIdentifier, vector, vector2, (Option<URI>)option);
    }
}

