/*
 * Decompiled with CFR 0.152.
 */
package lmcoursier.internal.shaded.coursier.cache;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import lmcoursier.internal.shaded.coursier.cache.ArchiveCache$;
import lmcoursier.internal.shaded.coursier.cache.ArchiveType;
import lmcoursier.internal.shaded.coursier.cache.ArtifactError;
import lmcoursier.internal.shaded.coursier.cache.Cache;
import lmcoursier.internal.shaded.coursier.cache.CacheLocks$;
import lmcoursier.internal.shaded.coursier.cache.CacheLogger;
import lmcoursier.internal.shaded.coursier.cache.CacheLogger$;
import lmcoursier.internal.shaded.coursier.cache.FileCache$;
import lmcoursier.internal.shaded.coursier.cache.UnArchiver;
import lmcoursier.internal.shaded.coursier.cache.UnArchiver$;
import lmcoursier.internal.shaded.coursier.paths.CachePath;
import lmcoursier.internal.shaded.coursier.util.Artifact;
import lmcoursier.internal.shaded.coursier.util.Monad$ops$;
import lmcoursier.internal.shaded.coursier.util.Sync;
import lmcoursier.internal.shaded.coursier.util.Task;
import scala.;
import scala.$less$colon$less$;
import scala.Array;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\tmc\u0001\u0002\u0014(\u00051B\u0001b\u0011\u0001\u0003\u0006\u0004%\t\u0001\u0012\u0005\t\u001b\u0002\u0011\t\u0011)A\u0005\u000b\"A\u0001\u0006\u0001BC\u0002\u0013\u0005a\n\u0003\u0005b\u0001\t\u0005\t\u0015!\u0003P\u0011!\u0011\u0007A!b\u0001\n\u0003\u0019\u0007\u0002C4\u0001\u0005\u0003\u0005\u000b\u0011\u00023\t\u0011!\u0004!Q1A\u0005\u0004%D\u0001\u0002\u001d\u0001\u0003\u0002\u0003\u0006IA\u001b\u0005\u0006c\u0002!\tA\u001d\u0005\u0006c\u0002!\t!\u001f\u0005\u0006{\u0002!I!\u001b\u0005\u0006}\u0002!Ia \u0005\b\u0003\u0017\u0001A\u0011AA\u0007\u0011\u001d\t)\u0003\u0001C\u0001\u0003OAq!a\f\u0001\t\u0003\t\t\u0004C\u0004\u00026\u0001!\t!a\u000e\t\u000f\u0005m\u0002\u0001\"\u0001\u0002>!9\u0011\u0011\t\u0001\u0005\u0002\u0005\r\u0003bBA$\u0001\u0011\u0005\u0013\u0011\n\u0005\b\u0003/\u0002A\u0011IA-\u0011\u001d\t)\u0007\u0001C!\u0003OBq!a\u001b\u0001\t\u0003\ni\u0007C\u0004\u0002v\u0001!I!a\u001e\t\u000f\u0005}\u0004\u0001\"\u0011\u0002\u0002\"9\u00111\u0011\u0001\u0005B\u0005\u0015\u0005bBAD\u0001\u0011\u0005\u0013\u0011\u0012\u0005\b\u0003\u001f\u0003A\u0011IAI\u000f\u001d\t)j\nE\u0001\u0003/3aAJ\u0014\t\u0002\u0005e\u0005BB9\u001e\t\u0003\ty\nC\u0004\u0002\"v!\t!a)\t\u0013\u0005eV$%A\u0005\u0002\u0005m\u0006bBAq;\u0011%\u00111\u001d\u0005\b\u0003_lB\u0011BAy\u0011\u001d\t\t+\bC\u0001\u0005\u0017Aq!!)\u001e\t\u0003\u0011\t\u0003C\u0005\u0003>u\t\t\u0011\"\u0003\u0003@\ta\u0011I]2iSZ,7)Y2iK*\u0019\u0001Fa\u0015\u0002\u000b\r\f7\r[3\u000b\u0007)\u0012I&\u0001\u0005d_V\u00148/[3s\u0007\u0001)\"!L+\u0014\t\u0001qCg\u000e\t\u0003_Ij\u0011\u0001\r\u0006\u0002c\u0005)1oY1mC&\u00111\u0007\r\u0002\u0007\u0003:L(+\u001a4\u0011\u0005=*\u0014B\u0001\u001c1\u0005\u001d\u0001&o\u001c3vGR\u0004\"\u0001\u000f!\u000f\u0005erdB\u0001\u001e>\u001b\u0005Y$B\u0001\u001f,\u0003\u0019a$o\\8u}%\t\u0011'\u0003\u0002@a\u00059\u0001/Y2lC\u001e,\u0017BA!C\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\ty\u0004'\u0001\u0005m_\u000e\fG/[8o+\u0005)\u0005C\u0001$L\u001b\u00059%B\u0001%J\u0003\tIwNC\u0001K\u0003\u0011Q\u0017M^1\n\u00051;%\u0001\u0002$jY\u0016\f\u0011\u0002\\8dCRLwN\u001c\u0011\u0016\u0003=\u00032\u0001U)T\u001b\u00059\u0013B\u0001*(\u0005\u0015\u0019\u0015m\u00195f!\t!V\u000b\u0004\u0001\u0005\u000bY\u0003!\u0019A,\u0003\u0003\u0019+\"\u0001W0\u0012\u0005ec\u0006CA\u0018[\u0013\tY\u0006GA\u0004O_RD\u0017N\\4\u0011\u0005=j\u0016B\u000101\u0005\r\te.\u001f\u0003\u0006AV\u0013\r\u0001\u0017\u0002\u0005?\u0012\"\u0013'\u0001\u0004dC\u000eDW\rI\u0001\u000bk:\f%o\u00195jm\u0016\u0014X#\u00013\u0011\u0005A+\u0017B\u00014(\u0005))f.\u0011:dQ&4XM]\u0001\fk:\f%o\u00195jm\u0016\u0014\b%\u0001\u0003ts:\u001cW#\u00016\u0011\u0007-t7+D\u0001m\u0015\ti\u0017&\u0001\u0003vi&d\u0017BA8m\u0005\u0011\u0019\u0016P\\2\u0002\u000bMLhn\u0019\u0011\u0002\rqJg.\u001b;?)\u0011\u0019ho\u001e=\u0015\u0005Q,\bc\u0001)\u0001'\")\u0001.\u0003a\u0002U\")1)\u0003a\u0001\u000b\")\u0001&\u0003a\u0001\u001f\")!-\u0003a\u0001IR\u0011!\u0010 \u000b\u0003inDQ\u0001\u001b\u0006A\u0004)DQa\u0011\u0006A\u0002\u0015\u000b\u0011aU\u0001\tY>\u001c\u0017\r\u001c#jeR\u0019Q)!\u0001\t\u000f\u0005\rA\u00021\u0001\u0002\u0006\u0005A\u0011M\u001d;jM\u0006\u001cG\u000fE\u0002l\u0003\u000fI1!!\u0003m\u0005!\t%\u000f^5gC\u000e$\u0018aC4fi&3W\t_5tiN$B!a\u0004\u0002$A!A+VA\t!\u001dA\u00141CA\f\u0003;I1!!\u0006C\u0005\u0019)\u0015\u000e\u001e5feB\u0019\u0001+!\u0007\n\u0007\u0005mqEA\u0007BeRLg-Y2u\u000bJ\u0014xN\u001d\t\u0005_\u0005}Q)C\u0002\u0002\"A\u0012aa\u00149uS>t\u0007bBA\u0002\u001b\u0001\u0007\u0011QA\u0001\u0004O\u0016$H\u0003BA\u0015\u0003[\u0001B\u0001V+\u0002,A1\u0001(a\u0005\u0002\u0018\u0015Cq!a\u0001\u000f\u0001\u0004\t)!\u0001\u0007xSRDGj\\2bi&|g\u000eF\u0002u\u0003gAQaQ\bA\u0002\u0015\u000b\u0011b^5uQ\u000e\u000b7\r[3\u0015\u0007Q\fI\u0004C\u0003)!\u0001\u0007q*\u0001\bxSRDWK\\!sG\"Lg/\u001a:\u0015\u0007Q\fy\u0004C\u0003c#\u0001\u0007A-\u0001\u0005xSRD7+\u001f8d)\r!\u0018Q\t\u0005\u0006QJ\u0001\rA[\u0001\ti>\u001cFO]5oOR\u0011\u00111\n\t\u0005\u0003\u001b\n\u0019&\u0004\u0002\u0002P)\u0019\u0011\u0011K%\u0002\t1\fgnZ\u0005\u0005\u0003+\nyE\u0001\u0004TiJLgnZ\u0001\tG\u0006tW)];bYR!\u00111LA1!\ry\u0013QL\u0005\u0004\u0003?\u0002$a\u0002\"p_2,\u0017M\u001c\u0005\u0007\u0003G\"\u0002\u0019\u0001/\u0002\u0007=\u0014'.\u0001\u0004fcV\fGn\u001d\u000b\u0005\u00037\nI\u0007\u0003\u0004\u0002dU\u0001\r\u0001X\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011q\u000e\t\u0004_\u0005E\u0014bAA:a\t\u0019\u0011J\u001c;\u0002\u000bQ,\b\u000f\\3\u0016\u0005\u0005e\u0004cB\u0018\u0002|\u0015{EM[\u0005\u0004\u0003{\u0002$A\u0002+va2,G'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003\u0017\nA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a\u001c\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u0019A,a#\t\u000f\u00055%\u00041\u0001\u0002p\u0005\ta.\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BA&\u0003'Cq!!$\u001c\u0001\u0004\ty'\u0001\u0007Be\u000eD\u0017N^3DC\u000eDW\r\u0005\u0002Q;M!QDLAN!\r1\u0015QT\u0005\u0003\u0003\u001e#\"!a&\u0002\u000b\u0005\u0004\b\u000f\\=\u0016\t\u0005\u0015\u0016Q\u0016\u000b\u0003\u0003O#B!!+\u00026B!\u0001\u000bAAV!\r!\u0016Q\u0016\u0003\u0007-~\u0011\r!a,\u0016\u0007a\u000b\t\fB\u0004\u00024\u00065&\u0019\u0001-\u0003\t}#CE\r\u0005\t{~\u0001\n\u0011q\u0001\u00028B!1N\\AV\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\nT\u0003BA_\u00037$\"!a0+\t\u0005\u0005\u0017\u0011\u001a\t\u0005W:\f\u0019\rE\u0002l\u0003\u000bL1!a2m\u0005\u0011!\u0016m]6,\u0005\u0005-\u0007\u0003BAg\u0003/l!!a4\u000b\t\u0005E\u00171[\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!61\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u00033\fyMA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016$aA\u0016\u0011C\u0002\u0005uWc\u0001-\u0002`\u00129\u00111WAn\u0005\u0004A\u0016a\u00043fY\u0016$XMU3dkJ\u001c\u0018N^3\u0015\t\u0005\u0015\u00181\u001e\t\u0004_\u0005\u001d\u0018bAAua\t!QK\\5u\u0011\u0019\ti/\ta\u0001\u000b\u0006\ta-A\u0006be\u000eD\u0017N^3UsB,G\u0003BAz\u0003s\u00042\u0001UA{\u0013\r\t9p\n\u0002\f\u0003J\u001c\u0007.\u001b<f)f\u0004X\rC\u0004\u0002|\n\u0002\r!!@\u0002\u0007U\u0014H\u000e\u0005\u0003\u0002\u0000\n\u001da\u0002\u0002B\u0001\u0005\u0007\u0001\"A\u000f\u0019\n\u0007\t\u0015\u0001'\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003+\u0012IAC\u0002\u0003\u0006A*BA!\u0004\u0003\u0016Q!!q\u0002B\u0010)\u0011\u0011\tBa\u0007\u0011\tA\u0003!1\u0003\t\u0004)\nUAA\u0002,$\u0005\u0004\u00119\"F\u0002Y\u00053!a\u0001\u0019B\u000b\u0005\u0004A\u0006B\u00025$\u0001\b\u0011i\u0002\u0005\u0003l]\nM\u0001\"B\"$\u0001\u0004)U\u0003\u0002B\u0012\u0005W!\u0002B!\n\u00036\t]\"1\b\u000b\u0005\u0005O\u0011\t\u0004\u0005\u0003Q\u0001\t%\u0002c\u0001+\u0003,\u00111a\u000b\nb\u0001\u0005[)2\u0001\u0017B\u0018\t\u0019\u0001'1\u0006b\u00011\"1\u0001\u000e\na\u0002\u0005g\u0001Ba\u001b8\u0003*!)1\t\na\u0001\u000b\"1\u0001\u0006\na\u0001\u0005s\u0001B\u0001U)\u0003*!)!\r\na\u0001I\u0006aqO]5uKJ+\u0007\u000f\\1dKR\u0011!\u0011\t\t\u0005\u0003\u001b\u0012\u0019%\u0003\u0003\u0003F\u0005=#AB(cU\u0016\u001cG/\u0001\u0006m[\u000e|WO]:jKJT!Aa\u0012\u0002\u0011%tG/\u001a:oC2TAAa\u0013\u0003J\u000511\u000f[1eK\u0012TAAa\u0014\u0003N)\u0019!F!\u0015\u000b\u0005\t\u001d#\u0002\u0002B&\u0005+RAAa\u0014\u0003X\u0001")
public final class ArchiveCache<F>
implements Product,
Serializable {
    private final File location;
    private final Cache<F> cache;
    private final UnArchiver unArchiver;
    private final Sync<F> sync;

    public static <F> ArchiveCache<F> apply(File location, Cache<F> cache, UnArchiver unArchiver, Sync<F> sync) {
        return ArchiveCache$.MODULE$.apply(location, cache, unArchiver, sync);
    }

    public static <F> ArchiveCache<F> apply(File location, Sync<F> sync) {
        return ArchiveCache$.MODULE$.apply(location, sync);
    }

    public static <F> Sync<Task> apply$default$1() {
        return ArchiveCache$.MODULE$.apply$default$1();
    }

    public static <F> ArchiveCache<F> apply(Sync<F> S) {
        return ArchiveCache$.MODULE$.apply(S);
    }

    public Iterator<Object> productIterator() {
        return Product.productIterator$((Product)this);
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public File location() {
        return this.location;
    }

    public Cache<F> cache() {
        return this.cache;
    }

    public UnArchiver unArchiver() {
        return this.unArchiver;
    }

    public Sync<F> sync() {
        return this.sync;
    }

    private Sync<F> S() {
        return this.sync();
    }

    private File localDir(Artifact artifact) {
        return CachePath.localFile(artifact.url(), this.location(), (String)artifact.authentication().map((Function1 & Serializable)x$1 -> x$1.user()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), true);
    }

    public F getIfExists(Artifact artifact) {
        File dir = this.localDir(artifact);
        ArchiveType archiveType0 = ArchiveCache$.MODULE$.coursier$cache$ArchiveCache$$archiveType(artifact.url());
        Object dirTask = Monad$ops$.MODULE$.toAllMonadOps(this.S().delay((JFunction0.mcZ.sp & Serializable)() -> dir.exists()), this.sync()).map((Function1 & Serializable)x0$1 -> ArchiveCache.$anonfun$getIfExists$2(dir, BoxesRunTime.unboxToBoolean((Object)x0$1)));
        if (archiveType0.singleFile()) {
            return Monad$ops$.MODULE$.toAllMonadOps(dirTask, this.sync()).flatMap((Function1 & Serializable)x0$2 -> {
                Right right;
                Option option;
                Either either = x0$2;
                if (either instanceof Right && (option = (Option)(right = (Right)either).value()) instanceof Some) {
                    Some some = (Some)option;
                    File dir = (File)some.value();
                    return this.S().delay((Function0 & Serializable)() -> {
                        Object object;
                        File[] fileArray = dir.listFiles();
                        if (fileArray != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)fileArray)) && new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1) == 0) {
                            File f = (File)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
                            return new Right((Object)new Some((Object)f));
                        }
                        return new Right((Object)new Some((Object)dir));
                    });
                }
                return this.S().point(either);
            });
        }
        return dirTask;
    }

    public F get(Artifact artifact) {
        File dir = this.localDir(artifact);
        ArchiveType archiveType0 = ArchiveCache$.MODULE$.coursier$cache$ArchiveCache$$archiveType(artifact.url());
        Object downloadAndExtract = Monad$ops$.MODULE$.toAllMonadOps(((CacheLogger)this.cache().loggerOpt().getOrElse((Function0 & Serializable)() -> CacheLogger$.MODULE$.nop())).using().apply(this.cache().file(artifact).run(), this.sync()), this.sync()).flatMap((Function1 & Serializable)x0$1 -> {
            Either either = x0$1;
            if (either instanceof Left) {
                Left left = (Left)either;
                ArtifactError err = (ArtifactError)left.value();
                return this.S().point(new Left((Object)err));
            }
            if (either instanceof Right) {
                Right right = (Right)either;
                File f = (File)right.value();
                return this.extract$1(f, false, dir, archiveType0);
            }
            throw new MatchError((Object)either);
        });
        Object dirTask = Monad$ops$.MODULE$.toAllMonadOps(this.S().delay((JFunction0.mcZ.sp & Serializable)() -> dir.exists()), this.sync()).flatMap((Function1 & Serializable)x0$2 -> ArchiveCache.$anonfun$get$7(this, artifact, dir, downloadAndExtract, archiveType0, BoxesRunTime.unboxToBoolean((Object)x0$2)));
        if (archiveType0.singleFile()) {
            return Monad$ops$.MODULE$.toAllMonadOps(dirTask, this.sync()).flatMap((Function1 & Serializable)x0$4 -> {
                Either either = x0$4;
                if (either instanceof Right) {
                    Right right = (Right)either;
                    File dir = (File)right.value();
                    return this.S().delay((Function0 & Serializable)() -> {
                        Object object;
                        File[] fileArray = dir.listFiles();
                        if (fileArray != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)fileArray)) && new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1) == 0) {
                            File f = (File)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
                            return new Right((Object)f);
                        }
                        return new Right((Object)dir);
                    });
                }
                return this.S().point(either);
            });
        }
        return dirTask;
    }

    public ArchiveCache<F> withLocation(File location) {
        return new ArchiveCache<F>(location, this.cache(), this.unArchiver(), this.sync());
    }

    public ArchiveCache<F> withCache(Cache<F> cache) {
        return new ArchiveCache<F>(this.location(), cache, this.unArchiver(), this.sync());
    }

    public ArchiveCache<F> withUnArchiver(UnArchiver unArchiver) {
        return new ArchiveCache<F>(this.location(), this.cache(), unArchiver, this.sync());
    }

    public ArchiveCache<F> withSync(Sync<F> sync) {
        return new ArchiveCache<F>(this.location(), this.cache(), this.unArchiver(), sync);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("ArchiveCache(");
        b.append(String.valueOf(this.location()));
        b.append(", ");
        b.append(String.valueOf(this.cache()));
        b.append(", ");
        b.append(String.valueOf(this.unArchiver()));
        b.append(", ");
        b.append(String.valueOf(this.sync()));
        b.append(")");
        return b.toString();
    }

    public boolean canEqual(Object obj) {
        return obj != null && obj instanceof ArchiveCache && true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!this.canEqual(obj)) return false;
        ArchiveCache other = (ArchiveCache)obj;
        if (!true) return false;
        File file = this.location();
        File file2 = other.location();
        if (file == null) {
            if (file2 != null) {
                return false;
            }
        } else if (!((Object)file).equals(file2)) return false;
        Cache<F> cache = this.cache();
        Cache<F> cache2 = other.cache();
        if (cache == null) {
            if (cache2 != null) {
                return false;
            }
        } else if (!cache.equals(cache2)) return false;
        UnArchiver unArchiver = this.unArchiver();
        UnArchiver unArchiver2 = other.unArchiver();
        if (unArchiver == null) {
            if (unArchiver2 != null) {
                return false;
            }
        } else if (!unArchiver.equals(unArchiver2)) return false;
        Sync<F> sync = this.sync();
        Sync<F> sync2 = other.sync();
        if (sync == null) {
            if (sync2 == null) return true;
            return false;
        } else {
            if (!sync.equals(sync2)) return false;
            return true;
        }
    }

    public int hashCode() {
        int code = 17 + Statics.anyHash((Object)"ArchiveCache");
        code = 37 * code + Statics.anyHash((Object)this.location());
        code = 37 * code + Statics.anyHash(this.cache());
        code = 37 * code + Statics.anyHash((Object)this.unArchiver());
        code = 37 * code + Statics.anyHash(this.sync());
        return 37 * code;
    }

    private Tuple4<File, Cache<F>, UnArchiver, Sync<F>> tuple() {
        return new Tuple4((Object)this.location(), this.cache(), (Object)this.unArchiver(), this.sync());
    }

    public String productPrefix() {
        return "ArchiveCache";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this.location();
            }
            case 1: {
                return this.cache();
            }
            case 2: {
                return this.unArchiver();
            }
            case 3: {
                return this.sync();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(n2));
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "location";
            }
            case 1: {
                return "cache";
            }
            case 2: {
                return "unArchiver";
            }
            case 3: {
                return "sync";
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(n2));
    }

    public static final /* synthetic */ Either $anonfun$getIfExists$2(File dir$1, boolean x0$1) {
        boolean bl = x0$1;
        if (bl) {
            return new Right((Object)new Some((Object)dir$1));
        }
        if (!bl) {
            return new Right((Object)None$.MODULE$);
        }
        throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
    }

    private static final void moveToDest$1(File tmp$1, File dir$3) {
        Files.move(tmp$1.toPath(), dir$3.toPath(), StandardCopyOption.ATOMIC_MOVE);
    }

    private final Object extract$1(File f, boolean deleteDest, File dir$3, ArchiveType archiveType0$1) {
        return this.S().delay((Function0 & Serializable)() -> {
            CacheLocks$.MODULE$.withLockOr(this.location(), dir$3, (JFunction0.mcV.sp & Serializable)() -> {
                if (deleteDest || !dir$3.exists()) {
                    File tmp = CachePath.temporaryFile(dir$3);
                    ArchiveCache$.MODULE$.coursier$cache$ArchiveCache$$deleteRecursive(tmp);
                    Files.createDirectories(tmp.toPath(), new FileAttribute[0]);
                    this.unArchiver().extract(archiveType0$1, f, tmp, false);
                    FileTime lastModifiedTime = Files.getLastModifiedTime(f.toPath(), new LinkOption[0]);
                    Files.setLastModifiedTime(tmp.toPath(), lastModifiedTime);
                    if (dir$3.exists()) {
                        if (deleteDest) {
                            ArchiveCache$.MODULE$.coursier$cache$ArchiveCache$$deleteRecursive(dir$3);
                            ArchiveCache.moveToDest$1(tmp, dir$3);
                            return;
                        }
                        ArchiveCache$.MODULE$.coursier$cache$ArchiveCache$$deleteRecursive(tmp);
                        return;
                    }
                    ArchiveCache.moveToDest$1(tmp, dir$3);
                    return;
                }
            }, (Function0 & Serializable)() -> {
                Thread.sleep(50L);
                return None$.MODULE$;
            });
            return new Right((Object)dir$3);
        });
    }

    public static final /* synthetic */ Object $anonfun$get$7(ArchiveCache $this, Artifact artifact$1, File dir$3, Object downloadAndExtract$1, ArchiveType archiveType0$1, boolean x0$2) {
        boolean bl = x0$2;
        if (bl) {
            if (artifact$1.changing()) {
                return Monad$ops$.MODULE$.toAllMonadOps(((CacheLogger)$this.cache().loggerOpt().getOrElse((Function0 & Serializable)() -> CacheLogger$.MODULE$.nop())).using().apply($this.cache().file(artifact$1).run(), $this.sync()), $this.sync()).flatMap((Function1 & Serializable)x0$3 -> {
                    Either either = x0$3;
                    if (either instanceof Left) {
                        Left left = (Left)either;
                        ArtifactError err = (ArtifactError)left.value();
                        return $this.S().point(new Left((Object)err));
                    }
                    if (either instanceof Right) {
                        Right right = (Right)either;
                        File f = (File)right.value();
                        FileTime archiveLastModifiedTime = Files.getLastModifiedTime(f.toPath(), new LinkOption[0]);
                        FileTime dirLastModifiedTime = Files.getLastModifiedTime(dir$3.toPath(), new LinkOption[0]);
                        FileTime fileTime = archiveLastModifiedTime;
                        FileTime fileTime2 = dirLastModifiedTime;
                        if (!(fileTime != null ? !((Object)fileTime).equals(fileTime2) : fileTime2 != null)) {
                            return $this.S().point(new Right((Object)dir$3));
                        }
                        return $this.extract$1(f, true, dir$3, archiveType0$1);
                    }
                    throw new MatchError((Object)either);
                });
            }
            return $this.S().point(new Right((Object)dir$3));
        }
        if (!bl) {
            return downloadAndExtract$1;
        }
        throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
    }

    public ArchiveCache(File location, Cache<F> cache, UnArchiver unArchiver, Sync<F> sync) {
        this.location = location;
        this.cache = cache;
        this.unArchiver = unArchiver;
        this.sync = sync;
        Product.$init$((Product)this);
    }

    public ArchiveCache(File location, Sync<F> sync) {
        this(location, FileCache$.MODULE$.apply(sync), UnArchiver$.MODULE$.default(), sync);
    }
}

