/*
 * Decompiled with CFR 0.152.
 */
package org.jline.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jline.terminal.Size;
import org.jline.terminal.Terminal;
import org.jline.terminal.impl.AbstractTerminal;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;
import org.jline.utils.InfoCmp;

public class Status {
    protected final AbstractTerminal terminal;
    protected final boolean supported;
    protected List<AttributedString> oldLines = Collections.emptyList();
    protected List<AttributedString> linesToRestore = Collections.emptyList();
    protected int rows;
    protected int columns;
    protected boolean force;
    protected boolean suspended = false;
    protected AttributedString borderString;
    protected int border = 0;

    public static Status getStatus(Terminal terminal) {
        return Status.getStatus(terminal, true);
    }

    public static Status getStatus(Terminal terminal, boolean bl) {
        return terminal instanceof AbstractTerminal ? ((AbstractTerminal)terminal).getStatus(bl) : null;
    }

    public Status(AbstractTerminal abstractTerminal) {
        this.terminal = Objects.requireNonNull(abstractTerminal, "terminal can not be null");
        boolean bl = this.supported = abstractTerminal.getStringCapability(InfoCmp.Capability.change_scroll_region) != null && abstractTerminal.getStringCapability(InfoCmp.Capability.save_cursor) != null && abstractTerminal.getStringCapability(InfoCmp.Capability.restore_cursor) != null && abstractTerminal.getStringCapability(InfoCmp.Capability.cursor_address) != null;
        if (this.supported) {
            char c = '\u2500';
            AttributedStringBuilder attributedStringBuilder = new AttributedStringBuilder();
            for (int i = 0; i < 200; ++i) {
                attributedStringBuilder.append(c);
            }
            this.borderString = attributedStringBuilder.toAttributedString();
            this.resize();
        }
    }

    public void setBorder(boolean bl) {
        this.border = bl ? 1 : 0;
    }

    public void resize() {
        Size size = this.terminal.getSize();
        this.rows = size.getRows();
        this.columns = size.getColumns();
        this.force = true;
    }

    public void reset() {
        this.force = true;
    }

    public void hardReset() {
        if (this.suspended) {
            return;
        }
        ArrayList<AttributedString> arrayList = new ArrayList<AttributedString>(this.oldLines);
        int n = this.border;
        this.update(null);
        this.border = n;
        this.update(arrayList);
    }

    public void redraw() {
        if (this.suspended) {
            return;
        }
        this.update(this.oldLines);
    }

    public void clear() {
        this.privateClear(this.oldLines.size());
    }

    private void clearAll() {
        int n = this.border;
        this.border = 0;
        this.privateClear(this.oldLines.size() + n);
    }

    private void privateClear(int n) {
        ArrayList<AttributedString> arrayList = new ArrayList<AttributedString>();
        for (int i = 0; i < n; ++i) {
            arrayList.add(new AttributedString(""));
        }
        if (!arrayList.isEmpty()) {
            this.update(arrayList);
        }
    }

    public void update(List<AttributedString> list) {
        int n;
        if (!this.supported) {
            return;
        }
        if (list == null) {
            list = Collections.emptyList();
        }
        if (this.suspended) {
            this.linesToRestore = new ArrayList<AttributedString>(list);
            return;
        }
        if (list.isEmpty()) {
            this.clearAll();
        }
        if (this.oldLines.equals(list) && !this.force) {
            return;
        }
        int n2 = list.size() + (list.size() == 0 ? 0 : this.border);
        int n3 = n2 - this.oldLines.size() - (this.oldLines.size() == 0 ? 0 : this.border);
        if (n3 > 0) {
            for (n = 0; n < n3; ++n) {
                this.terminal.puts(InfoCmp.Capability.cursor_down, new Object[0]);
            }
            for (n = 0; n < n3; ++n) {
                this.terminal.puts(InfoCmp.Capability.cursor_up, new Object[0]);
            }
        }
        this.terminal.puts(InfoCmp.Capability.save_cursor, new Object[0]);
        this.terminal.puts(InfoCmp.Capability.cursor_address, this.rows - n2, 0);
        if (!this.terminal.puts(InfoCmp.Capability.clr_eos, new Object[0])) {
            for (n = this.rows - n2; n < this.rows; ++n) {
                this.terminal.puts(InfoCmp.Capability.cursor_address, n, 0);
                this.terminal.puts(InfoCmp.Capability.clr_eol, new Object[0]);
            }
        }
        if (this.border == 1 && list.size() > 0) {
            this.terminal.puts(InfoCmp.Capability.cursor_address, this.rows - n2, 0);
            this.borderString.columnSubSequence(0, this.columns).print(this.terminal);
        }
        for (n = 0; n < list.size(); ++n) {
            this.terminal.puts(InfoCmp.Capability.cursor_address, this.rows - list.size() + n, 0);
            if (list.get(n).length() > this.columns) {
                AttributedStringBuilder attributedStringBuilder = new AttributedStringBuilder();
                attributedStringBuilder.append(list.get(n).substring(0, this.columns - 3)).append("...", new AttributedStyle(AttributedStyle.INVERSE));
                attributedStringBuilder.toAttributedString().columnSubSequence(0, this.columns).print(this.terminal);
                continue;
            }
            list.get(n).columnSubSequence(0, this.columns).print(this.terminal);
        }
        this.terminal.puts(InfoCmp.Capability.change_scroll_region, 0, this.rows - 1 - n2);
        this.terminal.puts(InfoCmp.Capability.restore_cursor, new Object[0]);
        this.terminal.flush();
        this.oldLines = new ArrayList<AttributedString>(list);
        this.force = false;
    }

    public void suspend() {
        if (this.suspended) {
            return;
        }
        this.linesToRestore = new ArrayList<AttributedString>(this.oldLines);
        int n = this.border;
        this.update(null);
        this.border = n;
        this.suspended = true;
    }

    public void restore() {
        if (!this.suspended) {
            return;
        }
        this.suspended = false;
        this.update(this.linesToRestore);
        this.linesToRestore = Collections.emptyList();
    }

    public int size() {
        return this.oldLines.size() + this.border;
    }
}

