/*
 * Decompiled with CFR 0.152.
 */
package org.jline.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.util.Objects;
import org.jline.utils.Log;

public final class Signals {
    private Signals() {
    }

    public static Object register(String string, Runnable runnable) {
        Objects.requireNonNull(runnable);
        return Signals.register(string, runnable, runnable.getClass().getClassLoader());
    }

    public static Object register(String string, Runnable runnable, ClassLoader classLoader) {
        try {
            Class<?> clazz = Class.forName("sun.misc.SignalHandler");
            Object object2 = Proxy.newProxyInstance(classLoader, new Class[]{clazz}, (object, method, objectArray) -> {
                if (method.getDeclaringClass() == Object.class) {
                    if ("toString".equals(method.getName())) {
                        return runnable.toString();
                    }
                } else if (method.getDeclaringClass() == clazz) {
                    Log.trace(() -> "Calling handler " + Signals.toString(runnable) + " for signal " + string);
                    runnable.run();
                }
                return null;
            });
            return Signals.doRegister(string, object2);
        }
        catch (Exception exception) {
            Log.debug("Error registering handler for signal ", string, exception);
            return null;
        }
    }

    public static Object registerDefault(String string) {
        try {
            Class<?> clazz = Class.forName("sun.misc.SignalHandler");
            return Signals.doRegister(string, clazz.getField("SIG_DFL").get(null));
        }
        catch (Exception exception) {
            Log.debug("Error registering default handler for signal ", string, exception);
            return null;
        }
    }

    public static void unregister(String string, Object object) {
        try {
            if (object != null) {
                Signals.doRegister(string, object);
            }
        }
        catch (Exception exception) {
            Log.debug("Error unregistering handler for signal ", string, exception);
        }
    }

    private static Object doRegister(String string, Object object) throws Exception {
        Object obj;
        Log.trace(() -> "Registering signal " + string + " with handler " + Signals.toString(object));
        Class<?> clazz = Class.forName("sun.misc.Signal");
        Constructor<?> constructor = clazz.getConstructor(String.class);
        try {
            obj = constructor.newInstance(string);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getCause() instanceof IllegalArgumentException) {
                Log.trace(() -> "Ignoring unsupported signal " + string);
            } else {
                Log.debug("Error registering handler for signal ", string, invocationTargetException);
            }
            return null;
        }
        Class<?> clazz2 = Class.forName("sun.misc.SignalHandler");
        return clazz.getMethod("handle", clazz, clazz2).invoke(null, obj, object);
    }

    private static String toString(Object object) {
        try {
            Class<?> clazz = Class.forName("sun.misc.SignalHandler");
            if (object == clazz.getField("SIG_DFL").get(null)) {
                return "SIG_DFL";
            }
            if (object == clazz.getField("SIG_IGN").get(null)) {
                return "SIG_IGN";
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return object != null ? object.toString() : "null";
    }
}

