/*
 * Decompiled with CFR 0.152.
 */
package org.jline.utils;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Writer;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.jline.utils.NonBlockingReader;

public class NonBlockingPumpReader
extends NonBlockingReader {
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private final char[] buffer;
    private int read;
    private int write;
    private int count;
    final ReentrantLock lock;
    private final Condition notEmpty;
    private final Condition notFull;
    private final Writer writer;
    private boolean closed;

    public NonBlockingPumpReader() {
        this(4096);
    }

    public NonBlockingPumpReader(int n) {
        this.buffer = new char[n];
        this.writer = new NbpWriter();
        this.lock = new ReentrantLock();
        this.notEmpty = this.lock.newCondition();
        this.notFull = this.lock.newCondition();
    }

    public Writer getWriter() {
        return this.writer;
    }

    @Override
    public boolean ready() {
        return this.available() > 0;
    }

    @Override
    public int available() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            int n = this.count;
            return n;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int read(long l, boolean bl) throws IOException {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            if (!this.closed && this.count == 0) {
                try {
                    if (l > 0L) {
                        this.notEmpty.await(l, TimeUnit.MILLISECONDS);
                    } else {
                        this.notEmpty.await();
                    }
                }
                catch (InterruptedException interruptedException) {
                    throw (IOException)new InterruptedIOException().initCause(interruptedException);
                }
            }
            if (this.closed) {
                int n = -1;
                return n;
            }
            if (this.count == 0) {
                int n = -2;
                return n;
            }
            if (bl) {
                char c = this.buffer[this.read];
                return c;
            }
            char c = this.buffer[this.read];
            if (++this.read == this.buffer.length) {
                this.read = 0;
            }
            --this.count;
            this.notFull.signal();
            char c2 = c;
            return c2;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int readBuffered(char[] cArray) throws IOException {
        if (cArray == null) {
            throw new NullPointerException();
        }
        if (cArray.length == 0) {
            return 0;
        }
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            int n;
            if (!this.closed && this.count == 0) {
                try {
                    this.notEmpty.await();
                }
                catch (InterruptedException interruptedException) {
                    throw (IOException)new InterruptedIOException().initCause(interruptedException);
                }
            }
            if (this.closed) {
                int n2 = -1;
                return n2;
            }
            if (this.count == 0) {
                int n3 = -2;
                return n3;
            }
            int n4 = Math.min(cArray.length, this.count);
            for (n = 0; n < n4; ++n) {
                cArray[n] = this.buffer[this.read++];
                if (this.read != this.buffer.length) continue;
                this.read = 0;
            }
            this.count -= n4;
            this.notFull.signal();
            n = n4;
            return n;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write(char[] cArray, int n, int n2) throws IOException {
        if (n2 > 0) {
            ReentrantLock reentrantLock = this.lock;
            reentrantLock.lock();
            try {
                while (n2 > 0) {
                    if (!this.closed && this.count == this.buffer.length) {
                        try {
                            this.notFull.await();
                        }
                        catch (InterruptedException interruptedException) {
                            throw (IOException)new InterruptedIOException().initCause(interruptedException);
                        }
                    }
                    if (this.closed) {
                        throw new IOException("Closed");
                    }
                    while (n2 > 0 && this.count < this.buffer.length) {
                        this.buffer[this.write++] = cArray[n++];
                        ++this.count;
                        --n2;
                        if (this.write != this.buffer.length) continue;
                        this.write = 0;
                    }
                    this.notEmpty.signal();
                }
            }
            finally {
                reentrantLock.unlock();
            }
        }
    }

    @Override
    public void close() throws IOException {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            this.closed = true;
            this.notEmpty.signalAll();
            this.notFull.signalAll();
        }
        finally {
            reentrantLock.unlock();
        }
    }

    private class NbpWriter
    extends Writer {
        private NbpWriter() {
        }

        @Override
        public void write(char[] cArray, int n, int n2) throws IOException {
            NonBlockingPumpReader.this.write(cArray, n, n2);
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
            NonBlockingPumpReader.this.close();
        }
    }
}

