/*
 * Decompiled with CFR 0.152.
 */
package org.jline.terminal;

import java.util.EnumMap;
import java.util.EnumSet;
import java.util.function.Function;
import java.util.stream.Collectors;

public class Attributes {
    final EnumSet<InputFlag> iflag = EnumSet.noneOf(InputFlag.class);
    final EnumSet<OutputFlag> oflag = EnumSet.noneOf(OutputFlag.class);
    final EnumSet<ControlFlag> cflag = EnumSet.noneOf(ControlFlag.class);
    final EnumSet<LocalFlag> lflag = EnumSet.noneOf(LocalFlag.class);
    final EnumMap<ControlChar, Integer> cchars = new EnumMap(ControlChar.class);

    public Attributes() {
    }

    public Attributes(Attributes attributes) {
        this.copy(attributes);
    }

    public EnumSet<InputFlag> getInputFlags() {
        return this.iflag;
    }

    public void setInputFlags(EnumSet<InputFlag> enumSet) {
        this.iflag.clear();
        this.iflag.addAll(enumSet);
    }

    public boolean getInputFlag(InputFlag inputFlag) {
        return this.iflag.contains((Object)inputFlag);
    }

    public void setInputFlags(EnumSet<InputFlag> enumSet, boolean bl) {
        if (bl) {
            this.iflag.addAll(enumSet);
        } else {
            this.iflag.removeAll(enumSet);
        }
    }

    public void setInputFlag(InputFlag inputFlag, boolean bl) {
        if (bl) {
            this.iflag.add(inputFlag);
        } else {
            this.iflag.remove((Object)inputFlag);
        }
    }

    public EnumSet<OutputFlag> getOutputFlags() {
        return this.oflag;
    }

    public void setOutputFlags(EnumSet<OutputFlag> enumSet) {
        this.oflag.clear();
        this.oflag.addAll(enumSet);
    }

    public boolean getOutputFlag(OutputFlag outputFlag) {
        return this.oflag.contains((Object)outputFlag);
    }

    public void setOutputFlags(EnumSet<OutputFlag> enumSet, boolean bl) {
        if (bl) {
            this.oflag.addAll(enumSet);
        } else {
            this.oflag.removeAll(enumSet);
        }
    }

    public void setOutputFlag(OutputFlag outputFlag, boolean bl) {
        if (bl) {
            this.oflag.add(outputFlag);
        } else {
            this.oflag.remove((Object)outputFlag);
        }
    }

    public EnumSet<ControlFlag> getControlFlags() {
        return this.cflag;
    }

    public void setControlFlags(EnumSet<ControlFlag> enumSet) {
        this.cflag.clear();
        this.cflag.addAll(enumSet);
    }

    public boolean getControlFlag(ControlFlag controlFlag) {
        return this.cflag.contains((Object)controlFlag);
    }

    public void setControlFlags(EnumSet<ControlFlag> enumSet, boolean bl) {
        if (bl) {
            this.cflag.addAll(enumSet);
        } else {
            this.cflag.removeAll(enumSet);
        }
    }

    public void setControlFlag(ControlFlag controlFlag, boolean bl) {
        if (bl) {
            this.cflag.add(controlFlag);
        } else {
            this.cflag.remove((Object)controlFlag);
        }
    }

    public EnumSet<LocalFlag> getLocalFlags() {
        return this.lflag;
    }

    public void setLocalFlags(EnumSet<LocalFlag> enumSet) {
        this.lflag.clear();
        this.lflag.addAll(enumSet);
    }

    public boolean getLocalFlag(LocalFlag localFlag) {
        return this.lflag.contains((Object)localFlag);
    }

    public void setLocalFlags(EnumSet<LocalFlag> enumSet, boolean bl) {
        if (bl) {
            this.lflag.addAll(enumSet);
        } else {
            this.lflag.removeAll(enumSet);
        }
    }

    public void setLocalFlag(LocalFlag localFlag, boolean bl) {
        if (bl) {
            this.lflag.add(localFlag);
        } else {
            this.lflag.remove((Object)localFlag);
        }
    }

    public EnumMap<ControlChar, Integer> getControlChars() {
        return this.cchars;
    }

    public void setControlChars(EnumMap<ControlChar, Integer> enumMap) {
        this.cchars.clear();
        this.cchars.putAll(enumMap);
    }

    public int getControlChar(ControlChar controlChar) {
        Integer n = this.cchars.get((Object)controlChar);
        return n != null ? n : -1;
    }

    public void setControlChar(ControlChar controlChar, int n) {
        this.cchars.put(controlChar, n);
    }

    public void copy(Attributes attributes) {
        this.setControlFlags(attributes.getControlFlags());
        this.setInputFlags(attributes.getInputFlags());
        this.setLocalFlags(attributes.getLocalFlags());
        this.setOutputFlags(attributes.getOutputFlags());
        this.setControlChars(attributes.getControlChars());
    }

    public String toString() {
        return "Attributes[lflags: " + this.append(this.lflag) + ", iflags: " + this.append(this.iflag) + ", oflags: " + this.append(this.oflag) + ", cflags: " + this.append(this.cflag) + ", cchars: " + this.append(EnumSet.allOf(ControlChar.class), this::display) + "]";
    }

    private String display(ControlChar controlChar) {
        int n = this.getControlChar(controlChar);
        String string = controlChar == ControlChar.VMIN || controlChar == ControlChar.VTIME ? Integer.toString(n) : (n < 0 ? "<undef>" : (n < 32 ? "^" + (char)(n + 65 - 1) : (n == 127 ? "^?" : (n >= 128 ? String.format("\\u%04x", n) : String.valueOf((char)n)))));
        return controlChar.name().toLowerCase().substring(1) + "=" + string;
    }

    private <T extends Enum<T>> String append(EnumSet<T> enumSet) {
        return this.append(enumSet, enum_ -> enum_.name().toLowerCase());
    }

    private <T extends Enum<T>> String append(EnumSet<T> enumSet, Function<T, String> function) {
        return enumSet.stream().map(function).collect(Collectors.joining(" "));
    }

    public static enum LocalFlag {
        ECHOKE,
        ECHOE,
        ECHOK,
        ECHO,
        ECHONL,
        ECHOPRT,
        ECHOCTL,
        ISIG,
        ICANON,
        ALTWERASE,
        IEXTEN,
        EXTPROC,
        TOSTOP,
        FLUSHO,
        NOKERNINFO,
        PENDIN,
        NOFLSH;

    }

    public static enum ControlFlag {
        CIGNORE,
        CS5,
        CS6,
        CS7,
        CS8,
        CSTOPB,
        CREAD,
        PARENB,
        PARODD,
        HUPCL,
        CLOCAL,
        CCTS_OFLOW,
        CRTS_IFLOW,
        CDTR_IFLOW,
        CDSR_OFLOW,
        CCAR_OFLOW;

    }

    public static enum OutputFlag {
        OPOST,
        ONLCR,
        OXTABS,
        ONOEOT,
        OCRNL,
        ONOCR,
        ONLRET,
        OFILL,
        NLDLY,
        TABDLY,
        CRDLY,
        FFDLY,
        BSDLY,
        VTDLY,
        OFDEL;

    }

    public static enum InputFlag {
        IGNBRK,
        BRKINT,
        IGNPAR,
        PARMRK,
        INPCK,
        ISTRIP,
        INLCR,
        IGNCR,
        ICRNL,
        IXON,
        IXOFF,
        IXANY,
        IMAXBEL,
        IUTF8;

    }

    public static enum ControlChar {
        VEOF,
        VEOL,
        VEOL2,
        VERASE,
        VWERASE,
        VKILL,
        VREPRINT,
        VINTR,
        VQUIT,
        VSUSP,
        VDSUSP,
        VSTART,
        VSTOP,
        VLNEXT,
        VDISCARD,
        VMIN,
        VTIME,
        VSTATUS;

    }
}

