/*
 * Decompiled with CFR 0.152.
 */
package sbt.nio.file;

import java.io.IOException;
import java.nio.file.Path;
import sbt.nio.file.FileAttributes$;
import scala.runtime.BoxesRunTime;
import scala.util.Either;

public interface FileAttributes {
    public static FileAttributes apply(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        return FileAttributes$.MODULE$.apply(bl, bl2, bl3, bl4);
    }

    public static Either<IOException, FileAttributes> apply(Path path) {
        return FileAttributes$.MODULE$.apply(path);
    }

    public static Either<IOException, FileAttributes> apply(Path path, boolean bl) {
        return FileAttributes$.MODULE$.apply(path, bl);
    }

    public boolean isRegularFile();

    public boolean isDirectory();

    public boolean isSymbolicLink();

    public boolean isOther();

    public static final class FileAttributesImpl
    implements FileAttributes {
        private final boolean isDirectory;
        private final boolean isOther;
        private final boolean isRegularFile;
        private final boolean isSymbolicLink;

        public FileAttributesImpl(boolean isDirectory, boolean isOther, boolean isRegularFile, boolean isSymbolicLink) {
            this.isDirectory = isDirectory;
            this.isOther = isOther;
            this.isRegularFile = isRegularFile;
            this.isSymbolicLink = isSymbolicLink;
        }

        @Override
        public boolean isDirectory() {
            return this.isDirectory;
        }

        @Override
        public boolean isOther() {
            return this.isOther;
        }

        @Override
        public boolean isRegularFile() {
            return this.isRegularFile;
        }

        @Override
        public boolean isSymbolicLink() {
            return this.isSymbolicLink;
        }

        public int hashCode() {
            return (BoxesRunTime.boxToBoolean((boolean)this.isRegularFile()).hashCode() * 31 ^ BoxesRunTime.boxToBoolean((boolean)this.isDirectory()).hashCode()) * 31 ^ BoxesRunTime.boxToBoolean((boolean)this.isSymbolicLink()).hashCode();
        }

        public boolean equals(Object o) {
            Object object = o;
            if (object instanceof FileAttributesImpl) {
                FileAttributesImpl that = (FileAttributesImpl)object;
                return this.isDirectory() == that.isDirectory() && this.isOther() == that.isOther() && this.isRegularFile() == that.isRegularFile() && this.isSymbolicLink() == that.isSymbolicLink();
            }
            return false;
        }

        public String toString() {
            return new StringBuilder(42).append("FileAttributes(isDirectory = ").append(this.isDirectory()).append(", isOther = ").append(this.isOther()).append(",").append(new StringBuilder(36).append("isRegularFile = ").append(this.isRegularFile()).append(", isSymbolicLink = ").append(this.isSymbolicLink()).append(")").toString()).toString();
        }
    }
}

