/*
 * Decompiled with CFR 0.152.
 */
package sbt.io;

import java.io.File;
import sbt.io.PathFinder;
import sbt.io.PathLister$;
import sbt.nio.file.Glob$;
import scala.collection.immutable.Seq;

public interface PathLister {
    public static PathLister apply(File file) {
        return PathLister$.MODULE$.apply(file);
    }

    public Seq<File> get();

    public static class SingleFilePathLister
    implements PathLister {
        private final File file;

        public SingleFilePathLister(File file) {
            this.file = file;
        }

        private File file() {
            return this.file;
        }

        @Override
        public Seq<File> get() {
            return new PathFinder.GlobPathFinder(Glob$.MODULE$.apply(this.file())).get();
        }

        public String toString() {
            return new StringBuilder(22).append("SingleFilePathLister(").append(this.file()).append(")").toString();
        }

        public boolean equals(Object o) {
            Object object = o;
            if (object instanceof SingleFilePathLister) {
                SingleFilePathLister that = (SingleFilePathLister)object;
                File file = this.file();
                File file2 = that.file();
                return !(file != null ? !((Object)file).equals(file2) : file2 != null);
            }
            return false;
        }

        public int hashCode() {
            return this.file().hashCode();
        }
    }
}

