/*
 * Decompiled with CFR 0.152.
 */
package sbt.io;

import java.io.File;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.LinkedHashSet;
import sbt.io.FileFilter;
import sbt.io.Path$;
import sbt.io.PathFinder$;
import sbt.io.PathFinder$Combinator$;
import sbt.io.PathFinderDefaults;
import sbt.io.PathLister;
import sbt.nio.file.Glob;
import sbt.nio.file.Glob$;
import sbt.nio.file.Glob$GlobOps$;
import sbt.nio.file.Glob$RelativeGlobViewOption$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Set;
import scala.package$;
import scala.runtime.BoxesRunTime;

public abstract class PathFinder
implements PathLister,
PathFinderDefaults {
    public static PathFinder apply(File file) {
        return PathFinder$.MODULE$.apply(file);
    }

    public static PathFinder apply(Function0<Iterable<File>> function0) {
        return PathFinder$.MODULE$.apply(function0);
    }

    public static PathFinder empty() {
        return PathFinder$.MODULE$.empty();
    }

    public static PathFinder strict(Iterable<File> iterable) {
        return PathFinder$.MODULE$.strict(iterable);
    }

    @Override
    public Seq<File> get() {
        return package$.MODULE$.Nil();
    }

    public static interface Combinator {
        public static File SingleFilePathFinderCombinator(File file) {
            return PathFinder$Combinator$.MODULE$.SingleFilePathFinderCombinator(file);
        }

        public PathFinder $plus$plus$plus(PathFinder var1);

        public PathFinder $minus$minus$minus(PathFinder var1);

        public <T> Seq<Tuple2<File, T>> pair(Function1<File, Option<T>> var1, boolean var2);

        public static boolean pair$default$2$(Combinator $this) {
            return $this.pair$default$2();
        }

        default public boolean pair$default$2() {
            return true;
        }

        public PathFinder descendantsExcept(FileFilter var1, FileFilter var2);

        public PathFinder filter(Function1<File, Object> var1);

        public PathFinder flatMap(Function1<File, PathFinder> var1);

        public URL[] getURLs();

        public Seq<String> getPaths();

        public PathFinder distinct();

        public String absString();
    }

    public static final class GlobPathFinder
    extends PathFinder {
        private final Glob glob;

        public GlobPathFinder(Glob glob) {
            this.glob = glob;
        }

        public Glob glob() {
            return this.glob;
        }

        @Override
        public Seq<File> get() {
            Path base = Glob$GlobOps$.MODULE$.base$extension(Glob$.MODULE$.GlobOps(this.glob()), Glob$RelativeGlobViewOption$.MODULE$.default());
            if (Glob$GlobOps$.MODULE$.range$extension(Glob$.MODULE$.GlobOps(this.glob()))._1$mcI$sp() == 0 && Glob$GlobOps$.MODULE$.range$extension(Glob$.MODULE$.GlobOps(this.glob()))._2$mcI$sp() == 0) {
                if (Files.exists(base, new LinkOption[0])) {
                    File file = base.toFile();
                    return package$.MODULE$.Nil().$colon$colon((Object)file);
                }
                return package$.MODULE$.Nil();
            }
            if (Glob$GlobOps$.MODULE$.range$extension(Glob$.MODULE$.GlobOps(this.glob()))._2$mcI$sp() > 1) {
                Set files = (Set)JavaConverters$.MODULE$.asScalaSetConverter(new LinkedHashSet()).asScala();
                if (Glob$GlobOps$.MODULE$.descendentMatches$extension(Glob$.MODULE$.GlobOps(this.glob()), Glob$GlobOps$.MODULE$.base$extension(Glob$.MODULE$.GlobOps(this.glob()), Glob$RelativeGlobViewOption$.MODULE$.default()))) {
                    files.add((Object)Glob$GlobOps$.MODULE$.base$extension(Glob$.MODULE$.GlobOps(this.glob()), Glob$RelativeGlobViewOption$.MODULE$.default()).toFile());
                }
                Path$.MODULE$.defaultDescendantHandler().apply((Object)Glob$GlobOps$.MODULE$.base$extension(Glob$.MODULE$.GlobOps(this.glob()), Glob$RelativeGlobViewOption$.MODULE$.default()).toFile(), (Object)Glob$GlobOps$.MODULE$.toFileFilter$extension(Glob$.MODULE$.GlobOps(this.glob())), (Object)files, (Object)BoxesRunTime.boxToInteger((int)Glob$GlobOps$.MODULE$.range$extension(Glob$.MODULE$.GlobOps(this.glob()))._2$mcI$sp()));
                return files.toIndexedSeq();
            }
            return (Seq)Path$.MODULE$.defaultChildHandler().apply((Object)Glob$GlobOps$.MODULE$.base$extension(Glob$.MODULE$.GlobOps(this.glob()), Glob$RelativeGlobViewOption$.MODULE$.default()).toFile(), (Object)Glob$GlobOps$.MODULE$.toFileFilter$extension(Glob$.MODULE$.GlobOps(this.glob())));
        }
    }
}

