/*
 * Decompiled with CFR 0.152.
 */
package sbt.io;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import sbt.io.DescendantOrSelfPathFinder$;
import sbt.io.FileFilter;
import sbt.io.IO$;
import sbt.io.Mapper;
import sbt.io.Path;
import sbt.nio.file.AnyPath$;
import sbt.nio.file.FileAttributes;
import sbt.nio.file.FileTreeView;
import sbt.nio.file.FileTreeView$;
import sbt.nio.file.FileTreeView$Ops$;
import sbt.nio.file.Glob$;
import sbt.nio.file.RelativeGlob;
import scala.Function1;
import scala.Function2;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Set;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class Path$
extends Mapper
implements Serializable {
    private static final char sep;
    private static final Vector defaultLinkOptions;
    private static final Function4 defaultDescendantHandler;
    private static final Function2 defaultChildHandler;
    public static final Path$ MODULE$;

    private Path$() {
    }

    static {
        Function2 & Serializable intersect;
        MODULE$ = new Path$();
        sep = File.separatorChar;
        defaultLinkOptions = package$.MODULE$.Vector().empty();
        Function4 & Serializable intersect2 = defaultDescendantHandler = "native".equals(scala.sys.package$.MODULE$.props().getOrElse((Object)"sbt.pathfinder", MODULE$::$init$$$anonfun$1)) ? (Function4 & Serializable)(v1, v2, v3, v4) -> {
            this.$init$$$anonfun$2((File)v1, (FileFilter)v2, (Set)v3, BoxesRunTime.unboxToInt((Object)v4));
            return BoxedUnit.UNIT;
        } : (Function4 & Serializable)(v1, v2, v3, v4) -> {
            this.$init$$$anonfun$3((File)v1, (FileFilter)v2, (Set)v3, BoxesRunTime.unboxToInt((Object)v4));
            return BoxedUnit.UNIT;
        };
        if ("native".equals(scala.sys.package$.MODULE$.props().getOrElse((Object)"sbt.pathfinder", MODULE$::$init$$$anonfun$4))) {
            FileTreeView<Tuple2<Path, FileAttributes>> fileTreeView = FileTreeView$.MODULE$.default();
            intersect = (Function2 & Serializable)(file, filter) -> (Seq)FileTreeView$Ops$.MODULE$.list$extension(FileTreeView$.MODULE$.Ops(fileTreeView), Glob$.MODULE$.apply(file.toPath(), (RelativeGlob)AnyPath$.MODULE$)).flatMap((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Path path = (Path)tuple2._1();
                    FileAttributes fileAttributes = (FileAttributes)tuple2._2();
                    if (path != null) {
                        Path path2 = path;
                        if (fileAttributes != null) {
                            FileAttributes attrs = fileAttributes;
                            if (filter.accept(new Path.AttributedFile(path2, attrs))) {
                                return Some$.MODULE$.apply((Object)path2.toFile());
                            }
                            return None$.MODULE$;
                        }
                    }
                }
                throw new MatchError((Object)tuple2);
            });
        } else {
            intersect = (Function2 & Serializable)(file, filter) -> {
                Object object = Predef$.MODULE$.refArrayOps((Object[])IO$.MODULE$.wrapNull(file.listFiles((java.io.FileFilter)filter)));
                return ArrayOps$.MODULE$.toSeq$extension(object);
            };
        }
        defaultChildHandler = intersect;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Path$.class);
    }

    public File apply(File f) {
        return f;
    }

    public File apply(String f) {
        return new File(f);
    }

    public File fileProperty(String name) {
        return new File(System.getProperty(name));
    }

    public File userHome() {
        return this.fileProperty("user.home");
    }

    public File absolute(File file) {
        return new File(file.toURI().normalize()).getAbsoluteFile();
    }

    public String makeString(Seq<File> paths) {
        return this.makeString(paths, File.pathSeparator);
    }

    public String makeString(Seq<File> paths, String sep) {
        Seq separated = (Seq)paths.map((Function1 & Serializable)_$1 -> _$1.getAbsolutePath());
        separated.find((Function1 & Serializable)_$2 -> _$2.contains(sep)).foreach((Function1 & Serializable)p -> {
            throw scala.sys.package$.MODULE$.error(new StringBuilder(29).append("Path '").append((String)p).append("' contains separator '").append(sep).append("'").toString());
        });
        return separated.mkString(sep);
    }

    public boolean newerThan(File a, File b) {
        return a.exists() && (!b.exists() || IO$.MODULE$.getModifiedTimeOrZero(a) > IO$.MODULE$.getModifiedTimeOrZero(b));
    }

    public char sep() {
        return sep;
    }

    public URL[] toURLs(Seq<File> files) {
        return (URL[])((IterableOnceOps)files.map((Function1 & Serializable)_$3 -> _$3.toURI().toURL())).toArray(ClassTag$.MODULE$.apply(URL.class));
    }

    public Vector<LinkOption> defaultLinkOptions() {
        return defaultLinkOptions;
    }

    public Function4<File, FileFilter, Set<File>, Object, BoxedUnit> defaultDescendantHandler() {
        return defaultDescendantHandler;
    }

    public Function2<File, FileFilter, Seq<File>> defaultChildHandler() {
        return defaultChildHandler;
    }

    private final String $init$$$anonfun$1() {
        return "";
    }

    private final /* synthetic */ void $init$$$anonfun$2(File file, FileFilter filter, Set fileSet, int depth) {
        DescendantOrSelfPathFinder$.MODULE$.native(file, filter, (Set<File>)fileSet, depth);
    }

    private final /* synthetic */ void $init$$$anonfun$3(File file, FileFilter filter, Set fileSet, int depth) {
        DescendantOrSelfPathFinder$.MODULE$.default(file, filter, (Set<File>)fileSet, depth);
    }

    private final String $init$$$anonfun$4() {
        return "";
    }
}

