/*
 * Decompiled with CFR 0.152.
 */
package sbt.io;

import java.io.File;
import java.io.Serializable;
import sbt.io.AllPassFilter$;
import sbt.io.FileFilter;
import sbt.io.IO$;
import sbt.io.PathFinder;
import sbt.io.PathFinder$;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.immutable.Seq;
import scala.runtime.Nothing$;
import scala.sys.package$;

public abstract class Mapper {
    private final Function1 basic = (Function1 & Serializable)f -> Some$.MODULE$.apply((Object)f.getPath());
    private final Function1 flat = (Function1 & Serializable)f -> Some$.MODULE$.apply((Object)f.getName());

    public Function1<File, Option<String>> basic() {
        return this.basic;
    }

    public Function1<File, Option<String>> relativeTo(File base) {
        return (Function1 & Serializable)_$1 -> IO$.MODULE$.relativize(base, (File)_$1);
    }

    public Function1<File, Option<String>> relativeTo(Iterable<File> bases, Function1<File, Option<String>> zero) {
        return this.fold(zero, bases, (Function1 & Serializable)base -> this.relativeTo((File)base));
    }

    public Function1<File, Option<String>> relativeTo$default$2() {
        return this.transparent();
    }

    public Function1<File, Option<String>> rebase(File oldBase, String newBase) {
        String normNewBase = this.normalizeBase(newBase);
        return (Function1 & Serializable)file -> {
            File file2 = file;
            File file3 = oldBase;
            if (!(file2 != null ? !((Object)file2).equals(file3) : file3 != null)) {
                return Some$.MODULE$.apply((Object)(normNewBase.isEmpty() ? "." : normNewBase));
            }
            return IO$.MODULE$.relativize(oldBase, (File)file).map((Function1 & Serializable)_$2 -> new StringBuilder(0).append(normNewBase).append((String)_$2).toString());
        };
    }

    public Function1<Object, Nothing$> fail() {
        return (Function1 & Serializable)f -> package$.MODULE$.error(new StringBuilder(15).append("No mapping for ").append(f).toString());
    }

    public Function1<File, Option<String>> flat() {
        return this.flat;
    }

    public Function1<File, Option<String>> flatRebase(String newBase) {
        String newBase0 = this.normalizeBase(newBase);
        return (Function1 & Serializable)f -> Some$.MODULE$.apply((Object)new StringBuilder(0).append(newBase0).append(f.getName()).toString());
    }

    public <A, B> Function1<A, Some<B>> total(Function1<A, B> f) {
        return (Function1 & Serializable)x -> Some$.MODULE$.apply(f.apply(x));
    }

    public Function1<Object, Option<Nothing$>> transparent() {
        return (Function1 & Serializable)_$3 -> None$.MODULE$;
    }

    public String normalizeBase(String base) {
        if (!base.isEmpty() && !base.endsWith("/")) {
            return new StringBuilder(1).append(base).append("/").toString();
        }
        return base;
    }

    public Function1<File, Option<File>> abs() {
        return (Function1 & Serializable)f -> Some$.MODULE$.apply((Object)f.getAbsoluteFile());
    }

    public Function1<File, Option<File>> resolve(File newDirectory) {
        return (Function1 & Serializable)file -> {
            if (file.isAbsolute()) {
                return None$.MODULE$;
            }
            return Some$.MODULE$.apply((Object)new File(newDirectory, file.getPath()));
        };
    }

    public Function1<File, Option<File>> rebase(Iterable<File> oldBases, File newBase, Function1<File, Option<File>> zero) {
        return this.fold(zero, oldBases, (Function1 & Serializable)old -> this.rebase((File)old, newBase));
    }

    public Function1<File, Option<File>> rebase$default$3() {
        return this.transparent();
    }

    public Function1<File, Option<File>> rebase(File oldBase, File newBase) {
        return (Function1 & Serializable)file -> {
            File file2 = file;
            File file3 = oldBase;
            if (!(file2 != null ? !((Object)file2).equals(file3) : file3 != null)) {
                return Some$.MODULE$.apply((Object)newBase);
            }
            return IO$.MODULE$.relativize(oldBase, (File)file).map((Function1 & Serializable)r -> new File(newBase, (String)r));
        };
    }

    public Function1<File, Option<File>> flat(File newDirectory) {
        return (Function1 & Serializable)file -> Some$.MODULE$.apply((Object)new File(newDirectory, file.getName()));
    }

    public Iterable<Tuple2<File, String>> allSubpaths(File base) {
        return this.selectSubpaths(base, AllPassFilter$.MODULE$);
    }

    public Iterable<Tuple2<File, String>> selectSubpaths(File base, FileFilter filter) {
        return (Iterable)PathFinder$.MODULE$.apply(base).globRecursive(filter).get().collect((PartialFunction)new Serializable(base){
            private final File base$2;
            {
                this.base$2 = base$4;
            }

            public final boolean isDefinedAt(File x) {
                File file;
                File f;
                File file2 = f = (file = x);
                File file3 = this.base$2;
                return file2 == null ? file3 != null : !((Object)file2).equals(file3);
            }

            public final Object applyOrElse(File x, Function1 function1) {
                File file;
                File f;
                File file2 = f = (file = x);
                File file3 = this.base$2;
                if (file2 == null ? file3 != null : !((Object)file2).equals(file3)) {
                    File file4 = (File)Predef$.MODULE$.ArrowAssoc((Object)f);
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)file4, (Object)this.base$2.toPath().relativize(f.toPath()).toString());
                }
                return function1.apply((Object)x);
            }
        });
    }

    public Seq<Tuple2<File, String>> directory(File baseDirectory) {
        return (Seq)Option$.MODULE$.apply((Object)baseDirectory.getParentFile()).map((Function1 & Serializable)parent -> {
            PathFinder pathFinder = PathFinder$.MODULE$.apply(baseDirectory).allPaths();
            return pathFinder.pair((Function1)this.relativeTo((File)parent), pathFinder.pair$default$2());
        }).getOrElse(() -> this.directory$$anonfun$2(baseDirectory));
    }

    public Seq<Tuple2<File, String>> contentOf(File baseDirectory) {
        PathFinder pathFinder = PathFinder$.MODULE$.apply(baseDirectory).allPaths().$minus$minus$minus(PathFinder$.MODULE$.apply(baseDirectory));
        return pathFinder.pair((Function1)this.relativeTo(baseDirectory), pathFinder.pair$default$2());
    }

    private <A, B, T> Function1<A, Option<B>> fold(Function1<A, Option<B>> zero, Iterable<T> in, Function1<T, Function1<A, Option<B>>> f) {
        return (Function1)in.foldLeft(zero, (Function2 & Serializable)(mapper, base) -> (Function1 & Serializable)a -> ((Option)((Function1)f.apply(base)).apply(a)).orElse(() -> Mapper.fold$$anonfun$1$$anonfun$1$$anonfun$1(mapper, a)));
    }

    private final Seq directory$$anonfun$2(File baseDirectory$2) {
        PathFinder pathFinder = PathFinder$.MODULE$.apply(baseDirectory$2).allPaths();
        return pathFinder.pair((Function1)this.basic(), pathFinder.pair$default$2());
    }

    private static final Option fold$$anonfun$1$$anonfun$1$$anonfun$1(Function1 mapper$2, Object a$1) {
        return (Option)mapper$2.apply(a$1);
    }
}

