/*
 * Decompiled with CFR 0.152.
 */
package sbt.io;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Locale;
import java.util.Properties;
import java.util.Random;
import java.util.TimeZone;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import sbt.internal.io.ErrorHandling$;
import sbt.internal.io.Milli$;
import sbt.internal.io.Retry$;
import sbt.io.AllPassFilter$;
import sbt.io.CopyOptions;
import sbt.io.CopyOptions$;
import sbt.io.GlobFilter$;
import sbt.io.NameFilter;
import sbt.io.Path$;
import sbt.io.PathFinder;
import sbt.io.PathFinder$;
import sbt.io.RichFile;
import sbt.io.Using;
import sbt.io.Using$;
import sbt.nio.file.FileAttributes;
import sbt.nio.file.FileTreeView$;
import scala.Function$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.SeqOps;
import scala.collection.Set;
import scala.collection.SetOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.TreeSet;
import scala.collection.immutable.TreeSet$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichInt$;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.function.JProcedure2;
import scala.runtime.java8.JFunction1;
import scala.util.control.Exception$;
import scala.util.control.NonFatal$;

public final class IO$
implements Serializable {
    public static final long OFFSET$_m_8 = LazyVals$.MODULE$.getOffsetStatic(IO$.class.getDeclaredField("supportedFileAttributeViews$lzy1"));
    public static final long OFFSET$_m_7 = LazyVals$.MODULE$.getOffsetStatic(IO$.class.getDeclaredField("hasUserDefinedFileAttributeView$lzy1"));
    public static final long OFFSET$_m_6 = LazyVals$.MODULE$.getOffsetStatic(IO$.class.getDeclaredField("hasBasicFileAttributeView$lzy1"));
    public static final long OFFSET$_m_5 = LazyVals$.MODULE$.getOffsetStatic(IO$.class.getDeclaredField("hasAclFileAttributeView$lzy1"));
    public static final long OFFSET$_m_4 = LazyVals$.MODULE$.getOffsetStatic(IO$.class.getDeclaredField("hasDosFileAttributeView$lzy1"));
    public static final long OFFSET$_m_3 = LazyVals$.MODULE$.getOffsetStatic(IO$.class.getDeclaredField("hasFileOwnerAttributeView$lzy1"));
    public static final long OFFSET$_m_2 = LazyVals$.MODULE$.getOffsetStatic(IO$.class.getDeclaredField("hasPosixFileAttributeView$lzy1"));
    public static final long OFFSET$_m_1 = LazyVals$.MODULE$.getOffsetStatic(IO$.class.getDeclaredField("jrtFs$lzy1"));
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(IO$.class.getDeclaredField("random$lzy1"));
    private static final int MaximumTries;
    private volatile Object random$lzy1;
    private static final File temporaryDirectory;
    private static final int BufferSize;
    private static final String FileScheme;
    private static final String Newline;
    private static final Charset utf8;
    private volatile Object jrtFs$lzy1;
    private static final Pattern PathSeparatorPattern;
    private static final boolean isWindows;
    private volatile Object hasPosixFileAttributeView$lzy1;
    private volatile Object hasFileOwnerAttributeView$lzy1;
    private volatile Object hasDosFileAttributeView$lzy1;
    private volatile Object hasAclFileAttributeView$lzy1;
    private volatile Object hasBasicFileAttributeView$lzy1;
    private volatile Object hasUserDefinedFileAttributeView$lzy1;
    private volatile Object supportedFileAttributeViews$lzy1;
    private static final Seq<Class<? extends IOException>> excludeFileNotFound;
    public static final IO$ MODULE$;

    private IO$() {
    }

    static {
        MODULE$ = new IO$();
        MaximumTries = 10;
        temporaryDirectory = new File(System.getProperty("java.io.tmpdir"));
        BufferSize = 8192;
        FileScheme = "file";
        Newline = System.getProperty("line.separator");
        utf8 = Charset.forName("UTF-8");
        PathSeparatorPattern = Pattern.compile(File.pathSeparator);
        isWindows = System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("windows");
        excludeFileNotFound = (Seq)new .colon.colon(FileNotFoundException.class, (List)Nil$.MODULE$);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(IO$.class);
    }

    private Random random() {
        Object object = this.random$lzy1;
        if (object instanceof Random) {
            return (Random)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Random)this.random$lzyINIT1();
    }

    private Object random$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.random$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Random random = null;
                    try {
                        random = new Random();
                        object2 = random == null ? LazyVals.NullValue$.MODULE$ : random;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.random$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return random;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public File temporaryDirectory() {
        return temporaryDirectory;
    }

    public String FileScheme() {
        return FileScheme;
    }

    public String Newline() {
        return Newline;
    }

    public Charset utf8() {
        return utf8;
    }

    private FileSystem jrtFs() {
        Object object = this.jrtFs$lzy1;
        if (object instanceof FileSystem) {
            return (FileSystem)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (FileSystem)this.jrtFs$lzyINIT1();
    }

    private Object jrtFs$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.jrtFs$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    FileSystem fileSystem = null;
                    try {
                        fileSystem = FileSystems.getFileSystem(URI.create("jrt:/"));
                        object2 = fileSystem == null ? LazyVals.NullValue$.MODULE$ : fileSystem;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.jrtFs$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return fileSystem;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Path classLocationPath(Class<?> cl) {
        URL u = this.classLocation(cl);
        String string = u.getProtocol();
        String string2 = this.FileScheme();
        String string3 = string;
        Option p = !(string2 != null ? !string2.equals(string3) : string3 != null) ? Option$.MODULE$.apply((Object)this.toFile(u).toPath()) : ("jar".equals(string) ? this.urlAsFile(u).map((Function1 & Serializable)_$1 -> _$1.toPath()) : ("jrt".equals(string) ? Option$.MODULE$.apply((Object)this.jrtFs().getPath(u.getPath(), new String[0])) : None$.MODULE$));
        return (Path)p.getOrElse(() -> IO$.classLocationPath$$anonfun$1(u, cl));
    }

    public <A> Path classLocationPath(Manifest<A> mf) {
        return this.classLocationPath(mf.runtimeClass());
    }

    public Option<File> classLocationFileOption(Class<?> cl) {
        URL u = this.classLocation(cl);
        return this.urlAsFile(u);
    }

    public <A> Option<File> classLocationFileOption(Manifest<A> mf) {
        return this.classLocationFileOption(mf.runtimeClass());
    }

    public File classLocationFile(Class<?> cl) {
        return (File)this.classLocationFileOption(cl).getOrElse(() -> IO$.classLocationFile$$anonfun$1(cl));
    }

    public <T> File classLocationFile(Manifest<T> mf) {
        return this.classLocationFile(mf.runtimeClass());
    }

    public URL classLocation(Class<?> cl) {
        URL uRL;
        String clsfile = new StringBuilder(6).append(cl.getName().replace('.', '/')).append(".class").toString();
        try {
            uRL = (URL)this.localcl$1(cl).orElse(() -> this.classLocation$$anonfun$1(clsfile)).map((Function1 & Serializable)url -> {
                String string = url.getProtocol();
                if ("jar".equals(string)) {
                    String path = url.getPath();
                    int end = path.indexOf(33);
                    return new URI(end == -1 ? path : path.substring(0, end)).toURL();
                }
                if ("jrt".equals(string)) {
                    String path = url.getPath();
                    int end = path.indexOf(47, 1);
                    return new URI(new StringBuilder(6).append("jrt://").append(end == -1 ? path : path.substring(0, end)).toString()).toURL();
                }
                return url;
            }).getOrElse(() -> IO$.classLocation$$anonfun$3(cl));
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable e = throwable3 = (Throwable)option.get();
                e.printStackTrace();
                throw e;
            }
            throw throwable;
        }
        return uRL;
    }

    public <A> URL classLocation(Manifest<A> mf) {
        return this.classLocation(mf.runtimeClass());
    }

    public <T> URL classfileLocation(Manifest<T> mf) {
        return this.classfileLocation(mf.runtimeClass());
    }

    public URL classfileLocation(Class<?> cl) {
        URL uRL;
        String clsfile = new StringBuilder(6).append(cl.getName().replace('.', '/')).append(".class").toString();
        try {
            uRL = (URL)this.localcl$2(cl, clsfile).orElse(() -> this.classfileLocation$$anonfun$1(clsfile)).getOrElse(() -> IO$.classfileLocation$$anonfun$2(cl));
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable e = throwable3 = (Throwable)option.get();
                e.printStackTrace();
                throw e;
            }
            throw throwable;
        }
        return uRL;
    }

    public File toFile(URL url) {
        File file;
        try {
            file = this.uriToFile(url.toURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            file = new File(url.getPath());
        }
        return file;
    }

    public File toFile(URI uri) {
        File file;
        try {
            file = this.uriToFile(uri);
        }
        catch (URISyntaxException uRISyntaxException) {
            file = new File(uri.getPath());
        }
        return file;
    }

    public File asFile(URL url) {
        return (File)this.urlAsFile(url).getOrElse(() -> IO$.asFile$$anonfun$1(url));
    }

    public Option<File> urlAsFile(URL url) {
        String string = url.getProtocol();
        String string2 = this.FileScheme();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            return Some$.MODULE$.apply((Object)this.toFile(url));
        }
        if ("jar".equals(string)) {
            String path = url.getPath();
            int end = path.indexOf(33);
            return Some$.MODULE$.apply((Object)this.uriToFile(end == -1 ? path : path.substring(0, end)));
        }
        return None$.MODULE$;
    }

    private File uriToFile(String uriString) {
        return this.uriToFile(new URI(uriString));
    }

    /*
     * Unable to fully structure code
     */
    private File uriToFile(URI uri) {
        block5: {
            part = uri.getSchemeSpecificPart();
            var3_3 = Option$.MODULE$.apply((Object)uri.getScheme());
            if (None$.MODULE$.equals(var3_3)) ** GOTO lbl-1000
            if (!(var3_3 instanceof Some)) ** GOTO lbl-1000
            v0 = this.FileScheme();
            var4_4 = ((Some)var3_3).value();
            if (v0 != null) break block5;
            if (var4_4 == null) ** GOTO lbl-1000
            ** GOTO lbl-1000
        }
        if (v0.equals(var4_4)) lbl-1000:
        // 3 sources

        {
            v1 = true;
        } else lbl-1000:
        // 3 sources

        {
            v1 = false;
        }
        if (!v1) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(43).append("Expected protocol to be '").append(this.FileScheme()).append("' or empty in URI ").append(uri).toString());
        }
        var5_5 = Option$.MODULE$.apply((Object)uri.getAuthority());
        if (None$.MODULE$.equals(var5_5) && part.startsWith("/")) {
            return new File(uri);
        }
        if (!part.startsWith("/") && part.contains(":")) {
            return new File(new StringBuilder(2).append("//").append(part).toString());
        }
        return new File(part);
    }

    public void assertDirectory(File file) {
        if (!file.isDirectory()) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(0).append(file.exists() ? "Not a directory: " : "Directory not found: ").append(file).toString());
        }
    }

    public void assertDirectories(Seq<File> file2) {
        file2.foreach((Function1)(JProcedure1 & Serializable)file -> MODULE$.assertDirectory((File)file));
    }

    public Tuple2<String, String> split(String name) {
        int lastDot = name.lastIndexOf(46);
        if (lastDot >= 0) {
            return Tuple2$.MODULE$.apply((Object)name.substring(0, lastDot), (Object)name.substring(lastDot + 1));
        }
        return Tuple2$.MODULE$.apply((Object)name, (Object)"");
    }

    public void touch(Iterable<File> files) {
        files.foreach((Function1)(JProcedure1 & Serializable)f -> this.touch((File)f, this.touch$default$2()));
    }

    public void touch(File file, boolean setModified) {
        Retry$.MODULE$.apply((Function0 & Serializable)() -> {
            IO$.touch$$anonfun$2(file, setModified);
            return BoxedUnit.UNIT;
        }, (Seq<Class<? extends Throwable>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[0]));
    }

    public boolean touch$default$2() {
        return true;
    }

    public void createDirectories(Iterable<File> dirs) {
        dirs.foreach((Function1)(JProcedure1 & Serializable)dir -> MODULE$.createDirectory((File)dir));
    }

    public void createDirectory(File dir) {
        Path path = dir.toPath();
        try {
            Retry$.MODULE$.apply(() -> IO$.createDirectory$$anonfun$1(path), (Seq<Class<? extends Throwable>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{FileAlreadyExistsException.class}));
        }
        catch (IOException e) {
            throw new IOException(new StringBuilder(2).append(this.failBase$1(dir)).append(": ").append(e).toString(), e);
        }
    }

    public void gzip(File in, File out) {
        File file = in;
        File file2 = out;
        Predef$.MODULE$.require(file == null ? file2 != null : !((Object)file).equals(file2), IO$::gzip$$anonfun$1);
        ((Using)((Object)Using$.MODULE$.fileInputStream())).apply(in, (JProcedure1 & Serializable)inputStream -> ((Using)((Object)Using$.MODULE$.fileOutputStream(Using$.MODULE$.fileOutputStream$default$1()))).apply(out, (JProcedure1 & Serializable)outputStream -> MODULE$.gzip((InputStream)inputStream, (OutputStream)outputStream)));
    }

    public void gzip(InputStream input, OutputStream output) {
        Using$.MODULE$.gzipOutputStream().apply(output, (JProcedure1 & Serializable)gzStream -> MODULE$.transfer(input, (OutputStream)gzStream));
    }

    public void gunzip(File in, File out) {
        File file = in;
        File file2 = out;
        Predef$.MODULE$.require(file == null ? file2 != null : !((Object)file).equals(file2), IO$::gunzip$$anonfun$1);
        ((Using)((Object)Using$.MODULE$.fileInputStream())).apply(in, (JProcedure1 & Serializable)inputStream -> ((Using)((Object)Using$.MODULE$.fileOutputStream(Using$.MODULE$.fileOutputStream$default$1()))).apply(out, (JProcedure1 & Serializable)outputStream -> MODULE$.gunzip((InputStream)inputStream, (OutputStream)outputStream)));
    }

    public void gunzip(InputStream input, OutputStream output) {
        Using$.MODULE$.gzipInputStream().apply(input, (JProcedure1 & Serializable)gzStream -> MODULE$.transfer((InputStream)gzStream, output));
    }

    public scala.collection.immutable.Set<File> unzip(File from, File toDirectory, NameFilter filter, boolean preserveLastModified) {
        return (scala.collection.immutable.Set)((Using)((Object)Using$.MODULE$.fileInputStream())).apply(from, (Function1 & Serializable)in -> MODULE$.unzipStream((InputStream)in, toDirectory, filter, preserveLastModified));
    }

    public NameFilter unzip$default$3() {
        return AllPassFilter$.MODULE$;
    }

    public boolean unzip$default$4() {
        return true;
    }

    public scala.collection.immutable.Set<File> unzipURL(URL from, File toDirectory, NameFilter filter, boolean preserveLastModified) {
        return (scala.collection.immutable.Set)Using$.MODULE$.urlInputStream().apply(from, (Function1 & Serializable)in -> MODULE$.unzipStream((InputStream)in, toDirectory, filter, preserveLastModified));
    }

    public NameFilter unzipURL$default$3() {
        return AllPassFilter$.MODULE$;
    }

    public boolean unzipURL$default$4() {
        return true;
    }

    public scala.collection.immutable.Set<File> unzipStream(InputStream from, File toDirectory, NameFilter filter, boolean preserveLastModified) {
        this.createDirectory(toDirectory);
        return (scala.collection.immutable.Set)Using$.MODULE$.zipInputStream().apply(from, (Function1 & Serializable)zipInput -> MODULE$.extract((ZipInputStream)zipInput, toDirectory.toPath(), filter, preserveLastModified));
    }

    public NameFilter unzipStream$default$3() {
        return AllPassFilter$.MODULE$;
    }

    public boolean unzipStream$default$4() {
        return true;
    }

    private scala.collection.immutable.Set<File> extract(ZipInputStream from, Path toDirectory, NameFilter filter, boolean preserveLastModified) {
        HashSet set = new HashSet();
        String canonicalDirPath = toDirectory.normalize().toString();
        this.next$1(from, filter, toDirectory, set, preserveLastModified, canonicalDirPath);
        return (scala.collection.immutable.Set)((SetOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Path[0]))).$plus$plus((IterableOnce)set).map((Function1 & Serializable)_$2 -> _$2.toFile());
    }

    public void transfer(File in2, File out) {
        ((Using)((Object)Using$.MODULE$.fileInputStream())).apply(in2, (JProcedure1 & Serializable)in -> MODULE$.transfer((InputStream)in, out));
    }

    public void transfer(File in2, OutputStream out) {
        ((Using)((Object)Using$.MODULE$.fileInputStream())).apply(in2, (JProcedure1 & Serializable)in -> MODULE$.transfer((InputStream)in, out));
    }

    public void transfer(InputStream in, File to) {
        ((Using)((Object)Using$.MODULE$.fileOutputStream(Using$.MODULE$.fileOutputStream$default$1()))).apply(to, (JProcedure1 & Serializable)outputStream -> MODULE$.transfer(in, (OutputStream)outputStream));
    }

    public void transfer(InputStream in, OutputStream out) {
        this.transferImpl(in, out, false);
    }

    public void transferAndClose(InputStream in, OutputStream out) {
        this.transferImpl(in, out, true);
    }

    private void transferImpl(InputStream in, OutputStream out, boolean close) {
        try {
            byte[] buffer = new byte[BufferSize];
            this.read$1(in, buffer, out);
        }
        finally {
            if (close) {
                in.close();
            }
        }
    }

    public <T> T withTemporaryDirectory(Function1<File, T> action, boolean keepDirectory) {
        Object object;
        File dir = this.createTemporaryDirectory();
        try {
            object = action.apply((Object)dir);
        }
        finally {
            if (!keepDirectory) {
                this.delete(dir);
            }
        }
        return (T)object;
    }

    public <T> T withTemporaryDirectory(Function1<File, T> action) {
        return this.withTemporaryDirectory(action, false);
    }

    public File createTemporaryDirectory() {
        return this.createUniqueDirectory(this.temporaryDirectory());
    }

    public File createUniqueDirectory(File baseDirectory) {
        return this.create$1(baseDirectory, 0);
    }

    public <T> T withTemporaryFile(String prefix, String postfix, boolean keepFile, Function1<File, T> action) {
        Object object;
        Path file = Files.createTempFile(prefix, postfix, new FileAttribute[0]);
        try {
            object = action.apply((Object)file.toFile());
        }
        finally {
            if (!keepFile) {
                file.toFile().delete();
            }
        }
        return (T)object;
    }

    public <T> T withTemporaryFile(String prefix, String postfix, Function1<File, T> action) {
        return this.withTemporaryFile(prefix, postfix, false, action);
    }

    public Iterable<File> jars(File dir) {
        return Predef$.MODULE$.wrapRefArray((Object[])this.listFiles(dir, GlobFilter$.MODULE$.apply("*.jar")));
    }

    public void deleteIfEmpty(Set<File> dirs) {
        HashMap isEmpty = new HashMap();
        dirs.foreach((Function1 & Serializable)f -> this.visit$1(isEmpty, (Set)dirs, (File)f));
        isEmpty.withFilter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                File f = (File)tuple2._1();
                if (BoxesRunTime.unboxToBoolean((Object)tuple2._2())) {
                    return true;
                }
            }
            return false;
        }).foreach((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                File f = (File)tuple2._1();
                if (BoxesRunTime.unboxToBoolean((Object)tuple2._2())) {
                    return f.delete();
                }
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public void delete(Iterable<File> files) {
        files.foreach((Function1)(JProcedure1 & Serializable)file -> MODULE$.delete((File)file));
    }

    public void deleteFilesEmptyDirs(Iterable<File> files) {
        this.delete(files);
        this.deleteEmpty$1(this.parents$1(files.toSet()));
    }

    public void delete(File file) {
        Retry$.MODULE$.apply((Function0 & Serializable)() -> {
            IO$.delete$$anonfun$2(file);
            return BoxedUnit.UNIT;
        }, (Seq<Class<? extends Throwable>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[0]));
    }

    public File[] listFiles(FileFilter filter, File dir) {
        return this.wrapNull(dir.listFiles(filter));
    }

    public File[] listFiles(File dir, FileFilter filter) {
        return this.wrapNull(dir.listFiles(filter));
    }

    public File[] listFiles(File dir) {
        return this.wrapNull(dir.listFiles());
    }

    public File[] wrapNull(File[] a) {
        if (a == null) {
            return new File[0];
        }
        return a;
    }

    public void jar(Iterable<Tuple2<File, String>> sources, File outputJar, java.util.jar.Manifest manifest) {
        this.archive((Seq<Tuple2<File, String>>)sources.toSeq(), outputJar, (Option<java.util.jar.Manifest>)Some$.MODULE$.apply((Object)manifest), (Option<Object>)None$.MODULE$);
    }

    public void jar(Iterable<Tuple2<File, String>> sources, File outputJar, java.util.jar.Manifest manifest, Option<Object> time) {
        this.archive((Seq<Tuple2<File, String>>)sources.toSeq(), outputJar, (Option<java.util.jar.Manifest>)Some$.MODULE$.apply((Object)manifest), time);
    }

    public void zip(Iterable<Tuple2<File, String>> sources, File outputZip) {
        this.archive((Seq<Tuple2<File, String>>)sources.toSeq(), outputZip, (Option<java.util.jar.Manifest>)None$.MODULE$, (Option<Object>)None$.MODULE$);
    }

    public void zip(Iterable<Tuple2<File, String>> sources, File outputZip, Option<Object> time) {
        this.archive((Seq<Tuple2<File, String>>)sources.toSeq(), outputZip, (Option<java.util.jar.Manifest>)None$.MODULE$, time);
    }

    private void archive(Seq<Tuple2<File, String>> sources, File outputFile, Option<java.util.jar.Manifest> manifest, Option<Object> time) {
        File parentFile;
        Option localTime = time.map((Function1)(JFunction1.mcJJ.sp & Serializable)t -> t - (long)TimeZone.getDefault().getOffset(t));
        if (outputFile.isDirectory()) {
            throw scala.sys.package$.MODULE$.error(new StringBuilder(38).append("Specified output file ").append(outputFile).append(" is a directory.").toString());
        }
        File file = outputFile.getParentFile();
        File outputDir = file == null ? new File(".") : (parentFile = file);
        this.createDirectory(outputDir);
        this.withZipOutput(outputFile, manifest, (Option<Object>)localTime, (Function1<ZipOutputStream, BoxedUnit>)(JProcedure1 & Serializable)output -> {
            Function1 & Serializable createEntry = manifest.isDefined() ? (Function1 & Serializable)_$4 -> new JarEntry((String)_$4) : (Function1 & Serializable)_$5 -> new ZipEntry((String)_$5);
            MODULE$.writeZip(sources, (ZipOutputStream)output, (Option<Object>)localTime, (Function1<String, ZipEntry>)createEntry);
        });
    }

    private void writeZip(Seq<Tuple2<File, String>> sources, ZipOutputStream output, Option<Object> time, Function1<String, ZipEntry> createEntry) {
        Seq files = (Seq)((SeqOps)sources.flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                File file = (File)tuple2._1();
                String name = (String)tuple2._2();
                if (file.isFile()) {
                    Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)file, (Object)MODULE$.normalizeToSlash(name));
                    return scala.package$.MODULE$.Nil().$colon$colon((Object)tuple22);
                }
                return scala.package$.MODULE$.Nil();
            }
            throw new MatchError((Object)tuple2);
        })).sortBy((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String name = (String)tuple2._2();
                return name;
            }
            throw new MatchError((Object)tuple2);
        }, (Ordering)Ordering.String$.MODULE$);
        long now = System.currentTimeMillis();
        long emptyCRC = new CRC32().getValue();
        this.allDirectoryPaths((Iterable<Tuple2<File, String>>)files).foreach((Function1)(JProcedure1 & Serializable)name -> this.addDirectoryEntry$1(output, (Function1)createEntry, (Option)time, now, emptyCRC, (String)name));
        files.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                File file = (File)tuple2._1();
                String name = (String)tuple2._2();
                this.addFileEntry$1(output, createEntry, time, file, name);
                return;
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private List<String> relativeComponents(String path) {
        return (List)Predef$.MODULE$.wrapRefArray((Object[])path.split("/")).toList().dropRight(1);
    }

    private List<String> directories(List<String> path) {
        return (List)path.foldLeft((Object)new .colon.colon((Object)"", (List)Nil$.MODULE$), (Function2 & Serializable)(e, l) -> {
            String string = new StringBuilder(1).append((String)e.head()).append((String)l).append("/").toString();
            return e.$colon$colon((Object)string);
        });
    }

    private List<String> directoryPaths(String path) {
        return this.directories(this.relativeComponents(path)).filter((Function1 & Serializable)_$6 -> _$6.length() > 1);
    }

    private TreeSet<String> allDirectoryPaths(Iterable<Tuple2<File, String>> files) {
        return (TreeSet)((SetOps)TreeSet$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]), (Object)Ordering.String$.MODULE$)).$plus$plus((IterableOnce)files.flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String name = (String)tuple2._2();
                return MODULE$.directoryPaths(name);
            }
            throw new MatchError((Object)tuple2);
        }));
    }

    private String normalizeToSlash(String name) {
        char sep = File.separatorChar;
        if (sep == '/') {
            return name;
        }
        return name.replace(sep, '/');
    }

    private void withZipOutput(File file, Option<java.util.jar.Manifest> manifest, Option<Object> time, Function1<ZipOutputStream, BoxedUnit> f) {
        ((Using)((Object)Using$.MODULE$.fileOutputStream(false))).apply(file, (JProcedure1 & Serializable)fileOut -> {
            Tuple2 tuple2;
            Option option = manifest;
            if (option instanceof Some) {
                java.util.jar.Manifest mf = (java.util.jar.Manifest)((Some)option).value();
                Attributes main = mf.getMainAttributes();
                if (!main.containsKey(Attributes.Name.MANIFEST_VERSION)) {
                    main.put(Attributes.Name.MANIFEST_VERSION, "1.0");
                }
                JarOutputStream os = new JarOutputStream((OutputStream)fileOut);
                ZipEntry e = new ZipEntry("META-INF/MANIFEST.MF");
                e.setTime(BoxesRunTime.unboxToLong((Object)time.getOrElse(IO$::$anonfun$10)));
                os.putNextEntry(e);
                mf.write(new BufferedOutputStream(os));
                os.closeEntry();
                tuple2 = Tuple2$.MODULE$.apply((Object)os, (Object)"jar");
            } else if (None$.MODULE$.equals(option)) {
                tuple2 = Tuple2$.MODULE$.apply((Object)new ZipOutputStream((OutputStream)fileOut, MODULE$.defaultCharset()), (Object)"zip");
            } else {
                throw new MatchError((Object)option);
            }
            Tuple2 tuple22 = tuple2;
            try (ZipOutputStream zipOut = (ZipOutputStream)tuple22._1();){
                f.apply((Object)zipOut);
            }
        });
    }

    public Option<File> relativizeFile(File base, File file) {
        return this.relativize(base, file).map((Function1 & Serializable)path -> new File((String)path));
    }

    public Option<String> relativize(File base, File file) {
        Path basePath = this.toAbsolutePath$1(base).normalize();
        Path filePath = this.toAbsolutePath$1(file).normalize();
        if (filePath.startsWith(basePath)) {
            Option relativePath = Exception$.MODULE$.catching((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{IllegalArgumentException.class})).opt(() -> IO$.$anonfun$11(basePath, filePath));
            return relativePath.map((Function1 & Serializable)_$7 -> _$7.toString());
        }
        return None$.MODULE$;
    }

    public scala.collection.immutable.Set<File> copy(Iterable<Tuple2<File, File>> sources) {
        return this.copy(sources, CopyOptions$.MODULE$.apply());
    }

    public scala.collection.immutable.Set<File> copy(Iterable<Tuple2<File, File>> sources, CopyOptions options) {
        return this.copy(sources, options.overwrite(), options.preserveLastModified(), options.preserveExecutable());
    }

    public scala.collection.immutable.Set<File> copy(Iterable<Tuple2<File, File>> sources, boolean overwrite, boolean preserveLastModified, boolean preserveExecutable) {
        return ((IterableOnceOps)sources.map(Function$.MODULE$.tupled((Function2 & Serializable)(from, to) -> MODULE$.copyImpl(overwrite, preserveLastModified, preserveExecutable, (File)from, (File)to)))).toSet();
    }

    private File copyImpl(boolean overwrite, boolean preserveLastModified, boolean preserveExecutable, File from, File to) {
        if (overwrite || !to.exists() || this.getModifiedTimeOrZero(from) > this.getModifiedTimeOrZero(to)) {
            if (from.isDirectory()) {
                this.createDirectory(to);
            } else {
                this.createDirectory(to.getParentFile());
                this.copyFile(from, to, preserveLastModified, preserveExecutable);
            }
        }
        return to;
    }

    public void copyDirectory(File source, File target) {
        this.copyDirectory(source, target, CopyOptions$.MODULE$.apply());
    }

    public void copyDirectory(File source, File target, CopyOptions options) {
        this.copyDirectory(source, target, options.overwrite(), options.preserveLastModified(), options.preserveExecutable());
    }

    public void copyDirectory(File source, File target, boolean overwrite, boolean preserveLastModified, boolean preserveExecutable) {
        PathFinder pathFinder = PathFinder$.MODULE$.apply(source).allPaths();
        Seq sources = pathFinder.pair((Function1)Path$.MODULE$.rebase(source, target), pathFinder.pair$default$2());
        this.copy((Iterable<Tuple2<File, File>>)sources, overwrite, preserveLastModified, preserveExecutable);
    }

    public boolean copyDirectory$default$3() {
        return false;
    }

    public boolean copyDirectory$default$4() {
        return false;
    }

    public boolean copyDirectory$default$5() {
        return true;
    }

    public void copyFile(File sourceFile, File targetFile) {
        this.copyFile(sourceFile, targetFile, CopyOptions$.MODULE$.apply());
    }

    public void copyFile(File sourceFile, File targetFile, CopyOptions options) {
        this.copyFile(sourceFile, targetFile, options.preserveLastModified(), options.preserveExecutable());
    }

    public void copyFile(File sourceFile, File targetFile, boolean preserveLastModified, boolean preserveExecutable) {
        Predef$.MODULE$.require(sourceFile.exists(), () -> IO$.copyFile$$anonfun$1(sourceFile));
        Predef$.MODULE$.require(!sourceFile.isDirectory(), () -> IO$.copyFile$$anonfun$2(sourceFile));
        ((Using)((Object)Using$.MODULE$.fileInputChannel())).apply(sourceFile, (JProcedure1 & Serializable)in -> ((Using)((Object)Using$.MODULE$.fileOutputChannel())).apply(targetFile, (JProcedure1 & Serializable)out -> {
            long max = 67076096L;
            long total = in.size();
            long copied = this.loop$1(total, (FileChannel)out, (FileChannel)in, max, 0L);
            if (copied != in.size()) {
                throw scala.sys.package$.MODULE$.error(new StringBuilder(40).append("Could not copy '").append(sourceFile).append("' to '").append(targetFile).append("' (").append(copied).append("/").append(in.size()).append(" bytes copied)").toString());
            }
        }));
        if (preserveLastModified) {
            this.copyLastModified(sourceFile, targetFile);
        }
        if (preserveExecutable) {
            this.copyExecutable(sourceFile, targetFile);
            return;
        }
    }

    public boolean copyFile$default$3() {
        return false;
    }

    public boolean copyFile$default$4() {
        return true;
    }

    public void copyExecutable(File sourceFile, File targetFile) {
        boolean executable = sourceFile.canExecute();
        if (executable) {
            targetFile.setExecutable(true);
            return;
        }
    }

    public Charset defaultCharset() {
        return this.utf8();
    }

    public void write(File file, String content, Charset charset, boolean append) {
        this.writer(file, content, charset, append, (Function1)(JProcedure1 & Serializable)_$8 -> _$8.write(content));
    }

    public Charset write$default$3() {
        return this.defaultCharset();
    }

    public boolean write$default$4() {
        return false;
    }

    public <T> T writer(File file, String content, Charset charset, boolean append, Function1<BufferedWriter, T> f) {
        if (charset.newEncoder().canEncode(content)) {
            return ((Using)((Object)Using$.MODULE$.fileWriter(charset, append))).apply(file, f);
        }
        throw scala.sys.package$.MODULE$.error(new StringBuilder(36).append("String cannot be encoded by charset ").append(charset.name()).toString());
    }

    public boolean writer$default$4() {
        return false;
    }

    public <T> T reader(File file, Charset charset, Function1<BufferedReader, T> f) {
        return ((Using)((Object)Using$.MODULE$.fileReader(charset))).apply(file, f);
    }

    public <T> Charset reader$default$2() {
        return this.defaultCharset();
    }

    public String read(File file, Charset charset) {
        ByteArrayOutputStream out = new ByteArrayOutputStream((int)file.length());
        this.transfer(file, (OutputStream)out);
        return out.toString(charset.name());
    }

    public Charset read$default$2() {
        return this.defaultCharset();
    }

    public String readStream(InputStream in, Charset charset) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.transfer(in, (OutputStream)out);
        return out.toString(charset.name());
    }

    public Charset readStream$default$2() {
        return this.defaultCharset();
    }

    public byte[] readBytes(File file) {
        return (byte[])((Using)((Object)Using$.MODULE$.fileInputStream())).apply(file, (Function1 & Serializable)in -> MODULE$.readBytes((InputStream)in));
    }

    public byte[] readBytes(InputStream in) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.transfer(in, (OutputStream)out);
        return out.toByteArray();
    }

    public void append(File file, String content, Charset charset) {
        this.write(file, content, charset, true);
    }

    public Charset append$default$3() {
        return this.defaultCharset();
    }

    public void append(File file, byte[] bytes) {
        this.writeBytes(file, bytes, true);
    }

    public void write(File file, byte[] bytes) {
        this.writeBytes(file, bytes, false);
    }

    private void writeBytes(File file, byte[] bytes, boolean append) {
        ((Using)((Object)Using$.MODULE$.fileOutputStream(append))).apply(file, (JProcedure1 & Serializable)_$9 -> _$9.write(bytes));
    }

    public List<String> readLinesURL(URL url, Charset charset) {
        return (List)Using$.MODULE$.urlReader(charset).apply(url, (Function1 & Serializable)in -> MODULE$.readLines((BufferedReader)in));
    }

    public Charset readLinesURL$default$2() {
        return this.defaultCharset();
    }

    public List<String> readLines(File file, Charset charset) {
        return (List)((Using)((Object)Using$.MODULE$.fileReader(charset))).apply(file, (Function1 & Serializable)in -> MODULE$.readLines((BufferedReader)in));
    }

    public Charset readLines$default$2() {
        return this.defaultCharset();
    }

    public List<String> readLines(BufferedReader in) {
        return ((List)this.foldLines(in, scala.package$.MODULE$.Nil(), (Function2 & Serializable)(accum, line) -> accum.$colon$colon(line))).reverse();
    }

    public void foreachLine(BufferedReader in, Function1<String, BoxedUnit> f) {
        this.foldLines(in, (Object)BoxedUnit.UNIT, (Function2)(JProcedure2 & Serializable)(_$10, line) -> f.apply(line));
    }

    public <T> T foldLines(BufferedReader in, T init, Function2<T, String, T> f) {
        return (T)this.readLine$1(in, f, init);
    }

    public void writeLines(File file, Seq<String> lines, Charset charset, boolean append) {
        this.writer(file, (String)lines.headOption().getOrElse(IO$::writeLines$$anonfun$1), charset, append, (Function1)(JProcedure1 & Serializable)w -> lines.foreach((Function1)(JProcedure1 & Serializable)line -> {
            w.write((String)line);
            w.newLine();
        }));
    }

    public Charset writeLines$default$3() {
        return this.defaultCharset();
    }

    public boolean writeLines$default$4() {
        return false;
    }

    public void writeLines(PrintWriter writer, Seq<String> lines) {
        lines.foreach((Function1)(JProcedure1 & Serializable)x$0 -> writer.println((String)x$0));
    }

    public void write(Properties properties, String label, File to) {
        ((Using)((Object)Using$.MODULE$.fileOutputStream(Using$.MODULE$.fileOutputStream$default$1()))).apply(to, (JProcedure1 & Serializable)output -> properties.store((OutputStream)output, label));
    }

    public void load(Properties properties, File from) {
        if (from.exists()) {
            ((Using)((Object)Using$.MODULE$.fileInputStream())).apply(from, (JProcedure1 & Serializable)input -> properties.load((InputStream)input));
            return;
        }
    }

    public String[] pathSplit(String s) {
        return PathSeparatorPattern.split(s);
    }

    public <T> T stash(scala.collection.immutable.Set<File> files, Function0<T> f) {
        return this.withTemporaryDirectory((Function1 & Serializable)dir -> {
            Object object;
            Object[] stashed = MODULE$.stashLocations((File)dir, (File[])files.toArray(ClassTag$.MODULE$.apply(File.class)));
            MODULE$.move((Iterable<Tuple2<File, File>>)Predef$.MODULE$.wrapRefArray(stashed));
            try {
                object = f.apply();
            }
            catch (Exception e) {
                try {
                    Object object2 = Predef$.MODULE$.refArrayOps(stashed);
                    MODULE$.move((Iterable<Tuple2<File, File>>)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object2, (Function1 & Serializable)_$11 -> _$11.swap(), ClassTag$.MODULE$.apply(Tuple2.class))));
                    throw e;
                }
                catch (Exception exception) {
                    throw e;
                }
            }
            return object;
        });
    }

    private Tuple2<File, File>[] stashLocations(File dir, File[] files) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])files);
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(object));
        return (Tuple2[])ArrayOps$.MODULE$.withFilter$extension(object2, (Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                File file = (File)tuple2._1();
                int index = BoxesRunTime.unboxToInt((Object)tuple2._2());
                return true;
            }
            return false;
        }).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                File file = (File)tuple2._1();
                int index = BoxesRunTime.unboxToInt((Object)tuple2._2());
                return Tuple2$.MODULE$.apply((Object)file, (Object)new File(dir, RichInt$.MODULE$.toHexString$extension(Predef$.MODULE$.intWrapper(index))));
            }
            throw new MatchError((Object)tuple2);
        }, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public void move(Iterable<Tuple2<File, File>> files) {
        files.foreach(Function$.MODULE$.tupled((Function2)(JProcedure2 & Serializable)(_$12, _$13) -> MODULE$.move((File)_$12, (File)_$13)));
    }

    public void move(File a, File b) {
        this.move(a.toPath(), b.toPath());
    }

    public void move(Path a, Path b) {
        this.createDirectory(b.getParent().toFile());
        Retry$.MODULE$.apply(() -> IO$.move$$anonfun$2(a, b), (Seq<Class<? extends Throwable>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[0]));
    }

    public <T> T gzipFileOut(File file, Function1<OutputStream, T> f) {
        return (T)((Using)((Object)Using$.MODULE$.fileOutputStream(Using$.MODULE$.fileOutputStream$default$1()))).apply(file, (Function1 & Serializable)fout -> Using$.MODULE$.gzipOutputStream().apply((OutputStream)fout, (Function1 & Serializable)outg -> Using$.MODULE$.bufferedOutputStream().apply((OutputStream)outg, f)));
    }

    public <T> T gzipFileIn(File file, Function1<InputStream, T> f) {
        return (T)((Using)((Object)Using$.MODULE$.fileInputStream())).apply(file, (Function1 & Serializable)fin -> Using$.MODULE$.gzipInputStream().apply((InputStream)fin, (Function1 & Serializable)ing -> Using$.MODULE$.bufferedInputStream().apply((InputStream)ing, f)));
    }

    public URI directoryURI(File dir) {
        this.assertAbsolute(dir);
        return this.directoryURI(dir.toURI().normalize());
    }

    /*
     * Unable to fully structure code
     */
    public URI directoryURI(URI uri) {
        if (!uri.isAbsolute()) {
            return uri;
        }
        str = uri.toASCIIString();
        if (str.endsWith("/")) ** GOTO lbl-1000
        v0 = uri.getScheme();
        var4_3 = this.FileScheme();
        if ((v0 != null ? v0.equals(var4_3) == false : var4_3 != null) || uri.getRawFragment() != null) lbl-1000:
        // 2 sources

        {
            v1 = uri;
        } else {
            v1 = new URI(new StringBuilder(1).append(str).append("/").toString());
        }
        dirURI = v1;
        return dirURI.normalize();
    }

    public boolean isWindows() {
        return isWindows;
    }

    public URI toURI(File f) {
        String p = f.getPath();
        if (this.isWindows() && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(p)) && StringOps$.MODULE$.head$extension(Predef$.MODULE$.augmentString(p)) == File.separatorChar) {
            if (p.startsWith("\\\\")) {
                return new URI(this.FileScheme(), this.normalizeToSlash(p), null);
            }
            return new URI(this.FileScheme(), "", this.normalizeToSlash(p), null);
        }
        if (f.isAbsolute()) {
            return new URI(this.FileScheme(), "", this.normalizeToSlash(this.ensureHeadSlash$1(f.getAbsolutePath())), null);
        }
        return new URI(null, this.normalizeToSlash(f.getPath()), null);
    }

    public File resolve(File base, File f) {
        this.assertAbsolute(base);
        File fabs = f.isAbsolute() ? f : new File(this.directoryURI(new File(base, f.getPath())));
        this.assertAbsolute(fabs);
        return fabs;
    }

    public void assertAbsolute(File f) {
        if (!f.isAbsolute()) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(14).append("Not absolute: ").append(f).toString());
        }
    }

    public void assertAbsolute(URI uri) {
        if (!uri.isAbsolute()) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(14).append("Not absolute: ").append(uri).toString());
        }
    }

    public Seq<File> parseClasspath(String s) {
        if (s.isEmpty()) {
            return scala.package$.MODULE$.Nil();
        }
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.pathSplit(s));
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)_$14 -> new File((String)_$14), ClassTag$.MODULE$.apply(File.class)));
        return ArrayOps$.MODULE$.toSeq$extension(object2);
    }

    public ObjectInputStream objectInputStream(InputStream wrapped, ClassLoader loader) {
        return new ObjectInputStream(wrapped, loader){
            private final ClassLoader loader$2;
            {
                this.loader$2 = loader$1;
                super(wrapped$1);
            }

            public Class resolveClass(ObjectStreamClass osc) {
                Class<?> c = Class.forName(osc.getName(), false, this.loader$2);
                if (c == null) {
                    return super.resolveClass(osc);
                }
                return c;
            }
        };
    }

    public boolean isPosix() {
        return this.hasPosixFileAttributeView();
    }

    public boolean hasPosixFileAttributeView() {
        Object object = this.hasPosixFileAttributeView$lzy1;
        if (object instanceof Boolean) {
            return BoxesRunTime.unboxToBoolean((Object)object);
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return BoxesRunTime.unboxToBoolean(null);
        }
        return BoxesRunTime.unboxToBoolean((Object)this.hasPosixFileAttributeView$lzyINIT1());
    }

    private Object hasPosixFileAttributeView$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.hasPosixFileAttributeView$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Boolean bl = null;
                    try {
                        bl = BoxesRunTime.boxToBoolean((boolean)this.supportedFileAttributeViews().contains((Object)"posix"));
                        object2 = bl == null ? LazyVals.NullValue$.MODULE$ : bl;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.hasPosixFileAttributeView$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return bl;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public boolean hasFileOwnerAttributeView() {
        Object object = this.hasFileOwnerAttributeView$lzy1;
        if (object instanceof Boolean) {
            return BoxesRunTime.unboxToBoolean((Object)object);
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return BoxesRunTime.unboxToBoolean(null);
        }
        return BoxesRunTime.unboxToBoolean((Object)this.hasFileOwnerAttributeView$lzyINIT1());
    }

    private Object hasFileOwnerAttributeView$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.hasFileOwnerAttributeView$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_3, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Boolean bl = null;
                    try {
                        bl = BoxesRunTime.boxToBoolean((boolean)this.supportedFileAttributeViews().contains((Object)"owner"));
                        object2 = bl == null ? LazyVals.NullValue$.MODULE$ : bl;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_3, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.hasFileOwnerAttributeView$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_3, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return bl;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_3, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public boolean hasDosFileAttributeView() {
        Object object = this.hasDosFileAttributeView$lzy1;
        if (object instanceof Boolean) {
            return BoxesRunTime.unboxToBoolean((Object)object);
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return BoxesRunTime.unboxToBoolean(null);
        }
        return BoxesRunTime.unboxToBoolean((Object)this.hasDosFileAttributeView$lzyINIT1());
    }

    private Object hasDosFileAttributeView$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.hasDosFileAttributeView$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_4, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Boolean bl = null;
                    try {
                        bl = BoxesRunTime.boxToBoolean((boolean)this.supportedFileAttributeViews().contains((Object)"dos"));
                        object2 = bl == null ? LazyVals.NullValue$.MODULE$ : bl;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_4, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.hasDosFileAttributeView$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_4, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return bl;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_4, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public boolean hasAclFileAttributeView() {
        Object object = this.hasAclFileAttributeView$lzy1;
        if (object instanceof Boolean) {
            return BoxesRunTime.unboxToBoolean((Object)object);
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return BoxesRunTime.unboxToBoolean(null);
        }
        return BoxesRunTime.unboxToBoolean((Object)this.hasAclFileAttributeView$lzyINIT1());
    }

    private Object hasAclFileAttributeView$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.hasAclFileAttributeView$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_5, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Boolean bl = null;
                    try {
                        bl = BoxesRunTime.boxToBoolean((boolean)this.supportedFileAttributeViews().contains((Object)"acl"));
                        object2 = bl == null ? LazyVals.NullValue$.MODULE$ : bl;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_5, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.hasAclFileAttributeView$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_5, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return bl;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_5, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public boolean hasBasicFileAttributeView() {
        Object object = this.hasBasicFileAttributeView$lzy1;
        if (object instanceof Boolean) {
            return BoxesRunTime.unboxToBoolean((Object)object);
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return BoxesRunTime.unboxToBoolean(null);
        }
        return BoxesRunTime.unboxToBoolean((Object)this.hasBasicFileAttributeView$lzyINIT1());
    }

    private Object hasBasicFileAttributeView$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.hasBasicFileAttributeView$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_6, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Boolean bl = null;
                    try {
                        bl = BoxesRunTime.boxToBoolean((boolean)this.supportedFileAttributeViews().contains((Object)"basic"));
                        object2 = bl == null ? LazyVals.NullValue$.MODULE$ : bl;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_6, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.hasBasicFileAttributeView$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_6, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return bl;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_6, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public boolean hasUserDefinedFileAttributeView() {
        Object object = this.hasUserDefinedFileAttributeView$lzy1;
        if (object instanceof Boolean) {
            return BoxesRunTime.unboxToBoolean((Object)object);
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return BoxesRunTime.unboxToBoolean(null);
        }
        return BoxesRunTime.unboxToBoolean((Object)this.hasUserDefinedFileAttributeView$lzyINIT1());
    }

    private Object hasUserDefinedFileAttributeView$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.hasUserDefinedFileAttributeView$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_7, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Boolean bl = null;
                    try {
                        bl = BoxesRunTime.boxToBoolean((boolean)this.supportedFileAttributeViews().contains((Object)"user"));
                        object2 = bl == null ? LazyVals.NullValue$.MODULE$ : bl;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_7, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.hasUserDefinedFileAttributeView$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_7, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return bl;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_7, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private scala.collection.immutable.Set<String> supportedFileAttributeViews() {
        Object object = this.supportedFileAttributeViews$lzy1;
        if (object instanceof scala.collection.immutable.Set) {
            return (scala.collection.immutable.Set)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (scala.collection.immutable.Set)this.supportedFileAttributeViews$lzyINIT1();
    }

    private Object supportedFileAttributeViews$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.supportedFileAttributeViews$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_8, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    scala.collection.immutable.Set set = null;
                    try {
                        set = ((IterableOnceOps)JavaConverters$.MODULE$.asScalaSetConverter(FileSystems.getDefault().supportedFileAttributeViews()).asScala()).toSet();
                        object2 = set == null ? LazyVals.NullValue$.MODULE$ : set;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_8, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.supportedFileAttributeViews$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_8, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return set;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_8, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public void setPermissions(File file, String permissions) {
        new RichFile(Path$.MODULE$.apply(file)).setPermissions(((IterableOnceOps)JavaConverters$.MODULE$.asScalaSetConverter(PosixFilePermissions.fromString(permissions)).asScala()).toSet());
    }

    public void chmod(String permissions, File file) {
        this.setPermissions(file, permissions);
    }

    public void setOwner(File file, String owner) {
        new RichFile(Path$.MODULE$.apply(file)).setOwner(owner);
    }

    public void chown(String owner, File file) {
        this.setOwner(file, owner);
    }

    public void setGroup(File file, String group) {
        new RichFile(Path$.MODULE$.apply(file)).setGroup(group);
    }

    public void chgrp(String group, File file) {
        this.setGroup(file, group);
    }

    public long getModifiedTime(File file) {
        return Milli$.MODULE$.getModifiedTime(file);
    }

    public void setModifiedTime(File file, long mtime) {
        Milli$.MODULE$.setModifiedTime(file, mtime);
    }

    public void copyModifiedTime(File fromFile, File toFile) {
        Milli$.MODULE$.copyModifiedTime(fromFile, toFile);
    }

    public long getModifiedTimeOrZero(File file) {
        long l;
        while (true) {
            try {
                l = BoxesRunTime.unboxToLong(Retry$.MODULE$.apply(() -> IO$.getModifiedTimeOrZero$$anonfun$1(file), excludeFileNotFound));
            }
            catch (FileNotFoundException fileNotFoundException) {
                Path unnormalized = file.toPath();
                Path normalized = unnormalized.normalize().toAbsolutePath();
                Path path = unnormalized;
                Path path2 = normalized;
                if (path == null ? path2 != null : !((Object)path).equals(path2)) {
                    file = normalized.toFile();
                    continue;
                }
                l = 0L;
            }
            break;
        }
        return l;
    }

    public boolean setModifiedTimeOrFalse(File file, long mtime) {
        boolean bl;
        while (true) {
            try {
                Retry$.MODULE$.apply((Function0 & Serializable)() -> {
                    IO$.setModifiedTimeOrFalse$$anonfun$1(file, mtime);
                    return BoxedUnit.UNIT;
                }, excludeFileNotFound);
                bl = true;
            }
            catch (FileNotFoundException fileNotFoundException) {
                Path unnormalized = file.toPath();
                Path normalized = unnormalized.normalize().toAbsolutePath();
                Path path = unnormalized;
                Path path2 = normalized;
                if (path == null ? path2 != null : !((Object)path).equals(path2)) {
                    file = normalized.toFile();
                    continue;
                }
                bl = false;
            }
            break;
        }
        return bl;
    }

    public boolean copyLastModified(File sourceFile, File targetFile) {
        long last = this.getModifiedTimeOrZero(sourceFile);
        return this.setModifiedTimeOrFalse(targetFile, package$.MODULE$.max(last, 0L));
    }

    private static final Path classLocationPath$$anonfun$1(URL u$1, Class cl$1) {
        throw scala.sys.package$.MODULE$.error(new StringBuilder(32).append("Unable to create File from ").append(u$1).append(" for ").append(cl$1).toString());
    }

    private static final File classLocationFile$$anonfun$1(Class cl$2) {
        throw scala.sys.package$.MODULE$.error(new StringBuilder(27).append("Unable to create File from ").append(cl$2).toString());
    }

    private final Option localcl$1(Class cl$3) {
        return Option$.MODULE$.apply((Object)cl$3.getProtectionDomain().getCodeSource()).flatMap((Function1 & Serializable)codeSource -> Option$.MODULE$.apply((Object)codeSource.getLocation()));
    }

    private final Option syscl$1(String clsfile$1) {
        return Option$.MODULE$.apply((Object)ClassLoader.getSystemClassLoader()).flatMap((Function1 & Serializable)classLoader -> Option$.MODULE$.apply((Object)classLoader.getResource(clsfile$1)));
    }

    private final Option classLocation$$anonfun$1(String clsfile$7) {
        return this.syscl$1(clsfile$7);
    }

    private static final URL classLocation$$anonfun$3(Class cl$4) {
        throw scala.sys.package$.MODULE$.error(new StringBuilder(22).append("No class location for ").append(cl$4).toString());
    }

    private final Option localcl$2(Class cl$5, String clsfile$3) {
        return Option$.MODULE$.apply((Object)cl$5.getClassLoader()).flatMap((Function1 & Serializable)classLoader -> Option$.MODULE$.apply((Object)classLoader.getResource(clsfile$3)));
    }

    private final Option syscl$2(String clsfile$5) {
        return Option$.MODULE$.apply((Object)ClassLoader.getSystemClassLoader()).flatMap((Function1 & Serializable)classLoader -> Option$.MODULE$.apply((Object)classLoader.getResource(clsfile$5)));
    }

    private final Option classfileLocation$$anonfun$1(String clsfile$8) {
        return this.syscl$2(clsfile$8);
    }

    private static final URL classfileLocation$$anonfun$2(Class cl$6) {
        throw scala.sys.package$.MODULE$.error(new StringBuilder(22).append("No class location for ").append(cl$6).toString());
    }

    private static final File asFile$$anonfun$1(URL url$1) {
        throw scala.sys.package$.MODULE$.error(new StringBuilder(19).append("URL is not a file: ").append(url$1).toString());
    }

    private static final String $anonfun$2(File absFile$1) {
        return new StringBuilder(22).append("Could not create file ").append(absFile$1).toString();
    }

    private static final boolean $anonfun$3(File absFile$2) {
        return absFile$2.createNewFile();
    }

    private static final void touch$$anonfun$2(File file$1, boolean setModified$1) {
        File absFile = file$1.getAbsoluteFile();
        MODULE$.createDirectory(absFile.getParentFile());
        boolean created = BoxesRunTime.unboxToBoolean(ErrorHandling$.MODULE$.translate((Function0<String>)((Function0 & Serializable)() -> IO$.$anonfun$2(absFile)), () -> IO$.$anonfun$3(absFile)));
        if (created || absFile.isDirectory()) {
            return;
        }
        if (setModified$1 && !MODULE$.setModifiedTimeOrFalse(absFile, System.currentTimeMillis())) {
            throw scala.sys.package$.MODULE$.error(new StringBuilder(45).append("Could not update last modified time for file ").append(absFile).toString());
        }
    }

    private final String failBase$1(File dir$1) {
        return new StringBuilder(27).append("Could not create directory ").append(dir$1).toString();
    }

    private static final Object createDirectory$$anonfun$1(Path path$1) {
        Path path;
        try {
            path = Files.createDirectories(path$1, new FileAttribute[0]);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!(throwable2 instanceof IOException) || !Files.isDirectory(path$1, new LinkOption[0])) {
                throw throwable;
            }
            path = BoxedUnit.UNIT;
        }
        return path;
    }

    private static final Object gzip$$anonfun$1() {
        return "Input file cannot be the same as the output file.";
    }

    private static final Object gunzip$$anonfun$1() {
        return "Input file cannot be the same as the output file.";
    }

    private final void validateExtractPath$1(String canonicalDirPath$1, String name, Path target) {
        if (!target.normalize().toString().startsWith(canonicalDirPath$1)) {
            throw new RuntimeException(new StringBuilder(43).append("Entry (").append(name).append(") is outside of the target directory").toString());
        }
    }

    private static final String next$1$$anonfun$1(String name$1, Path target$1) {
        return new StringBuilder(37).append("Error extracting zip entry '").append(name$1).append("' to '").append(target$1).append("': ").toString();
    }

    private static final void next$1$$anonfun$2(Path target$2, ZipInputStream from$2) {
        ((Using)((Object)Using$.MODULE$.fileOutputStream(false))).apply(target$2.toFile(), (JProcedure1 & Serializable)out -> MODULE$.transfer((InputStream)from$2, (OutputStream)out));
    }

    private final void next$1(ZipInputStream from$1, NameFilter filter$4, Path toDirectory$4, HashSet set$1, boolean preserveLastModified$4, String canonicalDirPath$2) {
        ZipEntry entry;
        while ((entry = from$1.getNextEntry()) != null) {
            String name = entry.getName();
            if (filter$4.accept(name)) {
                Path target = toDirectory$4.resolve(name);
                this.validateExtractPath$1(canonicalDirPath$2, name, target);
                if (entry.isDirectory()) {
                    this.createDirectory(target.toFile());
                } else {
                    set$1.$plus$eq((Object)target);
                    ErrorHandling$.MODULE$.translate((Function0<String>)((Function0 & Serializable)() -> IO$.next$1$$anonfun$1(name, target)), (Function0 & Serializable)() -> {
                        IO$.next$1$$anonfun$2(target, from$1);
                        return BoxedUnit.UNIT;
                    });
                }
                if (preserveLastModified$4) {
                    this.setModifiedTimeOrFalse(target.toFile(), entry.getTime());
                }
            }
            from$1.closeEntry();
        }
        return;
    }

    private final void read$1(InputStream in$2, byte[] buffer$1, OutputStream out$5) {
        int byteCount;
        while ((byteCount = in$2.read(buffer$1)) >= 0) {
            out$5.write(buffer$1, 0, byteCount);
        }
    }

    private final File create$1(File baseDirectory$1, int tries) {
        File file;
        while (true) {
            if (tries > MaximumTries) {
                throw scala.sys.package$.MODULE$.error("Could not create temporary directory.");
            }
            String randomName = new StringBuilder(4).append("sbt_").append(Integer.toHexString(this.random().nextInt())).toString();
            File f = new File(baseDirectory$1, randomName);
            try {
                this.createDirectory(f);
                file = f;
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3 = (Throwable)option.get();
                    ++tries;
                    continue;
                }
                throw throwable;
            }
            break;
        }
        return file;
    }

    private final boolean visit$1$$anonfun$1(Set dirs$2, File f$1, HashMap isEmpty$2) {
        Object object;
        return dirs$2.apply((Object)f$1) && f$1.isDirectory() && ArrayOps$.MODULE$.forall$extension(object = Predef$.MODULE$.refArrayOps((Object[])f$1.listFiles()), (Function1 & Serializable)f -> this.visit$1(isEmpty$2, dirs$2, (File)f));
    }

    private final boolean visit$1(HashMap isEmpty$1, Set dirs$1, File f) {
        return BoxesRunTime.unboxToBoolean((Object)isEmpty$1.getOrElseUpdate((Object)f, () -> this.visit$1$$anonfun$1(dirs$1, f, isEmpty$1)));
    }

    private final boolean isEmptyDirectory$1(File dir) {
        Object object;
        return dir.isDirectory() && ArrayOps$.MODULE$.isEmpty$extension(object = Predef$.MODULE$.refArrayOps((Object[])this.listFiles(dir)));
    }

    private final scala.collection.immutable.Set parents$1(scala.collection.immutable.Set fs) {
        return (scala.collection.immutable.Set)fs.flatMap((Function1 & Serializable)f -> Option$.MODULE$.apply((Object)f.getParentFile()));
    }

    private final void deleteEmpty$1(scala.collection.immutable.Set dirs) {
        scala.collection.immutable.Set empty;
        while ((empty = (scala.collection.immutable.Set)dirs.filter((Function1 & Serializable)dir -> this.isEmptyDirectory$1((File)dir))).nonEmpty()) {
            empty.foreach((Function1 & Serializable)_$3 -> _$3.delete());
            dirs = this.parents$1(empty);
        }
    }

    private static final void delete$$anonfun$2(File file$2) {
        Object object;
        try {
            FileTreeView$.MODULE$.default().list(file$2.toPath()).foreach((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Boolean bl;
                    Path path;
                    Path dir = path = (Path)tuple2._1();
                    FileAttributes attrs = (FileAttributes)tuple2._2();
                    if (attrs.isDirectory()) {
                        MODULE$.delete(dir.toFile());
                        return BoxedUnit.UNIT;
                    }
                    Path f = path;
                    try {
                        bl = BoxesRunTime.boxToBoolean((boolean)Files.deleteIfExists(f));
                    }
                    catch (IOException iOException) {
                        bl = BoxedUnit.UNIT;
                    }
                    return bl;
                }
                throw new MatchError((Object)tuple2);
            });
        }
        catch (IOException iOException) {}
        try {
            object = BoxesRunTime.boxToBoolean((boolean)Files.deleteIfExists(file$2.toPath()));
        }
        catch (IOException iOException) {
            object = BoxedUnit.UNIT;
        }
    }

    private final void addDirectoryEntry$1(ZipOutputStream output$2, Function1 createEntry$1, Option time$1, long now$1, long emptyCRC$1, String name) {
        output$2.putNextEntry(this.makeDirectoryEntry$1(createEntry$1, time$1, now$1, emptyCRC$1, name));
        output$2.closeEntry();
    }

    private static final long makeDirectoryEntry$1$$anonfun$1(long now$3) {
        return now$3;
    }

    private final ZipEntry makeDirectoryEntry$1(Function1 createEntry$2, Option time$2, long now$2, long emptyCRC$2, String name) {
        ZipEntry e = (ZipEntry)createEntry$2.apply((Object)name);
        e.setTime(BoxesRunTime.unboxToLong((Object)time$2.getOrElse(() -> IO$.makeDirectoryEntry$1$$anonfun$1(now$2))));
        e.setSize(0L);
        e.setMethod(0);
        e.setCrc(emptyCRC$2);
        return e;
    }

    private static final long makeFileEntry$1$$anonfun$1(File file$3) {
        return MODULE$.getModifiedTimeOrZero(file$3);
    }

    private final ZipEntry makeFileEntry$1(Function1 createEntry$3, Option time$3, File file, String name) {
        ZipEntry e = (ZipEntry)createEntry$3.apply((Object)name);
        e.setTime(BoxesRunTime.unboxToLong((Object)time$3.getOrElse(() -> IO$.makeFileEntry$1$$anonfun$1(file))));
        return e;
    }

    private final void addFileEntry$1(ZipOutputStream output$3, Function1 createEntry$4, Option time$4, File file, String name) {
        output$3.putNextEntry(this.makeFileEntry$1(createEntry$4, time$4, file, name));
        this.transfer(file, (OutputStream)output$3);
        output$3.closeEntry();
    }

    private static final long $anonfun$10() {
        return System.currentTimeMillis();
    }

    private final Path toAbsolutePath$1(File x) {
        Path p = x.toPath();
        if (!p.isAbsolute()) {
            return p.toAbsolutePath();
        }
        return p;
    }

    private static final Path $anonfun$11(Path basePath$1, Path filePath$1) {
        return basePath$1.relativize(filePath$1);
    }

    private static final Object copyFile$$anonfun$1(File sourceFile$1) {
        return new StringBuilder(30).append("Source file '").append(sourceFile$1.getAbsolutePath()).append("' does not exist.").toString();
    }

    private static final Object copyFile$$anonfun$2(File sourceFile$2) {
        return new StringBuilder(30).append("Source file '").append(sourceFile$2.getAbsolutePath()).append("' is a directory.").toString();
    }

    private final long loop$1(long total$1, FileChannel out$6, FileChannel in$4, long max$1, long offset) {
        while (offset < total$1) {
            offset += out$6.transferFrom(in$4, offset, max$1);
        }
        return offset;
    }

    private final Object readLine$1(BufferedReader in$5, Function2 f$4, Object accum) {
        String line;
        while ((line = in$5.readLine()) != null) {
            accum = f$4.apply(accum, (Object)line);
        }
        return accum;
    }

    private static final String writeLines$$anonfun$1() {
        return "";
    }

    private static final Path move$$anonfun$2(Path a$1, Path b$1) {
        return Files.move(a$1, b$1, StandardCopyOption.REPLACE_EXISTING);
    }

    private final String ensureHeadSlash$1(String name) {
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(name)) && StringOps$.MODULE$.head$extension(Predef$.MODULE$.augmentString(name)) != File.separatorChar) {
            return new StringBuilder(0).append(File.separatorChar).append(name).toString();
        }
        return name;
    }

    private static final long getModifiedTimeOrZero$$anonfun$1(File file$tailLocal1$1) {
        return Milli$.MODULE$.getModifiedTime(file$tailLocal1$1);
    }

    private static final void setModifiedTimeOrFalse$$anonfun$1(File file$tailLocal2$1, long mtime$1) {
        Milli$.MODULE$.setModifiedTime(file$tailLocal2$1, mtime$1);
    }
}

