/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.nio;

import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import sbt.internal.io.NewWatchState;
import sbt.internal.nio.FileCache;
import sbt.internal.nio.FileEvent;
import sbt.internal.nio.FileEvent$Creation$;
import sbt.internal.nio.FileEvent$Deletion$;
import sbt.internal.nio.Observable;
import sbt.internal.nio.Observer;
import sbt.internal.nio.Observers;
import sbt.internal.nio.Registerable;
import sbt.internal.nio.TimeSource$default$;
import sbt.internal.nio.WatchLogger;
import sbt.internal.nio.WatchServiceBackedObservable$;
import sbt.nio.file.AnyPath$;
import sbt.nio.file.FileAttributes;
import sbt.nio.file.FileAttributes$;
import sbt.nio.file.FileAttributes$NonExistent$;
import sbt.nio.file.FileTreeView;
import sbt.nio.file.FileTreeView$;
import sbt.nio.file.FileTreeView$Ops$;
import sbt.nio.file.Glob;
import sbt.nio.file.Glob$;
import sbt.nio.file.Glob$GlobOps$;
import sbt.nio.file.Glob$RelativeGlobViewOption$;
import sbt.nio.file.RecursiveGlob$;
import sbt.nio.file.RelativeGlob;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.SeqOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NonFatal$;

public class WatchServiceBackedObservable
implements Registerable<FileEvent<FileAttributes>>,
Observable<FileEvent<FileAttributes>> {
    public final NewWatchState sbt$internal$nio$WatchServiceBackedObservable$$s;
    public final FiniteDuration sbt$internal$nio$WatchServiceBackedObservable$$delay;
    private final boolean closeService;
    public final WatchLogger sbt$internal$nio$WatchServiceBackedObservable$$logger;
    public final AtomicBoolean sbt$internal$nio$WatchServiceBackedObservable$$closed;
    public final Observers<FileEvent<FileAttributes>> sbt$internal$nio$WatchServiceBackedObservable$$observers;
    public final FileCache<FileAttributes> sbt$internal$nio$WatchServiceBackedObservable$$fileCache;
    public final FileTreeView<Tuple2<Path, FileAttributes>> sbt$internal$nio$WatchServiceBackedObservable$$view;
    private final Thread thread;

    public WatchServiceBackedObservable(NewWatchState s, FiniteDuration delay, boolean closeService, WatchLogger logger) {
        this.sbt$internal$nio$WatchServiceBackedObservable$$s = s;
        this.sbt$internal$nio$WatchServiceBackedObservable$$delay = delay;
        this.closeService = closeService;
        this.sbt$internal$nio$WatchServiceBackedObservable$$logger = logger;
        this.sbt$internal$nio$WatchServiceBackedObservable$$closed = new AtomicBoolean(false);
        this.sbt$internal$nio$WatchServiceBackedObservable$$observers = new Observers();
        this.sbt$internal$nio$WatchServiceBackedObservable$$fileCache = new FileCache((Function1 & Serializable)p -> (FileAttributes)FileAttributes$.MODULE$.apply((Path)p).getOrElse(WatchServiceBackedObservable::$init$$$anonfun$1$$anonfun$1));
        this.sbt$internal$nio$WatchServiceBackedObservable$$view = FileTreeView$.MODULE$.default();
        CountDownLatch latch = new CountDownLatch(1);
        this.thread = new Thread(latch, this){
            private final CountDownLatch latch$2;
            private final /* synthetic */ WatchServiceBackedObservable $outer;
            {
                this.latch$2 = latch$1;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super(new StringBuilder(25).append("watch-state-event-thread-").append(WatchServiceBackedObservable$.sbt$internal$nio$WatchServiceBackedObservable$$$eventThreadId.incrementAndGet()).toString());
                this.setDaemon(true);
                this.start();
                if (!latch$1.await(5L, TimeUnit.SECONDS)) {
                    throw new IllegalStateException("Couldn't start event thread");
                }
            }

            public final void loopImpl() {
                do {
                    try {
                        if (this.$outer.sbt$internal$nio$WatchServiceBackedObservable$$closed.get()) continue;
                        this.getFilesForKey(this.$outer.sbt$internal$nio$WatchServiceBackedObservable$$s.service().poll((Duration)this.$outer.sbt$internal$nio$WatchServiceBackedObservable$$delay)).foreach((Function1)(JProcedure1 & Serializable)event -> this.$outer.sbt$internal$nio$WatchServiceBackedObservable$$observers.onNext((FileEvent<FileAttributes>)event));
                    }
                    catch (Throwable throwable) {
                        Option option;
                        Throwable throwable2 = throwable;
                        if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                            Throwable throwable3;
                            Throwable e = throwable3 = (Throwable)option.get();
                            this.$outer.sbt$internal$nio$WatchServiceBackedObservable$$logger.debug(new StringBuilder(28).append("Error getting files from ").append(this.$outer.sbt$internal$nio$WatchServiceBackedObservable$$s.service()).append(": ").append(e).append("\n").append(Predef$.MODULE$.wrapRefArray((Object[])e.getStackTrace()).mkString("\n")).toString());
                            continue;
                        }
                        throw throwable;
                    }
                } while (!this.$outer.sbt$internal$nio$WatchServiceBackedObservable$$closed.get());
            }

            public void run() {
                this.latch$2.countDown();
                try {
                    this.loopImpl();
                }
                catch (InterruptedException interruptedException) {}
            }

            public Seq getFilesForKey(WatchKey key) {
                Vector vector;
                WatchKey k;
                WatchKey watchKey = key;
                if (watchKey == null) {
                    return package$.MODULE$.Vector().empty();
                }
                WatchKey watchKey2 = k = watchKey;
                synchronized (watchKey2) {
                    Vector events = ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(k.pollEvents()).asScala()).toVector();
                    k.reset();
                    vector = events;
                }
                Vector rawEvents = vector;
                Path keyPath = (Path)k.watchable();
                Seq allEvents = (Seq)rawEvents.flatMap((Function1 & Serializable)x$1 -> {
                    WatchEvent watchEvent = x$1;
                    WatchEvent e = watchEvent;
                    if (e.kind().equals(StandardWatchEventKinds.OVERFLOW)) {
                        return this.$outer.sbt$internal$nio$WatchServiceBackedObservable$$fileCache.refresh(Glob$.MODULE$.apply(keyPath, (RelativeGlob)RecursiveGlob$.MODULE$));
                    }
                    WatchEvent e2 = watchEvent;
                    if (!e2.kind().equals(StandardWatchEventKinds.OVERFLOW) && e2.context() != null) {
                        Path path = keyPath.resolve((Path)e2.context());
                        Either<IOException, FileAttributes> either = FileAttributes$.MODULE$.apply(path);
                        if (either instanceof Right) {
                            FileAttributes attrs = (FileAttributes)((Right)either).value();
                            return this.$outer.sbt$internal$nio$WatchServiceBackedObservable$$fileCache.update(path, attrs);
                        }
                        return package$.MODULE$.Nil();
                    }
                    return package$.MODULE$.Nil();
                });
                this.$outer.sbt$internal$nio$WatchServiceBackedObservable$$logger.debug(new StringBuilder(17).append("Received events:\n").append(allEvents.mkString("\n")).toString());
                return (Seq)allEvents.flatMap((Function1 & Serializable)event -> this.process$1((FileEvent)event));
            }

            /*
             * Enabled aggressive block sorting
             */
            private final Seq process$1(FileEvent event) {
                Seq seq;
                FileEvent fileEvent = event;
                if (fileEvent instanceof FileEvent.Creation) {
                    FileEvent.Creation<T> creation = FileEvent$Creation$.MODULE$.unapply((FileEvent.Creation)fileEvent);
                    Path path = creation._1();
                    FileAttributes fileAttributes = (FileAttributes)creation._2();
                    Path path2 = path;
                    FileAttributes attrs = fileAttributes;
                    if (attrs.isDirectory()) {
                        this.$outer.sbt$internal$nio$WatchServiceBackedObservable$$s.register(path2);
                        seq = (Seq)((SeqOps)FileTreeView$Ops$.MODULE$.list$extension(FileTreeView$.MODULE$.Ops(this.$outer.sbt$internal$nio$WatchServiceBackedObservable$$view), Glob$.MODULE$.apply(path2, (RelativeGlob)RecursiveGlob$.MODULE$)).flatMap((Function1 & Serializable)x$1 -> {
                            Tuple2 tuple2 = x$1;
                            if (tuple2 != null) {
                                Path p = (Path)tuple2._1();
                                FileAttributes a = (FileAttributes)tuple2._2();
                                return this.process$1(FileEvent$Creation$.MODULE$.apply(p, a, TimeSource$default$.MODULE$));
                            }
                            throw new MatchError((Object)tuple2);
                        })).$plus$colon((Object)event);
                        return (Seq)seq.map(WatchServiceBackedObservable::sbt$internal$nio$WatchServiceBackedObservable$$anon$1$$_$process$1$$anonfun$4);
                    }
                }
                if (fileEvent instanceof FileEvent.Deletion) {
                    FileEvent.Deletion<T> deletion = FileEvent$Deletion$.MODULE$.unapply((FileEvent.Deletion)fileEvent);
                    Path path = deletion._1();
                    FileAttributes fileAttributes = (FileAttributes)deletion._2();
                    Path p = path;
                    FileAttributes attrs = fileAttributes;
                    if (attrs.isDirectory()) {
                        Seq events = this.$outer.sbt$internal$nio$WatchServiceBackedObservable$$fileCache.refresh(Glob$.MODULE$.apply(p, (RelativeGlob)RecursiveGlob$.MODULE$));
                        ((IterableOnceOps)events.view().filter(WatchServiceBackedObservable::sbt$internal$nio$WatchServiceBackedObservable$$anon$1$$_$process$1$$anonfun$2)).foreach((Function1)(JProcedure1 & Serializable)e -> this.$outer.sbt$internal$nio$WatchServiceBackedObservable$$s.unregister(e.path()));
                        seq = events;
                        return (Seq)seq.map(WatchServiceBackedObservable::sbt$internal$nio$WatchServiceBackedObservable$$anon$1$$_$process$1$$anonfun$4);
                    }
                }
                FileEvent e2 = fileEvent;
                seq = package$.MODULE$.Nil().$colon$colon((Object)e2);
                return (Seq)seq.map(WatchServiceBackedObservable::sbt$internal$nio$WatchServiceBackedObservable$$anon$1$$_$process$1$$anonfun$4);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{loopImpl$$anonfun$1(sbt.internal.nio.FileEvent ), $anonfun$1(java.nio.file.Path java.nio.file.WatchEvent ), getFilesForKey$$anonfun$1(sbt.internal.nio.FileEvent ), process$1$$anonfun$1(scala.Tuple2 ), sbt$internal$nio$WatchServiceBackedObservable$$anon$1$$_$process$1$$anonfun$2(sbt.internal.nio.FileEvent ), process$1$$anonfun$3(sbt.internal.nio.FileEvent ), sbt$internal$nio$WatchServiceBackedObservable$$anon$1$$_$process$1$$anonfun$4(sbt.internal.nio.FileEvent )}, serializedLambda);
            }
        };
    }

    @Override
    public AutoCloseable addObserver(Observer<FileEvent<FileAttributes>> observer) {
        return this.sbt$internal$nio$WatchServiceBackedObservable$$observers.addObserver(observer);
    }

    @Override
    public void close() {
        if (this.sbt$internal$nio$WatchServiceBackedObservable$$closed.compareAndSet(false, true)) {
            this.thread.interrupt();
            this.thread.join(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(5)).seconds().toMillis());
            if (this.closeService) {
                this.sbt$internal$nio$WatchServiceBackedObservable$$s.service().close();
            }
            this.sbt$internal$nio$WatchServiceBackedObservable$$logger.debug("Closed WatchServiceBackedObservable");
            return;
        }
    }

    @Override
    public Either<IOException, Observable<FileEvent<FileAttributes>>> register(Glob glob) {
        Left left;
        try {
            Glob glob2;
            this.sbt$internal$nio$WatchServiceBackedObservable$$fileCache.register(glob);
            int n = Glob$GlobOps$.MODULE$.range$extension(Glob$.MODULE$.GlobOps(glob))._2$mcI$sp();
            if (Integer.MAX_VALUE == n) {
                glob2 = Glob$.MODULE$.apply(Glob$GlobOps$.MODULE$.base$extension(Glob$.MODULE$.GlobOps(glob), Glob$RelativeGlobViewOption$.MODULE$.default()), (RelativeGlob)RecursiveGlob$.MODULE$);
            } else {
                int d = n;
                glob2 = (Glob)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), d).foldLeft((Object)Glob$.MODULE$.apply(Glob$GlobOps$.MODULE$.base$extension(Glob$.MODULE$.GlobOps(glob), Glob$RelativeGlobViewOption$.MODULE$.default())), (Function2 & Serializable)(x$1, x$2) -> WatchServiceBackedObservable.$anonfun$2((Glob)x$1, BoxesRunTime.unboxToInt((Object)x$2)));
            }
            Glob updatedGlob = glob2;
            this.sbt$internal$nio$WatchServiceBackedObservable$$fileCache.list(updatedGlob).foreach((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Path path = (Path)tuple2._1();
                    FileAttributes attrs = (FileAttributes)tuple2._2();
                    if (attrs.isDirectory()) {
                        return this.sbt$internal$nio$WatchServiceBackedObservable$$s.register(path);
                    }
                }
                return BoxedUnit.UNIT;
            });
            Observers<FileEvent<FileAttributes>> observable = new Observers<FileEvent<FileAttributes>>(glob){
                private final Glob glob$1;
                {
                    this.glob$1 = glob$3;
                }

                public void onNext(FileEvent t) {
                    if (this.glob$1.matches(t.path())) {
                        super.onNext(t);
                        return;
                    }
                }
            };
            AutoCloseable handle = this.sbt$internal$nio$WatchServiceBackedObservable$$observers.addObserver((Observer<FileEvent<FileAttributes>>)observable);
            left = package$.MODULE$.Right().apply((Object)new Observable<FileEvent<FileAttributes>>((Observers)observable, handle, glob){
                private final Observers observable$1;
                private final AutoCloseable handle$1;
                private final Glob glob$2;
                {
                    this.observable$1 = observable$2;
                    this.handle$1 = handle$2;
                    this.glob$2 = glob$4;
                }

                public AutoCloseable addObserver(Observer observer) {
                    return this.observable$1.addObserver(observer);
                }

                public void close() {
                    this.handle$1.close();
                }

                public String toString() {
                    return new StringBuilder(12).append("Observable(").append(this.glob$2).append(")").toString();
                }
            });
        }
        catch (IOException e) {
            left = package$.MODULE$.Left().apply((Object)e);
        }
        return left;
    }

    private static final FileAttributes $init$$$anonfun$1$$anonfun$1() {
        return FileAttributes$NonExistent$.MODULE$;
    }

    public static final /* synthetic */ boolean sbt$internal$nio$WatchServiceBackedObservable$$anon$1$$_$process$1$$anonfun$2(FileEvent _$1) {
        return ((FileAttributes)_$1.attributes()).isDirectory();
    }

    public static final /* synthetic */ FileEvent sbt$internal$nio$WatchServiceBackedObservable$$anon$1$$_$process$1$$anonfun$4(FileEvent x$1) {
        FileEvent fileEvent = x$1;
        if (fileEvent instanceof FileEvent.Deletion) {
            FileEvent.Deletion deletion = (FileEvent.Deletion)fileEvent;
            FileEvent.Deletion deletion2 = FileEvent$Deletion$.MODULE$.unapply(deletion);
            Path path = deletion2._1();
            FileAttributes fileAttributes = (FileAttributes)deletion2._2();
            Path path2 = path;
            FileAttributes attributes = fileAttributes;
            FileEvent.Deletion d = deletion;
            FileAttributes newAttrs = FileAttributes$.MODULE$.apply(attributes.isDirectory(), false, attributes.isRegularFile(), attributes.isSymbolicLink());
            return FileEvent$Deletion$.MODULE$.apply(path2, newAttrs, d.occurredAt());
        }
        FileEvent e = fileEvent;
        return e;
    }

    private static final /* synthetic */ Glob $anonfun$2(Glob x$1, int x$2) {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)x$1, (Object)BoxesRunTime.boxToInteger((int)x$2));
        if (tuple2 != null) {
            Glob g = (Glob)tuple2._1();
            return Glob$GlobOps$.MODULE$.$div$extension(Glob$.MODULE$.GlobOps(g), AnyPath$.MODULE$);
        }
        throw new MatchError((Object)tuple2);
    }
}

