/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.nio;

import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import sbt.internal.nio.Observable;
import sbt.internal.nio.Observer;
import scala.Option;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

public class Observers<T>
implements Observer<T>,
Observable<T> {
    private final AtomicInteger id = new AtomicInteger(0);
    public final ConcurrentHashMap<Object, Observer<T>> sbt$internal$nio$Observers$$observers = new ConcurrentHashMap();
    private final WeakHashMap<AutoCloseable, BoxedUnit> observables = new WeakHashMap();

    public AutoCloseable addObservable(Observable<T> observable) {
        AutoCloseable autoCloseable;
        WeakHashMap<AutoCloseable, BoxedUnit> weakHashMap = this.observables;
        synchronized (weakHashMap) {
            AutoCloseable handle = observable.addObserver(this);
            this.observables.put(handle, BoxedUnit.UNIT);
            autoCloseable = handle;
        }
        return autoCloseable;
    }

    @Override
    public AutoCloseable addObserver(Observer<T> observer) {
        int observerId = this.id.incrementAndGet();
        this.sbt$internal$nio$Observers$$observers.put(BoxesRunTime.boxToInteger((int)observerId), observer);
        return new Handle(this, observerId);
    }

    @Override
    public void close() {
        this.sbt$internal$nio$Observers$$observers.clear();
        WeakHashMap<AutoCloseable, BoxedUnit> weakHashMap = this.observables;
        synchronized (weakHashMap) {
            this.observables.keySet().forEach(_$1 -> _$1.close());
            this.observables.clear();
        }
    }

    public String toString() {
        return new StringBuilder(39).append("Observers(observers = ").append(this.sbt$internal$nio$Observers$$observers.values()).append(", observables = ").append(this.observables.keySet()).append(")").toString();
    }

    @Override
    public void onNext(T t) {
        this.sbt$internal$nio$Observers$$observers.values().forEach(o -> {
            try {
                o.onNext(t);
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3 = (Throwable)option.get();
                }
                throw throwable;
            }
        });
    }

    public class Handle
    implements AutoCloseable {
        private final int id;
        private final /* synthetic */ Observers $outer;

        public Handle(Observers $outer, int id) {
            this.id = id;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        @Override
        public void close() {
            this.$outer.sbt$internal$nio$Observers$$observers.remove(BoxesRunTime.boxToInteger((int)this.id));
        }

        public final /* synthetic */ Observers sbt$internal$nio$Observers$Handle$$$outer() {
            return this.$outer;
        }
    }
}

