/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.nio;

import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.WatchKey;
import java.util.concurrent.ConcurrentHashMap;
import sbt.internal.io.NewWatchState;
import sbt.internal.nio.FileCache;
import sbt.internal.nio.FileEvent;
import sbt.internal.nio.FileTreeRepository;
import sbt.internal.nio.Observable;
import sbt.internal.nio.Observer;
import sbt.internal.nio.Observers;
import sbt.internal.nio.Registerable;
import sbt.internal.nio.RegisterableObservable$;
import sbt.internal.nio.WatchLogger;
import sbt.internal.nio.WatchServiceBackedObservable;
import sbt.io.WatchService;
import sbt.nio.file.FileAttributes;
import sbt.nio.file.FileAttributes$;
import sbt.nio.file.FileAttributes$NonExistent$;
import sbt.nio.file.FileTreeView;
import sbt.nio.file.FileTreeView$;
import sbt.nio.file.Glob;
import scala.Function1;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Set;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;

public class LegacyFileTreeRepository
implements FileTreeRepository<FileAttributes> {
    private final FileTreeView<Tuple2<Path, FileAttributes>> view = FileTreeView$.MODULE$.default();
    private final FileCache<FileAttributes> fileCache;
    private final Observable<FileEvent<FileAttributes>> observable;
    private final Observers<FileEvent<FileAttributes>> observers;
    private final AutoCloseable handle;

    public LegacyFileTreeRepository(WatchLogger logger, WatchService watchService) {
        Set globs = (Set)JavaConverters$.MODULE$.asScalaSetConverter(ConcurrentHashMap.newKeySet()).asScala();
        this.fileCache = new FileCache((Function1 & Serializable)p -> (FileAttributes)FileAttributes$.MODULE$.apply((Path)p).getOrElse(LegacyFileTreeRepository::$init$$$anonfun$1$$anonfun$1), (Set<Glob>)globs);
        this.observable = new WatchServiceBackedObservable(new NewWatchState((Set<Glob>)globs, watchService, (Map<Path, WatchKey>)((Map)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(new ConcurrentHashMap()).asScala())), new package.DurationInt(package$.MODULE$.DurationInt(100)).millis(), true, logger);
        this.observers = new Observers();
        this.handle = this.observable.addObserver((T event) -> {
            FileEvent fileEvent = event;
            FileAttributes$NonExistent$ attributes = fileEvent instanceof FileEvent.Deletion ? FileAttributes$NonExistent$.MODULE$ : (FileAttributes)event.attributes();
            Seq<FileEvent<FileAttributes>> events = this.fileCache.update(event.path(), attributes);
            events.foreach((Function1)(JProcedure1 & Serializable)t -> this.observers.onNext((FileEvent<FileAttributes>)t));
        });
    }

    @Override
    public void close() {
        this.handle.close();
        this.observable.close();
    }

    @Override
    public Either<IOException, Observable<FileEvent<FileAttributes>>> register(Glob glob) {
        this.fileCache.register(glob);
        ((Registerable)((Object)this.observable)).register(glob).foreach((Function1)(JProcedure1 & Serializable)_$1 -> _$1.close());
        return RegisterableObservable$.MODULE$.register$extension(this.observers, glob);
    }

    @Override
    public Seq<Tuple2<Path, FileAttributes>> list(Path path) {
        return this.view.list(path);
    }

    @Override
    public AutoCloseable addObserver(Observer<FileEvent<FileAttributes>> observer) {
        return this.observers.addObserver(observer);
    }

    private static final FileAttributes $init$$$anonfun$1$$anonfun$1() {
        return FileAttributes$NonExistent$.MODULE$;
    }
}

