/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.nio;

import com.swoval.files.FileTreeDataViews;
import com.swoval.files.FileTreeRepositories;
import com.swoval.files.TypedPath;
import com.swoval.functional.Filters;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.file.Path;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import sbt.internal.nio.FileEvent;
import sbt.internal.nio.FileEvent$Creation$;
import sbt.internal.nio.FileEvent$Deletion$;
import sbt.internal.nio.FileEvent$Update$;
import sbt.internal.nio.FileTreeRepository;
import sbt.internal.nio.Observable;
import sbt.internal.nio.Observer;
import sbt.internal.nio.Observers;
import sbt.internal.nio.RegisterableObservable$;
import sbt.internal.nio.SwovalConverters$;
import sbt.internal.nio.SwovalConverters$RangeOps$;
import sbt.internal.nio.SwovalConverters$SwovalEitherOps$;
import sbt.internal.nio.TimeSource$default$;
import sbt.nio.file.FileAttributes;
import sbt.nio.file.FileAttributes$;
import sbt.nio.file.Glob;
import sbt.nio.file.Glob$;
import sbt.nio.file.Glob$GlobOps$;
import sbt.nio.file.Glob$RelativeGlobViewOption$;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.VectorBuilder;
import scala.collection.mutable.Set;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Properties$;
import scala.util.Right;

public class FileTreeRepositoryImpl<T>
implements FileTreeRepository<FileAttributes> {
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final com.swoval.files.FileTreeRepository<FileAttributes> underlying = FileTreeRepositories.get(typedPath -> FileAttributes$.MODULE$.apply(typedPath.isDirectory(), false, typedPath.isFile(), typedPath.isSymbolicLink()), (boolean)true);
    public final Observers<FileEvent<FileAttributes>> sbt$internal$nio$FileTreeRepositoryImpl$$observers = new Observers();
    private final Set<Path> registered = (Set)JavaConverters$.MODULE$.asScalaSetConverter(ConcurrentHashMap.newKeySet()).asScala();
    private final boolean isMac = Properties$.MODULE$.isMac();

    public FileTreeRepositoryImpl() {
        this.underlying.addCacheObserver((FileTreeDataViews.CacheObserver)new FileTreeDataViews.CacheObserver<FileAttributes>(this){
            private final /* synthetic */ FileTreeRepositoryImpl $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void onCreate(FileTreeDataViews.Entry newEntry) {
                Path path = newEntry.getTypedPath().getPath();
                com.swoval.functional.Either either = SwovalConverters$.MODULE$.SwovalEitherOps(newEntry.getValue());
                SwovalConverters$SwovalEitherOps$.MODULE$.asScala$extension(either, Predef$.MODULE$.$conforms()).foreach((Function1)(JProcedure1 & Serializable)v -> this.$outer.sbt$internal$nio$FileTreeRepositoryImpl$$observers.onNext(FileEvent$Creation$.MODULE$.apply(path, v, TimeSource$default$.MODULE$)));
            }

            public void onDelete(FileTreeDataViews.Entry oldEntry) {
                Path path = oldEntry.getTypedPath().getPath();
                com.swoval.functional.Either either = SwovalConverters$.MODULE$.SwovalEitherOps(oldEntry.getValue());
                SwovalConverters$SwovalEitherOps$.MODULE$.asScala$extension(either, Predef$.MODULE$.$conforms()).foreach((Function1)(JProcedure1 & Serializable)v -> this.$outer.sbt$internal$nio$FileTreeRepositoryImpl$$observers.onNext(FileEvent$Deletion$.MODULE$.apply(path, v, TimeSource$default$.MODULE$)));
            }

            public void onUpdate(FileTreeDataViews.Entry oldEntry, FileTreeDataViews.Entry newEntry) {
                Path path = newEntry.getTypedPath().getPath();
                com.swoval.functional.Either either = SwovalConverters$.MODULE$.SwovalEitherOps(oldEntry.getValue());
                Either<L, R0> oldEither = SwovalConverters$SwovalEitherOps$.MODULE$.asScala$extension(either, Predef$.MODULE$.$conforms());
                com.swoval.functional.Either either2 = SwovalConverters$.MODULE$.SwovalEitherOps(newEntry.getValue());
                Either<L, R0> newEither = SwovalConverters$SwovalEitherOps$.MODULE$.asScala$extension(either2, Predef$.MODULE$.$conforms());
                Either<L, R0> either3 = oldEither;
                if (either3 instanceof Right) {
                    FileAttributes o = (FileAttributes)((Right)either3).value();
                    Either<L, R0> either4 = newEither;
                    if (either4 instanceof Right) {
                        FileAttributes n = (FileAttributes)((Right)either4).value();
                        this.$outer.sbt$internal$nio$FileTreeRepositoryImpl$$observers.onNext(FileEvent$Update$.MODULE$.apply(path, o, n, TimeSource$default$.MODULE$));
                        return;
                    }
                    this.$outer.sbt$internal$nio$FileTreeRepositoryImpl$$observers.onNext(FileEvent$Deletion$.MODULE$.apply(path, o, TimeSource$default$.MODULE$));
                    return;
                }
                Either<L, R0> either5 = newEither;
                if (either5 instanceof Right) {
                    FileAttributes n = (FileAttributes)((Right)either5).value();
                    this.$outer.sbt$internal$nio$FileTreeRepositoryImpl$$observers.onNext(FileEvent$Creation$.MODULE$.apply(path, n, TimeSource$default$.MODULE$));
                    return;
                }
            }

            public void onError(IOException exception) {
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{onCreate$$anonfun$1(java.nio.file.Path sbt.nio.file.FileAttributes ), onDelete$$anonfun$1(java.nio.file.Path sbt.nio.file.FileAttributes )}, serializedLambda);
            }
        });
    }

    @Override
    public AutoCloseable addObserver(Observer<FileEvent<FileAttributes>> observer) {
        this.throwIfClosed("addObserver");
        return this.sbt$internal$nio$FileTreeRepositoryImpl$$observers.addObserver(observer);
    }

    @Override
    public Seq<Tuple2<Path, FileAttributes>> list(Path path) {
        this.throwIfClosed("list");
        VectorBuilder res = new VectorBuilder();
        ((IterableOnceOps)JavaConverters$.MODULE$.asScalaIteratorConverter(this.underlying.listEntries(path, 0, Filters.AllPass).iterator()).asScala()).foreach((Function1 & Serializable)e -> {
            FileAttributes fileAttributes;
            TypedPath tp = e.getTypedPath();
            Path path = tp.getPath();
            com.swoval.functional.Either either = SwovalConverters$.MODULE$.SwovalEitherOps(e.getValue());
            Either either2 = SwovalConverters$SwovalEitherOps$.MODULE$.asScala$extension(either, Predef$.MODULE$.$conforms());
            if (either2 instanceof Right && (fileAttributes = (FileAttributes)((Right)either2).value()) != null) {
                FileAttributes t = fileAttributes;
                Path path2 = (Path)Predef$.MODULE$.ArrowAssoc((Object)path);
                return res.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)path2, (Object)t));
            }
            return BoxedUnit.UNIT;
        });
        return res.result();
    }

    @Override
    public Either<IOException, Observable<FileEvent<FileAttributes>>> register(Glob glob) {
        com.swoval.functional.Either either;
        Either either2;
        Path parent;
        this.throwIfClosed("register");
        Path base = Glob$GlobOps$.MODULE$.base$extension(Glob$.MODULE$.GlobOps(glob), Glob$RelativeGlobViewOption$.MODULE$.default());
        if (this.isMac && !this.registered.contains((Object)(parent = Glob$GlobOps$.MODULE$.base$extension(Glob$.MODULE$.GlobOps(glob), Glob$RelativeGlobViewOption$.MODULE$.default()).getParent())) && this.registered.exists((Function1 & Serializable)path -> {
            Path path2 = path.getParent();
            Path path3 = parent;
            if (path2 == null) {
                if (path3 != null) {
                    return false;
                }
            } else if (!((Object)path2).equals(path3)) return false;
            String leftFileName = path.getFileName().toString();
            String rightFileName = base.getFileName().toString();
            String string = leftFileName;
            String string2 = rightFileName;
            if (string == null) {
                if (string2 == null) return false;
            } else if (string.equals(string2)) return false;
            if (leftFileName.startsWith(rightFileName)) return true;
            if (!rightFileName.startsWith(leftFileName)) return false;
            return true;
        })) {
            this.register(Glob$.MODULE$.apply(parent));
        }
        if ((either2 = SwovalConverters$SwovalEitherOps$.MODULE$.asScala$extension(either = SwovalConverters$.MODULE$.SwovalEitherOps(this.underlying.register(base, SwovalConverters$RangeOps$.MODULE$.toSwovalDepth$extension(SwovalConverters$.MODULE$.RangeOps(Glob$GlobOps$.MODULE$.range$extension(Glob$.MODULE$.GlobOps(glob)))))), Predef$.MODULE$.$conforms())) instanceof Right) {
            this.registered.add((Object)base);
            return RegisterableObservable$.MODULE$.register$extension(this.sbt$internal$nio$FileTreeRepositoryImpl$$observers, glob);
        }
        if (either2 instanceof Left) {
            IOException ex = (IOException)((Left)either2).value();
            return package$.MODULE$.Left().apply((Object)ex);
        }
        throw new MatchError(either2);
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.underlying.close();
            return;
        }
    }

    private void throwIfClosed(String method) {
        if (this.closed.get()) {
            IllegalStateException ex = new IllegalStateException(new StringBuilder(38).append("Tried to invoke ").append(method).append(" on closed repository ").append(this).toString());
            ex.printStackTrace();
            throw ex;
        }
    }
}

