/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.nio;

import java.io.Serializable;
import java.nio.file.Path;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import sbt.internal.nio.Deadline;
import sbt.internal.nio.Deadline$;
import sbt.internal.nio.FileEvent;
import sbt.internal.nio.FileEvent$;
import sbt.internal.nio.FileEvent$Creation$;
import sbt.internal.nio.FileEvent$Deletion$;
import sbt.internal.nio.FileEvent$Update$;
import sbt.internal.nio.FileEventMonitor$;
import sbt.internal.nio.FileEventMonitor$FileEventMonitorImpl$Trigger$;
import sbt.internal.nio.Observable;
import sbt.internal.nio.TimeSource;
import sbt.internal.nio.WatchLogger;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.concurrent.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;

public interface FileEventMonitor<T>
extends AutoCloseable {
    public static <T> FileEventMonitor<FileEvent<T>> antiEntropy(FileEventMonitor<FileEvent<T>> fileEventMonitor, FiniteDuration finiteDuration, WatchLogger watchLogger, FiniteDuration finiteDuration2, FiniteDuration finiteDuration3, TimeSource timeSource) {
        return FileEventMonitor$.MODULE$.antiEntropy(fileEventMonitor, finiteDuration, watchLogger, finiteDuration2, finiteDuration3, timeSource);
    }

    public static <T> FileEventMonitor<FileEvent<T>> antiEntropy(Observable<FileEvent<T>> observable, FiniteDuration finiteDuration, WatchLogger watchLogger, FiniteDuration finiteDuration2, FiniteDuration finiteDuration3, TimeSource timeSource) {
        return FileEventMonitor$.MODULE$.antiEntropy(observable, finiteDuration, watchLogger, finiteDuration2, finiteDuration3, timeSource);
    }

    public static <T> FileEventMonitor<FileEvent<T>> apply(Observable<FileEvent<T>> observable, WatchLogger watchLogger, TimeSource timeSource) {
        return FileEventMonitor$.MODULE$.apply(observable, watchLogger, timeSource);
    }

    public static <T> WatchLogger apply$default$2() {
        return FileEventMonitor$.MODULE$.apply$default$2();
    }

    public static Seq poll$(FileEventMonitor $this, Duration duration) {
        return $this.poll(duration);
    }

    default public Seq<T> poll(Duration duration) {
        return this.poll(duration, (Function1 & Serializable)_$1 -> true);
    }

    public Seq<T> poll(Duration var1, Function1<T, Object> var2);

    public static class AntiEntropyFileEventMonitor<T>
    implements FileEventMonitor<FileEvent<T>> {
        public final FiniteDuration sbt$internal$nio$FileEventMonitor$AntiEntropyFileEventMonitor$$period;
        private final FileEventMonitor<FileEvent<T>> fileEventMonitor;
        public final WatchLogger sbt$internal$nio$FileEventMonitor$AntiEntropyFileEventMonitor$$logger;
        public final FiniteDuration sbt$internal$nio$FileEventMonitor$AntiEntropyFileEventMonitor$$quarantinePeriod;
        private final FiniteDuration retentionPeriod;
        public final TimeSource sbt$internal$nio$FileEventMonitor$AntiEntropyFileEventMonitor$$timeSource;
        public final Map<Path, Deadline> sbt$internal$nio$FileEventMonitor$AntiEntropyFileEventMonitor$$antiEntropyDeadlines;
        public final Map<Path, FileEvent<T>> sbt$internal$nio$FileEventMonitor$AntiEntropyFileEventMonitor$$quarantinedEvents;

        public AntiEntropyFileEventMonitor(FiniteDuration period, FileEventMonitor<FileEvent<T>> fileEventMonitor, WatchLogger logger, FiniteDuration quarantinePeriod, FiniteDuration retentionPeriod, TimeSource timeSource) {
            this.sbt$internal$nio$FileEventMonitor$AntiEntropyFileEventMonitor$$period = period;
            this.fileEventMonitor = fileEventMonitor;
            this.sbt$internal$nio$FileEventMonitor$AntiEntropyFileEventMonitor$$logger = logger;
            this.sbt$internal$nio$FileEventMonitor$AntiEntropyFileEventMonitor$$quarantinePeriod = quarantinePeriod;
            this.retentionPeriod = retentionPeriod;
            this.sbt$internal$nio$FileEventMonitor$AntiEntropyFileEventMonitor$$timeSource = timeSource;
            this.sbt$internal$nio$FileEventMonitor$AntiEntropyFileEventMonitor$$antiEntropyDeadlines = (Map)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(new ConcurrentHashMap()).asScala();
            this.sbt$internal$nio$FileEventMonitor$AntiEntropyFileEventMonitor$$quarantinedEvents = (Map)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(new ConcurrentHashMap()).asScala();
        }

        private Option<Duration> quarantineDuration() {
            Deadline now = Deadline$.MODULE$.now(this.sbt$internal$nio$FileEventMonitor$AntiEntropyFileEventMonitor$$timeSource);
            Vector waits = ((IterableOnceOps)this.sbt$internal$nio$FileEventMonitor$AntiEntropyFileEventMonitor$$quarantinedEvents.map((Function1 & Serializable)_$2 -> ((FileEvent)_$2._2()).occurredAt().$plus(this.sbt$internal$nio$FileEventMonitor$AntiEntropyFileEventMonitor$$quarantinePeriod).$minus(now))).toVector();
            if (waits.isEmpty()) {
                return None$.MODULE$;
            }
            return Some$.MODULE$.apply(waits.min((Ordering)Duration.DurationIsOrdered$.MODULE$));
        }

        @Override
        public final Seq<FileEvent<T>> poll(Duration duration, Function1<FileEvent<T>, Object> filter) {
            return this.pollImpl(duration, filter);
        }

        private final Seq<FileEvent<T>> pollImpl(Duration duration, Function1<FileEvent<T>, Object> filter) {
            while (true) {
                Seq s;
                Deadline start = Deadline$.MODULE$.now(this.sbt$internal$nio$FileEventMonitor$AntiEntropyFileEventMonitor$$timeSource);
                Duration adjustedDuration = (Duration)this.quarantineDuration().map(arg_0 -> FileEventMonitor$.sbt$internal$nio$FileEventMonitor$AntiEntropyFileEventMonitor$$_$_$$anonfun$2(duration, arg_0)).getOrElse(() -> FileEventMonitor$.sbt$internal$nio$FileEventMonitor$AntiEntropyFileEventMonitor$$_$_$$anonfun$3(duration));
                Seq<FileEvent<T>> results = this.fileEventMonitor.poll(adjustedDuration, filter);
                Seq transformed = (Seq)((IterableOps)results.flatMap((Function1 & Serializable)x$1 -> {
                    Option option;
                    FileEvent fileEvent = x$1;
                    if (fileEvent != null && !(option = FileEvent$.MODULE$.unapply(fileEvent)).isEmpty()) {
                        Deadline deadline;
                        FileEvent fileEvent2;
                        Tuple2 tuple2 = (Tuple2)option.get();
                        Path path = (Path)tuple2._1();
                        Object attributes = tuple2._2();
                        FileEvent event = fileEvent;
                        Deadline occurredAt = event.occurredAt();
                        Object quarantined = event.exists() ? this.sbt$internal$nio$FileEventMonitor$AntiEntropyFileEventMonitor$$quarantinedEvents.remove((Object)path) : None$.MODULE$;
                        None$ none$ = quarantined;
                        if (none$ instanceof Some && (fileEvent2 = (FileEvent)((Some)none$).value()) instanceof FileEvent.Deletion) {
                            Object t;
                            FileEvent.Deletion deletion = (FileEvent.Deletion)fileEvent2;
                            FileEvent.Deletion deletion2 = FileEvent$Deletion$.MODULE$.unapply(deletion);
                            Path path2 = deletion2._1();
                            Object oldAttributes = t = deletion2._2();
                            FileEvent.Deletion d = deletion;
                            this.sbt$internal$nio$FileEventMonitor$AntiEntropyFileEventMonitor$$antiEntropyDeadlines.put((Object)path, (Object)d.occurredAt().$plus(this.sbt$internal$nio$FileEventMonitor$AntiEntropyFileEventMonitor$$period));
                            this.sbt$internal$nio$FileEventMonitor$AntiEntropyFileEventMonitor$$logger.debug(new StringBuilder(73).append("Triggering event for newly created path ").append(path).append(" that was previously quarantined.").toString());
                            return Some$.MODULE$.apply(FileEvent$Update$.MODULE$.apply(path, oldAttributes, attributes, d.occurredAt()));
                        }
                        Option option2 = this.sbt$internal$nio$FileEventMonitor$AntiEntropyFileEventMonitor$$antiEntropyDeadlines.get((Object)path);
                        if (option2 instanceof Some && occurredAt.$less(deadline = (Deadline)((Some)option2).value())) {
                            String msg = new StringBuilder(74).append("Discarding entry for recently updated path ").append(path).append(". ").append(new StringBuilder(30).append("This event occurred ").append(occurredAt.$minus(deadline.$minus(this.sbt$internal$nio$FileEventMonitor$AntiEntropyFileEventMonitor$$period)).toMillis()).append(" ms since ").toString()).append("the last event for this path.").toString();
                            this.sbt$internal$nio$FileEventMonitor$AntiEntropyFileEventMonitor$$logger.debug(msg);
                            return None$.MODULE$;
                        }
                        if (!event.exists()) {
                            this.sbt$internal$nio$FileEventMonitor$AntiEntropyFileEventMonitor$$quarantinedEvents.put((Object)path, (Object)event);
                            this.sbt$internal$nio$FileEventMonitor$AntiEntropyFileEventMonitor$$logger.debug(new StringBuilder(42).append("Quarantining deletion event for path ").append(path).append(" for ").append(this.sbt$internal$nio$FileEventMonitor$AntiEntropyFileEventMonitor$$period).toString());
                            return None$.MODULE$;
                        }
                        this.sbt$internal$nio$FileEventMonitor$AntiEntropyFileEventMonitor$$antiEntropyDeadlines.put((Object)path, (Object)occurredAt.$plus(this.sbt$internal$nio$FileEventMonitor$AntiEntropyFileEventMonitor$$period));
                        this.sbt$internal$nio$FileEventMonitor$AntiEntropyFileEventMonitor$$logger.debug(new StringBuilder(24).append("Received event for path ").append(path).toString());
                        return Some$.MODULE$.apply((Object)event);
                    }
                    throw new MatchError((Object)fileEvent);
                })).$plus$plus((IterableOnce)this.sbt$internal$nio$FileEventMonitor$AntiEntropyFileEventMonitor$$quarantinedEvents.collect((PartialFunction)new Serializable(this){
                    private final /* synthetic */ AntiEntropyFileEventMonitor $outer;
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }

                    public final boolean isDefinedAt(Tuple2 x) {
                        Tuple2 tuple2 = x;
                        if (tuple2 != null) {
                            FileEvent.Deletion event;
                            FileEvent fileEvent = (FileEvent)tuple2._2();
                            Path path = (Path)tuple2._1();
                            if (fileEvent instanceof FileEvent.Deletion && (event = (FileEvent.Deletion)fileEvent).occurredAt().$plus(this.$outer.sbt$internal$nio$FileEventMonitor$AntiEntropyFileEventMonitor$$quarantinePeriod).$less(Deadline$.MODULE$.now(this.$outer.sbt$internal$nio$FileEventMonitor$AntiEntropyFileEventMonitor$$timeSource))) {
                                return true;
                            }
                        }
                        return false;
                    }

                    public final Object applyOrElse(Tuple2 x, Function1 function1) {
                        Tuple2 tuple2 = x;
                        if (tuple2 != null) {
                            FileEvent.Deletion event;
                            FileEvent fileEvent = (FileEvent)tuple2._2();
                            Path path = (Path)tuple2._1();
                            if (fileEvent instanceof FileEvent.Deletion && (event = (FileEvent.Deletion)fileEvent).occurredAt().$plus(this.$outer.sbt$internal$nio$FileEventMonitor$AntiEntropyFileEventMonitor$$quarantinePeriod).$less(Deadline$.MODULE$.now(this.$outer.sbt$internal$nio$FileEventMonitor$AntiEntropyFileEventMonitor$$timeSource))) {
                                this.$outer.sbt$internal$nio$FileEventMonitor$AntiEntropyFileEventMonitor$$quarantinedEvents.remove((Object)path);
                                this.$outer.sbt$internal$nio$FileEventMonitor$AntiEntropyFileEventMonitor$$antiEntropyDeadlines.put((Object)path, (Object)event.occurredAt().$plus(this.$outer.sbt$internal$nio$FileEventMonitor$AntiEntropyFileEventMonitor$$period));
                                this.$outer.sbt$internal$nio$FileEventMonitor$AntiEntropyFileEventMonitor$$logger.debug(new StringBuilder(58).append("Triggering event for previously quarantined deleted file: ").append(path).toString());
                                return event;
                            }
                        }
                        return function1.apply((Object)x);
                    }
                }));
                this.sbt$internal$nio$FileEventMonitor$AntiEntropyFileEventMonitor$$antiEntropyDeadlines.retain((Function2 & Serializable)(_$4, deadline) -> Deadline$.MODULE$.now(this.sbt$internal$nio$FileEventMonitor$AntiEntropyFileEventMonitor$$timeSource).$less(deadline.$plus(this.retentionPeriod)));
                Seq seq = transformed;
                if (seq instanceof Seq && (s = seq).nonEmpty()) {
                    return s;
                }
                Duration limit = duration.$minus(Deadline$.MODULE$.now(this.sbt$internal$nio$FileEventMonitor$AntiEntropyFileEventMonitor$$timeSource).$minus(start));
                if (!limit.$greater((Object)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(0)).millis())) break;
                duration = limit;
            }
            return package$.MODULE$.Nil();
        }

        @Override
        public void close() {
            this.sbt$internal$nio$FileEventMonitor$AntiEntropyFileEventMonitor$$quarantinedEvents.clear();
            this.sbt$internal$nio$FileEventMonitor$AntiEntropyFileEventMonitor$$antiEntropyDeadlines.clear();
            this.fileEventMonitor.close();
        }
    }

    public static class FileEventMonitorImpl<T>
    implements FileEventMonitor<FileEvent<T>> {
        public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(FileEventMonitorImpl.class.getDeclaredField("Trigger$lzy1"));
        private final Observable<FileEvent<T>> observable;
        private final WatchLogger logger;
        private final TimeSource timeSource;
        private volatile Object Trigger$lzy1;
        private final Map<Path, FileEvent<T>> events;
        private final ArrayBlockingQueue<FileEventMonitor$FileEventMonitorImpl$Trigger$> queue;
        private final Object lock;
        private final AutoCloseable handle;

        public FileEventMonitorImpl(Observable<FileEvent<T>> observable, WatchLogger logger, TimeSource timeSource) {
            this.observable = observable;
            this.logger = logger;
            this.timeSource = timeSource;
            this.events = (Map)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(new ConcurrentHashMap()).asScala();
            this.queue = new ArrayBlockingQueue(1);
            this.lock = new Object();
            this.handle = observable.addObserver(event -> this.add((FileEvent<T>)event));
        }

        private final FileEventMonitor$FileEventMonitorImpl$Trigger$ Trigger() {
            Object object = this.Trigger$lzy1;
            if (object instanceof FileEventMonitor$FileEventMonitorImpl$Trigger$) {
                return (FileEventMonitor$FileEventMonitorImpl$Trigger$)object;
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return null;
            }
            return (FileEventMonitor$FileEventMonitorImpl$Trigger$)this.Trigger$lzyINIT1();
        }

        private Object Trigger$lzyINIT1() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.Trigger$lzy1) == null) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        FileEventMonitor$FileEventMonitorImpl$Trigger$ fileEventMonitor$FileEventMonitorImpl$Trigger$ = null;
                        try {
                            fileEventMonitor$FileEventMonitorImpl$Trigger$ = new FileEventMonitor$FileEventMonitorImpl$Trigger$();
                            object2 = fileEventMonitor$FileEventMonitorImpl$Trigger$ == null ? LazyVals.NullValue$.MODULE$ : fileEventMonitor$FileEventMonitorImpl$Trigger$;
                        }
                        finally {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.Trigger$lzy1;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                                waiting.countDown();
                            }
                        }
                        return fileEventMonitor$FileEventMonitorImpl$Trigger$;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void add(FileEvent<T> event) {
            boolean bl;
            Object object;
            Option option;
            this.logger.debug(new StringBuilder(9).append("Received ").append(event).toString());
            Path path = event.path();
            Object object2 = this.lock;
            synchronized (object2) {
                option = this.events.putIfAbsent((Object)path, event);
            }
            Option option2 = option;
            if (option2 instanceof Some) {
                FileEvent fileEvent = (FileEvent)((Some)option2).value();
                if (fileEvent instanceof FileEvent.Deletion) {
                    FileEvent.Deletion d = (FileEvent.Deletion)fileEvent;
                    FileEvent<T> fileEvent2 = event;
                    if (!(fileEvent2 instanceof FileEvent.Deletion)) {
                        if (fileEvent2 instanceof FileEvent.Update) {
                            FileEvent.Update update = FileEvent$Update$.MODULE$.unapply((FileEvent.Update)fileEvent2);
                            Path path2 = update._1();
                            Object t = update._2();
                            Object t2 = update._3();
                            Object previous = t;
                            this.put$1(path, FileEvent$Deletion$.MODULE$.apply(path, previous, event.occurredAt()));
                        } else {
                            this.put$1(path, FileEvent$Update$.MODULE$.apply(path, d.attributes(), event.attributes(), event.occurredAt()));
                        }
                    }
                    object = BoxedUnit.UNIT;
                    return;
                }
                if (fileEvent instanceof FileEvent.Creation) {
                    FileEvent<T> fileEvent3 = event;
                    if (fileEvent3 instanceof FileEvent.Deletion) {
                        object = this.events.remove((Object)path);
                        return;
                    } else if (fileEvent3 instanceof FileEvent.Update) {
                        this.put$1(path, FileEvent$Creation$.MODULE$.apply(path, event.attributes(), event.occurredAt()));
                        object = BoxedUnit.UNIT;
                        return;
                    } else {
                        this.put$1(path, event);
                        object = BoxedUnit.UNIT;
                    }
                    return;
                }
                if (fileEvent instanceof FileEvent.Update) {
                    FileEvent.Update update = (FileEvent.Update)fileEvent;
                    FileEvent.Update update2 = FileEvent$Update$.MODULE$.unapply(update);
                    Path path3 = update2._1();
                    Object t = update2._2();
                    Object t3 = update2._3();
                    Object previous = t;
                    FileEvent.Update u = update;
                    FileEvent<T> fileEvent4 = event;
                    if (fileEvent4 instanceof FileEvent.Deletion) {
                        this.put$1(path, FileEvent$Deletion$.MODULE$.apply(path, previous, u.occurredAt()));
                    } else {
                        FileEvent<T> e = fileEvent4;
                        this.put$1(path, FileEvent$Update$.MODULE$.apply(path, previous, e.attributes(), u.occurredAt()));
                    }
                    object = BoxedUnit.UNIT;
                    return;
                }
            }
            if (!None$.MODULE$.equals(option2)) throw new MatchError((Object)option2);
            Object object3 = this.lock;
            synchronized (object3) {
                bl = this.queue.offer(this.Trigger());
            }
            object = BoxesRunTime.boxToBoolean((boolean)bl);
        }

        @Override
        public final Seq<FileEvent<T>> poll(Duration duration, Function1<FileEvent<T>, Object> filter) {
            Deadline deadline;
            Duration duration2 = duration;
            if (duration2 instanceof FiniteDuration) {
                FiniteDuration d = (FiniteDuration)duration2;
                deadline = Deadline$.MODULE$.now(this.timeSource).$plus(d);
            } else {
                deadline = Deadline$.MODULE$.now(this.timeSource).$plus(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).day());
            }
            Deadline limit = deadline;
            return this.impl$1(duration, filter, limit);
        }

        @Override
        public void close() {
            this.handle.close();
            this.events.clear();
            this.observable.close();
        }

        private final void put$1(Path path, FileEvent event) {
            Object object = this.lock;
            synchronized (object) {
                this.events.put((Object)path, (Object)event);
                this.queue.offer(this.Trigger());
            }
        }

        private final Seq impl$1(Duration duration$1, Function1 filter$1, Deadline limit$1) {
            Vector vector;
            block10: {
                Deadline now;
                do {
                    Vector res;
                    Vector vector2;
                    boolean bl;
                    Object object = this.lock;
                    synchronized (object) {
                        bl = this.events.isEmpty();
                    }
                    if (bl && duration$1.$greater((Object)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(0)).seconds())) {
                        Duration duration = duration$1;
                        if (duration instanceof FiniteDuration) {
                            FiniteDuration d = (FiniteDuration)duration;
                            this.queue.poll(d.toNanos(), TimeUnit.NANOSECONDS);
                        } else {
                            this.queue.take();
                        }
                    }
                    Object object2 = this.lock;
                    synchronized (object2) {
                        this.queue.poll(0L, TimeUnit.MILLISECONDS);
                        Vector r = (Vector)this.events.values().toVector().filter(filter$1);
                        this.events.clear();
                        vector2 = r;
                    }
                    Vector e = vector = (res = vector2);
                    if (!e.isEmpty()) break block10;
                } while ((now = Deadline$.MODULE$.now(this.timeSource)).$less(limit$1));
                return package$.MODULE$.Nil();
            }
            Vector e = vector;
            return e;
        }
    }
}

