/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.nio;

import java.io.Serializable;
import java.nio.file.Path;
import sbt.internal.nio.Deadline;
import sbt.internal.nio.FileEvent$;
import sbt.internal.nio.FileEvent$Creation$;
import sbt.internal.nio.FileEvent$Deletion$;
import sbt.internal.nio.FileEvent$Update$;
import sbt.internal.nio.TimeSource;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public interface FileEvent<T> {
    public static <T> Option<Tuple2<Path, T>> unapply(FileEvent<T> fileEvent) {
        return FileEvent$.MODULE$.unapply(fileEvent);
    }

    public Path path();

    public T attributes();

    public boolean exists();

    public Deadline occurredAt();

    public static FileEvent map$(FileEvent $this, Function2 f) {
        return $this.map(f);
    }

    default public <U> FileEvent<U> map(Function2<Path, T, U> f) {
        Product product;
        FileEvent fileEvent = this;
        if (fileEvent instanceof Creation) {
            Creation c = (Creation)fileEvent;
            product = FileEvent$Creation$.MODULE$.apply(this.path(), f.apply((Object)this.path(), c.attributes()), c.occurredAt());
        } else if (fileEvent instanceof Deletion) {
            Deletion d = (Deletion)fileEvent;
            product = FileEvent$Deletion$.MODULE$.apply(this.path(), f.apply((Object)this.path(), d.attributes()), d.occurredAt());
        } else if (fileEvent instanceof Update) {
            Update u = (Update)fileEvent;
            product = FileEvent$Update$.MODULE$.apply(this.path(), f.apply((Object)this.path(), u.previousAttributes()), f.apply((Object)this.path(), u.attributes()), u.occurredAt());
        } else {
            throw new MatchError((Object)fileEvent);
        }
        return product;
    }

    public static abstract class Creation<T>
    implements FileEvent<T>,
    Product,
    Serializable {
        private final Path path;
        private final Object attributes;

        public static <T> Creation<T> apply(Path path, T t, Deadline deadline) {
            return FileEvent$Creation$.MODULE$.apply(path, t, deadline);
        }

        public static <T> Creation<T> apply(Path path, T t, TimeSource timeSource) {
            return FileEvent$Creation$.MODULE$.apply(path, t, timeSource);
        }

        public static <T> Creation<T> unapply(Creation<T> creation) {
            return FileEvent$Creation$.MODULE$.unapply(creation);
        }

        public Creation(Path path, T attributes) {
            this.path = path;
            this.attributes = attributes;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Creation)) return false;
            Creation creation = (Creation)object;
            Path path = this.path();
            Path path2 = creation.path();
            if (path == null) {
                if (path2 != null) {
                    return false;
                }
            } else if (!((Object)path).equals(path2)) return false;
            if (!BoxesRunTime.equals(this.attributes(), creation.attributes())) return false;
            if (!creation.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Creation;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Creation";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "path";
            }
            if (1 == n2) {
                return "attributes";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public Path path() {
            return this.path;
        }

        @Override
        public T attributes() {
            return (T)this.attributes;
        }

        @Override
        public boolean exists() {
            return true;
        }

        public Path _1() {
            return this.path();
        }

        public T _2() {
            return this.attributes();
        }
    }

    public static abstract class Deletion<T>
    implements FileEvent<T>,
    Product,
    Serializable {
        private final Path path;
        private final Object attributes;

        public static <T> Deletion<T> apply(Path path, T t, Deadline deadline) {
            return FileEvent$Deletion$.MODULE$.apply(path, t, deadline);
        }

        public static <T> Deletion<T> apply(Path path, T t, TimeSource timeSource) {
            return FileEvent$Deletion$.MODULE$.apply(path, t, timeSource);
        }

        public static <T> Deletion<T> unapply(Deletion<T> deletion) {
            return FileEvent$Deletion$.MODULE$.unapply(deletion);
        }

        public Deletion(Path path, T attributes) {
            this.path = path;
            this.attributes = attributes;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Deletion)) return false;
            Deletion deletion = (Deletion)object;
            Path path = this.path();
            Path path2 = deletion.path();
            if (path == null) {
                if (path2 != null) {
                    return false;
                }
            } else if (!((Object)path).equals(path2)) return false;
            if (!BoxesRunTime.equals(this.attributes(), deletion.attributes())) return false;
            if (!deletion.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Deletion;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Deletion";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "path";
            }
            if (1 == n2) {
                return "attributes";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public Path path() {
            return this.path;
        }

        @Override
        public T attributes() {
            return (T)this.attributes;
        }

        @Override
        public boolean exists() {
            return false;
        }

        public Path _1() {
            return this.path();
        }

        public T _2() {
            return this.attributes();
        }
    }

    public static abstract class Update<T>
    implements FileEvent<T>,
    Product,
    Serializable {
        private final Path path;
        private final Object previousAttributes;
        private final Object attributes;

        public static <T> Update<T> apply(Path path, T t, T t2, Deadline deadline) {
            return FileEvent$Update$.MODULE$.apply(path, t, t2, deadline);
        }

        public static <T> Update<T> apply(Path path, T t, T t2, TimeSource timeSource) {
            return FileEvent$Update$.MODULE$.apply(path, t, t2, timeSource);
        }

        public static <T> Update<T> unapply(Update<T> update) {
            return FileEvent$Update$.MODULE$.unapply(update);
        }

        public Update(Path path, T previousAttributes, T attributes) {
            this.path = path;
            this.previousAttributes = previousAttributes;
            this.attributes = attributes;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Update)) return false;
            Update update = (Update)object;
            Path path = this.path();
            Path path2 = update.path();
            if (path == null) {
                if (path2 != null) {
                    return false;
                }
            } else if (!((Object)path).equals(path2)) return false;
            if (!BoxesRunTime.equals(this.previousAttributes(), update.previousAttributes())) return false;
            if (!BoxesRunTime.equals(this.attributes(), update.attributes())) return false;
            if (!update.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Update;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "Update";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "path";
                }
                case 1: {
                    return "previousAttributes";
                }
                case 2: {
                    return "attributes";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public Path path() {
            return this.path;
        }

        public T previousAttributes() {
            return (T)this.previousAttributes;
        }

        @Override
        public T attributes() {
            return (T)this.attributes;
        }

        @Override
        public boolean exists() {
            return true;
        }

        public Path _1() {
            return this.path();
        }

        public T _2() {
            return this.previousAttributes();
        }

        public T _3() {
            return this.attributes();
        }
    }
}

