/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.nio;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import sbt.internal.nio.FileCache$;
import sbt.internal.nio.FileCache$GlobOps$;
import sbt.internal.nio.FileEvent;
import sbt.internal.nio.FileEvent$Creation$;
import sbt.internal.nio.FileEvent$Deletion$;
import sbt.internal.nio.FileEvent$Update$;
import sbt.internal.nio.TimeSource$default$;
import sbt.nio.file.AnyPath$;
import sbt.nio.file.FileAttributes;
import sbt.nio.file.FileAttributes$;
import sbt.nio.file.FileAttributes$NonExistent$;
import sbt.nio.file.FileTreeView;
import sbt.nio.file.FileTreeView$;
import sbt.nio.file.FileTreeView$Ops$;
import sbt.nio.file.Glob;
import sbt.nio.file.Glob$;
import sbt.nio.file.Glob$GlobOps$;
import sbt.nio.file.Glob$RelativeGlobViewOption$;
import sbt.nio.file.RecursiveGlob$;
import sbt.nio.file.RelativeGlob;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.immutable.AbstractSeq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Growable;
import scala.collection.mutable.Iterable;
import scala.collection.mutable.Set;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.function.JProcedure1;

public class FileCache<T> {
    private final Function1<Path, T> converter;
    private final Set<Glob> globs;
    private final SortedMap<Path, T> files;
    private final FileTreeView<Tuple2<Path, FileAttributes>> view;
    private final char ceilingChar;

    public FileCache(Function1<Path, T> converter, Set<Glob> globs) {
        this.converter = converter;
        this.globs = globs;
        this.files = Collections.synchronizedSortedMap(new ConcurrentSkipListMap());
        this.view = FileTreeView$.MODULE$.default();
        this.ceilingChar = (char)(File.separatorChar + '\u0001');
    }

    public FileCache(Function1<Path, T> converter) {
        this(converter, (Set<Glob>)((Set)JavaConverters$.MODULE$.asScalaSetConverter(ConcurrentHashMap.newKeySet()).asScala()));
    }

    public Seq<FileEvent<T>> update(Path path, FileAttributes attributes) {
        if (BoxesRunTime.unboxToBoolean((Object)this.globInclude().apply((Object)path))) {
            Nil$ nil$;
            SortedMap<Path, T> sortedMap = this.files;
            synchronized (sortedMap) {
                Nil$ nil$2;
                SortedMap<Path, T> subMap = this.files.subMap(path, this.ceiling(path));
                FileAttributes fileAttributes = attributes;
                FileAttributes$NonExistent$ fileAttributes$NonExistent$ = FileAttributes$NonExistent$.MODULE$;
                boolean exists = fileAttributes == null ? fileAttributes$NonExistent$ != null : !fileAttributes.equals(fileAttributes$NonExistent$);
                Object v = subMap.get(path);
                if (v == null) {
                    if (exists) {
                        this.add(this.updateGlob(path), attributes);
                        nil$2 = ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.mapAsScalaMapConverter(subMap).asScala()).map((Function1 & Serializable)x$1 -> {
                            Tuple2 tuple2 = x$1;
                            if (tuple2 != null) {
                                Path p = (Path)tuple2._1();
                                Object a = tuple2._2();
                                return FileEvent$Creation$.MODULE$.apply(p, a, TimeSource$default$.MODULE$);
                            }
                            throw new MatchError((Object)tuple2);
                        })).toIndexedSeq();
                    } else {
                        nil$2 = package$.MODULE$.Nil();
                    }
                } else {
                    Object prev = v;
                    if (exists) {
                        FileEvent.Update<Object> update = FileEvent$Update$.MODULE$.apply(path, prev, this.converter.apply((Object)path), TimeSource$default$.MODULE$);
                        nil$2 = package$.MODULE$.Nil().$colon$colon(update);
                    } else {
                        nil$2 = (Seq)this.remove(subMap).map((Function1 & Serializable)x$1 -> {
                            Tuple2 tuple2 = x$1;
                            if (tuple2 != null) {
                                Path p = (Path)tuple2._1();
                                Object a = tuple2._2();
                                return FileEvent$Deletion$.MODULE$.apply(p, a, TimeSource$default$.MODULE$);
                            }
                            throw new MatchError((Object)tuple2);
                        });
                    }
                }
                nil$ = nil$2;
            }
            return nil$;
        }
        return package$.MODULE$.Nil();
    }

    public Seq<FileEvent<T>> refresh(Glob glob) {
        AbstractSeq abstractSeq;
        FileCache fileCache = this;
        synchronized (fileCache) {
            Nil$ nil$;
            Path path = Glob$GlobOps$.MODULE$.base$extension(Glob$.MODULE$.GlobOps(glob), Glob$RelativeGlobViewOption$.MODULE$.default());
            if (BoxesRunTime.unboxToBoolean((Object)this.globInclude().apply((Object)path))) {
                SortedMap<Path, T> subMap = this.files.subMap(path, this.ceiling(path));
                Map previous = ((IterableOnceOps)JavaConverters$.MODULE$.mapAsScalaMapConverter(subMap).asScala()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                subMap.clear();
                FileAttributes$.MODULE$.apply(path).foreach((Function1)(JProcedure1 & Serializable)_$1 -> this.add(glob, (FileAttributes)_$1));
                Map current = ((IterableOnceOps)JavaConverters$.MODULE$.mapAsScalaMapConverter(subMap).asScala()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                Buffer result = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(new ArrayList()).asScala();
                previous.foreach((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        Object newPair;
                        Path p = (Path)tuple2._1();
                        Object prev = tuple2._2();
                        Option option = current.get((Object)p);
                        if (option instanceof Some && !BoxesRunTime.equals((Object)prev, (Object)(newPair = ((Some)option).value()))) {
                            return result.$plus$eq(FileEvent$Update$.MODULE$.apply(p, prev, newPair, TimeSource$default$.MODULE$));
                        }
                        if (None$.MODULE$.equals(option)) {
                            return result.$plus$eq(FileEvent$Deletion$.MODULE$.apply(p, prev, TimeSource$default$.MODULE$));
                        }
                        return BoxedUnit.UNIT;
                    }
                    throw new MatchError((Object)tuple2);
                });
                current.foreach((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        Path p = (Path)tuple2._1();
                        Object newAttributes = tuple2._2();
                        Option option = previous.get((Object)p);
                        if (None$.MODULE$.equals(option)) {
                            return result.$plus$eq(FileEvent$Creation$.MODULE$.apply(p, newAttributes, TimeSource$default$.MODULE$));
                        }
                        return BoxedUnit.UNIT;
                    }
                    throw new MatchError((Object)tuple2);
                });
                nil$ = result.toVector();
            } else {
                nil$ = package$.MODULE$.Nil();
            }
            abstractSeq = (AbstractSeq)nil$;
        }
        return abstractSeq;
    }

    public Seq<Tuple2<Path, T>> list(Glob glob) {
        return ((IterableOnceOps)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.files.subMap(Glob$GlobOps$.MODULE$.base$extension(Glob$.MODULE$.GlobOps(glob), Glob$RelativeGlobViewOption$.MODULE$.default()), this.ceiling(Glob$GlobOps$.MODULE$.base$extension(Glob$.MODULE$.GlobOps(glob), Glob$RelativeGlobViewOption$.MODULE$.default())))).asScala()).toIndexedSeq();
    }

    public void register(Glob glob) {
        Glob unfiltered;
        Glob glob2;
        int n = Glob$GlobOps$.MODULE$.range$extension(Glob$.MODULE$.GlobOps(glob))._2$mcI$sp();
        if (Integer.MAX_VALUE == n) {
            glob2 = Glob$.MODULE$.apply(Glob$GlobOps$.MODULE$.base$extension(Glob$.MODULE$.GlobOps(glob), Glob$RelativeGlobViewOption$.MODULE$.default()), (RelativeGlob)RecursiveGlob$.MODULE$);
        } else {
            int d = n;
            glob2 = unfiltered = (Glob)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), d).foldLeft((Object)Glob$.MODULE$.apply(Glob$GlobOps$.MODULE$.base$extension(Glob$.MODULE$.GlobOps(glob), Glob$RelativeGlobViewOption$.MODULE$.default())), (Function2 & Serializable)(x$1, x$2) -> FileCache.$anonfun$1((Glob)x$1, BoxesRunTime.unboxToInt((Object)x$2)));
        }
        if (!this.globs.exists((Function1 & Serializable)_$2 -> FileCache$GlobOps$.MODULE$.covers$extension(FileCache$.MODULE$.sbt$internal$nio$FileCache$$$GlobOps((Glob)_$2), unfiltered)) && this.globs.add((Object)unfiltered)) {
            FileAttributes$.MODULE$.apply(Glob$GlobOps$.MODULE$.base$extension(Glob$.MODULE$.GlobOps(glob), Glob$RelativeGlobViewOption$.MODULE$.default())).foreach((Function1)(JProcedure1 & Serializable)_$3 -> this.add(unfiltered, (FileAttributes)_$3));
            return;
        }
    }

    public void unregister(Glob glob) {
        if (this.globs.remove((Object)glob)) {
            SortedMap<Path, T> sortedMap = this.files;
            synchronized (sortedMap) {
                SortedMap subMap = this.files.subMap(Glob$GlobOps$.MODULE$.base$extension(Glob$.MODULE$.GlobOps(glob), Glob$RelativeGlobViewOption$.MODULE$.default()), this.ceiling(Glob$GlobOps$.MODULE$.base$extension(Glob$.MODULE$.GlobOps(glob), Glob$RelativeGlobViewOption$.MODULE$.default())));
                Function1<Path, Object> filter = this.globExcludes();
                Iterable toRemove = (Iterable)((IterableOps)JavaConverters$.MODULE$.mapAsScalaMapConverter(subMap).asScala()).collect((PartialFunction)new Serializable(filter){
                    private final Function1 filter$1;
                    {
                        this.filter$1 = filter$2;
                    }

                    public final boolean isDefinedAt(Tuple2 x) {
                        Path k;
                        Tuple2 tuple2 = x;
                        return tuple2 != null && BoxesRunTime.unboxToBoolean((Object)this.filter$1.apply((Object)(k = (Path)tuple2._1())));
                    }

                    public final Object applyOrElse(Tuple2 x, Function1 function1) {
                        Path k;
                        Tuple2 tuple2 = x;
                        if (tuple2 != null && BoxesRunTime.unboxToBoolean((Object)this.filter$1.apply((Object)(k = (Path)tuple2._1())))) {
                            return k;
                        }
                        return function1.apply((Object)x);
                    }
                });
                toRemove.foreach((Function1 & Serializable)x$0 -> subMap.remove(x$0));
            }
            return;
        }
    }

    private Seq<Tuple2<Path, T>> remove(SortedMap<Path, T> subMap) {
        IndexedSeq allEntries = ((IterableOnceOps)JavaConverters$.MODULE$.mapAsScalaMapConverter(subMap).asScala()).toIndexedSeq();
        allEntries.foreach((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Path p = (Path)tuple2._1();
                return subMap.remove(p);
            }
            throw new MatchError((Object)tuple2);
        });
        return allEntries;
    }

    private void add(Glob glob, FileAttributes fileAttributes) {
        FileAttributes fileAttributes2 = fileAttributes;
        FileAttributes$NonExistent$ fileAttributes$NonExistent$ = FileAttributes$NonExistent$.MODULE$;
        if (fileAttributes2 == null ? fileAttributes$NonExistent$ != null : !fileAttributes2.equals(fileAttributes$NonExistent$)) {
            HashMap newFiles = new HashMap();
            scala.collection.mutable.Map asScala = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(newFiles).asScala();
            Path path = (Path)Predef$.MODULE$.ArrowAssoc((Object)Glob$GlobOps$.MODULE$.base$extension(Glob$.MODULE$.GlobOps(glob), Glob$RelativeGlobViewOption$.MODULE$.default()));
            asScala.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)path, this.converter.apply((Object)Glob$GlobOps$.MODULE$.base$extension(Glob$.MODULE$.GlobOps(glob), Glob$RelativeGlobViewOption$.MODULE$.default()))));
            if (fileAttributes.isDirectory()) {
                ((Growable)JavaConverters$.MODULE$.mapAsScalaMapConverter(newFiles).asScala()).$plus$plus$eq((IterableOnce)FileTreeView$Ops$.MODULE$.list$extension(FileTreeView$.MODULE$.Ops(this.view), glob).map((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        Path p = (Path)tuple2._1();
                        Path path = (Path)Predef$.MODULE$.ArrowAssoc((Object)p);
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)path, this.converter.apply((Object)p));
                    }
                    throw new MatchError((Object)tuple2);
                }));
            }
            this.files.putAll(newFiles);
            return;
        }
    }

    private Function1<Path, Object> globInclude() {
        return (Function1 & Serializable)path -> this.globs.exists((Function1 & Serializable)g -> {
            if (g.matches((Path)path)) return true;
            Path path = Glob$GlobOps$.MODULE$.base$extension(Glob$.MODULE$.GlobOps((Glob)g), Glob$RelativeGlobViewOption$.MODULE$.default());
            Path path2 = path;
            if (path != null) {
                if (!((Object)path).equals(path2)) return false;
                return true;
            }
            if (path2 == null) return true;
            return false;
        });
    }

    private Function1<Path, Object> globExcludes() {
        return (Function1 & Serializable)path -> !this.globs.exists((Function1 & Serializable)g -> {
            if (g.matches((Path)path)) return true;
            Path path = Glob$GlobOps$.MODULE$.base$extension(Glob$.MODULE$.GlobOps((Glob)g), Glob$RelativeGlobViewOption$.MODULE$.default());
            Path path2 = path;
            if (path != null) {
                if (!((Object)path).equals(path2)) return false;
                return true;
            }
            if (path2 == null) return true;
            return false;
        });
    }

    private Glob updateGlob(Path path) {
        int depth = BoxesRunTime.unboxToInt((Object)this.globs.toIndexedSeq().view().map((Function1 & Serializable)g -> {
            if (path.startsWith(Glob$GlobOps$.MODULE$.base$extension(Glob$.MODULE$.GlobOps((Glob)g), Glob$RelativeGlobViewOption$.MODULE$.default()))) {
                Path path = path;
                Path path2 = Glob$GlobOps$.MODULE$.base$extension(Glob$.MODULE$.GlobOps((Glob)g), Glob$RelativeGlobViewOption$.MODULE$.default());
                if (!(path != null ? !((Object)path).equals(path2) : path2 != null)) {
                    return Glob$GlobOps$.MODULE$.range$extension(Glob$.MODULE$.GlobOps((Glob)g))._2$mcI$sp();
                }
                int n = Glob$GlobOps$.MODULE$.range$extension(Glob$.MODULE$.GlobOps((Glob)g))._2$mcI$sp();
                if (Integer.MAX_VALUE == n) {
                    return Integer.MAX_VALUE;
                }
                int d = n;
                return d - Glob$GlobOps$.MODULE$.base$extension(Glob$.MODULE$.GlobOps((Glob)g), Glob$RelativeGlobViewOption$.MODULE$.default()).relativize(path).getNameCount();
            }
            return Integer.MIN_VALUE;
        }).min((Ordering)Ordering.Int$.MODULE$));
        int n = depth;
        if (Integer.MAX_VALUE == n) {
            return Glob$.MODULE$.apply(path, (RelativeGlob)RecursiveGlob$.MODULE$);
        }
        int d = n;
        return (Glob)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), d).foldLeft((Object)Glob$.MODULE$.apply(path), (Function2 & Serializable)(x$1, x$2) -> FileCache.updateGlob$$anonfun$1((Glob)x$1, BoxesRunTime.unboxToInt((Object)x$2)));
    }

    private Path ceiling(Path path) {
        return Paths.get(new StringBuilder(0).append(path.toString()).append(this.ceilingChar).toString(), new String[0]);
    }

    private static final /* synthetic */ Glob $anonfun$1(Glob x$1, int x$2) {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)x$1, (Object)BoxesRunTime.boxToInteger((int)x$2));
        if (tuple2 != null) {
            Glob g = (Glob)tuple2._1();
            return Glob$GlobOps$.MODULE$.$div$extension(Glob$.MODULE$.GlobOps(g), AnyPath$.MODULE$);
        }
        throw new MatchError((Object)tuple2);
    }

    private static final /* synthetic */ Glob updateGlob$$anonfun$1(Glob x$1, int x$2) {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)x$1, (Object)BoxesRunTime.boxToInteger((int)x$2));
        if (tuple2 != null) {
            Glob g = (Glob)tuple2._1();
            return Glob$GlobOps$.MODULE$.$div$extension(Glob$.MODULE$.GlobOps(g), AnyPath$.MODULE$);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final class GlobOps {
        private final Glob glob;

        public static boolean covers$extension(Glob glob, Glob glob2) {
            return FileCache$GlobOps$.MODULE$.covers$extension(glob, glob2);
        }

        public static boolean equals$extension(Glob glob, Object object) {
            return FileCache$GlobOps$.MODULE$.equals$extension(glob, object);
        }

        public static int hashCode$extension(Glob glob) {
            return FileCache$GlobOps$.MODULE$.hashCode$extension(glob);
        }

        public GlobOps(Glob glob) {
            this.glob = glob;
        }

        public int hashCode() {
            return FileCache$GlobOps$.MODULE$.hashCode$extension(this.glob());
        }

        public boolean equals(Object x$0) {
            return FileCache$GlobOps$.MODULE$.equals$extension(this.glob(), x$0);
        }

        public Glob glob() {
            return this.glob;
        }

        public boolean covers(Glob other) {
            return FileCache$GlobOps$.MODULE$.covers$extension(this.glob(), other);
        }
    }
}

