/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.io;

import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import sbt.internal.io.NewWatchState;
import sbt.internal.io.Source;
import sbt.internal.io.WatchState$;
import sbt.io.Unregisterable;
import sbt.io.WatchService;
import sbt.nio.file.AnyPath$;
import sbt.nio.file.Glob;
import sbt.nio.file.Glob$;
import sbt.nio.file.RecursiveGlob$;
import sbt.nio.file.RelativeGlob;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.MapOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Set;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public final class WatchState
implements AutoCloseable {
    private final int count;
    private final Seq sources;
    private final WatchService service;
    private final Map registered;
    private final AtomicBoolean closed;

    public static WatchState empty(Seq<Glob> seq) {
        return WatchState$.MODULE$.empty(seq);
    }

    public static NewWatchState empty(Seq<Glob> seq, WatchService watchService) {
        return WatchState$.MODULE$.empty(seq, watchService);
    }

    public static WatchState empty(WatchService watchService, Seq<Source> seq) {
        return WatchState$.MODULE$.empty(watchService, seq);
    }

    public static WatchEvent.Kind<Path>[] events() {
        return WatchState$.MODULE$.events();
    }

    public WatchState(int count, Seq<Source> sources, WatchService service, Map<Path, WatchKey> registered) {
        this.count = count;
        this.sources = sources;
        this.service = service;
        this.registered = registered;
        this.closed = new AtomicBoolean(false);
    }

    public int count() {
        return this.count;
    }

    public Seq<Source> sources() {
        return this.sources;
    }

    public WatchService service() {
        return this.service;
    }

    public Map<Path, WatchKey> registered() {
        return this.registered;
    }

    public boolean accept(Path p) {
        return this.sources().exists((Function1 & Serializable)_$1 -> _$1.accept(p, _$1.accept$default$2()));
    }

    public void unregister(Path path) {
        WatchService watchService = this.service();
        if (watchService instanceof Unregisterable) {
            Unregisterable s = (Unregisterable)((Object)watchService);
            s.unregister(path);
            return;
        }
    }

    public WatchState $minus$minus(Iterable<Path> fs) {
        fs.foreach((Function1)(JProcedure1 & Serializable)f -> this.registered().get(f).withFilter((Function1 & Serializable)wk -> this.registered().values().count((Function1 & Serializable)_$2 -> {
            WatchKey watchKey = _$2;
            WatchKey watchKey2 = wk;
            return !(watchKey != null ? !watchKey.equals(watchKey2) : watchKey2 != null);
        }) <= 1).foreach((Function1)(JProcedure1 & Serializable)wk -> this.unregister((Path)wk.watchable())));
        return this.withRegistered((Map<Path, WatchKey>)((Map)this.registered().$minus$minus(fs)));
    }

    public WatchState $plus$plus(Iterable<Path> fs) {
        Map newKeys = (Map)((IterableOnceOps)fs.filter((Function1 & Serializable)_$3 -> Files.exists(_$3, new LinkOption[0]))).foldLeft(this.registered(), (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 != null) {
                Map map = (Map)tuple2._1();
                Path path = (Path)tuple2._2();
                Map ks = map;
                Path d = path;
                if (Files.isDirectory(d, new LinkOption[0])) {
                    if (ks.contains((Object)d)) {
                        return ks;
                    }
                    Path path2 = (Path)Predef$.MODULE$.ArrowAssoc((Object)d);
                    return (Map)ks.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)path2, (Object)this.register(d)));
                }
                Map ks2 = map;
                Path f = path;
                Path parent = f.getParent();
                if (!ks2.contains((Object)parent)) {
                    Path path3 = (Path)Predef$.MODULE$.ArrowAssoc((Object)parent);
                    return (Map)ks2.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)path3, (Object)this.register(parent)));
                }
                return ks2;
            }
            throw new MatchError((Object)tuple2);
        });
        return this.withRegistered((Map<Path, WatchKey>)newKeys);
    }

    public Iterable<Tuple2<Path, WatchEvent<?>>> pollEvents() {
        Map<WatchKey, Seq<WatchEvent<Path>>> events = this.service().pollEvents();
        return (Iterable)((MapOps)events.toIterable()).flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                WatchKey k = (WatchKey)tuple2._1();
                Seq evs = (Seq)tuple2._2();
                return (Seq)evs.map((Function1 & Serializable)_$4 -> Tuple2$.MODULE$.apply((Object)((Path)k.watchable()), _$4));
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public WatchKey register(Path path) {
        return this.service().register(path, (Seq<WatchEvent.Kind<Path>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])WatchState$.MODULE$.events()));
    }

    public WatchState withCount(int count) {
        return new WatchState(count, this.sources(), this.service(), this.registered());
    }

    public WatchState withRegistered(Map<Path, WatchKey> registered) {
        return new WatchState(this.count(), this.sources(), this.service(), registered);
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.service().close();
            return;
        }
    }

    public NewWatchState toNewWatchState() {
        Set globs = (Set)JavaConverters$.MODULE$.asScalaSetConverter(ConcurrentHashMap.newKeySet()).asScala();
        globs.$plus$plus$eq((IterableOnce)this.sources().map((Function1 & Serializable)s -> {
            Glob base = s.recursive() ? Glob$.MODULE$.apply(s.base(), (RelativeGlob)RecursiveGlob$.MODULE$) : Glob$.MODULE$.apply(s.base(), (RelativeGlob)AnyPath$.MODULE$);
            return base;
        }));
        ConcurrentHashMap map = new ConcurrentHashMap();
        map.putAll((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.registered()).asJava());
        return new NewWatchState((Set<Glob>)globs, this.service(), (scala.collection.mutable.Map<Path, WatchKey>)((scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(map).asScala()));
    }
}

