/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.io;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import sbt.internal.io.Source$;
import sbt.io.DirectoryFilter$;
import sbt.io.FileFilter;
import sbt.nio.file.AnyPath$;
import sbt.nio.file.FileTreeView$;
import sbt.nio.file.FileTreeView$Ops$;
import sbt.nio.file.Glob$;
import sbt.nio.file.RecursiveGlob$;
import sbt.nio.file.RelativeGlob;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;

public final class Source {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(Source.class.getDeclaredField("hashCode$lzy1"));
    private final File base;
    private final FileFilter includeFilter;
    private final FileFilter excludeFilter;
    private final boolean recursive;
    private volatile Object hashCode$lzy1;

    public static Source apply(File file) {
        return Source$.MODULE$.apply(file);
    }

    public static Source apply(File file, FileFilter fileFilter, FileFilter fileFilter2) {
        return Source$.MODULE$.apply(file, fileFilter, fileFilter2);
    }

    public Source(File base, FileFilter includeFilter, FileFilter excludeFilter, boolean recursive) {
        this.base = base;
        this.includeFilter = includeFilter;
        this.excludeFilter = excludeFilter;
        this.recursive = recursive;
    }

    public File base() {
        return this.base;
    }

    public FileFilter includeFilter() {
        return this.includeFilter;
    }

    public FileFilter excludeFilter() {
        return this.excludeFilter;
    }

    public boolean recursive() {
        return this.recursive;
    }

    public Source(File base, FileFilter includeFilter, FileFilter excludeFilter) {
        this(base, includeFilter, excludeFilter, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean accept(Path p, boolean includeDirs) {
        FileFilter inc;
        FileFilter fileFilter = inc = includeDirs ? DirectoryFilter$.MODULE$.$bar$bar(this.includeFilter()) : this.includeFilter();
        if (!this.recursive()) {
            Path path = p.getParent();
            Path path2 = this.base().toPath();
            if (path == null ? path2 != null : !((Object)path).equals(path2)) {
                return false;
            }
        } else if (!p.startsWith(this.base().toPath())) return false;
        if (!inc.accept(p.toFile())) return false;
        if (this.excludeFilter().accept(p.toFile())) return false;
        return true;
    }

    public boolean accept$default$2() {
        return false;
    }

    public scala.collection.immutable.Seq<Path> getUnfilteredPaths() {
        return (scala.collection.immutable.Seq)FileTreeView$Ops$.MODULE$.list$extension(FileTreeView$.MODULE$.Ops(FileTreeView$.MODULE$.default()), Glob$.MODULE$.apply(this.base(), (RelativeGlob)(this.recursive() ? RecursiveGlob$.MODULE$ : AnyPath$.MODULE$))).map((Function1 & Serializable)_$6 -> (Path)_$6._1());
    }

    public Source withRecursive(boolean recursive) {
        return new Source(this.base(), this.includeFilter(), this.excludeFilter(), recursive);
    }

    public String toString() {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(116).append("Source(\n       |  base = ").append(this.base()).append(",\n       |  includeFilter = ").append(this.includeFilter()).append(",\n       |  excludeFilter = ").append(this.excludeFilter()).append(",\n       |  recursive = ").append(this.recursive()).append(",\n       |)").toString()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        Object object = o;
        if (!(object instanceof Source)) return false;
        Source that = (Source)object;
        File file = this.base();
        File file2 = that.base();
        if (file == null) {
            if (file2 != null) {
                return false;
            }
        } else if (!((Object)file).equals(file2)) return false;
        FileFilter fileFilter = this.includeFilter();
        FileFilter fileFilter2 = that.includeFilter();
        if (fileFilter == null) {
            if (fileFilter2 != null) {
                return false;
            }
        } else if (!fileFilter.equals(fileFilter2)) return false;
        FileFilter fileFilter3 = this.excludeFilter();
        FileFilter fileFilter4 = that.excludeFilter();
        if (fileFilter3 == null) {
            if (fileFilter4 != null) {
                return false;
            }
        } else if (!fileFilter3.equals(fileFilter4)) return false;
        if (this.recursive() != that.recursive()) return false;
        return true;
    }

    public int hashCode() {
        Object object = this.hashCode$lzy1;
        if (object instanceof Integer) {
            return BoxesRunTime.unboxToInt((Object)object);
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return BoxesRunTime.unboxToInt(null);
        }
        return BoxesRunTime.unboxToInt((Object)this.hashCode$lzyINIT1());
    }

    private Object hashCode$lzyINIT1() {
        Object object;
        block7: {
            while (true) {
                if ((object = this.hashCode$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Integer n = null;
                    try {
                        n = BoxesRunTime.boxToInteger((int)((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.base(), this.includeFilter(), this.excludeFilter(), BoxesRunTime.boxToBoolean((boolean)this.recursive())}))).hashCode());
                        object2 = n == null ? LazyVals.NullValue$.MODULE$ : n;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.hashCode$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.hashCode$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return n;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block7;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }
}

