/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.ui;

import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import sbt.State;
import sbt.internal.CommandChannel;
import sbt.internal.ConsolePromptEvent;
import sbt.internal.ConsoleUnpromptEvent;
import sbt.internal.ui.UITask;
import sbt.internal.ui.UITask$;
import sbt.internal.ui.UserThread$;
import sbt.internal.util.ConsoleAppender$;
import sbt.internal.util.JoinThread$;
import sbt.internal.util.ProgressEvent;
import sbt.internal.util.ProgressEvent$;
import sbt.internal.util.ProgressState$;
import sbt.internal.util.Prompt;
import sbt.internal.util.Terminal;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.concurrent.duration.package;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class UserThread
implements AutoCloseable {
    private final CommandChannel channel;
    public final AtomicReference<Tuple2<UITask, Thread>> sbt$internal$ui$UserThread$$uiThread;
    private final ExecutorService executor;
    private final AtomicReference<ProgressEvent> lastProgressEvent;
    private final AtomicBoolean isClosed;

    public UserThread(CommandChannel channel) {
        this.channel = channel;
        this.sbt$internal$ui$UserThread$$uiThread = new AtomicReference();
        this.executor = Executors.newSingleThreadExecutor(r -> new Thread(r, new StringBuilder(14).append("sbt-").append(this.sbt$internal$ui$UserThread$$name()).append("-ui-thread").toString()));
        this.lastProgressEvent = new AtomicReference();
        this.isClosed = new AtomicBoolean(false);
    }

    public CommandChannel channel() {
        return this.channel;
    }

    public final void onProgressEvent(ProgressEvent pe) {
        this.lastProgressEvent.set(pe);
        ProgressState$.MODULE$.updateProgressState(pe, this.channel().terminal());
    }

    public void reset(State state) {
        block5: {
            block7: {
                if (this.isClosed.get()) break block5;
                AtomicReference<Tuple2<UITask, Thread>> atomicReference = this.sbt$internal$ui$UserThread$$uiThread;
                synchronized (atomicReference) {
                    Tuple2<UITask, Thread> tuple2;
                    block8: {
                        UITask uITask;
                        UITask task;
                        block10: {
                            Class<?> clazz;
                            Class<?> clazz2;
                            block9: {
                                block6: {
                                    task = this.channel().makeUIThread(state);
                                    tuple2 = this.sbt$internal$ui$UserThread$$uiThread.get();
                                    if (tuple2 != null) break block6;
                                    this.submit$1(task);
                                    break block7;
                                }
                                if (tuple2 == null) break block8;
                                UITask prevTask = uITask = (UITask)tuple2._1();
                                clazz2 = prevTask.getClass();
                                clazz = task.getClass();
                                if (clazz2 != null) break block9;
                                if (clazz == null) break block7;
                                break block10;
                            }
                            if (clazz2.equals(clazz)) break block7;
                        }
                        UITask t = uITask;
                        Thread thread = (Thread)tuple2._2();
                        this.stopThreadImpl();
                        this.submit$1(task);
                        break block7;
                    }
                    throw new MatchError(tuple2);
                }
            }
            Option$.MODULE$.apply((Object)this.lastProgressEvent.get()).foreach((Function1)(JProcedure1 & Serializable)pe -> this.onProgressEvent((ProgressEvent)pe));
            return;
        }
    }

    public void stopThreadImpl() {
        AtomicReference<Tuple2<UITask, Thread>> atomicReference = this.sbt$internal$ui$UserThread$$uiThread;
        synchronized (atomicReference) {
            Tuple2 tuple2 = this.sbt$internal$ui$UserThread$$uiThread.getAndSet(null);
            if (tuple2 != null) {
                if (tuple2 != null) {
                    UITask t = (UITask)tuple2._1();
                    Thread thread = (Thread)tuple2._2();
                    t.close();
                    JoinThread$.MODULE$.joinFor(thread, new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).second());
                } else {
                    throw new MatchError((Object)tuple2);
                }
            }
        }
    }

    public void stopThread() {
        AtomicReference<Tuple2<UITask, Thread>> atomicReference = this.sbt$internal$ui$UserThread$$uiThread;
        synchronized (atomicReference) {
            this.stopThreadImpl();
        }
    }

    public void onConsolePromptEvent(ConsolePromptEvent consolePromptEvent) {
        UserThread userThread = this;
        synchronized (userThread) {
            if (this.terminal().isAnsiSupported()) {
                this.channel().terminal().withPrintStream((Function1)(JProcedure1 & Serializable)ps -> {
                    ps.print(ConsoleAppender$.MODULE$.ClearScreenAfterCursor());
                    ps.flush();
                });
            }
            State state = consolePromptEvent.state();
            Prompt prompt = this.terminal().prompt();
            if (Prompt.Running$.MODULE$.equals(prompt) || Prompt.Pending$.MODULE$.equals(prompt)) {
                this.terminal().setPrompt((Prompt)Prompt.AskUser$.MODULE$.apply((Function0 & Serializable)() -> UITask$.MODULE$.shellPrompt(this.terminal(), state)));
            }
            this.onProgressEvent(ProgressEvent$.MODULE$.apply("Info", (Vector)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0])), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$));
            this.reset(state);
        }
    }

    public void onConsoleUnpromptEvent(ConsoleUnpromptEvent consoleUnpromptEvent) {
        this.terminal().setPrompt((Prompt)Prompt.Pending$.MODULE$);
        if (BoxesRunTime.unboxToBoolean((Object)consoleUnpromptEvent.lastSource().fold(UserThread::onConsoleUnpromptEvent$$anonfun$1, (Function1 & Serializable)_$1 -> {
            String string = _$1.channelName();
            String string2 = this.sbt$internal$ui$UserThread$$name();
            return string == null ? string2 != null : !string.equals(string2);
        }))) {
            this.terminal().progressState().reset();
            return;
        }
        this.stopThread();
    }

    @Override
    public void close() {
        if (this.isClosed.compareAndSet(false, true)) {
            this.executor.shutdown();
            return;
        }
    }

    private Terminal terminal() {
        return this.channel().terminal();
    }

    public String sbt$internal$ui$UserThread$$name() {
        return this.channel().name();
    }

    private final void submit$1(UITask task$1) {
        Thread thread = new Thread(task$1, this){
            private final UITask task$2;
            private final /* synthetic */ UserThread $outer;
            {
                this.task$2 = task$3;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super(new StringBuilder(14).append("sbt-").append($outer.sbt$internal$ui$UserThread$$name()).append("-ui-thread").toString());
                this.setDaemon(true);
            }

            public void run() {
                try {
                    this.task$2.run();
                }
                finally {
                    Tuple2 tuple2 = this.$outer.sbt$internal$ui$UserThread$$uiThread.getAndSet(null);
                    if (tuple2 != null) {
                        Thread th = (Thread)tuple2._2();
                        Tuple2 prev = tuple2;
                        Thread thread = th;
                        $anon$1 var6_9 = this;
                        if (thread == null ? var6_9 != null : !thread.equals(var6_9)) {
                            this.$outer.sbt$internal$ui$UserThread$$uiThread.set((Tuple2<UITask, Thread>)prev);
                        }
                    }
                }
            }
        };
        Tuple2<UITask, Thread> tuple2 = this.sbt$internal$ui$UserThread$$uiThread.getAndSet((Tuple2<UITask, Thread>)Tuple2$.MODULE$.apply((Object)task$1, (Object)thread));
        if (tuple2 == null) {
            thread.start();
            return;
        }
        if (tuple2 != null) {
            UITask prevTask = (UITask)tuple2._1();
            Thread prevThread = (Thread)tuple2._2();
            Class<?> clazz = prevTask.getClass();
            Class<?> clazz2 = task$1.getClass();
            if (clazz == null ? clazz2 != null : !clazz.equals(clazz2)) {
                prevTask.close();
                JoinThread$.MODULE$.joinFor(prevThread, new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).second());
                thread.start();
                return;
            }
        }
        Tuple2<UITask, Thread> t = tuple2;
        this.sbt$internal$ui$UserThread$$uiThread.set(t);
    }

    private static final boolean onConsoleUnpromptEvent$$anonfun$1() {
        return true;
    }
}

