/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.server;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.AclEntryPermission;
import java.nio.file.attribute.AclEntryType;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.UserPrincipal;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.scalasbt.ipcsocket.UnixDomainServerSocket;
import org.scalasbt.ipcsocket.UnixDomainSocket;
import org.scalasbt.ipcsocket.UnixDomainSocketLibraryProvider;
import org.scalasbt.ipcsocket.Win32NamedPipeServerSocket;
import sbt.ConnectionType;
import sbt.ConnectionType$Local$;
import sbt.ConnectionType$Tcp$;
import sbt.ServerAuthentication;
import sbt.ServerAuthentication$Token$;
import sbt.internal.bsp.BuildServerConnection$;
import sbt.internal.protocol.PortFile;
import sbt.internal.protocol.PortFile$;
import sbt.internal.protocol.TokenFile;
import sbt.internal.protocol.TokenFile$;
import sbt.internal.server.AlreadyRunningException;
import sbt.internal.server.Server$;
import sbt.internal.server.Server$JsonProtocol$;
import sbt.internal.server.ServerConnection;
import sbt.internal.server.ServerInstance;
import sbt.internal.util.ErrorHandling$;
import sbt.internal.util.Util$;
import sbt.io.IO$;
import sbt.io.RichFile;
import sbt.io.syntax$;
import sbt.util.Logger;
import scala.Function0;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.collection.immutable.Set;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ModuleSerializationProxy;
import scala.sys.package$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import sjsonnew.JsonWriter;
import sjsonnew.shaded.scalajson.ast.unsafe.JValue;
import sjsonnew.support.scalajson.unsafe.CompactPrinter$;
import sjsonnew.support.scalajson.unsafe.Converter$;

public final class Server$
implements Serializable {
    public static final Server$JsonProtocol$ JsonProtocol;
    public static final Server$ MODULE$;

    private Server$() {
    }

    static {
        MODULE$ = new Server$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Server$.class);
    }

    public ServerInstance start(ServerConnection connection, Function2<Socket, ServerInstance, BoxedUnit> onIncomingSocket, Logger log) {
        return new ServerInstance(connection, log, onIncomingSocket){
            private final ServerConnection connection$3;
            private final Logger log$3;
            private final AtomicBoolean running;
            private final Promise p;
            private final Future ready;
            private final SecureRandom rand;
            private String token;
            public final AtomicReference sbt$internal$server$Server$$anon$1$$serverSocketHolder;
            private final Thread serverThread;
            {
                this.connection$3 = connection$1;
                this.log$3 = log$1;
                this.running = new AtomicBoolean(false);
                this.p = Promise$.MODULE$.apply();
                this.ready = this.p().future();
                this.rand = new SecureRandom();
                this.token = this.nextToken();
                this.sbt$internal$server$Server$$anon$1$$serverSocketHolder = new AtomicReference<V>();
                this.serverThread = new Thread(connection$1, log$1, onIncomingSocket$1, this){
                    private final ServerConnection connection$2;
                    private final Logger log$2;
                    private final Function2 onIncomingSocket$2;
                    private final /* synthetic */ anon.1 $outer;
                    {
                        this.connection$2 = connection$4;
                        this.log$2 = log$4;
                        this.onIncomingSocket$2 = onIncomingSocket$3;
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        super("sbt-socket-server");
                    }

                    public void run() {
                        Try try_ = Try$.MODULE$.apply(this::run$$anonfun$1);
                        if (try_ instanceof Failure) {
                            Throwable e = ((Failure)try_).exception();
                            this.$outer.p().failure(e);
                            return;
                        }
                        if (try_ instanceof Success) {
                            ServerSocket serverSocket = (ServerSocket)((Success)try_).value();
                            serverSocket.setSoTimeout(5000);
                            ServerSocket serverSocket2 = this.$outer.sbt$internal$server$Server$$anon$1$$serverSocketHolder.getAndSet(serverSocket);
                            if (serverSocket2 != null) {
                                ServerSocket s = serverSocket2;
                                s.close();
                            }
                            this.log$2.info(this::run$$anonfun$2);
                            this.$outer.sbt$internal$server$Server$$anon$1$$writePortfile();
                            if (this.connection$2.bspEnabled()) {
                                this.log$2.debug(Server$::sbt$internal$server$Server$$anon$2$$_$run$$anonfun$3);
                                BuildServerConnection$.MODULE$.writeConnectionFile(this.connection$2.appConfiguration().provider().id().version(), this.connection$2.appConfiguration().baseDirectory());
                            }
                            this.$outer.running().set(true);
                            this.$outer.p().success((Object)BoxedUnit.UNIT);
                            while (this.$outer.running().get()) {
                                try {
                                    Socket socket = serverSocket.accept();
                                    this.onIncomingSocket$2.apply((Object)socket, (Object)this.$outer);
                                }
                                catch (Throwable throwable) {
                                    IOException e;
                                    Throwable throwable2 = throwable;
                                    if (throwable2 instanceof IOException && (e = (IOException)throwable2).getMessage().contains("connect") || throwable2 instanceof SocketTimeoutException || throwable2 instanceof SocketException && !this.$outer.running().get()) continue;
                                    throw throwable;
                                }
                            }
                            ServerSocket serverSocket3 = (ServerSocket)this.$outer.sbt$internal$server$Server$$anon$1$$serverSocketHolder.get();
                            if (serverSocket3 == null) {
                                return;
                            }
                            ServerSocket s = serverSocket3;
                            s.close();
                            return;
                        }
                        throw new MatchError((Object)try_);
                    }

                    private final ServerSocket run$$anonfun$1$$anonfun$1() {
                        return new Win32NamedPipeServerSocket(this.connection$2.pipeName(), this.connection$2.useJni(), this.connection$2.windowsServerSecurityLevel());
                    }

                    private final Socket run$$anonfun$1$$anonfun$2(String path$1) {
                        return new UnixDomainSocket(path$1, this.connection$2.useJni());
                    }

                    private final ServerSocket run$$anonfun$1$$anonfun$3(String path$2) {
                        return new UnixDomainServerSocket(path$2, this.connection$2.useJni());
                    }

                    private final Socket run$$anonfun$1$$anonfun$4() {
                        return new Socket(InetAddress.getByName(this.connection$2.host()), this.connection$2.port());
                    }

                    private final ServerSocket run$$anonfun$1$$anonfun$5() {
                        return new ServerSocket(this.connection$2.port(), 50, InetAddress.getByName(this.connection$2.host()));
                    }

                    private final ServerSocket run$$anonfun$1() {
                        ConnectionType connectionType = this.connection$2.connectionType();
                        if (ConnectionType$Local$.MODULE$.equals(connectionType)) {
                            if (Util$.MODULE$.isWindows()) {
                                return this.$outer.addServerError(this::run$$anonfun$1$$anonfun$1);
                            }
                            int maxSocketLength = UnixDomainSocketLibraryProvider.maxSocketLength((boolean)this.connection$2.useJni()) - 1;
                            String path = this.connection$2.socketfile().getAbsolutePath();
                            if (path.length() > maxSocketLength) {
                                throw package$.MODULE$.error(new StringBuilder(126).append("socket file absolute path too long; either switch to another connection type or define a short \"SBT_GLOBAL_SERVER_DIR\" value. ").append(new StringBuilder(14).append("Current path: ").append(path).toString()).toString());
                            }
                            this.$outer.tryClient(() -> this.run$$anonfun$1$$anonfun$2(path));
                            this.$outer.prepareSocketfile();
                            return this.$outer.addServerError(() -> this.run$$anonfun$1$$anonfun$3(path));
                        }
                        if (ConnectionType$Tcp$.MODULE$.equals(connectionType)) {
                            this.$outer.tryClient(this::run$$anonfun$1$$anonfun$4);
                            return this.$outer.addServerError(this::run$$anonfun$1$$anonfun$5);
                        }
                        throw new MatchError((Object)connectionType);
                    }

                    private final String run$$anonfun$2() {
                        return new StringBuilder(22).append("sbt server started at ").append(this.connection$2.shortName()).toString();
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{run$$anonfun$1(), run$$anonfun$2(), sbt$internal$server$Server$$anon$2$$_$run$$anonfun$3(), run$$anonfun$1$$anonfun$1(), run$$anonfun$1$$anonfun$2(java.lang.String ), run$$anonfun$1$$anonfun$3(java.lang.String ), run$$anonfun$1$$anonfun$4(), run$$anonfun$1$$anonfun$5()}, serializedLambda);
                    }
                };
                this.serverThread().start();
            }

            public AtomicBoolean running() {
                return this.running;
            }

            public Promise p() {
                return this.p;
            }

            public Future ready() {
                return this.ready;
            }

            public Thread serverThread() {
                return this.serverThread;
            }

            public void tryClient(Function0 f) {
                if (this.connection$3.portfile().exists()) {
                    Try try_ = Try$.MODULE$.apply(() -> Server$.sbt$internal$server$Server$$anon$1$$_$tryClient$$anonfun$1(f));
                    if (try_ instanceof Failure) {
                        return;
                    }
                    if (try_ instanceof Success) {
                        Socket socket = (Socket)((Success)try_).value();
                        socket.close();
                        throw new AlreadyRunningException();
                    }
                    throw new MatchError((Object)try_);
                }
            }

            public ServerSocket addServerError(Function0 f) {
                return (ServerSocket)ErrorHandling$.MODULE$.translate(this::addServerError$$anonfun$1, () -> Server$.sbt$internal$server$Server$$anon$1$$_$addServerError$$anonfun$2(f));
            }

            public boolean authenticate(String challenge) {
                boolean bl;
                anon.1 var2_2 = this;
                synchronized (var2_2) {
                    boolean bl2;
                    String string = this.token;
                    String string2 = challenge;
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        this.token = this.nextToken();
                        this.writeTokenfile();
                        bl2 = true;
                    } else {
                        bl2 = false;
                    }
                    bl = bl2;
                }
                return bl;
            }

            private String nextToken() {
                return new BigInteger(128, this.rand).toString();
            }

            public void shutdown() {
                this.log$3.info(Server$::sbt$internal$server$Server$$anon$1$$_$shutdown$$anonfun$1);
                if (this.connection$3.portfile().exists()) {
                    IO$.MODULE$.delete(this.connection$3.portfile());
                }
                if (this.connection$3.tokenfile().exists()) {
                    IO$.MODULE$.delete(this.connection$3.tokenfile());
                }
                this.running().set(false);
                ServerSocket serverSocket = this.sbt$internal$server$Server$$anon$1$$serverSocketHolder.getAndSet(null);
                if (serverSocket == null) {
                    return;
                }
                ServerSocket s = serverSocket;
                s.close();
            }

            private void writeTokenfile() {
                String uri = this.connection$3.shortName();
                TokenFile t = TokenFile$.MODULE$.apply(uri, this.token);
                JValue jsonToken = (JValue)Converter$.MODULE$.toJson((Object)t, (JsonWriter)Server$JsonProtocol$.MODULE$.TokenFileFormat()).get();
                if (this.connection$3.tokenfile().exists()) {
                    IO$.MODULE$.delete(this.connection$3.tokenfile());
                }
                IO$.MODULE$.touch(this.connection$3.tokenfile(), IO$.MODULE$.touch$default$2());
                this.ownerOnly(this.connection$3.tokenfile());
                IO$.MODULE$.write(this.connection$3.tokenfile(), CompactPrinter$.MODULE$.apply(jsonToken), IO$.MODULE$.utf8(), true);
            }

            private void ownerOnly(File file) {
                File file2 = file;
                if (IO$.MODULE$.isPosix()) {
                    IO$.MODULE$.chmod("rw-------", file);
                    return;
                }
                if (IO$.MODULE$.hasAclFileAttributeView()) {
                    AclFileAttributeView view = new RichFile(syntax$.MODULE$.fileToRichFile(file)).aclFileAttributeView();
                    view.setAcl(Collections.singletonList(Server$.sbt$internal$server$Server$$anon$1$$_$acl$1(view.getOwner())));
                    return;
                }
            }

            public void sbt$internal$server$Server$$anon$1$$writePortfile() {
                PortFile portFile;
                String uri = this.connection$3.shortName();
                Set<ServerAuthentication> set = this.connection$3.auth();
                if (this.connection$3.auth().apply((Object)ServerAuthentication$Token$.MODULE$)) {
                    this.writeTokenfile();
                    portFile = PortFile$.MODULE$.apply(uri, Option$.MODULE$.apply((Object)this.connection$3.tokenfile().toString()), Option$.MODULE$.apply((Object)IO$.MODULE$.toURI(this.connection$3.tokenfile()).toString()));
                } else {
                    portFile = PortFile$.MODULE$.apply(uri, (Option)None$.MODULE$, (Option)None$.MODULE$);
                }
                PortFile p = portFile;
                JValue json = (JValue)Converter$.MODULE$.toJson((Object)p, (JsonWriter)Server$JsonProtocol$.MODULE$.PortFileFormat()).get();
                IO$.MODULE$.write(this.connection$3.portfile(), CompactPrinter$.MODULE$.apply(json), IO$.MODULE$.write$default$3(), IO$.MODULE$.write$default$4());
            }

            public void prepareSocketfile() {
                if (this.connection$3.socketfile().exists()) {
                    IO$.MODULE$.delete(this.connection$3.socketfile());
                }
                IO$.MODULE$.createDirectory(this.connection$3.socketfile().getParentFile());
            }

            private final String addServerError$$anonfun$1() {
                return new StringBuilder(28).append("server failed to start on ").append(this.connection$3.shortName()).append(". ").toString();
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{sbt$internal$server$Server$$anon$1$$_$tryClient$$anonfun$1(scala.Function0 ), addServerError$$anonfun$1(), sbt$internal$server$Server$$anon$1$$_$addServerError$$anonfun$2(scala.Function0 ), sbt$internal$server$Server$$anon$1$$_$shutdown$$anonfun$1()}, serializedLambda);
            }
        };
    }

    public static final String sbt$internal$server$Server$$anon$2$$_$run$$anonfun$3() {
        return "Writing bsp connection file";
    }

    public static final Socket sbt$internal$server$Server$$anon$1$$_$tryClient$$anonfun$1(Function0 f$1) {
        return (Socket)f$1.apply();
    }

    public static final ServerSocket sbt$internal$server$Server$$anon$1$$_$addServerError$$anonfun$2(Function0 f$2) {
        return (ServerSocket)f$2.apply();
    }

    public static final String sbt$internal$server$Server$$anon$1$$_$shutdown$$anonfun$1() {
        return "shutting down sbt server";
    }

    public static final AclEntry sbt$internal$server$Server$$anon$1$$_$acl$1(UserPrincipal owner) {
        AclEntry.Builder builder = AclEntry.newBuilder();
        builder.setPrincipal(owner);
        builder.setPermissions(AclEntryPermission.values());
        builder.setType(AclEntryType.ALLOW);
        return builder.build();
    }
}

