/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import sbt.internal.protocol.JsonRpcMessage;
import sbt.internal.protocol.JsonRpcNotificationMessage;
import sbt.internal.protocol.JsonRpcRequestMessage;
import sbt.internal.protocol.JsonRpcResponseMessage;
import sbt.internal.util.ReadJsonFromInputStream$;
import sbt.protocol.Serialization$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.function.JProcedure1;

public abstract class ServerConnection {
    public final Socket sbt$internal$client$ServerConnection$$connection;
    public final AtomicBoolean sbt$internal$client$ServerConnection$$running;
    private final AtomicBoolean closed;
    private final byte retByte;
    private final byte delimiter;
    private final OutputStream out;
    private final Thread thread;

    public ServerConnection(Socket connection) {
        this.sbt$internal$client$ServerConnection$$connection = connection;
        this.sbt$internal$client$ServerConnection$$running = new AtomicBoolean(true);
        this.closed = new AtomicBoolean(false);
        this.retByte = (byte)13;
        this.delimiter = (byte)10;
        this.out = connection.getOutputStream();
        this.thread = new Thread(this){
            private final /* synthetic */ ServerConnection $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super(new StringBuilder(21).append("sbt-serverconnection-").append($outer.sbt$internal$client$ServerConnection$$connection.getPort()).toString());
                this.setDaemon(true);
            }

            public void run() {
                try {
                    InputStream in = this.$outer.sbt$internal$client$ServerConnection$$connection.getInputStream();
                    this.$outer.sbt$internal$client$ServerConnection$$connection.setSoTimeout(5000);
                    while (this.$outer.sbt$internal$client$ServerConnection$$running.get()) {
                        try {
                            Seq<Object> frame = ReadJsonFromInputStream$.MODULE$.apply(in, this.$outer.sbt$internal$client$ServerConnection$$running, (Option<Function1<String, BoxedUnit>>)None$.MODULE$);
                            if (!this.$outer.sbt$internal$client$ServerConnection$$running.get()) continue;
                            Serialization$.MODULE$.deserializeJsonMessage(frame).fold((Function1)((JProcedure1 & Serializable)arg_0 -> ServerConnection.sbt$internal$client$ServerConnection$$anon$1$$_$run$$anonfun$1(frame, arg_0)), (Function1)(JProcedure1 & Serializable)_$1 -> {
                                JsonRpcMessage jsonRpcMessage = _$1;
                                if (jsonRpcMessage instanceof JsonRpcRequestMessage) {
                                    JsonRpcRequestMessage msg = (JsonRpcRequestMessage)jsonRpcMessage;
                                    this.$outer.onRequest(msg);
                                    return;
                                }
                                if (jsonRpcMessage instanceof JsonRpcResponseMessage) {
                                    JsonRpcResponseMessage msg = (JsonRpcResponseMessage)jsonRpcMessage;
                                    this.$outer.onResponse(msg);
                                    return;
                                }
                                if (jsonRpcMessage instanceof JsonRpcNotificationMessage) {
                                    JsonRpcNotificationMessage msg = (JsonRpcNotificationMessage)jsonRpcMessage;
                                    this.$outer.onNotification(msg);
                                    return;
                                }
                                throw new MatchError((Object)jsonRpcMessage);
                            });
                        }
                        catch (SocketTimeoutException socketTimeoutException) {
                        }
                        catch (IOException e) {
                            this.$outer.sbt$internal$client$ServerConnection$$running.set(false);
                        }
                    }
                }
                finally {
                    this.$outer.shutdown();
                }
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{sbt$internal$client$ServerConnection$$anon$1$$_$run$$anonfun$1(scala.collection.immutable.Seq java.lang.String ), run$$anonfun$2(sbt.internal.protocol.JsonRpcMessage )}, serializedLambda);
            }
        };
        this.thread().start();
    }

    public Thread thread() {
        return this.thread;
    }

    public void sendString(String message) {
        ServerConnection serverConnection = this;
        synchronized (serverConnection) {
            byte[] a = message.getBytes("UTF-8");
            this.writeLine(new StringBuilder(16).append("Content-Length: ").append(a.length + 2).toString().getBytes("UTF-8"));
            this.writeLine(new byte[0]);
            this.writeLine(a);
        }
    }

    public void writeLine(byte[] a) {
        try {
            Object object = Predef$.MODULE$.byteArrayOps(a);
            if (ArrayOps$.MODULE$.nonEmpty$extension(object)) {
                this.out.write(a);
            }
            this.writeEndLine$1();
        }
        catch (IOException e) {
            this.shutdown();
            throw e;
        }
    }

    public abstract void onRequest(JsonRpcRequestMessage var1);

    public abstract void onResponse(JsonRpcResponseMessage var1);

    public abstract void onNotification(JsonRpcNotificationMessage var1);

    public abstract void onShutdown();

    public void shutdown() {
        if (this.closed.compareAndSet(false, true)) {
            if (!this.sbt$internal$client$ServerConnection$$running.compareAndSet(true, false)) {
                System.err.println("\nsbt server connection closed.");
            }
            try {
                this.out.close();
                this.sbt$internal$client$ServerConnection$$connection.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.onShutdown();
            return;
        }
    }

    public static final /* synthetic */ void sbt$internal$client$ServerConnection$$anon$1$$_$run$$anonfun$1(Seq frame$1, String errorDesc) {
        String s = frame$1.mkString("");
        Predef$.MODULE$.println((Object)new StringBuilder(33).append("Got invalid chunk from server: ").append(s).append(" \n").append(errorDesc).toString());
    }

    private final void writeEndLine$1() {
        this.out.write(this.retByte);
        this.out.write(this.delimiter);
        this.out.flush();
    }
}

