/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.client;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.Socket;
import java.text.DateFormat;
import sbt.internal.BootServerSocket;
import sbt.internal.client.BspClient$;
import sbt.internal.client.ConsoleInterface;
import sbt.internal.client.NetworkClient;
import sbt.internal.client.NetworkClient$;
import sbt.internal.util.Appender;
import sbt.internal.util.ConsoleAppender$;
import sbt.internal.util.ConsoleOut$;
import sbt.internal.util.Terminal;
import sbt.internal.util.Terminal$;
import sbt.util.Level$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Growable;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Properties$;
import scala.util.matching.Regex;
import xsbti.AppConfiguration;

public final class NetworkClient$
implements Serializable {
    private static final String CancelAll;
    private static final String completions;
    private static final String noTab;
    private static final String noStdErr;
    private static final String sbtBase;
    public static final NetworkClient$ MODULE$;

    private NetworkClient$() {
    }

    static {
        MODULE$ = new NetworkClient$();
        CancelAll = "__CancelAll";
        completions = "--completions";
        noTab = "--no-tab";
        noStdErr = "--no-stderr";
        sbtBase = "--sbt-base-directory";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(NetworkClient$.class);
    }

    public String CancelAll() {
        return CancelAll;
    }

    public ConsoleInterface sbt$internal$client$NetworkClient$$$consoleAppenderInterface(PrintStream printStream) {
        Appender appender = ConsoleAppender$.MODULE$.apply("thin", ConsoleOut$.MODULE$.printStreamOut(printStream));
        return new ConsoleInterface(appender){
            private final Appender appender$1;
            {
                this.appender$1 = appender$2;
            }

            public void appendLog(Enumeration.Value level, Function0 message) {
                this.appender$1.appendLog(level, message);
            }

            public void success(String msg) {
                this.appender$1.success(() -> NetworkClient$.sbt$internal$client$NetworkClient$$anon$12$$_$success$$anonfun$1(msg));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{sbt$internal$client$NetworkClient$$anon$12$$_$success$$anonfun$1(java.lang.String )}, serializedLambda);
            }
        };
    }

    private ConsoleInterface simpleConsoleInterface(Function1<String, BoxedUnit> doPrintln) {
        return new ConsoleInterface(doPrintln){
            private final Function1 doPrintln$1;
            {
                this.doPrintln$1 = doPrintln$2;
            }

            public void appendLog(Enumeration.Value level, Function0 message) {
                anon.13 var3_3 = this;
                synchronized (var3_3) {
                    String string;
                    Enumeration.Value value = level;
                    Enumeration.Value value2 = Level$.MODULE$.Error();
                    Enumeration.Value value3 = value;
                    if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                        string = new StringBuilder(11).append("[").append("\u001b[31m").append(level).append("\u001b[0m").append("]").toString();
                    } else {
                        Enumeration.Value value4 = Level$.MODULE$.Warn();
                        Enumeration.Value value5 = value;
                        string = !(value4 != null ? !value4.equals(value5) : value5 != null) ? new StringBuilder(11).append("[").append("\u001b[33m").append(level).append("\u001b[0m").append("]").toString() : new StringBuilder(10).append("[").append("\u001b[0m").append(level).append("\u001b[0m").append("]").toString();
                    }
                    String prefix = string;
                    StringOps$.MODULE$.linesIterator$extension(Predef$.MODULE$.augmentString((String)message.apply())).foreach((Function1)(JProcedure1 & Serializable)line -> this.doPrintln$1.apply((Object)new StringBuilder(1).append(prefix).append(" ").append((String)line).toString()));
                }
            }

            public void success(String msg) {
                this.doPrintln$1.apply((Object)new StringBuilder(19).append("[").append("\u001b[32m").append("success").append("\u001b[0m").append("] ").append(msg).toString());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{appendLog$$anonfun$1(java.lang.String java.lang.String )}, serializedLambda);
            }
        };
    }

    public String completions() {
        return completions;
    }

    public String noTab() {
        return noTab;
    }

    public String noStdErr() {
        return noStdErr;
    }

    public String sbtBase() {
        return sbtBase;
    }

    public NetworkClient.Arguments parseArgs(String[] args) {
        String defaultSbtScript = Properties$.MODULE$.isWin() ? "sbt.bat" : "sbt";
        ObjectRef sbtScript2 = ObjectRef.create((Object)Properties$.MODULE$.propOrNone("sbt.script"));
        None$ launchJar = None$.MODULE$;
        boolean bsp = false;
        ArrayBuffer commandArgs = new ArrayBuffer();
        ArrayBuffer sbtArguments = new ArrayBuffer();
        ArrayBuffer completionArguments = new ArrayBuffer();
        Regex SysProp = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("-D([^=]+)=(.*)"));
        Object object = Predef$.MODULE$.refArrayOps((Object[])args);
        String[] sanitized = (String[])ArrayOps$.MODULE$.flatMap$extension(object, (Function1 & Serializable)x$1 -> {
            String string = x$1;
            String a = string;
            if (a.startsWith("\"")) {
                return new String[]{a};
            }
            String a2 = string;
            return a2.split(" ");
        }, (Function1 & Serializable)xs -> Predef$.MODULE$.wrapRefArray((Object[])xs), ClassTag$.MODULE$.apply(String.class));
        for (int i = 0; i < sanitized.length; ++i) {
            List list;
            Option option;
            Growable growable;
            String string;
            block16: {
                String a;
                block15: {
                    String a2 = string = sanitized[i];
                    if (completionArguments.nonEmpty()) {
                        growable = completionArguments.$plus$eq((Object)a2);
                        continue;
                    }
                    String a3 = string;
                    if (commandArgs.nonEmpty()) {
                        growable = commandArgs.$plus$eq((Object)a3);
                        continue;
                    }
                    String string2 = a = string;
                    String string3 = this.noStdErr();
                    if (!(string2 == null ? string3 != null : !string2.equals(string3))) break block15;
                    String string4 = a;
                    String string5 = this.noTab();
                    if ((string4 == null ? string5 != null : !string4.equals(string5)) && !a.startsWith(this.completions())) break block16;
                }
                growable = completionArguments.$plus$eq((Object)a);
                continue;
            }
            String a = string;
            if (a.startsWith("--sbt-script=")) {
                Object object2 = Predef$.MODULE$.refArrayOps((Object[])a.split("--sbt-script="));
                sbtScript2.elem = ArrayOps$.MODULE$.lastOption$extension(object2).orElse(() -> NetworkClient$.parseArgs$$anonfun$1(sbtScript2));
                growable = BoxedUnit.UNIT;
                continue;
            }
            if ("--sbt-script".equals(string) && i + 1 < sanitized.length) {
                sbtScript2.elem = Some$.MODULE$.apply((Object)sanitized[++i]);
                growable = BoxedUnit.UNIT;
                continue;
            }
            String a4 = string;
            if (a4.startsWith("--sbt-launch-jar=")) {
                Object object3 = Predef$.MODULE$.refArrayOps((Object[])a4.split("--sbt-launch-jar="));
                launchJar = ArrayOps$.MODULE$.lastOption$extension(object3).map((Function1 & Serializable)_$18 -> _$18.replace("%20", " "));
                growable = BoxedUnit.UNIT;
                continue;
            }
            if ("--sbt-launch-jar".equals(string) && i + 1 < sanitized.length) {
                launchJar = Option$.MODULE$.apply((Object)sanitized[++i].replace("%20", " "));
                growable = BoxedUnit.UNIT;
                continue;
            }
            if ("-bsp".equals(string) || "--bsp".equals(string)) {
                bsp = true;
                growable = BoxedUnit.UNIT;
                continue;
            }
            String a5 = string;
            if (!a5.startsWith("-")) {
                growable = commandArgs.$plus$eq((Object)a5);
                continue;
            }
            if (string != null && !(option = SysProp.unapplySeq((CharSequence)string)).isEmpty() && (list = (List)option.get()).lengthCompare(2) == 0) {
                String string6 = (String)list.apply(0);
                String string7 = (String)list.apply(1);
                String key = string6;
                String value = string7;
                String a6 = string;
                System.setProperty(key, value);
                growable = sbtArguments.$plus$eq((Object)a6);
                continue;
            }
            String a7 = string;
            growable = sbtArguments.$plus$eq((Object)a7);
        }
        File base = new File("").getCanonicalFile();
        if (!sbtArguments.contains((Object)"-Dsbt.io.virtual=true")) {
            sbtArguments.$plus$eq((Object)"-Dsbt.io.virtual=true");
        }
        if (!sbtArguments.exists((Function1 & Serializable)_$19 -> _$19.startsWith("-Dsbt.script"))) {
            ((Option)sbtScript2.elem).foreach((Function1 & Serializable)sbtScript -> (ArrayBuffer)sbtArguments.$plus$eq((Object)new StringBuilder(13).append("-Dsbt.script=").append((String)sbtScript).toString()));
        }
        return new NetworkClient.Arguments(base, (Seq<String>)sbtArguments.toSeq(), (Seq<String>)commandArgs.toSeq(), (Seq<String>)completionArguments.toSeq(), ((String)((Option)sbtScript2.elem).getOrElse(() -> NetworkClient$.parseArgs$$anonfun$5(defaultSbtScript))).replace("%20", " "), bsp, (Option<String>)launchJar);
    }

    public String timing(DateFormat format, long startTime, long endTime) {
        String string;
        long total = (endTime - startTime + 500L) / 1000L;
        StringBuilder stringBuilder = new StringBuilder(2).append(total).append(" s");
        if (total <= 60L) {
            string = "";
        } else {
            String string2;
            long l = total / 3600L;
            if (0L == l) {
                string2 = "0";
            } else {
                long h = l;
                string2 = StringOps$.MODULE$.format$extension("%02d", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)h)}));
            }
            String hours = string2;
            String mins = StringOps$.MODULE$.format$extension("%02d", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(total % 3600L / 60L))}));
            String secs = StringOps$.MODULE$.format$extension("%02d", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(total % 60L))}));
            string = new StringBuilder(7).append(" (").append(hours).append(":").append(mins).append(":").append(secs).append(".0)").toString();
        }
        String totalString = stringBuilder.append(string).toString();
        return new StringBuilder(14).append("elapsed time: ").append(totalString).toString();
    }

    public String timing(long startTime, long endTime) {
        DateFormat format = DateFormat.getDateTimeInstance(2, 2);
        return this.timing(format, startTime, endTime);
    }

    public int client(File baseDirectory, String[] args, InputStream inputStream, PrintStream printStream, PrintStream errorStream, boolean useJNI) {
        int n;
        block6: {
            try (NetworkClient client = this.simpleClient(this.parseArgs(args).withBaseDirectory(baseDirectory), inputStream, printStream, errorStream, useJNI);){
                try {
                    if (client.connect(true, false)) {
                        n = client.run();
                        break block6;
                    }
                    n = 1;
                }
                catch (Exception exception) {
                    n = 1;
                }
            }
        }
        return n;
    }

    public int client(File baseDirectory, NetworkClient.Arguments args, InputStream inputStream, PrintStream errorStream, Terminal terminal, boolean useJNI) {
        PrintStream printStream = args.bsp() ? errorStream : terminal.printStream();
        NetworkClient client = this.simpleClient(args.withBaseDirectory(baseDirectory), inputStream, printStream, errorStream, useJNI);
        return this.clientImpl(client, args.bsp());
    }

    private int clientImpl(NetworkClient client, boolean isBsp) {
        int n;
        block8: {
            try {
                try {
                    if (isBsp) {
                        Tuple2<Socket, Option<String>> tuple2 = client.connectOrStartServerAndConnect(false, true);
                        if (tuple2 == null) {
                            throw new MatchError(tuple2);
                        }
                        Socket socket = (Socket)tuple2._1();
                        Socket socket2 = socket;
                        n = BspClient$.MODULE$.bspRun(socket2);
                        break block8;
                    }
                    if (client.connect(true, false)) {
                        n = client.run();
                        break block8;
                    }
                    n = 1;
                }
                catch (Exception exception) {
                    n = 1;
                }
            }
            finally {
                client.close();
            }
        }
        return n;
    }

    public int client(File baseDirectory, String[] args, InputStream inputStream, PrintStream errorStream, Terminal terminal, boolean useJNI) {
        return this.client(baseDirectory, this.parseArgs(args), inputStream, errorStream, terminal, useJNI);
    }

    private NetworkClient simpleClient(NetworkClient.Arguments arguments, InputStream inputStream, PrintStream errorStream, boolean useJNI, Terminal terminal) {
        JProcedure1 & Serializable doPrint = (JProcedure1 & Serializable)line -> {
            if (terminal.getLastLine().isDefined()) {
                terminal.printStream().println();
            }
            terminal.printStream().println((String)line);
        };
        ConsoleInterface consoleInterface = this.simpleConsoleInterface((Function1<String, BoxedUnit>)doPrint);
        PrintStream printStream = terminal.printStream();
        return new NetworkClient(arguments, consoleInterface, inputStream, errorStream, printStream, useJNI);
    }

    private NetworkClient simpleClient(NetworkClient.Arguments arguments, InputStream inputStream, PrintStream printStream, PrintStream errorStream, boolean useJNI) {
        ConsoleInterface consoleInterface = this.simpleConsoleInterface((Function1<String, BoxedUnit>)(JProcedure1 & Serializable)x$0 -> printStream.println((String)x$0));
        return new NetworkClient(arguments, consoleInterface, inputStream, errorStream, printStream, useJNI);
    }

    public void main(String[] args) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])args);
        Tuple2 tuple2 = ArrayOps$.MODULE$.partition$extension(object, (Function1 & Serializable)_$20 -> {
            String string = _$20;
            String string2 = "--jna";
            return !(string != null ? !string.equals(string2) : string2 != null);
        });
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String[] jnaArg = (String[])tuple2._1();
        String[] restOfArgs = (String[])tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)jnaArg, (Object)restOfArgs);
        Object[] jnaArg2 = (String[])tuple22._1();
        Object[] restOfArgs2 = (String[])tuple22._2();
        Object object2 = Predef$.MODULE$.refArrayOps(jnaArg2);
        boolean useJNI = ArrayOps$.MODULE$.isEmpty$extension(object2);
        File base = new File("").getCanonicalFile();
        Object object3 = Predef$.MODULE$.refArrayOps(restOfArgs2);
        if (ArrayOps$.MODULE$.exists$extension(object3, (Function1 & Serializable)_$21 -> _$21.startsWith(MODULE$.completions()))) {
            System.exit(this.complete(base, (String[])restOfArgs2, useJNI, System.in, System.out));
            return;
        }
        Thread hook = new Thread(() -> {
            System.out.print(ConsoleAppender$.MODULE$.ClearScreenAfterCursor());
            System.out.flush();
        });
        Runtime.getRuntime().addShutdownHook(hook);
        NetworkClient.Arguments parsed = this.parseArgs((String[])restOfArgs2);
        System.exit(BoxesRunTime.unboxToInt((Object)Terminal$.MODULE$.withStreams(false, false, () -> NetworkClient$.main$$anonfun$2(base, parsed, useJNI, hook))));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int complete(File baseDirectory, String[] args, boolean useJNI, InputStream in, PrintStream out) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])args);
        Option option = ArrayOps$.MODULE$.find$extension(object, (Function1 & Serializable)_$22 -> _$22.startsWith(MODULE$.completions()));
        if (!(option instanceof Some)) throw new IllegalStateException("should be unreachable");
        String c = (String)((Some)option).value();
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(c), '='));
        Option option2 = ArrayOps$.MODULE$.lastOption$extension(object2);
        if (!(option2 instanceof Some)) throw new IllegalArgumentException(c);
        String query = (String)((Some)option2).value();
        int n = query.indexOf(" ");
        if (-1 == n) {
            throw new IllegalArgumentException(query);
        }
        int i = n;
        String cmd = query.substring(i + 1);
        Object object3 = Predef$.MODULE$.refArrayOps((Object[])args);
        boolean quiet = ArrayOps$.MODULE$.exists$extension(object3, (Function1 & Serializable)_$23 -> {
            String string = _$23;
            String string2 = "--quiet";
            return !(string != null ? !string.equals(string2) : string2 != null);
        });
        PrintStream errorStream = quiet ? new PrintStream(new OutputStream(){

            public final void write(int _$24) {
                NetworkClient$.sbt$internal$client$NetworkClient$$$_$_$$anonfun$44(_$24);
            }
        }, false) : System.err;
        Object object4 = Predef$.MODULE$.refArrayOps((Object[])args);
        String[] sbtArgs = (String[])ArrayOps$.MODULE$.takeWhile$extension(object4, (Function1 & Serializable)_$25 -> !_$25.startsWith(MODULE$.completions()));
        NetworkClient.Arguments arguments = this.parseArgs(sbtArgs);
        Object object5 = Predef$.MODULE$.refArrayOps((Object[])args);
        boolean noTab = ArrayOps$.MODULE$.contains$extension(object5, (Object)"--no-tab");
        try {
            NetworkClient.Arguments arguments2 = arguments.withBaseDirectory(baseDirectory);
            try (NetworkClient client = this.simpleClient(arguments2, in, errorStream, errorStream, useJNI);){
                int n2;
                try {
                    Seq<String> results = client.connect(false, true) ? client.getCompletions(cmd) : package$.MODULE$.Nil();
                    out.println(((IterableOnceOps)((SeqOps)results.sorted((Ordering)Ordering.String$.MODULE$)).distinct()).mkString("\n"));
                    n2 = 0;
                    return n2;
                }
                catch (Exception exception) {
                    n2 = 1;
                }
                return n2;
            }
        }
        catch (NetworkClient.AccessDeniedException accessDeniedException) {
            return 1;
        }
    }

    public int run(AppConfiguration configuration, List<String> arguments) {
        return this.run(configuration, arguments, false);
    }

    /*
     * Unable to fully structure code
     */
    public int run(AppConfiguration configuration, List<String> arguments, boolean redirectOutput) {
        term = Terminal$.MODULE$.console();
        err = new PrintStream(term.errorStream());
        out = redirectOutput != false ? err : new PrintStream(term.outputStream());
        args = this.parseArgs((String[])arguments.toArray(ClassTag$.MODULE$.apply(String.class))).withBaseDirectory(configuration.baseDirectory());
        if (Predef$.MODULE$.Boolean2boolean(BootServerSocket.requiresJNI())) ** GOTO lbl-1000
        v0 = System.getProperty("sbt.ipcsocket.jni", "false");
        var9_8 = "true";
        if (!(v0 != null ? v0.equals(var9_8) == false : var9_8 != null)) lbl-1000:
        // 2 sources

        {
            v1 = true;
        } else {
            v1 = false;
        }
        useJNI = v1;
        client = this.simpleClient(args, term.inputStream(), out, err, useJNI);
        return this.clientImpl(client, args.bsp());
    }

    public static final String sbt$internal$client$NetworkClient$$anon$12$$_$success$$anonfun$1(String msg$5) {
        return msg$5;
    }

    private static final Option parseArgs$$anonfun$1(ObjectRef sbtScript$2) {
        return (Option)sbtScript$2.elem;
    }

    private static final String parseArgs$$anonfun$5(String defaultSbtScript$1) {
        return defaultSbtScript$1;
    }

    private static final int main$$anonfun$2(File base$1, NetworkClient.Arguments parsed$1, boolean useJNI$1, Thread hook$1) {
        int n;
        Terminal term = Terminal$.MODULE$.console();
        try {
            try {
                n = MODULE$.client(base$1, parsed$1, term.inputStream(), System.err, term, useJNI$1);
            }
            catch (NetworkClient.AccessDeniedException accessDeniedException) {
                n = 1;
            }
        }
        finally {
            Runtime.getRuntime().removeShutdownHook(hook$1);
            hook$1.run();
        }
        return n;
    }

    public static final /* synthetic */ void sbt$internal$client$NetworkClient$$$_$_$$anonfun$44(int _$24) {
    }
}

