/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import sbt.CommandSource;
import sbt.CommandSource$;
import sbt.Exec;
import sbt.Exec$;
import sbt.State;
import sbt.internal.ConsolePromptEvent;
import sbt.internal.ConsoleUnpromptEvent;
import sbt.internal.FastTrackTask;
import sbt.internal.ui.UITask;
import sbt.internal.ui.UserThread;
import sbt.internal.util.Terminal;
import sbt.util.Level$;
import scala.Enumeration;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some$;
import scala.collection.StringOps$;
import scala.jdk.CollectionConverters$;

public abstract class CommandChannel {
    private final ConcurrentLinkedQueue<Exec> commandQueue = new ConcurrentLinkedQueue();
    private final Set<Queue<Exec>> registered = new HashSet<Queue<Exec>>();
    private final Set<Queue<FastTrackTask>> fastTrack = new HashSet<Queue<FastTrackTask>>();
    private final AtomicReference<Enumeration.Value> level = new AtomicReference<Enumeration.Value>(Level$.MODULE$.Info());
    private boolean _active = true;

    public final void register(Queue<Exec> queue, Queue<FastTrackTask> fastTrackQueue) {
        Set<Queue<Exec>> set = this.registered;
        synchronized (set) {
            this.registered.add(queue);
            if (!this.commandQueue.isEmpty()) {
                queue.addAll(this.commandQueue);
                this.commandQueue.clear();
            }
            this.fastTrack.add(fastTrackQueue);
        }
    }

    public final void unregister(Queue<CommandChannel> queue, Queue<FastTrackTask> fastTrackQueue) {
        Set<Queue<Exec>> set = this.registered;
        synchronized (set) {
            this.registered.remove(queue);
            this.fastTrack.remove(fastTrackQueue);
        }
    }

    public final void addFastTrackTask(String task) {
        this.fastTrack.forEach(q -> {
            Queue queue = q;
            synchronized (queue) {
                q.add(new FastTrackTask(this, task));
            }
        });
    }

    public abstract Function2<State, CommandChannel, UITask> mkUIThread();

    public UITask makeUIThread(State state) {
        return (UITask)this.mkUIThread().apply((Object)state, (Object)this);
    }

    public final boolean append(Exec exec) {
        boolean bl;
        Set<Queue<Exec>> set = this.registered;
        synchronized (set) {
            bl = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(exec.commandLine())) && !(!this.registered.isEmpty() ? !CollectionConverters$.MODULE$.SetHasAsScala(this.registered).asScala().forall((Function1 & Serializable)_$1 -> _$1.add(exec)) : !this.commandQueue.add(exec));
        }
        return bl;
    }

    public boolean appendExec(String commandLine, Option<String> execId) {
        return this.append(Exec$.MODULE$.apply(commandLine, (Option<String>)execId.orElse(CommandChannel::appendExec$$anonfun$1), (Option<CommandSource>)Some$.MODULE$.apply((Object)CommandSource$.MODULE$.apply(this.name()))));
    }

    public Option<Exec> poll() {
        return Option$.MODULE$.apply((Object)this.commandQueue.poll());
    }

    public void prompt(ConsolePromptEvent e) {
        this.userThread().onConsolePromptEvent(e);
    }

    public void unprompt(ConsoleUnpromptEvent e) {
        this.userThread().onConsoleUnpromptEvent(e);
    }

    public abstract void publishBytes(byte[] var1);

    public abstract UserThread userThread();

    public void shutdown(boolean logShutdown) {
        this.userThread().stopThread();
        this.userThread().close();
    }

    public void shutdown() {
        this.shutdown(true);
    }

    public abstract String name();

    public final void setLevel(Enumeration.Value l) {
        this.level.set(l);
    }

    public final Enumeration.Value logLevel() {
        return this.level.get();
    }

    private boolean setLevel(Enumeration.Value value, String cmd) {
        this.level.set(value);
        return this.appendExec(cmd, (Option<String>)None$.MODULE$);
    }

    public boolean onCommandLine(String cmd) {
        String string = cmd;
        switch (string == null ? 0 : string.hashCode()) {
            case 3237038: {
                if (!"info".equals(string)) break;
                return this.setLevel(Level$.MODULE$.Info(), "info");
            }
            case 3641990: {
                if (!"warn".equals(string)) break;
                return this.setLevel(Level$.MODULE$.Warn(), "warn");
            }
            case 95458899: {
                if (!"debug".equals(string)) break;
                return this.setLevel(Level$.MODULE$.Debug(), "debug");
            }
            case 96784904: {
                if (!"error".equals(string)) break;
                return this.setLevel(Level$.MODULE$.Error(), "error");
            }
        }
        String cmd2 = string;
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(cmd2))) {
            return this.appendExec(cmd2, (Option<String>)None$.MODULE$);
        }
        return false;
    }

    public boolean onFastTrackTask(String cmd) {
        Set<Queue<FastTrackTask>> set = this.fastTrack;
        synchronized (set) {
            this.fastTrack.forEach(q -> q.add(new FastTrackTask(this, cmd)));
        }
        return true;
    }

    public abstract Terminal terminal();

    public boolean _active() {
        return this._active;
    }

    public void _active_$eq(boolean x$1) {
        this._active = x$1;
    }

    public void pause() {
        this._active_$eq(false);
    }

    public boolean isPaused() {
        return !this._active();
    }

    public void resume() {
        this._active_$eq(true);
    }

    private static final Option appendExec$$anonfun$1() {
        return Some$.MODULE$.apply((Object)Exec$.MODULE$.newExecId());
    }
}

