/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import net.openhft.hashing.LongHashFunction;
import org.scalasbt.ipcsocket.UnixDomainServerSocket;
import org.scalasbt.ipcsocket.Win32NamedPipeServerSocket;
import org.scalasbt.ipcsocket.Win32SecurityLevel;
import sbt.internal.ServerAlreadyBootingException;
import sbt.internal.util.Terminal;
import xsbti.AppConfiguration;

public class BootServerSocket
implements AutoCloseable {
    private ServerSocket serverSocket = null;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final AtomicInteger threadId = new AtomicInteger(1);
    private final Future<?> acceptFuture;
    private final ExecutorService service = Executors.newCachedThreadPool(r -> new Thread(r, "boot-server-socket-thread-" + this.threadId.getAndIncrement()));
    private final Set<ClientSocket> clientSockets = ConcurrentHashMap.newKeySet();
    private final Object lock = new Object();
    private final LinkedBlockingQueue<ClientSocket> clientSocketReads = new LinkedBlockingQueue();
    private final Path socketFile;
    private final AtomicBoolean needInput = new AtomicBoolean(false);
    private final Object writeLock = new Object();
    private final InputStream inputStream = new InputStream(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read() {
            if (BootServerSocket.this.clientSockets.isEmpty()) {
                return Terminal.NO_BOOT_CLIENTS_CONNECTED();
            }
            try {
                AtomicBoolean atomicBoolean = BootServerSocket.this.needInput;
                synchronized (atomicBoolean) {
                    BootServerSocket.this.needInput.set(true);
                    BootServerSocket.this.needInput.notifyAll();
                }
                ClientSocket clientSocket = (ClientSocket)BootServerSocket.this.clientSocketReads.take();
                int n = (Integer)clientSocket.bytes.take();
                return n;
            }
            catch (InterruptedException e) {
                int n = -1;
                return n;
            }
            finally {
                AtomicBoolean atomicBoolean = BootServerSocket.this.needInput;
                synchronized (atomicBoolean) {
                    BootServerSocket.this.needInput.set(false);
                }
            }
        }
    };
    private final OutputStream outputStream = new OutputStream(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(int b) {
            Object object = BootServerSocket.this.lock;
            synchronized (object) {
                BootServerSocket.this.clientSockets.forEach(cs -> ((ClientSocket)cs).write(b));
            }
        }

        @Override
        public void write(byte[] b) {
            this.write(b, 0, b.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(byte[] b, int offset, int len) {
            Object object = BootServerSocket.this.lock;
            synchronized (object) {
                BootServerSocket.this.clientSockets.forEach(cs -> ((ClientSocket)cs).write(b, offset, len));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void flush() {
            Object object = BootServerSocket.this.lock;
            synchronized (object) {
                BootServerSocket.this.clientSockets.forEach(cs -> ((ClientSocket)cs).flush());
            }
        }
    };
    private final Runnable acceptRunnable = () -> {
        try {
            this.serverSocket.setSoTimeout(5000);
            while (this.running.get()) {
                try {
                    ClientSocket clientSocket = new ClientSocket(this.serverSocket.accept());
                }
                catch (SocketTimeoutException socketTimeoutException) {
                }
                catch (IOException e) {
                    this.running.set(false);
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    };
    static final boolean isWindows = System.getProperty("os.name", "").toLowerCase().startsWith("win");

    public InputStream inputStream() {
        return this.inputStream;
    }

    public OutputStream outputStream() {
        return this.outputStream;
    }

    public BootServerSocket(AppConfiguration configuration) throws ServerAlreadyBootingException, IOException {
        Path base = configuration.baseDirectory().toPath().toRealPath(new LinkOption[0]);
        if (!isWindows) {
            String actualSocketLocation = BootServerSocket.socketLocation(base);
            Path target = Paths.get(actualSocketLocation, new String[0]).getParent();
            if (!Files.isDirectory(target, new LinkOption[0])) {
                Files.createDirectories(target, new FileAttribute[0]);
            }
            this.socketFile = Paths.get(actualSocketLocation, new String[0]);
        } else {
            this.socketFile = null;
        }
        this.serverSocket = BootServerSocket.newSocket(BootServerSocket.socketLocation(base));
        if (this.serverSocket != null) {
            this.running.set(true);
            this.acceptFuture = this.service.submit(this.acceptRunnable);
        } else {
            this.closed.set(true);
            this.acceptFuture = null;
        }
    }

    public static String socketLocation(Path base) throws UnsupportedEncodingException, IOException {
        Path target = base.resolve("project").resolve("target");
        long hash = LongHashFunction.farmNa().hashBytes(target.toString().getBytes("UTF-8"));
        if (isWindows) {
            return "sbt-load" + hash;
        }
        String alternativeSocketLocation = System.getenv().getOrDefault("XDG_RUNTIME_DIR", System.getProperty("java.io.tmpdir"));
        Path alternativeSocketLocationRoot = Paths.get(alternativeSocketLocation, new String[0]).resolve(".sbt");
        Path locationForSocket = alternativeSocketLocationRoot.resolve("sbt-socket" + hash);
        Path pathForSocket = locationForSocket.resolve("sbt-load.sock");
        return pathForSocket.toString();
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.clientSockets.forEach(ClientSocket::close);
            if (this.acceptFuture != null) {
                this.acceptFuture.cancel(true);
            }
            this.service.shutdownNow();
            try {
                if (this.serverSocket != null) {
                    this.serverSocket.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                if (this.socketFile != null) {
                    Files.deleteIfExists(this.socketFile);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static ServerSocket newSocket(String sock) throws ServerAlreadyBootingException {
        Win32NamedPipeServerSocket socket = null;
        String name = BootServerSocket.socketName(sock);
        boolean jni = BootServerSocket.requiresJNI() != false || System.getProperty("sbt.ipcsocket.jni", "false").equals("true");
        try {
            if (!isWindows) {
                Files.deleteIfExists(Paths.get(sock, new String[0]));
            }
            socket = isWindows ? new Win32NamedPipeServerSocket(name, jni, Win32SecurityLevel.OWNER_DACL) : new UnixDomainServerSocket(name, jni);
            return socket;
        }
        catch (IOException e) {
            throw new ServerAlreadyBootingException(e);
        }
    }

    public static Boolean requiresJNI() {
        boolean isMac = System.getProperty("os.name").toLowerCase().startsWith("mac");
        return isMac && !System.getProperty("os.arch", "").equals("x86_64");
    }

    private static String socketName(String sock) {
        return isWindows ? "\\\\.\\pipe\\" + sock : sock;
    }

    private class ClientSocket
    implements AutoCloseable {
        final Socket socket;
        final AtomicBoolean alive = new AtomicBoolean(true);
        final Future<?> future;
        private final LinkedBlockingQueue<Integer> bytes = new LinkedBlockingQueue();
        private final AtomicBoolean closed = new AtomicBoolean(false);

        ClientSocket(Socket socket) {
            this.socket = socket;
            BootServerSocket.this.clientSockets.add(this);
            Future<?> f = null;
            try {
                f = BootServerSocket.this.service.submit(() -> {
                    try {
                        Terminal.console().getLines().foreach(l -> {
                            try {
                                this.write((l + System.lineSeparator()).getBytes("UTF-8"));
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            return 0;
                        });
                        InputStream inputStream = socket.getInputStream();
                        while (this.alive.get()) {
                            try {
                                AtomicBoolean atomicBoolean = BootServerSocket.this.needInput;
                                synchronized (atomicBoolean) {
                                    while (!BootServerSocket.this.needInput.get() && this.alive.get()) {
                                        BootServerSocket.this.needInput.wait();
                                    }
                                }
                                if (!this.alive.get()) continue;
                                socket.getOutputStream().write(5);
                                int b = inputStream.read();
                                if (b != -1) {
                                    this.bytes.put(b);
                                    BootServerSocket.this.clientSocketReads.put(this);
                                    continue;
                                }
                                this.alive.set(false);
                            }
                            catch (IOException e) {
                                this.alive.set(false);
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                });
            }
            catch (RejectedExecutionException e) {
                this.alive.set(false);
            }
            this.future = f;
        }

        private void write(int i) {
            try {
                if (this.alive.get()) {
                    this.socket.getOutputStream().write(i);
                }
            }
            catch (IOException e) {
                this.alive.set(false);
                this.close();
            }
        }

        private void write(byte[] b) {
            try {
                if (this.alive.get()) {
                    this.socket.getOutputStream().write(b);
                }
            }
            catch (IOException e) {
                this.alive.set(false);
                this.close();
            }
        }

        private void write(byte[] b, int offset, int len) {
            try {
                if (this.alive.get()) {
                    this.socket.getOutputStream().write(b, offset, len);
                }
            }
            catch (IOException e) {
                this.alive.set(false);
                this.close();
            }
        }

        private void flush() {
            try {
                this.socket.getOutputStream().flush();
            }
            catch (IOException e) {
                this.alive.set(false);
                this.close();
            }
        }

        @Override
        public void close() {
            if (this.closed.compareAndSet(false, true)) {
                if (this.alive.get()) {
                    this.write(2);
                    this.bytes.forEach(this::write);
                    this.bytes.clear();
                    this.write(3);
                    this.flush();
                }
                this.alive.set(false);
                if (this.future != null) {
                    this.future.cancel(true);
                }
                try {
                    this.socket.getOutputStream().close();
                    this.socket.getInputStream().close();
                    if (!System.getProperty("os.name", "").toLowerCase().startsWith("win")) {
                        this.socket.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                BootServerSocket.this.clientSockets.remove(this);
            }
        }
    }
}

