/*
 * Decompiled with CFR 0.152.
 */
package sbt;

import java.io.Serializable;
import sbt.Help;
import sbt.Help$;
import sbt.internal.util.complete.HistoryCommands$;
import sbt.util.Level$;
import scala.;
import scala.$less$colon$less$;
import scala.Enumeration;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class BasicCommandStrings$
implements Serializable {
    private static final String HelpCommand;
    private static final String CompletionsCommand;
    private static final String Exit;
    private static final String Shutdown;
    private static final String Quit;
    private static final String TemplateCommand;
    private static final String TemplateCommandAlias;
    private static final String Cancel;
    private static final String TerminateAction;
    private static final String EarlyCommand;
    private static final Tuple2<String, String> EarlyCommandBrief;
    private static final String EarlyCommandDetailed;
    private static final String AddPluginSbtFileCommand;
    private static final String AliasCommand;
    private static final String ContinuousExecutePrefix;
    private static final String networkExecPrefix;
    private static final String DisconnectNetworkChannel;
    public static final BasicCommandStrings$ MODULE$;

    private BasicCommandStrings$() {
    }

    static {
        MODULE$ = new BasicCommandStrings$();
        HelpCommand = "help";
        CompletionsCommand = "completions";
        Exit = "exit";
        Shutdown = "shutdown";
        Quit = "quit";
        TemplateCommand = "new";
        TemplateCommandAlias = "init";
        Cancel = "cancel";
        TerminateAction = MODULE$.Exit();
        EarlyCommand = "early";
        EarlyCommandBrief = Tuple2$.MODULE$.apply((Object)new StringBuilder(11).append(MODULE$.EarlyCommand()).append("(<command>)").toString(), (Object)"Schedules a command to run before other commands on startup.");
        EarlyCommandDetailed = new StringBuilder(219).append(MODULE$.EarlyCommand()).append("(<command>)\n\n  Schedules an early command, which will be run before other commands on the command line.\n  The order is preserved between all early commands, so `sbt \"early(a)\" \"early(b)\"` executes `a` and `b` in order.\n").toString();
        AddPluginSbtFileCommand = "addPluginSbtFile";
        AliasCommand = "alias";
        ContinuousExecutePrefix = "~";
        networkExecPrefix = "__";
        DisconnectNetworkChannel = new StringBuilder(24).append(MODULE$.networkExecPrefix()).append("disconnectNetworkChannel").toString();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(BasicCommandStrings$.class);
    }

    public String HelpCommand() {
        return HelpCommand;
    }

    public String CompletionsCommand() {
        return CompletionsCommand;
    }

    public String Exit() {
        return Exit;
    }

    public String Shutdown() {
        return Shutdown;
    }

    public String Quit() {
        return Quit;
    }

    public String TemplateCommand() {
        return TemplateCommand;
    }

    public String TemplateCommandAlias() {
        return TemplateCommandAlias;
    }

    public String Cancel() {
        return Cancel;
    }

    public String TerminateAction() {
        return TerminateAction;
    }

    public Tuple2<String, String> helpBrief() {
        return Tuple2$.MODULE$.apply((Object)this.HelpCommand(), (Object)new StringBuilder(92).append("Displays this help message or prints detailed help on requested commands (run '").append(this.HelpCommand()).append(" <command>').").toString());
    }

    public String helpDetailed() {
        return new StringBuilder(173).append(this.HelpCommand()).append("\n\n\tPrints a help summary.\n\n").append(this.HelpCommand()).append(" <command>\n\n\tPrints detailed help for command <command>.\n\n").append(this.HelpCommand()).append(" <regular expression>\n\n\tSearches the help according to the provided regular expression.\n").toString();
    }

    public String CompletionsDetailed() {
        return "Displays a list of completions for the given argument string (run 'completions <string>').";
    }

    public Tuple2<String, String> CompletionsBrief() {
        return Tuple2$.MODULE$.apply((Object)this.CompletionsCommand(), (Object)this.CompletionsDetailed());
    }

    public Tuple2<String, String> templateBrief() {
        return Tuple2$.MODULE$.apply((Object)this.TemplateCommand(), (Object)"Creates a new sbt build.");
    }

    public String templateDetailed() {
        return new StringBuilder(229).append(this.TemplateCommand()).append(" [--options] <template>\n  Create a new sbt build based on the given template.\n  sbt provides out-of-the-box support for Giter8 templates. See foundweekends.org/giter8/ for details.\n  \n  Example:\n    sbt new scala/scala-seed.g8\n  ").toString();
    }

    public Tuple2<String, String> HistoryHelpBrief() {
        return Tuple2$.MODULE$.apply((Object)HistoryCommands$.MODULE$.Start(), (Object)"History command help.  Lists and describes all history commands.");
    }

    public Help historyHelp() {
        Tuple2<String, String> tuple2 = this.HistoryHelpBrief();
        return Help$.MODULE$.apply((Seq<Tuple2<String, String>>)package$.MODULE$.Nil(), (Map<String, String>)((IterableOnceOps)HistoryCommands$.MODULE$.descriptions().$plus$colon(tuple2)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{HistoryCommands$.MODULE$.Start()}))));
    }

    public String exitBrief() {
        return "Terminates the remote client or the build when called from the console.";
    }

    public String shutdownBrief() {
        return "Terminates the build.";
    }

    public Help logLevelHelp() {
        Seq levels = Level$.MODULE$.values().toSeq();
        String levelList = levels.mkString(", ");
        Tuple2 brief = Tuple2$.MODULE$.apply((Object)"<log-level>", (Object)new StringBuilder(54).append("Sets the logging level to 'log-level'.  Valid levels: ").append(levelList).toString());
        Map detailed = ((IterableOnceOps)levels.map((Function1 & Serializable)l -> Tuple2$.MODULE$.apply((Object)l.toString(), (Object)MODULE$.logLevelDetail((Enumeration.Value)l)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        return Help$.MODULE$.apply((Tuple2<String, String>)brief, (Map<String, String>)detailed);
    }

    private String logLevelDetail(Enumeration.Value level) {
        return new StringBuilder(516).append(level).append("\n\n  Sets the global logging level to ").append(level).append(".\n  This will be used as the default level for logging from commands, settings, and tasks.\n  Any explicit `logLevel` configuration in a project overrides this setting.\n\n-").append(level).append(" OR --").append(level).append("\n\n  Sets the global logging level as described above, but does so before any other commands are executed on startup, including project loading.\n  This is useful as a startup option:\n    * it takes effect before any logging occurs\n    * if no other commands are passed, interactive mode is still entered\n").toString();
    }

    public String runEarly(String command) {
        return new StringBuilder(2).append(this.EarlyCommand()).append("(").append(command).append(")").toString();
    }

    public boolean isEarlyCommand(String s) {
        Seq levelOptions = (Seq)Level$.MODULE$.values().toSeq().flatMap((Function1 & Serializable)elem -> (IterableOnce)new .colon.colon((Object)new StringBuilder(1).append("-").append(elem).toString(), (List)new .colon.colon((Object)new StringBuilder(2).append("--").append(elem).toString(), (List)Nil$.MODULE$)));
        return s.startsWith(new StringBuilder(1).append(this.EarlyCommand()).append("(").toString()) && s.endsWith(")") || levelOptions.contains((Object)s) || s.startsWith(new StringBuilder(1).append("-").append(this.AddPluginSbtFileCommand()).toString()) || s.startsWith(new StringBuilder(2).append("--").append(this.AddPluginSbtFileCommand()).toString());
    }

    public String EarlyCommand() {
        return EarlyCommand;
    }

    public Tuple2<String, String> EarlyCommandBrief() {
        return EarlyCommandBrief;
    }

    public String EarlyCommandDetailed() {
        return EarlyCommandDetailed;
    }

    public Help addPluginSbtFileHelp() {
        Tuple2 brief = Tuple2$.MODULE$.apply((Object)new StringBuilder(9).append("--").append(this.AddPluginSbtFileCommand()).append("=<file>").toString(), (Object)"Adds the given *.sbt file to the plugin build.");
        return Help$.MODULE$.apply((Tuple2<String, String>)brief, Help$.MODULE$.apply$default$2());
    }

    public String AddPluginSbtFileCommand() {
        return AddPluginSbtFileCommand;
    }

    public String ReadCommand() {
        return "<";
    }

    public String ReadFiles() {
        return " file1 file2 ...";
    }

    public String ReadDetailed() {
        return new StringBuilder(478).append(this.ReadCommand()).append(this.ReadFiles()).append("\n\n  Reads the lines from the given files and inserts them as commands.\n  All empty lines and lines that start with '#' are ignored.\n  If a file does not exist or is not readable, this command fails.\n\n  All the lines from all the files are read before any of the commands\n    are executed. Thus, if any file is not readable, none of commands\n    from any of the files (even the existing ones) will be run.\n\n  You probably need to escape this command if entering it at your shell.").toString();
    }

    public String ApplyCommand() {
        return "apply";
    }

    public String ApplyDetailed() {
        return new StringBuilder(287).append(this.ApplyCommand()).append(" [-cp|-classpath <classpath>] <module-name>*\n  Transforms the current State by calling <module-name>.apply(currentState) for each listed module name.\n  Here, currentState is of type sbt.State.\n   If a classpath is provided, modules are loaded from a new class loader for this classpath.\n").toString();
    }

    public String RebootNetwork() {
        return "sbtRebootNetwork";
    }

    public String RebootImpl() {
        return "sbtRebootImpl";
    }

    public String RebootCommand() {
        return "reboot";
    }

    public String RebootDetailed() {
        return new StringBuilder(485).append(this.RebootCommand()).append(" [dev | full]\n\n  This command is equivalent to exiting sbt, restarting, and running the\n    remaining commands with the exception that the JVM is not shut down.\n\n  If 'dev' is specified, the current sbt artifacts from the boot directory\n    (`~/.sbt/boot` by default) are deleted before restarting.\n  This forces an update of sbt and Scala, which is useful when working with development\n    versions of sbt.\n  If 'full' is specified, the boot directory is wiped out before restarting.\n").toString();
    }

    public String Multi() {
        return ";";
    }

    public Tuple2<String, String> MultiBrief() {
        return Tuple2$.MODULE$.apply((Object)new StringBuilder(23).append("<command> (").append(this.Multi()).append(" <command>)*").toString(), (Object)"Runs the provided semicolon-separated commands.");
    }

    public String MultiDetailed() {
        return new StringBuilder(54).append(this.Multi()).append(" command1 ").append(this.Multi()).append(" command2 ...\n\n\tRuns the specified commands.").toString();
    }

    public String AppendCommand() {
        return "append";
    }

    public String AppendLastDetailed() {
        return new StringBuilder(58).append(this.AppendCommand()).append(" <command>\n\tAppends 'command' to list of commands to run.\n").toString();
    }

    public String AliasCommand() {
        return AliasCommand;
    }

    public String AliasDetailed() {
        return new StringBuilder(358).append(this.AliasCommand()).append("\n\n\tPrints a list of defined aliases.\n\n").append(this.AliasCommand()).append(" name\n\n\tPrints the alias defined for `name`.\n\n").append(this.AliasCommand()).append(" name=value\n\n\tSets the alias `name` to `value`, replacing any existing alias with that name.\n\tWhenever `name` is entered, the corresponding `value` is run.\n\tIf any argument is provided to `name`, it is appended as argument to `value`.\n\n").append(this.AliasCommand()).append(" name=\n\n\tRemoves the alias for `name`.").toString();
    }

    public String Shell() {
        return "shell";
    }

    public String ShellDetailed() {
        return "Provides an interactive prompt and network server from which commands can be run.";
    }

    public String StartServer() {
        return "startServer";
    }

    public String StartServerDetailed() {
        return new StringBuilder(113).append(this.StartServer()).append("\n  Starts the server if it has not been started. This is intended to be used with\n  -Dsbt.server.autostart=false.").toString();
    }

    public String ServerDetailed() {
        return "--server always runs sbt in not-daemon mode.";
    }

    public String DashDashServer() {
        return "--server";
    }

    public String OldShell() {
        return "oldshell";
    }

    public String OldShellDetailed() {
        return "Provides an interactive prompt from which commands can be run.";
    }

    public String Client() {
        return "client";
    }

    public String ClientDetailed() {
        return "Provides an interactive prompt from which commands can be run on a server.";
    }

    public String JavaClient() {
        return "--java-client";
    }

    public String DashClient() {
        return "-client";
    }

    public String DashDashClient() {
        return "--client";
    }

    public String DashDashDetachStdio() {
        return "--detach-stdio";
    }

    public String StashOnFailure() {
        return "sbtStashOnFailure";
    }

    public String PopOnFailure() {
        return "sbtPopOnFailure";
    }

    public String FailureWall() {
        return "resumeFromFailure";
    }

    public String ReportResult() {
        return "sbtReportResult";
    }

    public String CompleteExec() {
        return "sbtCompleteExec";
    }

    public String MapExec() {
        return "sbtMapExec";
    }

    public String PromptChannel() {
        return "sbtPromptChannel";
    }

    public String ClearOnFailure() {
        return "sbtClearOnFailure";
    }

    public String OnFailure() {
        return "onFailure";
    }

    public String OnFailureDetailed() {
        return new StringBuilder(291).append(this.OnFailure()).append(" command\n\n\tRegisters 'command' to run when a command fails to complete normally.\n\n\tOnly one failure command may be registered at a time, so this command\n\t  replaces the previous command if there is one.\n\n\tThe failure command resets when it runs once, so it must be added\n\t  again if desired.").toString();
    }

    public String IfLast() {
        return "iflast";
    }

    public String IfLastCommon() {
        return "If there are no more commands after this one, 'command' is run.";
    }

    public String IfLastDetailed() {
        return new StringBuilder(14).append(this.IfLast()).append(" <command>\n\n  ").append(this.IfLastCommon()).toString();
    }

    public String ContinuousExecutePrefix() {
        return ContinuousExecutePrefix;
    }

    public String continuousDetail() {
        return "Executes the specified command whenever source files change.";
    }

    public Tuple2<String, String> continuousBriefHelp() {
        return Tuple2$.MODULE$.apply((Object)new StringBuilder(10).append(this.ContinuousExecutePrefix()).append(" <command>").toString(), (Object)this.continuousDetail());
    }

    public String ClearCaches() {
        return "clearCaches";
    }

    public String ClearCachesDetailed() {
        return "Clears all of sbt's internal caches.";
    }

    public String networkExecPrefix() {
        return networkExecPrefix;
    }

    public String DisconnectNetworkChannel() {
        return DisconnectNetworkChannel;
    }
}

