/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.util;

import java.io.Serializable;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import sbt.internal.util.EvaluationState;
import sbt.internal.util.EvaluationState$;
import sbt.internal.util.Init;
import sbt.internal.util.PMap;
import sbt.internal.util.PMap$;
import sbt.internal.util.RMap;
import sbt.internal.util.TupleMapExtension$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple$package$EmptyTuple$;
import scala.Tuple1;
import scala.Tuple1$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.ListBuffer;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.Scala3RunTime$;
import scala.runtime.function.JProcedure1;

public class EvaluateSettings<I extends Init> {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(EvaluateSettings.class.getDeclaredField("getValue$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(EvaluateSettings.class.getDeclaredField("roots$lzy1"));
    private final I init;
    private final Executor executor;
    private final Seq<Init.Compiled<?>> compiledSettings;
    private final LinkedBlockingQueue<Option<Throwable>> complete;
    public final PMap<Init.ScopedKey, INode> sbt$internal$util$EvaluateSettings$$static;
    private final Set<Object> allScopes;
    private final Function1 transform;
    private volatile Object roots$lzy1;
    private final AtomicInteger running;
    private final AtomicBoolean cancel;
    private volatile Object getValue$lzy1;

    public EvaluateSettings(I init, Executor executor, Seq<Init.Compiled<?>> compiledSettings) {
        this.init = init;
        this.executor = executor;
        this.compiledSettings = compiledSettings;
        this.complete = new LinkedBlockingQueue();
        this.sbt$internal$util$EvaluateSettings$$static = PMap$.MODULE$.empty();
        this.allScopes = ((IterableOnceOps)compiledSettings.map((Function1 & Serializable)_$1 -> _$1.key().scope())).toSet();
        this.transform = (Function1 & Serializable)fa -> {
            Init.Initialize initialize = fa;
            if (initialize instanceof Init.GetValue && ((Init.GetValue)initialize).sbt$internal$util$Init$GetValue$$$outer() == init) {
                Init.GetValue g = (Init.GetValue)initialize;
                return this.single(this.getStatic(g.scopedKey()), g.transform());
            }
            if (initialize instanceof Init.KeyedInitialize && ((Init.KeyedInitialize)initialize).sbt$internal$util$Init$KeyedInitialize$$$outer() == init) {
                Init.KeyedInitialize k = (Init.KeyedInitialize)initialize;
                return this.single(this.getStatic(k.scopedKey()), (Function1 & Serializable)x -> Predef$.MODULE$.identity(x));
            }
            if (initialize instanceof Init.Uniform && ((Init.Uniform)initialize).sbt$internal$util$Init$Uniform$$$outer() == init) {
                Init.Uniform u = (Init.Uniform)initialize;
                return new UniformNode(this, u.inputs().map(this.transform), u.f());
            }
            if (initialize instanceof Init.Apply && ((Init.Apply)initialize).sbt$internal$util$Init$Apply$$$outer() == init) {
                Init.Apply a = (Init.Apply)initialize;
                return new MixedNode(this, TupleMapExtension$.MODULE$.transform(a.inputs(), this.transform), a.f());
            }
            if (initialize instanceof Init.Bind && ((Init.Bind)initialize).sbt$internal$util$Init$Bind$$$outer() == init) {
                Init.Bind b = (Init.Bind)initialize;
                return new BindNode(this, (INode)this.transform.apply(b.in()), (Function1 & Serializable)x -> (INode)this.transform.apply(b.f().apply(x)));
            }
            if (initialize instanceof Init.Value && ((Init.Value)initialize).sbt$internal$util$Init$Value$$$outer() == init) {
                Init.Value v = (Init.Value)initialize;
                return this.constant(v.value());
            }
            if (initialize instanceof Init.ValidationCapture && ((Init.ValidationCapture)initialize).sbt$internal$util$Init$ValidationCapture$$$outer() == init) {
                Init.ValidationCapture v = (Init.ValidationCapture)initialize;
                return this.strictConstant(v.key());
            }
            if (initialize instanceof Init.TransformCapture && ((Init.TransformCapture)initialize).sbt$internal$util$Init$TransformCapture$$$outer() == init) {
                Init.TransformCapture t = (Init.TransformCapture)initialize;
                return this.strictConstant(t.f());
            }
            if (initialize instanceof Init.Optional && ((Init.Optional)initialize).sbt$internal$util$Init$Optional$$$outer() == init) {
                Init.Optional o = (Init.Optional)initialize;
                Option option = o.a();
                if (None$.MODULE$.equals(option)) {
                    return this.constant((Function0 & Serializable)() -> o.f().apply((Object)None$.MODULE$));
                }
                if (option instanceof Some) {
                    Init.Initialize i = (Init.Initialize)((Some)option).value();
                    return this.single((INode)this.transform.apply((Object)i), (Function1 & Serializable)x -> o.f().apply((Object)Some$.MODULE$.apply(x)));
                }
                throw new MatchError(option);
            }
            if (init.StaticScopes().equals(initialize)) {
                return this.strictConstant(this.allScopes);
            }
            throw new MatchError((Object)initialize);
        };
        this.running = new AtomicInteger();
        this.cancel = new AtomicBoolean(false);
    }

    public I init() {
        return this.init;
    }

    private <A> INode<A> getStatic(Init.ScopedKey<A> key) {
        return (INode)this.sbt$internal$util$EvaluateSettings$$static.get(key).getOrElse(() -> EvaluateSettings.getStatic$$anonfun$1(key));
    }

    private Seq<INode<?>> roots() {
        Object object = this.roots$lzy1;
        if (object instanceof Seq) {
            return (Seq)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Seq)this.roots$lzyINIT1();
    }

    private Object roots$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.roots$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Seq seq = null;
                    try {
                        seq = (Seq)this.compiledSettings.flatMap((Function1 & Serializable)cs -> (Seq)cs.settings().map((Function1 & Serializable)s -> {
                            INode t = (INode)this.transform.apply(s.init());
                            this.sbt$internal$util$EvaluateSettings$$static.update(s.key(), t);
                            return t;
                        }));
                        object2 = seq == null ? LazyVals.NullValue$.MODULE$ : seq;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.roots$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return seq;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Init.Settings run(Function1<Object, Seq<Object>> delegates) {
        if (this.running.get() != 0) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)"Already running");
        }
        this.startWork();
        this.roots().foreach((Function1)(JProcedure1 & Serializable)_$2 -> _$2.registerIfNew());
        this.workComplete();
        this.complete.take().foreach((Function1 & Serializable)ex -> {
            this.cancel.set(true);
            throw ex;
        });
        return this.getResults(delegates);
    }

    private Init.Settings getResults(Function1<Object, Seq<Object>> x$12) {
        return (Init.Settings)this.sbt$internal$util$EvaluateSettings$$static.toTypedSeq().foldLeft((Object)this.init().empty(x$12), (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 != null) {
                RMap.TPair tPair = (RMap.TPair)tuple2._2();
                Init.Settings ss = (Init.Settings)tuple2._1();
                if (tPair instanceof RMap.TPair && tPair.sbt$internal$util$RMap$TPair$$$outer() == this.sbt$internal$util$EvaluateSettings$$static) {
                    RMap.TPair tPair2 = this.sbt$internal$util$EvaluateSettings$$static.TPair().unapply(tPair);
                    Init.ScopedKey scopedKey = (Init.ScopedKey)tPair2._1();
                    INode iNode = (INode)tPair2._2();
                    Init.ScopedKey key = scopedKey;
                    INode node = iNode;
                    if (key.key().isLocal()) {
                        return ss;
                    }
                    return ss.set(key, node.get());
                }
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public Function1 sbt$internal$util$EvaluateSettings$$getValue() {
        Object object = this.getValue$lzy1;
        if (object instanceof Function1) {
            return (Function1)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Function1)this.getValue$lzyINIT1();
    }

    private Object getValue$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.getValue$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Function1 & Serializable intersect = null;
                    Function1 & Serializable intersect2 = null;
                    try {
                        intersect2 = (Function1 & Serializable)fa -> fa.get();
                        intersect = intersect2 == null ? LazyVals.NullValue$.MODULE$ : intersect2;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, (Object)intersect)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.getValue$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, (Object)intersect);
                            waiting.countDown();
                        }
                    }
                    return intersect2;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public void sbt$internal$util$EvaluateSettings$$submitEvaluate(INode<?> node) {
        this.submit((Function0<BoxedUnit>)(Function0 & Serializable)() -> {
            EvaluateSettings.submitEvaluate$$anonfun$1(node);
            return BoxedUnit.UNIT;
        });
    }

    public <A> void sbt$internal$util$EvaluateSettings$$submitCallComplete(BindNode<?, A> node, A value) {
        this.submit((Function0<BoxedUnit>)(Function0 & Serializable)() -> {
            EvaluateSettings.submitCallComplete$$anonfun$1(node, value);
            return BoxedUnit.UNIT;
        });
    }

    private void submit(Function0<BoxedUnit> work) {
        this.startWork();
        this.executor.execute(() -> {
            if (!this.cancel.get()) {
                this.run0(work);
                return;
            }
        });
    }

    private void run0(Function0<BoxedUnit> work) {
        try {
            work.apply$mcV$sp();
        }
        catch (Throwable e) {
            this.complete.put((Option<Throwable>)Some$.MODULE$.apply((Object)e));
        }
        this.workComplete();
    }

    private void startWork() {
        this.running.incrementAndGet();
    }

    private void workComplete() {
        if (this.running.decrementAndGet() == 0) {
            this.complete.put((Option<Throwable>)None$.MODULE$);
            return;
        }
    }

    private <A1> INode<A1> strictConstant(A1 v) {
        return this.constant((Function0 & Serializable)() -> v);
    }

    private <A1> INode<A1> constant(Function0<A1> f) {
        return new MixedNode(this, (Product)Tuple$package$EmptyTuple$.MODULE$, (Function1 & Serializable)_$5 -> f.apply());
    }

    private <A1, A2> INode<A2> single(INode<A1> in, Function1<A1, A2> f) {
        return new MixedNode(this, (Product)Tuple1$.MODULE$.apply(in), (Function1 & Serializable)x$1 -> {
            Tuple1 tuple1 = x$1;
            if (tuple1 != null) {
                Object a = tuple1._1();
                return f.apply(a);
            }
            throw new MatchError((Object)tuple1);
        });
    }

    private static final INode getStatic$$anonfun$1(Init.ScopedKey key$1) {
        throw scala.sys.package$.MODULE$.error(new StringBuilder(25).append("Illegal reference to key ").append(key$1).toString());
    }

    private static final void submitEvaluate$$anonfun$1(INode node$1) {
        node$1.evaluate();
    }

    private static final void submitCallComplete$$anonfun$1(BindNode node$2, Object value$1) {
        node$2.callComplete(value$1);
    }

    public static final String sbt$internal$util$EvaluateSettings$INode$$_$keyString$$anonfun$2() {
        return "non-static";
    }

    public static final /* synthetic */ void sbt$internal$util$EvaluateSettings$INode$$_$setValue$$anonfun$1(INode _$4) {
        _$4.unblocked();
    }

    public static final /* synthetic */ Object sbt$internal$util$EvaluateSettings$UniformNode$$_$evaluate0$$anonfun$1(INode _$6) {
        return _$6.get();
    }

    public final class BindNode<A1, A2>
    extends INode<A2> {
        private final INode<A1> in;
        private final Function1<A1, INode<A2>> f;
        private final /* synthetic */ EvaluateSettings $outer;

        public BindNode(EvaluateSettings $outer, INode<A1> in, Function1<A1, INode<A2>> f) {
            this.in = in;
            this.f = f;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        @Override
        public Seq<INode<?>> dependsOn() {
            return package$.MODULE$.Nil().$colon$colon(this.in);
        }

        @Override
        public void evaluate0() {
            this.makeCall(this, (INode)this.f.apply(this.in.get()));
        }

        public void callComplete(A2 value) {
            BindNode bindNode = this;
            synchronized (bindNode) {
                block4: {
                    if (this.isCalling()) break block4;
                    throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(34).append("Invalid state for callComplete(").append(value).append("): ").append(this.toString()).toString());
                }
                this.setValue(value);
            }
        }

        public final /* synthetic */ EvaluateSettings sbt$internal$util$EvaluateSettings$BindNode$$$outer() {
            return this.$outer;
        }
    }

    public abstract class INode<A1> {
        private EvaluationState state;
        private A1 value;
        private final ListBuffer<INode<?>> blocking;
        private int blockedOn;
        private final ListBuffer<BindNode<?, A1>> calledBy;

        public INode() {
            if (EvaluateSettings.this == null) {
                throw new NullPointerException();
            }
            this.state = EvaluationState$.New;
            this.blocking = new ListBuffer();
            this.blockedOn = 0;
            this.calledBy = new ListBuffer();
        }

        public String toString() {
            return new StringBuilder(42).append(this.getClass().getName()).append(" (state=").append(this.state).append(",blockedOn=").append(this.blockedOn).append(",calledBy=").append(this.calledBy.size()).append(",blocking=").append(this.blocking.size()).append("): ").append(this.keyString()).toString();
        }

        private String keyString() {
            return (String)((IterableOps)EvaluateSettings.this.sbt$internal$util$EvaluateSettings$$static.toSeq().flatMap((Function1 & Serializable)x$1 -> {
                Init.ScopedKey scopedKey = (Init.ScopedKey)x$1._1();
                INode iNode = (INode)x$1._2();
                if (iNode == this) {
                    String string = EvaluateSettings.this.init().showFullKey().show(scopedKey);
                    return package$.MODULE$.Nil().$colon$colon((Object)string);
                }
                return package$.MODULE$.Nil();
            })).headOption().getOrElse(EvaluateSettings::sbt$internal$util$EvaluateSettings$INode$$_$keyString$$anonfun$2);
        }

        public final A1 get() {
            A1 A1;
            INode iNode = this;
            synchronized (iNode) {
                block4: {
                    if (this.value != null) break block4;
                    throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(14).append(this.toString()).append(" not evaluated").toString());
                }
                A1 = this.value;
            }
            return A1;
        }

        public final boolean doneOrBlock(INode<?> from) {
            boolean bl;
            INode iNode = this;
            synchronized (iNode) {
                boolean ready;
                EvaluationState evaluationState = this.state;
                EvaluationState evaluationState2 = EvaluationState$.Evaluated;
                boolean bl2 = !(evaluationState != null ? !evaluationState.equals(evaluationState2) : evaluationState2 != null) ? true : (ready = false);
                if (!ready) {
                    this.blocking.$plus$eq(from);
                }
                this.registerIfNew();
                bl = ready;
            }
            return bl;
        }

        public final boolean isDone() {
            boolean bl;
            INode iNode = this;
            synchronized (iNode) {
                EvaluationState evaluationState = this.state;
                EvaluationState evaluationState2 = EvaluationState$.Evaluated;
                bl = !(evaluationState != null ? !evaluationState.equals(evaluationState2) : evaluationState2 != null);
            }
            return bl;
        }

        public final boolean isNew() {
            boolean bl;
            INode iNode = this;
            synchronized (iNode) {
                EvaluationState evaluationState = this.state;
                EvaluationState evaluationState2 = EvaluationState$.New;
                bl = !(evaluationState != null ? !evaluationState.equals(evaluationState2) : evaluationState2 != null);
            }
            return bl;
        }

        public final boolean isCalling() {
            boolean bl;
            INode iNode = this;
            synchronized (iNode) {
                EvaluationState evaluationState = this.state;
                EvaluationState evaluationState2 = EvaluationState$.Calling;
                bl = !(evaluationState != null ? !evaluationState.equals(evaluationState2) : evaluationState2 != null);
            }
            return bl;
        }

        public final void registerIfNew() {
            INode iNode = this;
            synchronized (iNode) {
                BoxedUnit boxedUnit;
                EvaluationState evaluationState = this.state;
                EvaluationState evaluationState2 = EvaluationState$.New;
                if (!(evaluationState != null ? !evaluationState.equals(evaluationState2) : evaluationState2 != null)) {
                    this.register();
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
        }

        private void register() {
            EvaluationState evaluationState = this.state;
            EvaluationState evaluationState2 = EvaluationState$.New;
            if (evaluationState == null ? evaluationState2 != null : !evaluationState.equals(evaluationState2)) {
                throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(24).append("Already registered and: ").append(this.toString()).toString());
            }
            Seq<INode<?>> deps = this.dependsOn();
            this.blockedOn = deps.size() - deps.count((Function1 & Serializable)_$3 -> _$3.doneOrBlock(this));
            if (this.blockedOn == 0) {
                this.schedule();
                return;
            }
            this.state = EvaluationState$.Blocked;
        }

        public final void schedule() {
            INode iNode = this;
            synchronized (iNode) {
                block4: {
                    EvaluationState evaluationState = this.state;
                    EvaluationState evaluationState2 = EvaluationState$.New;
                    if (!(evaluationState == null ? evaluationState2 != null : !evaluationState.equals(evaluationState2))) break block4;
                    EvaluationState evaluationState3 = this.state;
                    EvaluationState evaluationState4 = EvaluationState$.Blocked;
                    if (!(evaluationState3 == null ? evaluationState4 != null : !evaluationState3.equals(evaluationState4))) break block4;
                    throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(35).append("Invalid state for schedule() call: ").append(this.toString()).toString());
                }
                this.state = EvaluationState$.Ready;
                EvaluateSettings.this.sbt$internal$util$EvaluateSettings$$submitEvaluate(this);
            }
        }

        public final void unblocked() {
            INode iNode = this;
            synchronized (iNode) {
                BoxedUnit boxedUnit;
                block8: {
                    block7: {
                        EvaluationState evaluationState = this.state;
                        EvaluationState evaluationState2 = EvaluationState$.Blocked;
                        if (!(evaluationState == null ? evaluationState2 != null : !evaluationState.equals(evaluationState2))) break block7;
                        throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(36).append("Invalid state for unblocked() call: ").append(this.toString()).toString());
                    }
                    --this.blockedOn;
                    if (this.blockedOn >= 0) break block8;
                    throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(25).append("Negative blockedOn: ").append(this.blockedOn).append(" for ").append(this.toString()).toString());
                }
                if (this.blockedOn == 0) {
                    this.schedule();
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
        }

        public final void evaluate() {
            INode iNode = this;
            synchronized (iNode) {
                this.evaluate0();
            }
        }

        public final void makeCall(BindNode<?, A1> source, INode<A1> target) {
            EvaluationState evaluationState = this.state;
            EvaluationState evaluationState2 = EvaluationState$.Ready;
            if (evaluationState == null ? evaluationState2 != null : !evaluationState.equals(evaluationState2)) {
                throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(36).append("Invalid state for call to makeCall: ").append(this.toString()).toString());
            }
            this.state = EvaluationState$.Calling;
            target.call(source);
        }

        public final void setValue(A1 v) {
            EvaluationState evaluationState = this.state;
            EvaluationState evaluationState2 = EvaluationState$.Evaluated;
            if (!(evaluationState != null ? !evaluationState.equals(evaluationState2) : evaluationState2 != null)) {
                throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(45).append("Already evaluated (trying to set value to ").append(v).append("): ").append(this.toString()).toString());
            }
            if (v == null) {
                throw scala.sys.package$.MODULE$.error(new StringBuilder(30).append("Setting value cannot be null: ").append(this.keyString()).toString());
            }
            this.value = v;
            this.state = EvaluationState$.Evaluated;
            this.blocking.foreach((Function1)((JProcedure1 & Serializable)EvaluateSettings::sbt$internal$util$EvaluateSettings$INode$$_$setValue$$anonfun$1));
            this.blocking.clear();
            this.calledBy.foreach((Function1)(JProcedure1 & Serializable)node -> EvaluateSettings.this.sbt$internal$util$EvaluateSettings$$submitCallComplete(node, this.value));
            this.calledBy.clear();
        }

        public final void call(BindNode<?, A1> by) {
            INode iNode = this;
            synchronized (iNode) {
                this.registerIfNew();
                EvaluationState evaluationState = this.state;
                EvaluationState evaluationState2 = EvaluationState$.Evaluated;
                EvaluationState evaluationState3 = evaluationState;
                if (!(evaluationState2 != null ? !evaluationState2.equals(evaluationState3) : evaluationState3 != null)) {
                    EvaluateSettings.this.sbt$internal$util$EvaluateSettings$$submitCallComplete(by, this.value);
                } else {
                    this.calledBy.$plus$eq(by);
                }
            }
        }

        public abstract Seq<INode<?>> dependsOn();

        public abstract void evaluate0();

        public final /* synthetic */ EvaluateSettings sbt$internal$util$EvaluateSettings$INode$$$outer() {
            return EvaluateSettings.this;
        }
    }

    public final class MixedNode<Tup extends Product, A1>
    extends INode<A1> {
        private final Product in;
        private final Function1<Tup, A1> f;
        private final /* synthetic */ EvaluateSettings $outer;

        public MixedNode(EvaluateSettings $outer, Product in, Function1<Tup, A1> f) {
            this.in = in;
            this.f = f;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        @Override
        public Seq<INode<?>> dependsOn() {
            return TupleMapExtension$.MODULE$.toList0(this.in);
        }

        @Override
        public void evaluate0() {
            this.setValue(this.f.apply(TupleMapExtension$.MODULE$.unmap(this.in, this.$outer.sbt$internal$util$EvaluateSettings$$getValue())));
        }

        public final /* synthetic */ EvaluateSettings sbt$internal$util$EvaluateSettings$MixedNode$$$outer() {
            return this.$outer;
        }
    }

    public final class UniformNode<A1, A2>
    extends INode<A2> {
        private final List<INode<A1>> in;
        private final Function1<List<A1>, A2> f;
        private final /* synthetic */ EvaluateSettings $outer;

        public UniformNode(EvaluateSettings $outer, List<INode<A1>> in, Function1<List<A1>, A2> f) {
            this.in = in;
            this.f = f;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        @Override
        public Seq<INode<?>> dependsOn() {
            return this.in;
        }

        @Override
        public void evaluate0() {
            this.setValue(this.f.apply((Object)this.in.map(EvaluateSettings::sbt$internal$util$EvaluateSettings$UniformNode$$_$evaluate0$$anonfun$1)));
        }

        public final /* synthetic */ EvaluateSettings sbt$internal$util$EvaluateSettings$UniformNode$$$outer() {
            return this.$outer;
        }
    }
}

