/*
 * Decompiled with CFR 0.152.
 */
package scala.scalanative.build;

import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichChar$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.scalanative.build.Build$;
import scala.scalanative.build.BuildException;
import scala.scalanative.build.BuildTarget;
import scala.scalanative.build.BuildTarget$Application$;
import scala.scalanative.build.BuildTarget$LibraryDynamic$;
import scala.scalanative.build.BuildTarget$LibraryStatic$;
import scala.scalanative.build.Config;
import scala.scalanative.build.Discover$;
import scala.scalanative.build.Discover$features$;
import scala.scalanative.build.IO$;
import scala.scalanative.build.IO$RichPath$;
import scala.scalanative.build.LTO;
import scala.scalanative.build.LTO$None$;
import scala.scalanative.build.Logger$;
import scala.scalanative.build.Mode;
import scala.scalanative.build.Mode$Debug$;
import scala.scalanative.build.Mode$ReleaseFast$;
import scala.scalanative.build.Mode$ReleaseFull$;
import scala.scalanative.build.Mode$ReleaseSize$;
import scala.scalanative.build.NativeConfig;
import scala.scalanative.build.Sanitizer;
import scala.scalanative.linker.ReachabilityAnalysis;
import scala.sys.process.Process$;
import scala.sys.process.ProcessBuilder;
import scala.util.Failure;
import scala.util.Failure$;
import scala.util.Success;
import scala.util.Success$;
import scala.util.Try;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class LLVM$
implements Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffset(LLVM$.class, "0bitmap$1");
    public long 0bitmap$1;
    private static final String oExt;
    private static final String cppExt;
    private static final String llExt;
    private static final scala.collection.immutable.Seq srcExtensions;
    public static scala.collection.immutable.Seq msysExtras$lzy1;
    public static final LLVM$ MODULE$;

    private LLVM$() {
    }

    static {
        MODULE$ = new LLVM$();
        oExt = ".o";
        cppExt = ".cpp";
        llExt = ".ll";
        srcExtensions = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{".c", MODULE$.cppExt(), ".S"}));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(LLVM$.class);
    }

    public String oExt() {
        return oExt;
    }

    public String cppExt() {
        return cppExt;
    }

    public String llExt() {
        return llExt;
    }

    public scala.collection.immutable.Seq<String> srcExtensions() {
        return srcExtensions;
    }

    public Future<Path> compile(Config config, Path path, ExecutionContext ec) {
        Config _config = config;
        String inpath = IO$RichPath$.MODULE$.abs$extension(IO$.MODULE$.RichPath(path));
        String outpath = new StringBuilder(0).append(inpath).append(this.oExt()).toString();
        Path objPath = Paths.get(outpath, new String[0]);
        return this.needsCompiling(path, objPath, _config) ? this.compileFile(path, objPath, _config, ec) : Future$.MODULE$.successful((Object)objPath);
    }

    private Future<Path> compileFile(Path srcPath, Path objPath, Config config, ExecutionContext ec) {
        return Future$.MODULE$.apply(() -> this.compileFile$$anonfun$1(srcPath, objPath, config), ec);
    }

    public Path link(Config config, ReachabilityAnalysis.Result analysis, scala.collection.immutable.Seq<Path> objectsPaths) {
        ProcessBuilder processBuilder;
        Config _config = config;
        Path buildPath = config.buildPath();
        if (!this.needsLinking(objectsPaths, buildPath)) {
            return this.copyOutput(config, buildPath);
        }
        BuildTarget buildTarget = config.compilerConfig().buildTarget();
        if (BuildTarget$Application$.MODULE$.equals(buildTarget) || BuildTarget$LibraryDynamic$.MODULE$.equals(buildTarget)) {
            processBuilder = this.prepareLinkCommand(objectsPaths, analysis, _config);
        } else if (BuildTarget$LibraryStatic$.MODULE$.equals(buildTarget)) {
            processBuilder = this.prepareArchiveCommand(objectsPaths, _config);
        } else {
            throw new MatchError((Object)buildTarget);
        }
        ProcessBuilder command = processBuilder;
        int result = command.$bang(Logger$.MODULE$.toProcessLogger(config.logger()));
        if (result != 0) {
            throw new BuildException(new StringBuilder(15).append("Failed to link ").append(buildPath).toString());
        }
        return this.copyOutput(config, buildPath);
    }

    public void dsymutil(Config config, Path path) {
        Try try_ = Discover$.MODULE$.tryDiscover("dsymutil", "LLVM_BIN").flatMap((Function1 & Serializable)dsymutil -> {
            ProcessBuilder proc = Process$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{IO$RichPath$.MODULE$.abs$extension(IO$.MODULE$.RichPath((Path)dsymutil)), IO$RichPath$.MODULE$.abs$extension(IO$.MODULE$.RichPath(path))})), config.workDir().toFile(), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
            int result = proc.$bang(Logger$.MODULE$.toProcessLogger(config.logger()));
            return result != 0 ? Failure$.MODULE$.apply((Throwable)new BuildException("Failed to link the debug information.")) : Success$.MODULE$.apply((Object)BoxedUnit.UNIT);
        });
        if (try_ instanceof Failure) {
            Throwable e = ((Failure)try_).exception();
            config.logger().warn(e.getMessage());
        } else if (!(try_ instanceof Success)) {
            throw new MatchError((Object)try_);
        }
    }

    private Path copyOutput(Config config, Path buildPath) {
        Path path;
        Path outPath = config.artifactPath();
        BuildTarget buildTarget = config.compilerConfig().buildTarget();
        if (BuildTarget$Application$.MODULE$.equals(buildTarget)) {
            path = Files.copy(buildPath, outPath, StandardCopyOption.REPLACE_EXISTING);
        } else if (buildTarget instanceof BuildTarget.Library) {
            path = outPath;
        } else {
            throw new MatchError((Object)buildTarget);
        }
        return path;
    }

    private ProcessBuilder prepareLinkCommand(scala.collection.immutable.Seq<Path> objectsPaths, ReachabilityAnalysis.Result analysis, Config config) {
        BoxedUnit boxedUnit;
        LTO lTO;
        Nil$ ltoSupport;
        Nil$ debugFlags;
        Path workDir = config.workDir();
        scala.collection.immutable.Seq srclinks = (scala.collection.immutable.Seq)analysis.links().map((Function1 & Serializable)_$2 -> _$2.name());
        scala.collection.immutable.Seq<String> gclinks = config.gc().links();
        scala.collection.immutable.Seq platformsLinks = config.targetsWindows() ? (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"dbghelp"})) : (config.targetsOpenBSD() || config.targetsNetBSD() ? (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"pthread"})) : (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"pthread", "dl"})));
        scala.collection.immutable.Seq links = (scala.collection.immutable.Seq)((SeqOps)((IterableOps)platformsLinks.$plus$plus((IterableOnce)srclinks)).$plus$plus(gclinks)).distinct();
        config.logger().info(new StringBuilder(15).append("Linking with [").append(links.mkString(", ")).append("]").toString());
        scala.collection.immutable.Seq linkopts = (scala.collection.immutable.Seq)config.linkingOptions().$plus$plus((IterableOnce)links.map((Function1 & Serializable)_$3 -> new StringBuilder(2).append("-l").append((String)_$3).toString()));
        Object object = debugFlags = config.compilerConfig().sourceLevelDebuggingConfig().enabled() || config.targetsWindows() ? (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"-g"})) : package$.MODULE$.Nil();
        Nil$ platformFlags = !config.targetsWindows() ? package$.MODULE$.Nil() : (ltoSupport = LTO$None$.MODULE$.equals(lTO = config.compilerConfig().lto()) ? package$.MODULE$.Nil() : (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"-fuse-ld=lld", "-Wl,/force:multiple"})));
        BuildTarget buildTarget = config.compilerConfig().buildTarget();
        BuildTarget$LibraryDynamic$ buildTarget$LibraryDynamic$ = BuildTarget$LibraryDynamic$.MODULE$;
        Nil$ linkNameFlags = !(buildTarget != null ? !buildTarget.equals(buildTarget$LibraryDynamic$) : buildTarget$LibraryDynamic$ != null) ? (config.targetsLinux() ? (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(12).append("-Wl,-soname,").append(config.artifactName()).toString()})) : (config.targetsMac() ? (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(18).append("-Wl,-install_name,").append(config.artifactName()).toString()})) : package$.MODULE$.Nil())) : package$.MODULE$.Nil();
        scala.collection.immutable.Seq output = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"-o", IO$RichPath$.MODULE$.abs$extension(IO$.MODULE$.RichPath(config.buildPath()))}));
        scala.collection.immutable.Seq flags = (scala.collection.immutable.Seq)((IterableOps)((IterableOps)((IterableOps)((IterableOps)((IterableOps)((IterableOps)this.buildTargetLinkOpts(config).$plus$plus(this.flto(config))).$plus$plus((IterableOnce)debugFlags)).$plus$plus((IterableOnce)platformFlags)).$plus$plus((IterableOnce)linkNameFlags)).$plus$plus((IterableOnce)output)).$plus$plus(this.sanitizer(config))).$plus$plus(this.target(config));
        scala.collection.immutable.Seq paths = (scala.collection.immutable.Seq)objectsPaths.map((Function1 & Serializable)_$4 -> IO$RichPath$.MODULE$.abs$extension(IO$.MODULE$.RichPath((Path)_$4)));
        scala.collection.immutable.Seq llvmLinkInfo = (scala.collection.immutable.Seq)((IterableOps)flags.$plus$plus((IterableOnce)paths)).$plus$plus((IterableOnce)linkopts);
        File configFile = workDir.resolve("llvmLinkInfo").toFile();
        try (PrintWriter pw = new PrintWriter(configFile);){
            llvmLinkInfo.foreach((Function1)(JProcedure1 & Serializable)str -> pw.println(this.escapeWhitespaces(str.replace("\\", "/"))));
            boxedUnit = BoxedUnit.UNIT;
        }
        Predef$.MODULE$.locally((Object)boxedUnit);
        scala.collection.immutable.Seq command = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{IO$RichPath$.MODULE$.abs$extension(IO$.MODULE$.RichPath(config.clangPP())), new StringBuilder(1).append("@").append(configFile.getAbsolutePath()).toString()}));
        config.logger().running((scala.collection.immutable.Seq<String>)command);
        return Process$.MODULE$.apply((Seq)command, config.workDir().toFile(), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
    }

    private ProcessBuilder prepareArchiveCommand(scala.collection.immutable.Seq<Path> objectPaths, Config config) {
        ProcessBuilder processBuilder;
        Path workDir = config.workDir();
        Option MRICompatibleAR = Discover$.MODULE$.tryDiscover("llvm-ar", "LLVM_BIN").toOption().orElse(() -> this.$anonfun$5(config));
        Option option = MRICompatibleAR;
        if (None$.MODULE$.equals(option)) {
            Path ar = Discover$.MODULE$.discover("ar");
            scala.collection.immutable.Seq command = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{IO$RichPath$.MODULE$.abs$extension(IO$.MODULE$.RichPath(ar)), "rc", IO$RichPath$.MODULE$.abs$extension(IO$.MODULE$.RichPath(config.buildPath()))})).$plus$plus((IterableOnce)this.stageFiles$1(objectPaths, workDir));
            config.logger().running((scala.collection.immutable.Seq<String>)command);
            processBuilder = Process$.MODULE$.apply((Seq)command, config.workDir().toFile(), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        } else if (option instanceof Some) {
            Path path = (Path)((Some)option).value();
            processBuilder = this.useMRIScript$1(objectPaths, config, workDir, path);
        } else {
            throw new MatchError((Object)option);
        }
        return processBuilder;
    }

    private boolean needsCompiling(Path in, Path out, Config config) {
        return in.toFile().lastModified() > out.toFile().lastModified() || Build$.MODULE$.userConfigHasChanged(config);
    }

    private boolean needsLinking(scala.collection.immutable.Seq<Path> in, Path out) {
        long outmax;
        long inmax = BoxesRunTime.unboxToLong((Object)((IterableOnceOps)in.map((Function1 & Serializable)_$6 -> _$6.toFile().lastModified())).max((Ordering)Ordering.Long$.MODULE$));
        return inmax > (outmax = out.toFile().lastModified());
    }

    private scala.collection.immutable.Seq<String> flto(Config config) {
        scala.collection.immutable.Seq seq;
        LTO lTO = config.compilerConfig().lto();
        if (LTO$None$.MODULE$.equals(lTO)) {
            seq = (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
        } else {
            LTO lto = lTO;
            seq = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(6).append("-flto=").append(lto.name()).toString()}));
        }
        return seq;
    }

    private scala.collection.immutable.Seq<String> sanitizer(Config config) {
        scala.collection.immutable.Seq seq;
        Option<Sanitizer> option = config.compilerConfig().sanitizer();
        if (option instanceof Some) {
            Sanitizer sanitizer = (Sanitizer)((Some)option).value();
            seq = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(11).append("-fsanitize=").append(sanitizer.name()).toString(), "-fno-omit-frame-pointer"}));
        } else {
            seq = (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
        }
        return seq;
    }

    private scala.collection.immutable.Seq<String> target(Config config) {
        scala.collection.immutable.Seq seq;
        Option<String> option = config.compilerConfig().targetTriple();
        if (option instanceof Some) {
            String tt = (String)((Some)option).value();
            seq = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"-target", tt}));
        } else if (None$.MODULE$.equals(option)) {
            seq = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"-Wno-override-module"}));
        } else {
            throw new MatchError(option);
        }
        return seq;
    }

    private String opt(Config config) {
        String string;
        Mode mode = config.mode();
        if (Mode$Debug$.MODULE$.equals(mode)) {
            string = "-O0";
        } else if (Mode$ReleaseFast$.MODULE$.equals(mode)) {
            string = "-O2";
        } else if (Mode$ReleaseSize$.MODULE$.equals(mode)) {
            string = "-Oz";
        } else if (Mode$ReleaseFull$.MODULE$.equals(mode)) {
            string = "-O3";
        } else {
            throw new MatchError((Object)mode);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private scala.collection.immutable.Seq<String> llvmIrFeatures(Config config) {
        void var2_2;
        List opaquePointers = Discover$features$.MODULE$.opaquePointers(this.nativeConfig$1(config)).requiredFlag().toList().flatMap((Function1 & Serializable)_$7 -> package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"-mllvm", _$7})));
        return var2_2;
    }

    private scala.collection.immutable.Seq<String> buildTargetCompileOpts(Config config) {
        Nil$ nil$;
        BuildTarget buildTarget = config.compilerConfig().buildTarget();
        if (BuildTarget$Application$.MODULE$.equals(buildTarget)) {
            nil$ = package$.MODULE$.Nil();
        } else if (BuildTarget$LibraryStatic$.MODULE$.equals(buildTarget)) {
            nil$ = (scala.collection.immutable.Seq)this.optionalPICflag(config).$plus$plus((IterableOnce)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--emit-static-lib"})));
        } else if (BuildTarget$LibraryDynamic$.MODULE$.equals(buildTarget)) {
            nil$ = (scala.collection.immutable.Seq)this.optionalPICflag(config).$colon$plus((Object)"-DSCALANATIVE_DYLIB");
        } else {
            throw new MatchError((Object)buildTarget);
        }
        return nil$;
    }

    private scala.collection.immutable.Seq<String> buildTargetLinkOpts(Config config) {
        Nil$ nil$;
        Nil$ optRdynamic = config.targetsWindows() ? package$.MODULE$.Nil() : (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"-rdynamic"}));
        BuildTarget buildTarget = config.compilerConfig().buildTarget();
        if (BuildTarget$Application$.MODULE$.equals(buildTarget)) {
            nil$ = optRdynamic;
        } else if (BuildTarget$LibraryStatic$.MODULE$.equals(buildTarget)) {
            nil$ = (scala.collection.immutable.Seq)this.optionalPICflag(config).$plus$plus((IterableOnce)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--emit-static-lib"})));
        } else if (BuildTarget$LibraryDynamic$.MODULE$.equals(buildTarget)) {
            String libFlag = config.targetsMac() ? "-dynamiclib" : "-shared";
            nil$ = (scala.collection.immutable.Seq)((IterableOps)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{libFlag})).$plus$plus(this.optionalPICflag(config))).$plus$plus((IterableOnce)optRdynamic);
        } else {
            throw new MatchError((Object)buildTarget);
        }
        return nil$;
    }

    private scala.collection.immutable.Seq<String> optionalPICflag(Config config) {
        return config.targetsWindows() ? package$.MODULE$.Nil() : (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"-fPIC"}));
    }

    private String escapeWhitespaces(String str) {
        return StringOps$.MODULE$.exists$extension(Predef$.MODULE$.augmentString(str), (Function1 & Serializable)_$8 -> this.escapeWhitespaces$$anonfun$1(BoxesRunTime.unboxToChar((Object)_$8))) ? new StringBuilder(2).append("\"").append(str).append("\"").toString() : str;
    }

    public scala.collection.immutable.Seq<String> msysExtras() {
        long l;
        long l2;
        while ((l2 = LazyVals$.MODULE$.STATE(l = LazyVals$.MODULE$.get((Object)this, OFFSET$_m_0), 0)) != 3L) {
            if (l2 == 0L) {
                if (!LazyVals$.MODULE$.CAS((Object)this, OFFSET$_m_0, l, 1, 0)) continue;
                try {
                    scala.collection.immutable.Seq seq;
                    msysExtras$lzy1 = seq = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"-D_WIN64", "-D__MINGW64__", "-D_X86_64_ -D__X86_64__ -D__x86_64", "-D__USING_SJLJ_EXCEPTIONS__", "-DNO_OLDNAMES", "-D_LIBUNWIND_BUILD_ZERO_COST_APIS"}));
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$_m_0, 3, 0);
                    return seq;
                }
                catch (Throwable throwable) {
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$_m_0, 0, 0);
                    throw throwable;
                }
            }
            LazyVals$.MODULE$.wait4Notification((Object)this, OFFSET$_m_0, l, 0);
        }
        return msysExtras$lzy1;
    }

    private final Path compileFile$$anonfun$1(Path srcPath$1, Path objPath$1, Config config$1) {
        String compiler;
        String inpath = IO$RichPath$.MODULE$.abs$extension(IO$.MODULE$.RichPath(srcPath$1));
        String outpath = IO$RichPath$.MODULE$.abs$extension(IO$.MODULE$.RichPath(objPath$1));
        boolean isCpp = inpath.endsWith(this.cppExt());
        boolean isLl = inpath.endsWith(this.llExt());
        Path workDir = config$1.workDir();
        String string = compiler = isCpp ? IO$RichPath$.MODULE$.abs$extension(IO$.MODULE$.RichPath(config$1.clangPP())) : IO$RichPath$.MODULE$.abs$extension(IO$.MODULE$.RichPath(config$1.clang()));
        scala.collection.immutable.Seq stdflag = isLl ? this.llvmIrFeatures(config$1) : (isCpp ? (config$1.targetsWindows() ? (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"-std=c++14"})) : (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"-std=c++11"}))) : (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"-std=gnu11"})));
        Nil$ platformFlags = config$1.targetsMsys() ? this.msysExtras() : package$.MODULE$.Nil();
        Nil$ multithreadingEnabled = config$1.compilerConfig().multithreadingSupport() ? (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"-DSCALANATIVE_MULTITHREADING_ENABLED"})) : package$.MODULE$.Nil();
        Option allowTargetOverrrides = config$1.compilerConfig().targetTriple().map((Function1 & Serializable)_$1 -> "-Wno-override-module");
        scala.collection.immutable.Seq configFlags = (scala.collection.immutable.Seq)multithreadingEnabled.$plus$plus((IterableOnce)allowTargetOverrrides);
        Nil$ opt = isCpp ? (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"-fcxx-exceptions"})) : package$.MODULE$.Nil();
        List list = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"-fexceptions", "-funwind-tables"}));
        List exceptionsHandling = opt.$colon$colon$colon(list);
        Nil$ debugFlags = config$1.compilerConfig().sourceLevelDebuggingConfig().enabled() || config$1.targetsWindows() ? (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"-g"})) : package$.MODULE$.Nil();
        scala.collection.immutable.Seq flags = (scala.collection.immutable.Seq)((IterableOps)((IterableOps)((IterableOps)((IterableOps)((IterableOps)((IterableOps)((IterableOps)((IterableOps)((IterableOps)((IterableOps)this.buildTargetCompileOpts(config$1).$plus$plus(this.flto(config$1))).$plus$plus(this.sanitizer(config$1))).$plus$plus(this.target(config$1))).$plus$plus((IterableOnce)stdflag)).$plus$plus((IterableOnce)platformFlags)).$plus$plus((IterableOnce)debugFlags)).$plus$plus((IterableOnce)exceptionsHandling)).$plus$plus((IterableOnce)configFlags)).$plus$plus((IterableOnce)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"-fvisibility=hidden", this.opt(config$1)})))).$plus$plus((IterableOnce)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"-fomit-frame-pointer"})))).$plus$plus(config$1.compileOptions());
        scala.collection.immutable.Seq compilec = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{compiler, "-c", inpath, "-o", outpath})).$plus$plus((IterableOnce)flags);
        config$1.logger().running((scala.collection.immutable.Seq<String>)compilec);
        int result = Process$.MODULE$.apply((Seq)compilec, workDir.toFile(), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0])).$bang(Logger$.MODULE$.toProcessLogger(config$1.logger()));
        if (result != 0) {
            throw new BuildException(new StringBuilder(18).append("Failed to compile ").append(inpath).toString());
        }
        return objPath$1;
    }

    private final Option $anonfun$5(Config config$3) {
        return Discover$.MODULE$.tryDiscover("ar").toOption().filter((Function1 & Serializable)_$5 -> config$3.targetsLinux());
    }

    private final scala.collection.immutable.Seq stageFiles$1(scala.collection.immutable.Seq objectPaths$1, Path workDir$1) {
        return (scala.collection.immutable.Seq)objectPaths$1.map((Function1 & Serializable)path -> {
            String uniqueName = workDir$1.relativize((Path)path).toString().replace(File.separator, "_");
            Path newPath = workDir$1.resolve(uniqueName);
            Files.move(path, newPath, StandardCopyOption.REPLACE_EXISTING);
            return IO$RichPath$.MODULE$.abs$extension(IO$.MODULE$.RichPath(newPath));
        });
    }

    private final ProcessBuilder useMRIScript$1(scala.collection.immutable.Seq objectPaths$2, Config config$5, Path workDir$3, Path ar) {
        File MIRScriptFile = workDir$3.resolve("MIRScript").toFile();
        try (PrintWriter pw = new PrintWriter(MIRScriptFile);){
            pw.println(new StringBuilder(7).append("CREATE ").append(this.escapeWhitespaces(IO$RichPath$.MODULE$.abs$extension(IO$.MODULE$.RichPath(config$5.buildPath())))).toString());
            this.stageFiles$1(objectPaths$2, workDir$3).foreach((Function1)(JProcedure1 & Serializable)path -> pw.println(new StringBuilder(7).append("ADDMOD ").append(this.escapeWhitespaces((String)path)).toString()));
            pw.println("SAVE");
            pw.println("END");
        }
        scala.collection.immutable.Seq command = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{IO$RichPath$.MODULE$.abs$extension(IO$.MODULE$.RichPath(ar)), "-M"}));
        config$5.logger().running((scala.collection.immutable.Seq<String>)command);
        return Process$.MODULE$.apply((Seq)command, config$5.workDir().toFile(), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0])).$hash$less(MIRScriptFile);
    }

    private final NativeConfig nativeConfig$1(Config config$6) {
        return config$6.compilerConfig();
    }

    private final /* synthetic */ boolean escapeWhitespaces$$anonfun$1(char _$8) {
        return RichChar$.MODULE$.isWhitespace$extension(Predef$.MODULE$.charWrapper(_$8));
    }
}

