/*
 * Decompiled with CFR 0.152.
 */
package scala.scalanative.interflow;

import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.runtime.BoxesRunTime;
import scala.scalanative.interflow.BailOut$;
import scala.scalanative.interflow.MergePhi;
import scala.scalanative.interflow.MergePhi$;
import scala.scalanative.interflow.State;
import scala.scalanative.nir.Buffer;
import scala.scalanative.nir.Fresh$;
import scala.scalanative.nir.Inst;
import scala.scalanative.nir.Local;
import scala.scalanative.nir.Next;
import scala.scalanative.nir.Position;
import scala.scalanative.nir.Val;
import scala.scalanative.util.package$;

public final class MergeBlock {
    private final Inst.Label label;
    private final long name;
    private Map incoming;
    private Map outgoing;
    private Seq phis;
    private State start;
    private State end;
    private Inst.Cf cf;
    private int invalidations;

    public MergeBlock(Inst.Label label, long name) {
        this.label = label;
        this.name = name;
        this.incoming = (Map)Map$.MODULE$.empty();
        this.outgoing = (Map)Map$.MODULE$.empty();
        this.invalidations = 0;
    }

    public Inst.Label label() {
        return this.label;
    }

    public long name() {
        return this.name;
    }

    public Map<Local, Tuple2<Seq<Val>, State>> incoming() {
        return this.incoming;
    }

    public void incoming_$eq(Map<Local, Tuple2<Seq<Val>, State>> x$1) {
        this.incoming = x$1;
    }

    public Map<Local, MergeBlock> outgoing() {
        return this.outgoing;
    }

    public void outgoing_$eq(Map<Local, MergeBlock> x$1) {
        this.outgoing = x$1;
    }

    public Seq<MergePhi> phis() {
        return this.phis;
    }

    public void phis_$eq(Seq<MergePhi> x$1) {
        this.phis = x$1;
    }

    public State start() {
        return this.start;
    }

    public void start_$eq(State x$1) {
        this.start = x$1;
    }

    public State end() {
        return this.end;
    }

    public void end_$eq(State x$1) {
        this.end = x$1;
    }

    public Inst.Cf cf() {
        return this.cf;
    }

    public void cf_$eq(Inst.Cf x$1) {
        this.cf = x$1;
    }

    public int invalidations() {
        return this.invalidations;
    }

    public void invalidations_$eq(int x$1) {
        this.invalidations = x$1;
    }

    public Position cfPos() {
        return this.cf() != null ? this.cf().pos() : this.label().pos();
    }

    /*
     * Enabled aggressive block sorting
     */
    public Seq<Inst> toInsts() {
        Inst.Jump jump;
        Next next;
        MergeBlock block = this;
        Buffer result = new Buffer(Fresh$.MODULE$.apply(0L));
        Seq params = (Seq)block.phis().map((Function1 & Serializable)_$5 -> _$5.param());
        result.label(block.name(), params, this.cfPos());
        result.$plus$plus$eq(block.end().emit());
        Inst.Cf cf = block.cf();
        if (cf instanceof Inst.Ret) {
            Inst.Ret ret = (Inst.Ret)cf;
            result.$plus$eq((Inst)ret);
            return result.toSeq();
        }
        if (cf instanceof Inst.Jump && (next = (jump = Inst.Jump$.MODULE$.unapply((Inst.Jump)cf))._1()) instanceof Next.Label) {
            Next.Label next2 = (Next.Label)next;
            result.jump((Next)this.mergeNext$1(block, next2), this.cfPos());
            return result.toSeq();
        }
        if (cf instanceof Inst.If) {
            Inst.If if_ = Inst.If$.MODULE$.unapply((Inst.If)cf);
            Val val = if_._1();
            Next next3 = if_._2();
            Next next4 = if_._3();
            Val cond = val;
            if (next3 instanceof Next.Label) {
                Next.Label thenNext = (Next.Label)next3;
                if (next4 instanceof Next.Label) {
                    Next.Label elseNext = (Next.Label)next4;
                    result.branch(cond, (Next)this.mergeNext$1(block, thenNext), (Next)this.mergeNext$1(block, elseNext), this.cfPos());
                    return result.toSeq();
                }
            }
        }
        if (cf instanceof Inst.Switch) {
            Inst.Switch switch_ = Inst.Switch$.MODULE$.unapply((Inst.Switch)cf);
            Val val = switch_._1();
            Next next5 = switch_._2();
            Seq seq = switch_._3();
            Val scrut = val;
            if (next5 instanceof Next.Label) {
                Next.Label defaultNext = (Next.Label)next5;
                Seq cases = seq;
                Seq mergeCases = (Seq)cases.map((Function1 & Serializable)x$1 -> {
                    Val v;
                    Next next;
                    block3: {
                        block2: {
                            Next next2 = x$1;
                            if (!(next2 instanceof Next.Case)) break block2;
                            Next.Case case_ = Next.Case$.MODULE$.unapply((Next.Case)next2);
                            Val val = case_._1();
                            next = case_._2();
                            v = val;
                            if (next instanceof Next.Label) break block3;
                        }
                        throw package$.MODULE$.unreachable();
                    }
                    Next.Label next3 = (Next.Label)next;
                    return Next.Case$.MODULE$.apply(v, (Next)this.mergeNext$1(block, next3));
                });
                result.switch(scrut, (Next)this.mergeNext$1(block, defaultNext), mergeCases, this.cfPos());
                return result.toSeq();
            }
        }
        if (cf instanceof Inst.Throw) {
            Inst.Throw throw_ = Inst.Throw$.MODULE$.unapply((Inst.Throw)cf);
            Val val = throw_._1();
            Next next6 = throw_._2();
            Val v = val;
            Next unwind = next6;
            result.raise(v, this.mergeUnwind$1(block, unwind), this.cfPos());
            return result.toSeq();
        }
        if (cf instanceof Inst.Unreachable) {
            Next next7;
            Inst.Unreachable unreachable = Inst.Unreachable$.MODULE$.unapply((Inst.Unreachable)cf);
            Next unwind = next7 = unreachable._1();
            result.unreachable(this.mergeUnwind$1(block, unwind), this.cfPos());
            return result.toSeq();
        }
        Inst.Cf unknown = cf;
        throw BailOut$.MODULE$.apply(new StringBuilder(26).append("MergeUnwind unknown Inst: ").append(unknown.show()).toString());
    }

    private final Next.Label mergeNext$1(MergeBlock block$1, Next.Label next) {
        MergeBlock nextBlock = (MergeBlock)this.outgoing().apply((Object)new Local(next.name()));
        Seq mergeValues = (Seq)nextBlock.phis().flatMap((Function1 & Serializable)x$1 -> {
            Seq<Tuple2<Local, Val>> seq;
            MergePhi mergePhi = x$1;
            if (mergePhi == null) {
                throw new MatchError((Object)mergePhi);
            }
            MergePhi mergePhi2 = MergePhi$.MODULE$.unapply(mergePhi);
            Val.Local local = mergePhi2._1();
            Seq<Tuple2<Local, Val>> incoming = seq = mergePhi2._2();
            return (Seq)incoming.collect((PartialFunction)new Serializable(block$1){
                private final MergeBlock block$3;
                {
                    this.block$3 = block$4;
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final boolean isDefinedAt(Tuple2 x) {
                    Tuple2 tuple2 = x;
                    if (tuple2 == null) return false;
                    long name = tuple2._1() == null ? BoxesRunTime.unboxToLong(null) : ((Local)tuple2._1()).id();
                    Val value = (Val)tuple2._2();
                    if (name != this.block$3.label().name()) return false;
                    return true;
                }

                /*
                 * Enabled aggressive block sorting
                 */
                public final Object applyOrElse(Tuple2 x, Function1 function1) {
                    Object object;
                    Tuple2 tuple2 = x;
                    if (tuple2 != null) {
                        long name = tuple2._1() == null ? BoxesRunTime.unboxToLong(null) : ((Local)tuple2._1()).id();
                        Val value = (Val)tuple2._2();
                        if (name == this.block$3.label().name()) {
                            object = value;
                            return object;
                        }
                    }
                    object = function1.apply((Object)x);
                    return object;
                }
            });
        });
        return Next.Label$.MODULE$.apply(nextBlock.name(), mergeValues);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Next mergeUnwind$1(MergeBlock block$5, Next next) {
        Next next2;
        Next next3 = next;
        if (Next.None$.MODULE$.equals(next3)) {
            next2 = next;
            return next2;
        } else {
            if (!(next3 instanceof Next.Unwind)) throw package$.MODULE$.unreachable();
            Next.Unwind unwind = Next.Unwind$.MODULE$.unapply((Next.Unwind)next3);
            Val.Local local = unwind._1();
            Next next4 = unwind._2();
            Val.Local exc = local;
            if (!(next4 instanceof Next.Label)) throw package$.MODULE$.unreachable();
            Next.Label next5 = (Next.Label)next4;
            next2 = Next.Unwind$.MODULE$.apply(exc, (Next)this.mergeNext$1(block$5, next5));
        }
        return next2;
    }
}

