/*
 * Decompiled with CFR 0.152.
 */
package scala.scalanative.checker;

import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.UnrolledBuffer;
import scala.collection.mutable.UnrolledBuffer$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.function.JProcedure1;
import scala.scalanative.checker.Check;
import scala.scalanative.checker.Check$Error$;
import scala.scalanative.linker.Class;
import scala.scalanative.linker.ClassRef$;
import scala.scalanative.linker.Info;
import scala.scalanative.linker.Method;
import scala.scalanative.linker.Result;
import scala.scalanative.linker.ScopeInfo;
import scala.scalanative.linker.ScopeRef$;
import scala.scalanative.linker.Sub$;
import scala.scalanative.nir.Global;
import scala.scalanative.nir.Op;
import scala.scalanative.nir.Rt$;
import scala.scalanative.nir.Sig;
import scala.scalanative.nir.Type;
import scala.scalanative.nir.Val;

public abstract class NIRCheck {
    private final Result linked;
    private final UnrolledBuffer errors;
    private Global name;
    private List ctx;

    public NIRCheck(Result linked) {
        this.linked = linked;
        this.errors = UnrolledBuffer$.MODULE$.empty(ClassTag$.MODULE$.apply(Check.Error.class));
        this.name = Global.None$.MODULE$;
        this.ctx = package$.MODULE$.Nil();
    }

    public UnrolledBuffer<Check.Error> errors() {
        return this.errors;
    }

    public Global name() {
        return this.name;
    }

    public void name_$eq(Global x$1) {
        this.name = x$1;
    }

    public List<String> ctx() {
        return this.ctx;
    }

    public void ctx_$eq(List<String> x$1) {
        this.ctx = x$1;
    }

    public void ok() {
    }

    public void error(String msg) {
        this.errors().$plus$eq((Object)Check$Error$.MODULE$.apply(this.name(), this.ctx(), msg));
    }

    public void expect(Type expected, Val got) {
        this.expect(expected, got.ty());
    }

    public void expect(Type expected, Type got) {
        if (!Sub$.MODULE$.is(got, expected, this.linked)) {
            this.error(new StringBuilder(19).append("expected ").append(expected.show()).append(", but got ").append(got.show()).toString());
        }
    }

    public void run(Seq<Info> infos) {
        infos.foreach((Function1)(JProcedure1 & Serializable)info -> {
            this.name_$eq(info.name());
            this.checkInfo((Info)info);
        });
    }

    public void checkInfo(Info info) {
        Info info2 = info;
        if (info2 instanceof Method) {
            Method meth = (Method)info2;
            this.checkMethod(meth);
        } else {
            this.ok();
        }
    }

    public abstract void checkMethod(Method var1);

    public final void checkFieldOp(Op.Field op) {
        Option option;
        Op.Field field = op;
        if (field == null) {
            throw new MatchError((Object)field);
        }
        Op.Field field2 = Op.Field$.MODULE$.unapply(field);
        Val val = field2._1();
        Global global = field2._2();
        Val obj = val;
        Global name = global;
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)obj, (Object)name);
        Val obj2 = (Val)tuple2._1();
        Global name2 = (Global)tuple2._2();
        Type type = obj2.ty();
        if (type != null && !(option = ScopeRef$.MODULE$.unapply(type, this.linked)).isEmpty()) {
            ScopeInfo scopeInfo;
            ScopeInfo scope = scopeInfo = (ScopeInfo)option.get();
            scope.implementors().foreach((Function1)(JProcedure1 & Serializable)cls -> {
                if (cls.fields().exists((Function1 & Serializable)_$1 -> {
                    Global global = _$1.name();
                    Global global2 = name2;
                    return !(global != null ? !global.equals(global2) : global2 != null);
                })) {
                    this.ok();
                } else {
                    this.error(new StringBuilder(24).append("can't acces field '").append(name2.show()).append("' in ").append(cls.name().show()).toString());
                }
            });
        } else {
            Type ty = type;
            this.error(new StringBuilder(40).append("can't access fields of a non-class type ").append(ty.show()).toString());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void checkMethodOp(Op.Method op) {
        Sig sig;
        Op.Method method = op;
        if (method == null) throw new MatchError((Object)method);
        Op.Method method2 = Op.Method$.MODULE$.unapply(method);
        Val val = method2._1();
        Sig sig2 = method2._2();
        Val obj = val;
        Sig sig3 = sig2;
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)obj, (Object)sig3);
        Val obj2 = (Val)tuple2._1();
        Sig sig4 = (Sig)tuple2._2();
        this.expect((Type)Rt$.MODULE$.Object(), obj2);
        Sig sig5 = sig = sig4;
        if (sig5.isMethod() || sig5.isCtor() || sig5.isGenerated()) {
            this.ok();
        } else {
            this.error(new StringBuilder(41).append("method must take a method signature, not ").append(sig4.show()).toString());
        }
        Type type = obj2.ty();
        if (Type.Null$.MODULE$.equals(type)) {
            this.ok();
            return;
        }
        if (type != null) {
            Option option;
            Option option2 = ScopeRef$.MODULE$.unapply(type, this.linked);
            if (!option2.isEmpty()) {
                ScopeInfo scopeInfo;
                ScopeInfo info = scopeInfo = (ScopeInfo)option2.get();
                if (sig4.isVirtual()) {
                    info.implementors().foreach((Function1)(JProcedure1 & Serializable)cls -> this.checkCallable$1(sig4, (Class)cls));
                    return;
                }
            }
            if (!(option = ClassRef$.MODULE$.unapply(type, this.linked)).isEmpty()) {
                Class clazz;
                Class info = clazz = (Class)option.get();
                this.checkCallable$1(sig4, info);
                return;
            }
        }
        Type ty = type;
        this.error(new StringBuilder(24).append("can't resolve method on ").append(ty.show()).toString());
    }

    private final void checkCallable$1(Sig sig$1, Class cls) {
        if (cls.allocated() && cls.resolve(sig$1).isEmpty()) {
            this.error(new StringBuilder(15).append("can't call ").append(sig$1.show()).append(" on ").append(cls.name().show()).toString());
        }
    }
}

