/*
 * Decompiled with CFR 0.152.
 */
package scala.scalanative.build.core;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.deriving.Mirror;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.scalanative.build.BuildException;
import scala.scalanative.build.LLVM$;
import scala.scalanative.build.Platform$;
import scala.scalanative.build.core.IO$;
import scala.scalanative.build.core.NativeLib;

public final class NativeLib$
implements Mirror.Product,
Serializable {
    private static final String nativeCodeDir;
    private static final String jarExt;
    private static final Pattern jarPattern;
    public static final NativeLib$ MODULE$;

    private NativeLib$() {
    }

    static {
        MODULE$ = new NativeLib$();
        nativeCodeDir = "scala-native";
        jarExt = ".jar";
        String regexExtensions = LLVM$.MODULE$.srcExtensions().mkString("(\\", "|\\", ")");
        String jarSrcRegex = new StringBuilder(7).append("^").append(MODULE$.nativeCodeDir()).append("/(.+)").append(regexExtensions).append("$").toString();
        jarPattern = Pattern.compile(jarSrcRegex);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(NativeLib$.class);
    }

    public NativeLib apply(Path src, Path dest) {
        return new NativeLib(src, dest);
    }

    public NativeLib unapply(NativeLib x$1) {
        return x$1;
    }

    public String toString() {
        return "NativeLib";
    }

    public String nativeCodeDir() {
        return nativeCodeDir;
    }

    public Seq<NativeLib> findNativeLibs(Seq<Path> classpath, Path workdir) {
        String nativeCodePrefix = "native-code";
        Seq nativeLibPaths = (Seq)classpath.flatMap((Function1 & Serializable)path -> this.isJar((Path)path) ? this.readJar((Path)path) : this.readDir((Path)path));
        Seq extractPaths = (Seq)((IterableOps)nativeLibPaths.zipWithIndex()).withFilter((Function1 & Serializable)x$1 -> {
            boolean bl;
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Path path = (Path)tuple2._1();
                int index = BoxesRunTime.unboxToInt((Object)tuple2._2());
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Path path = (Path)tuple2._1();
            int index = BoxesRunTime.unboxToInt((Object)tuple2._2());
            String name = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(path.getFileName().toString()), jarExt);
            return this.apply(path, workdir.resolve(new StringBuilder(2).append(nativeCodePrefix).append("-").append(name).append("-").append(index).toString()));
        });
        if (extractPaths.isEmpty()) {
            throw new BuildException(new StringBuilder(38).append("No Scala Native libraries were found: ").append(classpath).toString());
        }
        if (Files.exists(workdir, new LinkOption[0])) {
            Set expectedPaths = ((IterableOnceOps)extractPaths.map((Function1 & Serializable)_$1 -> _$1.dest().toAbsolutePath())).toSet();
            String nativeCodePattern = new StringBuilder(7).append(nativeCodePrefix).append("-.*-\\d+").toString();
            Files.list(workdir).forEach(new Consumer<Path>(expectedPaths, nativeCodePattern){
                private final Set expectedPaths$1;
                private final String nativeCodePattern$1;
                {
                    this.expectedPaths$1 = expectedPaths$2;
                    this.nativeCodePattern$1 = nativeCodePattern$2;
                }

                public void accept(Path path) {
                    if (this.matchesPattern$1(path) && this.notIgnored$1(path)) {
                        IO$.MODULE$.deleteRecursive(path);
                    }
                }

                private final boolean matchesPattern$1(Path path$1) {
                    return path$1.getFileName().toString().matches(this.nativeCodePattern$1);
                }

                private final boolean notIgnored$1(Path path$2) {
                    return this.expectedPaths$1.contains((Object)path$2.toAbsolutePath());
                }
            });
        }
        return extractPaths;
    }

    public Seq<Path> findNativePaths(Path workdir, Path destPath) {
        String srcPatterns = this.destSrcPattern(workdir, destPath);
        return IO$.MODULE$.getAll(workdir, srcPatterns);
    }

    public Seq<Path> filterClasspath(Seq<Path> classpath) {
        return (Seq)classpath.filter((Function1 & Serializable)p -> Files.exists(p, new LinkOption[0]) && (this.isJar((Path)p) || Files.isDirectory(p, new LinkOption[0])));
    }

    public Path unpackNativeCode(NativeLib nativelib) {
        return this.isJar(nativelib) ? this.unpackNativeJar(nativelib) : this.copyNativeDir(nativelib);
    }

    /*
     * WARNING - void declaration
     */
    private Path unpackNativeJar(NativeLib nativelib) {
        void var2_2;
        Path jarhashPath;
        Path source;
        byte[] jarhash;
        Path target = nativelib.dest();
        if (!this.unpacked$1(target, jarhash = IO$.MODULE$.sha1(source = nativelib.src(), IO$.MODULE$.sha1$default$2()), jarhashPath = target.resolve("jarhash"))) {
            IO$.MODULE$.deleteRecursive(target);
            IO$.MODULE$.unzip(source, target);
            IO$.MODULE$.write(jarhashPath, jarhash);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private Path copyNativeDir(NativeLib nativelib) {
        void var2_2;
        Path fileshashPath;
        Path source;
        Seq<Path> files;
        byte[] fileshash;
        Path target = nativelib.dest();
        if (!this.copied$1(target, fileshash = IO$.MODULE$.sha1files(files = IO$.MODULE$.getAll(source = nativelib.src(), this.allFilesPattern(source)), IO$.MODULE$.sha1files$default$2()), fileshashPath = target.resolve("fileshash"))) {
            IO$.MODULE$.deleteRecursive(target);
            IO$.MODULE$.copyDirectory(source, target);
            IO$.MODULE$.write(fileshashPath, fileshash);
        }
        return var2_2;
    }

    private boolean isJar(Path path) {
        return path.toString().endsWith(jarExt);
    }

    private boolean isJar(NativeLib nativelib) {
        return this.isJar(nativelib.src());
    }

    private boolean isNativeFile(String name) {
        return jarPattern.matcher(name).matches();
    }

    private Option<Path> readDir(Path path) {
        Some some;
        boolean bl = IO$.MODULE$.existsInDir(path, this.srcPatterns(path));
        if (bl) {
            some = Some$.MODULE$.apply((Object)path);
        } else if (!bl) {
            some = None$.MODULE$;
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
        }
        return some;
    }

    private Option<Path> readJar(Path path) {
        Some some;
        boolean bl = IO$.MODULE$.existsInJar(path, (Function1<String, Object>)(Function1 & Serializable)name -> this.isNativeFile((String)name));
        if (bl) {
            some = Some$.MODULE$.apply((Object)path);
        } else if (!bl) {
            some = None$.MODULE$;
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
        }
        return some;
    }

    private String srcPatterns(Path path) {
        return LLVM$.MODULE$.srcExtensions().mkString(new StringBuilder(8).append("glob:").append(this.srcPathPattern(path)).append("**{").toString(), ",", "}");
    }

    private String srcPathPattern(Path path) {
        return this.makeDirPath(path, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.nativeCodeDir()}));
    }

    private String allFilesPattern(Path path) {
        return new StringBuilder(7).append("glob:").append(this.srcPathPattern(path)).append("**").toString();
    }

    private String destSrcPattern(Path workdir, Path destPath) {
        String dirPattern = new StringBuilder(2).append("{").append(destPath.getFileName()).append("}").toString();
        String pathPat = this.makeDirPath(workdir, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{dirPattern, this.nativeCodeDir()}));
        return LLVM$.MODULE$.srcExtensions().mkString(new StringBuilder(8).append("glob:").append(pathPat).append("**{").toString(), ",", "}");
    }

    private String makeDirPath(Path path, Seq<String> elems) {
        String pathSep = Platform$.MODULE$.isWindows() ? "\\\\" : File.separator;
        String string = path.toString().replace(File.separator, pathSep);
        return ((IterableOnceOps)elems.$plus$colon((Object)string)).mkString("", pathSep, pathSep);
    }

    public NativeLib fromProduct(Product x$0) {
        return new NativeLib((Path)x$0.productElement(0), (Path)x$0.productElement(1));
    }

    private final boolean unpacked$1(Path target$1, byte[] jarhash$1, Path jarhashPath$1) {
        return Files.exists(target$1, new LinkOption[0]) && Files.exists(jarhashPath$1, new LinkOption[0]) && Arrays.equals(jarhash$1, Files.readAllBytes(jarhashPath$1));
    }

    private final boolean copied$1(Path target$2, byte[] fileshash$1, Path fileshashPath$1) {
        return Files.exists(target$2, new LinkOption[0]) && Files.exists(fileshashPath$1, new LinkOption[0]) && Arrays.equals(fileshash$1, Files.readAllBytes(fileshashPath$1));
    }
}

