/*
 * Decompiled with CFR 0.152.
 */
package scala.scalanative.build;

import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.parallel.CollectionConverters;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichChar$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.scalanative.build.BuildException;
import scala.scalanative.build.BuildTarget;
import scala.scalanative.build.BuildTarget$Application$;
import scala.scalanative.build.BuildTarget$LibraryDynamic$;
import scala.scalanative.build.BuildTarget$LibraryStatic$;
import scala.scalanative.build.Config;
import scala.scalanative.build.Discover$;
import scala.scalanative.build.Discover$features$;
import scala.scalanative.build.LTO;
import scala.scalanative.build.LTO$None$;
import scala.scalanative.build.Logger$;
import scala.scalanative.build.Mode;
import scala.scalanative.build.Mode$Debug$;
import scala.scalanative.build.Mode$ReleaseFast$;
import scala.scalanative.build.Mode$ReleaseFull$;
import scala.scalanative.build.Mode$ReleaseSize$;
import scala.scalanative.build.NativeConfig;
import scala.scalanative.build.core.IO$;
import scala.scalanative.build.core.IO$RichPath$;
import scala.scalanative.compat.CompatParColls$;
import scala.scalanative.linker.Result;
import scala.scalanative.nir.Attr;
import scala.scalanative.nir.Versions$;
import scala.sys.process.Process$;
import scala.sys.process.ProcessBuilder;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class LLVM$
implements Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffset(LLVM$.class, "0bitmap$1");
    public long 0bitmap$1;
    private static final String oExt;
    private static final String cppExt;
    private static final String llExt;
    private static final scala.collection.immutable.Seq srcExtensions;
    public static scala.collection.immutable.Seq msysExtras$lzy1;
    public static final LLVM$ MODULE$;

    private LLVM$() {
    }

    static {
        MODULE$ = new LLVM$();
        oExt = ".o";
        cppExt = ".cpp";
        llExt = ".ll";
        srcExtensions = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{".c", MODULE$.cppExt(), ".S"}));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(LLVM$.class);
    }

    public String oExt() {
        return oExt;
    }

    public String cppExt() {
        return cppExt;
    }

    public String llExt() {
        return llExt;
    }

    public scala.collection.immutable.Seq<String> srcExtensions() {
        return srcExtensions;
    }

    public scala.collection.immutable.Seq<Path> compile(Config config, scala.collection.immutable.Seq<Path> paths) {
        Config _config = config;
        scala.collection.immutable.Seq seq = CompatParColls$.MODULE$.Converters().ImmutableSeqIsParallelizable(paths);
        return (scala.collection.immutable.Seq)CollectionConverters.ImmutableSeqIsParallelizable$.MODULE$.par$extension(seq).map((Function1 & Serializable)srcPath -> {
            String inpath = IO$RichPath$.MODULE$.abs$extension(IO$.MODULE$.RichPath((Path)srcPath));
            String outpath = new StringBuilder(0).append(inpath).append(this.oExt()).toString();
            Path objPath = Paths.get(outpath, new String[0]);
            return this.needsCompiling((Path)srcPath, objPath) ? this.compileFile((Path)srcPath, objPath, _config) : objPath;
        }).seq();
    }

    private Path compileFile(Path srcPath, Path objPath, Config config) {
        Nil$ nil$;
        scala.collection.immutable.Seq stdflag;
        String compiler;
        String inpath = IO$RichPath$.MODULE$.abs$extension(IO$.MODULE$.RichPath(srcPath));
        String outpath = IO$RichPath$.MODULE$.abs$extension(IO$.MODULE$.RichPath(objPath));
        boolean isCpp = inpath.endsWith(this.cppExt());
        boolean isLl = inpath.endsWith(this.llExt());
        Path workdir = config.workdir();
        String string = compiler = isCpp ? IO$RichPath$.MODULE$.abs$extension(IO$.MODULE$.RichPath(config.clangPP())) : IO$RichPath$.MODULE$.abs$extension(IO$.MODULE$.RichPath(config.clang()));
        scala.collection.immutable.Seq seq = isLl ? this.llvmIrFeatures(config) : (isCpp ? (config.targetsWindows() ? (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"-std=c++14"})) : (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"-std=c++11"}))) : (stdflag = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"-std=gnu11"}))));
        if (config.targetsWindows()) {
            scala.collection.immutable.Seq common = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"-g"}));
            Nil$ optional = config.targetsMsys() ? this.msysExtras() : package$.MODULE$.Nil();
            nil$ = (scala.collection.immutable.Seq)common.$plus$plus((IterableOnce)optional);
        } else {
            nil$ = package$.MODULE$.Nil();
        }
        Nil$ platformFlags = nil$;
        Nil$ opt = isCpp ? (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"-fcxx-exceptions"})) : package$.MODULE$.Nil();
        List list = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"-fexceptions", "-funwind-tables"}));
        List exceptionsHandling = opt.$colon$colon$colon(list);
        scala.collection.immutable.Seq flags = (scala.collection.immutable.Seq)((IterableOps)((IterableOps)((IterableOps)((IterableOps)((IterableOps)((IterableOps)this.buildTargetCompileOpts(config).$plus$plus(this.flto(config))).$plus$plus(this.target(config))).$plus$plus((IterableOnce)stdflag)).$plus$plus((IterableOnce)platformFlags)).$plus$plus((IterableOnce)exceptionsHandling)).$plus$plus((IterableOnce)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"-fvisibility=hidden", this.opt(config)})))).$plus$plus(config.compileOptions());
        scala.collection.immutable.Seq compilec = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{compiler, "-c", inpath, "-o", outpath})).$plus$plus((IterableOnce)flags);
        config.logger().running((scala.collection.immutable.Seq<String>)compilec);
        int result = Process$.MODULE$.apply((Seq)compilec, config.workdir().toFile(), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0])).$bang(Logger$.MODULE$.toProcessLogger(config.logger()));
        if (result != 0) {
            throw new BuildException(new StringBuilder(18).append("Failed to compile ").append(inpath).toString());
        }
        return objPath;
    }

    public Path link(Config config, Result linkerResult, scala.collection.immutable.Seq<Path> objectsPaths, Path outpath) {
        ProcessBuilder processBuilder;
        Config _config = config;
        BuildTarget buildTarget = config.compilerConfig().buildTarget();
        if (BuildTarget$Application$.MODULE$.equals(buildTarget) || BuildTarget$LibraryDynamic$.MODULE$.equals(buildTarget)) {
            processBuilder = this.prepareLinkCommand(objectsPaths, linkerResult, outpath, _config);
        } else if (BuildTarget$LibraryStatic$.MODULE$.equals(buildTarget)) {
            processBuilder = this.prepareArchiveCommand(objectsPaths, outpath, _config);
        } else {
            throw new MatchError((Object)buildTarget);
        }
        ProcessBuilder command = processBuilder;
        int result = command.$bang(Logger$.MODULE$.toProcessLogger(config.logger()));
        if (result != 0) {
            throw new BuildException(new StringBuilder(15).append("Failed to link ").append(outpath).toString());
        }
        return outpath;
    }

    private ProcessBuilder prepareLinkCommand(scala.collection.immutable.Seq<Path> objectsPaths, Result linkerResult, Path outpath, Config config) {
        BoxedUnit boxedUnit;
        Nil$ nil$;
        Path workdir = config.workdir();
        scala.collection.immutable.Seq srclinks = (scala.collection.immutable.Seq)linkerResult.links().collect((PartialFunction)new Serializable(config){
            private final Config config$1;
            {
                this.config$1 = config$4;
            }

            public final boolean isDefinedAt(Attr.Link x) {
                boolean bl;
                Attr.Link link = x;
                if (link != null) {
                    Attr.Link link2 = Attr.Link$.MODULE$.unapply(link);
                    String string = link2._1();
                    if ("z".equals(string) && this.config$1.targetsWindows()) {
                        bl = true;
                    } else {
                        String name = string;
                        bl = true;
                    }
                } else {
                    bl = false;
                }
                return bl;
            }

            public final Object applyOrElse(Attr.Link x, Function1 function1) {
                Object object;
                Attr.Link link = x;
                if (link != null) {
                    Attr.Link link2 = Attr.Link$.MODULE$.unapply(link);
                    String string = link2._1();
                    if ("z".equals(string) && this.config$1.targetsWindows()) {
                        object = "zlib";
                    } else {
                        String name = string;
                        object = name;
                    }
                } else {
                    object = function1.apply((Object)x);
                }
                return object;
            }
        });
        scala.collection.immutable.Seq<String> gclinks = config.gc().links();
        scala.collection.immutable.Seq platformsLinks = config.targetsWindows() ? (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Dbghelp"})) : (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"pthread", "dl"}));
        scala.collection.immutable.Seq links = (scala.collection.immutable.Seq)((IterableOps)platformsLinks.$plus$plus((IterableOnce)srclinks)).$plus$plus(gclinks);
        scala.collection.immutable.Seq linkopts = (scala.collection.immutable.Seq)config.linkingOptions().$plus$plus((IterableOnce)links.map((Function1 & Serializable)_$1 -> new StringBuilder(2).append("-l").append((String)_$1).toString()));
        if (!config.targetsWindows()) {
            nil$ = package$.MODULE$.Nil();
        } else {
            LTO lTO = config.compilerConfig().lto();
            Nil$ ltoSupport = LTO$None$.MODULE$.equals(lTO) ? package$.MODULE$.Nil() : (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"-fuse-ld=lld", "-Wl,/force:multiple"}));
            nil$ = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"-g"})).$plus$plus((IterableOnce)ltoSupport);
        }
        Nil$ platformFlags = nil$;
        scala.collection.immutable.Seq output = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"-o", IO$RichPath$.MODULE$.abs$extension(IO$.MODULE$.RichPath(outpath))}));
        scala.collection.immutable.Seq flags = (scala.collection.immutable.Seq)((IterableOps)((IterableOps)((IterableOps)this.buildTargetLinkOpts(config).$plus$plus(this.flto(config))).$plus$plus((IterableOnce)platformFlags)).$plus$plus((IterableOnce)output)).$plus$plus(this.target(config));
        scala.collection.immutable.Seq paths = (scala.collection.immutable.Seq)objectsPaths.map((Function1 & Serializable)_$2 -> IO$RichPath$.MODULE$.abs$extension(IO$.MODULE$.RichPath((Path)_$2)));
        scala.collection.immutable.Seq llvmLinkInfo = (scala.collection.immutable.Seq)((IterableOps)flags.$plus$plus((IterableOnce)paths)).$plus$plus((IterableOnce)linkopts);
        File configFile = workdir.resolve("llvmLinkInfo").toFile();
        try (PrintWriter pw = new PrintWriter(configFile);){
            llvmLinkInfo.foreach((Function1)(JProcedure1 & Serializable)str -> pw.println(this.escapeWhitespaces(str.replace("\\", "/"))));
            boxedUnit = BoxedUnit.UNIT;
        }
        Predef$.MODULE$.locally((Object)boxedUnit);
        scala.collection.immutable.Seq command = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{IO$RichPath$.MODULE$.abs$extension(IO$.MODULE$.RichPath(config.clangPP())), new StringBuilder(1).append("@").append(configFile.getAbsolutePath()).toString()}));
        config.logger().running((scala.collection.immutable.Seq<String>)command);
        return Process$.MODULE$.apply((Seq)command, config.workdir().toFile(), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
    }

    private ProcessBuilder prepareArchiveCommand(scala.collection.immutable.Seq<Path> objectPaths, Path outpath, Config config) {
        Path workdir = config.workdir();
        Path llvmAR = Discover$.MODULE$.discover("llvm-ar", "LLVM_BIN");
        File MIRScriptFile = workdir.resolve("MIRScript").toFile();
        try (PrintWriter pw = new PrintWriter(MIRScriptFile);){
            pw.println(new StringBuilder(7).append("CREATE ").append(this.escapeWhitespaces(IO$RichPath$.MODULE$.abs$extension(IO$.MODULE$.RichPath(outpath)))).toString());
            objectPaths.foreach((Function1)(JProcedure1 & Serializable)path -> {
                String uniqueName = workdir.relativize((Path)path).toString().replace(File.separator, "_");
                Path newPath = workdir.resolve(uniqueName);
                Files.move(path, newPath, StandardCopyOption.REPLACE_EXISTING);
                pw.println(new StringBuilder(7).append("ADDMOD ").append(this.escapeWhitespaces(IO$RichPath$.MODULE$.abs$extension(IO$.MODULE$.RichPath(newPath)))).toString());
            });
            pw.println("SAVE");
            pw.println("END");
        }
        scala.collection.immutable.Seq command = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{IO$RichPath$.MODULE$.abs$extension(IO$.MODULE$.RichPath(llvmAR)), "-M"}));
        config.logger().running((scala.collection.immutable.Seq<String>)command);
        return Process$.MODULE$.apply((Seq)command, config.workdir().toFile(), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0])).$hash$less(MIRScriptFile);
    }

    private boolean needsCompiling(Path in, Path out) {
        return in.toFile().lastModified() > out.toFile().lastModified();
    }

    private boolean needsLinking(scala.collection.immutable.Seq<Path> in, Path out) {
        long outmax;
        long inmax = BoxesRunTime.unboxToLong((Object)((IterableOnceOps)in.map((Function1 & Serializable)_$3 -> _$3.toFile().lastModified())).max((Ordering)Ordering.Long$.MODULE$));
        return inmax > (outmax = out.toFile().lastModified());
    }

    private scala.collection.immutable.Seq<String> flto(Config config) {
        scala.collection.immutable.Seq seq;
        LTO lTO = config.compilerConfig().lto();
        if (LTO$None$.MODULE$.equals(lTO)) {
            seq = (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
        } else {
            LTO lto = lTO;
            seq = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(6).append("-flto=").append(lto.name()).toString()}));
        }
        return seq;
    }

    private scala.collection.immutable.Seq<String> target(Config config) {
        scala.collection.immutable.Seq seq;
        Option<String> option = config.compilerConfig().targetTriple();
        if (option instanceof Some) {
            String tt = (String)((Some)option).value();
            seq = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"-target", tt}));
        } else if (None$.MODULE$.equals(option)) {
            seq = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"-Wno-override-module"}));
        } else {
            throw new MatchError(option);
        }
        return seq;
    }

    private String opt(Config config) {
        String string;
        Mode mode = config.mode();
        if (Mode$Debug$.MODULE$.equals(mode)) {
            string = "-O0";
        } else if (Mode$ReleaseFast$.MODULE$.equals(mode)) {
            string = "-O2";
        } else if (Mode$ReleaseSize$.MODULE$.equals(mode)) {
            string = "-Oz";
        } else if (Mode$ReleaseFull$.MODULE$.equals(mode)) {
            string = "-O3";
        } else {
            throw new MatchError((Object)mode);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private scala.collection.immutable.Seq<String> llvmIrFeatures(Config config) {
        void var2_2;
        List opaquePointers = Discover$features$.MODULE$.opaquePointers(this.nativeConfig$1(config)).requiredFlag().toList().flatMap((Function1 & Serializable)_$4 -> package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"-mllvm", _$4})));
        return var2_2;
    }

    private scala.collection.immutable.Seq<String> buildTargetCompileOpts(Config config) {
        Nil$ nil$;
        BuildTarget buildTarget = config.compilerConfig().buildTarget();
        if (BuildTarget$Application$.MODULE$.equals(buildTarget)) {
            nil$ = package$.MODULE$.Nil();
        } else if (BuildTarget$LibraryStatic$.MODULE$.equals(buildTarget)) {
            nil$ = (scala.collection.immutable.Seq)this.optionalPICflag(config).$plus$plus((IterableOnce)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--emit-static-lib"})));
        } else if (BuildTarget$LibraryDynamic$.MODULE$.equals(buildTarget)) {
            nil$ = (scala.collection.immutable.Seq)this.optionalPICflag(config).$colon$plus((Object)"-DSCALANATIVE_DYLIB");
        } else {
            throw new MatchError((Object)buildTarget);
        }
        return nil$;
    }

    private scala.collection.immutable.Seq<String> buildTargetLinkOpts(Config config) {
        Nil$ nil$;
        Nil$ optRdynamic = config.targetsWindows() ? package$.MODULE$.Nil() : (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"-rdynamic"}));
        BuildTarget buildTarget = config.compilerConfig().buildTarget();
        if (BuildTarget$Application$.MODULE$.equals(buildTarget)) {
            nil$ = optRdynamic;
        } else if (BuildTarget$LibraryStatic$.MODULE$.equals(buildTarget)) {
            nil$ = (scala.collection.immutable.Seq)this.optionalPICflag(config).$plus$plus((IterableOnce)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--emit-static-lib"})));
        } else if (BuildTarget$LibraryDynamic$.MODULE$.equals(buildTarget)) {
            String libFlag = config.targetsMac() ? "-dynamiclib" : "-shared";
            nil$ = (scala.collection.immutable.Seq)((IterableOps)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{libFlag})).$plus$plus(this.optionalPICflag(config))).$plus$plus((IterableOnce)optRdynamic);
        } else {
            throw new MatchError((Object)buildTarget);
        }
        return nil$;
    }

    private scala.collection.immutable.Seq<String> optionalPICflag(Config config) {
        return config.targetsWindows() ? package$.MODULE$.Nil() : (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"-fPIC"}));
    }

    private String escapeWhitespaces(String str) {
        return StringOps$.MODULE$.exists$extension(Predef$.MODULE$.augmentString(str), (Function1 & Serializable)_$5 -> this.escapeWhitespaces$$anonfun$1(BoxesRunTime.unboxToChar((Object)_$5))) ? new StringBuilder(2).append("\"").append(str).append("\"").toString() : str;
    }

    public scala.collection.immutable.Seq<String> msysExtras() {
        long l;
        long l2;
        while ((l2 = LazyVals$.MODULE$.STATE(l = LazyVals$.MODULE$.get((Object)this, OFFSET$_m_0), 0)) != 3L) {
            if (l2 == 0L) {
                if (!LazyVals$.MODULE$.CAS((Object)this, OFFSET$_m_0, l, 1, 0)) continue;
                try {
                    scala.collection.immutable.Seq seq;
                    msysExtras$lzy1 = seq = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"-D_WIN64", "-D__MINGW64__", "-D_X86_64_ -D__X86_64__ -D__x86_64", "-D__USING_SJLJ_EXCEPTIONS__", "-DNO_OLDNAMES", "-D_LIBUNWIND_BUILD_ZERO_COST_APIS"}));
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$_m_0, 3, 0);
                    return seq;
                }
                catch (Throwable throwable) {
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$_m_0, 0, 0);
                    throw throwable;
                }
            }
            LazyVals$.MODULE$.wait4Notification((Object)this, OFFSET$_m_0, l, 0);
        }
        return msysExtras$lzy1;
    }

    public scala.collection.immutable.Seq<Path> generateLLVMIdent(Config config) {
        scala.collection.immutable.Seq seq;
        if (!config.targetsLinux()) {
            seq = (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
        } else {
            Path workDir = config.workdir();
            Path identPath = workDir.resolve("ScalaNativeIdent.ll");
            String ident = this.constructIdent$1(config);
            try (PrintWriter pw = new PrintWriter(identPath.toFile());){
                pw.println("!llvm.ident = !{!0}");
                pw.println(new StringBuilder(11).append("!0 = !{!\"").append(ident).append("\"}").toString());
            }
            seq = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Path[]{identPath}));
        }
        return seq;
    }

    private final NativeConfig nativeConfig$1(Config config$2) {
        return config$2.compilerConfig();
    }

    private final /* synthetic */ boolean escapeWhitespaces$$anonfun$1(char _$5) {
        return RichChar$.MODULE$.isWhitespace$extension(Predef$.MODULE$.charWrapper(_$5));
    }

    private final String constructIdent$1(Config config$3) {
        String snVersion = Versions$.MODULE$.current();
        String ident1 = new StringBuilder(13).append("Scala Native ").append(snVersion).toString();
        String ident2 = new StringBuilder(19).append("Mode: ").append(config$3.mode()).append(", LTO: ").append(config$3.LTO()).append(", GC: ").append(config$3.gc()).toString();
        return new StringBuilder(3).append(ident1).append(" (").append(ident2).append(")").toString();
    }
}

