/*
 * Decompiled with CFR 0.152.
 */
package scala.scalanative.testinterface.common;

import java.io.Serializable;
import java.util.HashMap;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;
import scala.scalanative.testinterface.common.Endpoint;
import scala.scalanative.testinterface.common.MsgEndpoint;
import scala.scalanative.testinterface.common.RPCCore;
import scala.scalanative.testinterface.common.RPCEndpoint;
import scala.scalanative.testinterface.common.RunMux;
import scala.util.Try$;

public final class RunMuxRPC {
    private final RPCCore rpc;
    private final Map<Object, HashMap<Object, ?>> mux;

    public RunMuxRPC(RPCCore rpc) {
        this.rpc = rpc;
        this.mux = (Map)Map$.MODULE$.empty();
    }

    public <Req> Future<Object> call(RPCEndpoint ep, int runId, Req req) {
        return this.rpc.call(ep, new RunMux<Req>(runId, req));
    }

    public <Msg> void send(MsgEndpoint ep, int runId, Msg msg) {
        this.rpc.send(ep, new RunMux<Msg>(runId, msg));
    }

    public <Msg> void attach(MsgEndpoint ep, int runId, Function1<Msg, BoxedUnit> ex2) {
        this.attachMux(ep.opCode(), runId, (Function1)ex2, (Function1)(JProcedure1 & Serializable)ex -> this.rpc.attach(ep, (Function1<Object, BoxedUnit>)ex));
    }

    public <Req> void attach(RPCEndpoint ep, int runId, Function1<Req, Object> ex) {
        this.attachAsync(ep, runId, (Function1 & Serializable)x -> Future$.MODULE$.fromTry(Try$.MODULE$.apply(() -> RunMuxRPC.attach$$anonfun$2$$anonfun$1(ex, x))));
    }

    public <Req> void attachAsync(RPCEndpoint ep, int runId, Function1<Req, Future<Object>> ex2) {
        this.attachMux(ep.opCode(), runId, (Function1)ex2, (Function1)(JProcedure1 & Serializable)ex -> this.rpc.attachAsync(ep, (Function1<Object, Future<Object>>)ex));
    }

    private <Req, Resp> void attachMux(byte opCode, int runId, Function1<Req, Resp> ex, Function1<Function1<RunMux<Req>, Resp>, BoxedUnit> attach) {
        RunMuxRPC runMuxRPC = this;
        synchronized (runMuxRPC) {
            HashMap dispatch = (HashMap)this.mux.getOrElseUpdate((Object)BoxesRunTime.boxToByte((byte)opCode), () -> RunMuxRPC.$anonfun$1(attach));
            Function1<Req, Resp> old = dispatch.put(BoxesRunTime.boxToInteger((int)runId), ex);
            Predef$.MODULE$.require(old == null, () -> RunMuxRPC.attachMux$$anonfun$1(opCode, runId));
        }
    }

    public void detach(Endpoint ep, int runId) {
        RunMuxRPC runMuxRPC = this;
        synchronized (runMuxRPC) {
            BoxedUnit boxedUnit;
            byte opCode = ep.opCode();
            HashMap dispatch = (HashMap)this.mux.getOrElse((Object)BoxesRunTime.boxToByte((byte)opCode), () -> RunMuxRPC.$anonfun$2(opCode));
            Object old = dispatch.remove(BoxesRunTime.boxToInteger((int)runId));
            Predef$.MODULE$.require(old != null, () -> RunMuxRPC.detach$$anonfun$1(runId, opCode));
            if (dispatch.isEmpty()) {
                this.rpc.detach(ep);
                this.mux.$minus$eq((Object)BoxesRunTime.boxToByte((byte)opCode));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    private static final Object attach$$anonfun$2$$anonfun$1(Function1 ex$2, Object x$1) {
        return ex$2.apply(x$1);
    }

    private static final Object newDispatchMap$1$$anonfun$1$$anonfun$1(RunMux r$1) {
        throw new IllegalArgumentException(new StringBuilder(12).append("Unknown run ").append(r$1.runId()).toString());
    }

    /*
     * WARNING - void declaration
     */
    private static final HashMap newDispatchMap$1(Function1 attach$1) {
        void var1_1;
        HashMap dispatch = new HashMap();
        attach$1.apply((Function1 & Serializable)r -> Option$.MODULE$.apply(dispatch.get(BoxesRunTime.boxToInteger((int)r.runId()))).fold(() -> RunMuxRPC.newDispatchMap$1$$anonfun$1$$anonfun$1(r), (Function1 & Serializable)f -> f.apply(r.value())));
        return var1_1;
    }

    private static final HashMap $anonfun$1(Function1 attach$2) {
        return RunMuxRPC.newDispatchMap$1(attach$2);
    }

    private static final String attachMux$$anonfun$1(byte opCode$1, int runId$1) {
        return new StringBuilder(35).append("Duplicate endpoint for opcode ").append(opCode$1).append(" run ").append(runId$1).toString();
    }

    private static final HashMap $anonfun$2(byte opCode$2) {
        throw new IllegalArgumentException(new StringBuilder(32).append("No endpoint attached for opCode ").append(opCode$2).toString());
    }

    private static final String detach$$anonfun$1(int runId$2, byte opCode$3) {
        return new StringBuilder(37).append("No endpoint attached for opCode ").append(opCode$3).append(" run ").append(runId$2).toString();
    }
}

