/*
 * Decompiled with CFR 0.152.
 */
package scala.scalanative.testinterface.common;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import scala.Byte$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.scalanative.testinterface.common.Endpoint;
import scala.scalanative.testinterface.common.MsgEndpoint;
import scala.scalanative.testinterface.common.NativeEndpoints$;
import scala.scalanative.testinterface.common.RPCCore$;
import scala.scalanative.testinterface.common.RPCCore$ClosedException$;
import scala.scalanative.testinterface.common.RPCCore$PendingCall$;
import scala.scalanative.testinterface.common.RPCCore$RPCException$;
import scala.scalanative.testinterface.common.RPCEndpoint;
import scala.scalanative.testinterface.common.Serializer;
import scala.scalanative.testinterface.common.Serializer$;
import scala.scalanative.testinterface.common.Serializer$ThrowableSerializer$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public abstract class RPCCore {
    private final ExecutionContext ec;
    private final HashMap<Object, PendingCall> pending;
    private volatile Throwable closeReason;
    private final AtomicLong nextID;
    private final HashMap<Object, BoundEndpoint> endpoints;

    public static boolean isReservedOpCode(byte by) {
        return RPCCore$.MODULE$.isReservedOpCode(by);
    }

    public RPCCore(ExecutionContext ec) {
        this.ec = ec;
        this.pending = new HashMap();
        this.nextID = new AtomicLong(0L);
        this.endpoints = new HashMap();
    }

    public final void handleMessage(String msg) {
        Serializer$.MODULE$.withInputStream(msg, (JProcedure1 & Serializable)in -> {
            byte opCode = in.readByte();
            byte by = opCode;
            if (RPCCore$.scala$scalanative$testinterface$common$RPCCore$$$ReplyOK == by) {
                this.getPending$1((DataInputStream)in).foreach((Function1 & Serializable)p -> p.promise().complete(Try$.MODULE$.apply(() -> RPCCore.handleMessage$$anonfun$1$$anonfun$1$$anonfun$1(in, p))));
            } else if (RPCCore$.scala$scalanative$testinterface$common$RPCCore$$$ReplyErr == by) {
                this.getPending$1((DataInputStream)in).foreach((Function1 & Serializable)p -> {
                    Throwable throwable;
                    Try try_ = Try$.MODULE$.apply(() -> RPCCore.$anonfun$1(in));
                    if (try_ instanceof Success) {
                        Throwable t = (Throwable)((Success)try_).value();
                        throwable = new RPCException(t);
                    } else if (try_ instanceof Failure) {
                        Throwable t = ((Failure)try_).exception();
                        throwable = t;
                    } else {
                        throw new MatchError((Object)try_);
                    }
                    Throwable throwable2 = throwable;
                    return p.promise().failure(throwable2);
                });
            } else {
                BoundEndpoint boundEndpoint = this.endpoints.get(BoxesRunTime.boxToByte((byte)opCode));
                if (boundEndpoint == null) {
                    byte by2 = opCode;
                    String detail = NativeEndpoints$.MODULE$.msgWorker().opCode() == by2 ? "; The test adapter could not send a message to a worker, which probably happens because the worker terminated early, without waiting for the reply to a call to send(). This is probably a bug in the testing framework you are using. See also scala-js/scala-js#3201." : "";
                    throw new IllegalStateException(new StringBuilder(16).append("Unknown opcode: ").append(opCode).append(detail).toString());
                }
                if (boundEndpoint instanceof BoundMsgEndpoint) {
                    BoundMsgEndpoint bep = (BoundMsgEndpoint)boundEndpoint;
                    MsgEndpoint ep = bep.endpoint();
                    Object arg = Serializer$.MODULE$.deserialize((DataInputStream)in, ep.msgSerializer());
                    bep.exec().apply(arg);
                } else if (boundEndpoint instanceof BoundRPCEndpoint) {
                    BoundRPCEndpoint bep = (BoundRPCEndpoint)boundEndpoint;
                    long callID = in.readLong();
                    RPCEndpoint ep = bep.endpoint();
                    Future$.MODULE$.fromTry(Try$.MODULE$.apply(() -> RPCCore.handleMessage$$anonfun$1$$anonfun$3(in, ep))).flatMap(bep.exec(), this.ec).onComplete((Function1)(JProcedure1 & Serializable)repl -> this.send(this.makeReply(callID, (Try)repl, ep.respSerializer())), this.ec);
                } else {
                    throw new MatchError((Object)boundEndpoint);
                }
            }
        });
    }

    public boolean isClosed() {
        return this.closeReason != null;
    }

    public abstract void send(String var1);

    public final void send(MsgEndpoint ep, Object msg) {
        this.send(this.makeMsgMsg(ep.opCode(), msg, ep.msgSerializer()));
    }

    public final Future<Object> call(RPCEndpoint ep, Object req) {
        long id = this.nextID.incrementAndGet();
        String msg = this.makeRPCMsg(ep.opCode(), id, req, ep.reqSerializer());
        Promise promise = Promise$.MODULE$.apply();
        PendingCall oldCall = this.pending.put(BoxesRunTime.boxToLong((long)id), RPCCore$PendingCall$.MODULE$.apply(promise, ep.respSerializer()));
        if (oldCall != null) {
            AssertionError error = new AssertionError((Object)"Ran out of call ids!");
            this.close((Throwable)((Object)error));
            throw error;
        }
        if (this.closeReason != null) {
            this.helpClose();
        } else {
            this.send(msg);
        }
        return promise.future();
    }

    public final void attach(MsgEndpoint ep, Function1<Object, BoxedUnit> ex) {
        this.attach(new BoundMsgEndpoint(ep, ex){
            private final MsgEndpoint endpoint;
            private final Function1 exec;
            {
                this.endpoint = ep$3;
                this.exec = ex$1;
            }

            public MsgEndpoint endpoint() {
                return this.endpoint;
            }

            public Function1 exec() {
                return this.exec;
            }
        });
    }

    public final void attach(RPCEndpoint ep, Function1<Object, Object> ex) {
        this.attachAsync(ep, (Function1<Object, Future<Object>>)(Function1 & Serializable)x -> Future$.MODULE$.fromTry(Try$.MODULE$.apply(() -> RPCCore.attach$$anonfun$1$$anonfun$1(ex, x))));
    }

    public final void attachAsync(RPCEndpoint ep, Function1<Object, Future<Object>> ex) {
        this.attach(new BoundRPCEndpoint(ep, ex){
            private final RPCEndpoint endpoint;
            private final Function1 exec;
            {
                this.endpoint = ep$4;
                this.exec = ex$4;
            }

            public RPCEndpoint endpoint() {
                return this.endpoint;
            }

            public Function1 exec() {
                return this.exec;
            }
        });
    }

    private final void attach(BoundEndpoint bep) {
        byte opCode = bep.endpoint().opCode();
        BoundEndpoint old = this.endpoints.put(BoxesRunTime.boxToByte((byte)opCode), bep);
        Predef$.MODULE$.require(old == null, () -> RPCCore.attach$$anonfun$2(opCode));
    }

    public final void detach(Endpoint ep) {
        BoundEndpoint old = this.endpoints.remove(BoxesRunTime.boxToByte((byte)ep.opCode()));
        Predef$.MODULE$.require(old != null, RPCCore::detach$$anonfun$1);
    }

    public void close(Throwable reason) {
        this.closeReason = reason;
        this.helpClose();
    }

    private void helpClose() {
        Set pendingCallIDs = this.pending.keySet();
        ClosedException exception = new ClosedException(this.closeReason);
        Iterator pendingCallIDsIter = pendingCallIDs.iterator();
        while (pendingCallIDsIter.hasNext()) {
            long callID = BoxesRunTime.unboxToLong(pendingCallIDsIter.next());
            Option$.MODULE$.apply((Object)this.pending.remove(BoxesRunTime.boxToLong((long)callID))).foreach((Function1 & Serializable)failing -> failing.promise().failure((Throwable)exception));
        }
    }

    private <T> String makeReply(long id, Try<T> result, Serializer<T> evidence$1) {
        String string;
        Try try_ = result.map((Function1 & Serializable)_$2 -> this.makeRPCMsg(RPCCore$.scala$scalanative$testinterface$common$RPCCore$$$ReplyOK, id, _$2, evidence$1));
        if (try_ instanceof Success) {
            String m;
            string = m = (String)((Success)try_).value();
        } else if (try_ instanceof Failure) {
            Throwable t = ((Failure)try_).exception();
            string = this.makeRPCMsg(RPCCore$.scala$scalanative$testinterface$common$RPCCore$$$ReplyErr, id, t, Serializer$ThrowableSerializer$.MODULE$);
        } else {
            throw new MatchError((Object)try_);
        }
        return string;
    }

    private <T> String makeRPCMsg(byte opCode, long id, T payload, Serializer<T> evidence$2) {
        return Serializer$.MODULE$.withOutputStream((Function1<DataOutputStream, BoxedUnit>)(JProcedure1 & Serializable)out -> {
            out.writeByte(Byte$.MODULE$.byte2int(opCode));
            out.writeLong(id);
            Serializer$.MODULE$.serialize(payload, (DataOutputStream)out, evidence$2);
        });
    }

    private <T> String makeMsgMsg(byte opCode, T payload, Serializer<T> evidence$3) {
        return Serializer$.MODULE$.withOutputStream((Function1<DataOutputStream, BoxedUnit>)(JProcedure1 & Serializable)out -> {
            out.writeByte(Byte$.MODULE$.byte2int(opCode));
            Serializer$.MODULE$.serialize(payload, (DataOutputStream)out, evidence$3);
        });
    }

    private final Option getPending$1(DataInputStream in$1) {
        long callID = in$1.readLong();
        return Option$.MODULE$.apply((Object)this.pending.remove(BoxesRunTime.boxToLong((long)callID)));
    }

    private static final Object handleMessage$$anonfun$1$$anonfun$1$$anonfun$1(DataInputStream in$3, PendingCall p$1) {
        return Serializer$.MODULE$.deserialize(in$3, p$1.serializer());
    }

    private static final Throwable $anonfun$1(DataInputStream in$5) {
        return Serializer$.MODULE$.deserialize(in$5, Serializer$ThrowableSerializer$.MODULE$);
    }

    private static final Object handleMessage$$anonfun$1$$anonfun$3(DataInputStream in$6, RPCEndpoint ep$1) {
        return Serializer$.MODULE$.deserialize(in$6, ep$1.reqSerializer());
    }

    private static final Object attach$$anonfun$1$$anonfun$1(Function1 ex$3, Object x$1) {
        return ex$3.apply(x$1);
    }

    private static final String attach$$anonfun$2(byte opCode$1) {
        return new StringBuilder(31).append("Duplicate endpoint for opcode ").append(opCode$1).append(".").toString();
    }

    private static final String detach$$anonfun$1() {
        return "Endpoint was not attached.";
    }

    public static interface BoundEndpoint {
        public Endpoint endpoint();
    }

    public static interface BoundMsgEndpoint
    extends BoundEndpoint {
        @Override
        public MsgEndpoint endpoint();

        public Function1<Object, BoxedUnit> exec();
    }

    public static interface BoundRPCEndpoint
    extends BoundEndpoint {
        @Override
        public RPCEndpoint endpoint();

        public Function1<Object, Future<Object>> exec();
    }

    public static final class ClosedException
    extends Exception
    implements Product {
        private final Throwable c;

        public static ClosedException apply(Throwable throwable) {
            return RPCCore$ClosedException$.MODULE$.apply(throwable);
        }

        public static ClosedException fromProduct(Product product) {
            return RPCCore$ClosedException$.MODULE$.fromProduct(product);
        }

        public static ClosedException unapply(ClosedException closedException) {
            return RPCCore$ClosedException$.MODULE$.unapply(closedException);
        }

        public ClosedException(Throwable c) {
            this.c = c;
            super(c);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ClosedException)) return false;
            ClosedException closedException = (ClosedException)object;
            Throwable throwable = this.c();
            Throwable throwable2 = closedException.c();
            if (throwable != null) {
                if (!throwable.equals(throwable2)) return false;
                return true;
            }
            if (throwable2 == null) return true;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof ClosedException;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "ClosedException";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "c";
        }

        public Throwable c() {
            return this.c;
        }

        public ClosedException copy(Throwable c) {
            return new ClosedException(c);
        }

        public Throwable copy$default$1() {
            return this.c();
        }

        public Throwable _1() {
            return this.c();
        }
    }

    public static interface PendingCall {
        public static <R> PendingCall apply(Promise<R> promise, Serializer<R> serializer) {
            return RPCCore$PendingCall$.MODULE$.apply(promise, serializer);
        }

        public Promise<Object> promise();

        public Serializer<Object> serializer();
    }

    public static final class RPCException
    extends Exception
    implements Product {
        private final Throwable c;

        public static RPCException apply(Throwable throwable) {
            return RPCCore$RPCException$.MODULE$.apply(throwable);
        }

        public static RPCException fromProduct(Product product) {
            return RPCCore$RPCException$.MODULE$.fromProduct(product);
        }

        public static RPCException unapply(RPCException rPCException) {
            return RPCCore$RPCException$.MODULE$.unapply(rPCException);
        }

        public RPCException(Throwable c) {
            this.c = c;
            super(c);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof RPCException)) return false;
            RPCException rPCException = (RPCException)object;
            Throwable throwable = this.c();
            Throwable throwable2 = rPCException.c();
            if (throwable != null) {
                if (!throwable.equals(throwable2)) return false;
                return true;
            }
            if (throwable2 == null) return true;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof RPCException;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "RPCException";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "c";
        }

        public Throwable c() {
            return this.c;
        }

        public RPCException copy(Throwable c) {
            return new RPCException(c);
        }

        public Throwable copy$default$1() {
            return this.c();
        }

        public Throwable _1() {
            return this.c();
        }
    }
}

