/*
 * Decompiled with CFR 0.152.
 */
package scala.concurrent.duration;

import java.util.concurrent.TimeUnit;
import scala.MatchError;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.Deadline$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration$;
import scala.math.Ordered;
import scala.reflect.ScalaSignature;
import scala.runtime.OrderedProxy;
import scala.runtime.RichLong;

@ScalaSignature(bytes="\u0006\u0005\t-t!\u0002#F\u0011\u0003ae!\u0002(F\u0011\u0003y\u0005\"\u0002/\u0002\t\u0003iv!\u00020\u0002\u0011\u0007yf!B1\u0002\u0011\u0003\u0011\u0007B\u0002/\u0005\t\u0003\ti\u0010C\u0004\u0002\\\u0011!\t!a@\t\u0013\t\u0015A!!A\u0005\n\t\u001d\u0001b\u0002B\u0005\u0003\u0011\u0005!1\u0002\u0005\b\u0005\u0013\tA\u0011\u0001B\t\u0011%\u0011)#\u0001b\u0001\n\u001b\u00119\u0003\u0003\u0005\u0003.\u0005\u0001\u000bQ\u0002B\u0015\u0011%\u0011y#\u0001b\u0001\n\u001b\u0011\t\u0004\u0003\u0005\u00038\u0005\u0001\u000bQ\u0002B\u001a\u0011%\u0011I$\u0001b\u0001\n\u001b\u0011Y\u0004\u0003\u0005\u0003B\u0005\u0001\u000bQ\u0002B\u001f\u0011%\u0011\u0019%\u0001b\u0001\n\u001b\u0011)\u0005\u0003\u0005\u0003L\u0005\u0001\u000bQ\u0002B$\u0011%\u0011i%\u0001b\u0001\n\u001b\u0011y\u0005\u0003\u0005\u0003V\u0005\u0001\u000bQ\u0002B)\u0011%\u00119&\u0001b\u0001\n\u001b\u0011I\u0006\u0003\u0005\u0003`\u0005\u0001\u000bQ\u0002B.\u0011%\u0011\t'\u0001b\u0001\n\u001b\u0011\u0019\u0007\u0003\u0005\u0003j\u0005\u0001\u000bQ\u0002B3\u0011%\u0011)!AA\u0001\n\u0013\u00119A\u0002\u0003O\u000b\n1\b\u0002\u0003>\u001a\u0005\u000b\u0007I\u0011A>\t\u0011}L\"\u0011!Q\u0001\nqD!\"!\u0001\u001a\u0005\u000b\u0007I\u0011AA\u0002\u0011)\t\t\"\u0007B\u0001B\u0003%\u0011Q\u0001\u0005\u00079f!\t!a\u0005\t\u0011\u0005e\u0011\u0004)C\u0005\u00037Aa!a\n\u001a\t\u0003Y\bBBA\u00153\u0011\u00051\u0010\u0003\u0004\u0002,e!\ta\u001f\u0005\u0007\u0003[IB\u0011A>\t\r\u0005=\u0012\u0004\"\u0001|\u0011\u0019\t\t$\u0007C\u0001w\"1\u00111G\r\u0005\u0002mDq!!\u000e\u001a\t\u0003\t9\u0004C\u0004\u0002De!\t!!\u0012\t\u0011\u00055\u0013\u0004)C\u0005\u0003\u001fBq!a\u0016\u001a\t\u0003\nI\u0006C\u0004\u0002\\e!\t!!\u0018\t\u0011\u0005%\u0014\u0004)C\u0005\u0003WB\u0001\"!\u001e\u001aA\u0013%\u0011q\u000f\u0005\b\u0003\u0003KB\u0011AAB\u0011\u001d\t9)\u0007C\u0001\u0003\u0013Cq!!$\u001a\t\u0003\ty\tC\u0004\u0002\u0016f!\t!a&\t\u0011\u0005u\u0015\u0004)C\u0005\u0003?Cq!!&\u001a\t\u0003\t\t\u000bC\u0004\u0002\u0002f!\t!!*\t\u000f\u0005\u001d\u0015\u0004\"\u0001\u0002*\"9\u0011QV\r\u0005\u0002\u0005=\u0006bBAZ3\u0011\u0005\u0011Q\u0017\u0005\b\u0003sKB\u0011AA^\u0011\u001d\t)#\u0007C\u0001\u0003\u007fCq!!&\u001a\t\u0003\t\u0019\rC\u0004\u0002\u000ef!\t!a2\t\u000f\u0005-\u0017\u0004\"\u0003\u0002N\"9\u0011q[\r\u0005\u0002\u0005e\u0007bBAo3\u0011\u0005\u0011q\u001c\u0005\b\u0003GLB\u0011AAs\u0011\u001d\t9/\u0007C\u0003\u0003SDq!a;\u001a\t\u000b\n)\u000fC\u0004\u0002nf!\t%a<\t\u000f\u0005e\u0018\u0004\"\u0011\u0002|\u0006qa)\u001b8ji\u0016$UO]1uS>t'B\u0001$H\u0003!!WO]1uS>t'B\u0001%J\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0002\u0015\u0006)1oY1mC\u000e\u0001\u0001CA'\u0002\u001b\u0005)%A\u0004$j]&$X\rR;sCRLwN\\\n\u0004\u0003A#\u0006CA)S\u001b\u0005I\u0015BA*J\u0005\u0019\te.\u001f*fMB\u0011QKW\u0007\u0002-*\u0011q\u000bW\u0001\u0003S>T\u0011!W\u0001\u0005U\u00064\u0018-\u0003\u0002\\-\na1+\u001a:jC2L'0\u00192mK\u00061A(\u001b8jiz\"\u0012\u0001T\u0001\u0018\r&t\u0017\u000e^3EkJ\fG/[8o\u0013N|%\u000fZ3sK\u0012\u0004\"\u0001\u0019\u0003\u000e\u0003\u0005\u0011qCR5oSR,G)\u001e:bi&|g.S:Pe\u0012,'/\u001a3\u0014\u0007\u0011\u0019\u0017\u000e\u0005\u0002eO6\tQM\u0003\u0002g1\u0006!A.\u00198h\u0013\tAWM\u0001\u0004PE*,7\r\u001e\t\u0004UJ,hBA6q\u001d\taw.D\u0001n\u0015\tq7*\u0001\u0004=e>|GOP\u0005\u0002\u0015&\u0011\u0011/S\u0001\ba\u0006\u001c7.Y4f\u0013\t\u0019HO\u0001\u0005Pe\u0012,'/\u001b8h\u0015\t\t\u0018\n\u0005\u0002N3M\u0011\u0011d\u001e\t\u0003\u001bbL!!_#\u0003\u0011\u0011+(/\u0019;j_:\fa\u0001\\3oORDW#\u0001?\u0011\u0005Ek\u0018B\u0001@J\u0005\u0011auN\\4\u0002\u000f1,gn\u001a;iA\u0005!QO\\5u+\t\t)\u0001\u0005\u0003\u0002\b\u0005-abA'\u0002\n%\u0011\u0011/R\u0005\u0005\u0003\u001b\tyA\u0001\u0005US6,WK\\5u\u0015\t\tX)A\u0003v]&$\b\u0005F\u0003v\u0003+\t9\u0002C\u0003{=\u0001\u0007A\u0010C\u0004\u0002\u0002y\u0001\r!!\u0002\u0002\u000f\t|WO\u001c3fIR!\u0011QDA\u0012!\r\t\u0016qD\u0005\u0004\u0003CI%a\u0002\"p_2,\u0017M\u001c\u0005\u0007\u0003Ky\u0002\u0019\u0001?\u0002\u00075\f\u00070A\u0004u_:\u000bgn\\:\u0002\u0011Q|W*[2s_N\f\u0001\u0002^8NS2d\u0017n]\u0001\ni>\u001cVmY8oIN\f\u0011\u0002^8NS:,H/Z:\u0002\u000fQ|\u0007j\\;sg\u00061Ao\u001c#bsN\fa\u0001^8V]&$H\u0003BA\u001d\u0003\u007f\u00012!UA\u001e\u0013\r\ti$\u0013\u0002\u0007\t>,(\r\\3\t\u000f\u0005\u0005s\u00051\u0001\u0002\u0006\u0005\tQ/A\u0004ge>lgj\\<\u0016\u0005\u0005\u001d\u0003cA'\u0002J%\u0019\u00111J#\u0003\u0011\u0011+\u0017\r\u001a7j]\u0016\f!\"\u001e8jiN#(/\u001b8h+\t\t\t\u0006E\u0002e\u0003'J1!!\u0016f\u0005\u0019\u0019FO]5oO\u0006AAo\\*ue&tw\r\u0006\u0002\u0002R\u000591m\\7qCJ,G\u0003BA0\u0003K\u00022!UA1\u0013\r\t\u0019'\u0013\u0002\u0004\u0013:$\bBBA4W\u0001\u0007q/A\u0003pi\",'/A\u0004tC\u001a,\u0017\t\u001a3\u0015\u000bq\fi'!\u001d\t\r\u0005=D\u00061\u0001}\u0003\u0005\t\u0007BBA:Y\u0001\u0007A0A\u0001c\u0003\r\tG\r\u001a\u000b\u0006k\u0006e\u0014Q\u0010\u0005\u0007\u0003wj\u0003\u0019\u0001?\u0002\u0017=$\b.\u001a:MK:<G\u000f\u001b\u0005\b\u0003\u007fj\u0003\u0019AA\u0003\u0003%yG\u000f[3s+:LG/A\u0003%a2,8\u000fF\u0002x\u0003\u000bCa!a\u001a/\u0001\u00049\u0018A\u0002\u0013nS:,8\u000fF\u0002x\u0003\u0017Ca!a\u001a0\u0001\u00049\u0018A\u0002\u0013uS6,7\u000fF\u0002x\u0003#Cq!a%1\u0001\u0004\tI$\u0001\u0004gC\u000e$xN]\u0001\u0005I\u0011Lg\u000fF\u0002x\u00033Cq!a'2\u0001\u0004\tI$A\u0004eSZL7o\u001c:\u0002\u00135Lg.^:[KJ|WCAA\u001d)\u0011\tI$a)\t\r\u0005m5\u00071\u0001x)\r)\u0018q\u0015\u0005\u0007\u0003O\"\u0004\u0019A;\u0015\u0007U\fY\u000b\u0003\u0004\u0002hU\u0002\r!^\u0001\u0005a2,8\u000fF\u0002v\u0003cCa!a\u001a7\u0001\u0004)\u0018!B7j]V\u001cHcA;\u00028\"1\u0011qM\u001cA\u0002U\f1!\\5o)\r)\u0018Q\u0018\u0005\u0007\u0003OB\u0004\u0019A;\u0015\u0007U\f\t\r\u0003\u0004\u0002he\u0002\r!\u001e\u000b\u0004k\u0006\u0015\u0007BBANu\u0001\u0007A\u0010F\u0002v\u0003\u0013Da!a%<\u0001\u0004a\u0018aB:bM\u0016lU\u000f\u001c\u000b\u0006y\u0006=\u00171\u001b\u0005\u0007\u0003#d\u0004\u0019\u0001?\u0002\u0005}\u000b\u0007BBAky\u0001\u0007A0\u0001\u0002`E\u0006\u0019A-\u001b<\u0015\u0007U\fY\u000e\u0003\u0004\u0002\u001cv\u0002\r\u0001`\u0001\u0004[VdGcA;\u0002b\"1\u00111\u0013 A\u0002q\fA\"\u001e8bef|F%\\5okN,\u0012!^\u0001\tSN4\u0015N\\5uKV\u0011\u0011QD\u0001\u000bi>\u001cu.\u0019:tKN$\u0018AB3rk\u0006d7\u000f\u0006\u0003\u0002\u001e\u0005E\bbBA4\u0005\u0002\u0007\u00111\u001f\t\u0004#\u0006U\u0018bAA|\u0013\n\u0019\u0011I\\=\u0002\u0011!\f7\u000f[\"pI\u0016$\"!a\u0018\u0015\u0003}#b!a\u0018\u0003\u0002\t\r\u0001BBA8\r\u0001\u0007Q\u000f\u0003\u0004\u0002t\u0019\u0001\r!^\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0002G\u0006)\u0011\r\u001d9msR)QO!\u0004\u0003\u0010!)!\u0010\u0003a\u0001y\"9\u0011\u0011\u0001\u0005A\u0002\u0005\u0015A#B;\u0003\u0014\tU\u0001\"\u0002>\n\u0001\u0004a\bbBA\u0001\u0013\u0001\u0007!q\u0003\t\u0005\u00053\u0011\tC\u0004\u0003\u0003\u001c\tu\u0001C\u00017J\u0013\r\u0011y\"S\u0001\u0007!J,G-\u001a4\n\t\u0005U#1\u0005\u0006\u0004\u0005?I\u0015AB7bq~s7/\u0006\u0002\u0003*=\u0011!1\u0006\u0010\t\u007f~\u0000\u0000\u0000\u0000\u0000\u0000\u0000\b9Q.\u0019=`]N\u0004\u0013aB7bq~\u0013]w]\u000b\u0003\u0005gy!A!\u000e\u001f\u000f\u0001\"=4jrTo\bAQ.\u0019=`\u0005X\u001e\b%\u0001\u0004nCb|Vn]\u000b\u0003\u0005{y!Aa\u0010\u001f\r!\u00197\u00105.w\u0004\u001di\u0017\r_0ng\u0002\nQ!\\1y?N,\"Aa\u0012\u0010\u0005\t%c$\u0002\u0002&\u0003x$\u0011AB7bq~\u001b\b%A\u0004nCb|V.\u001b8\u0016\u0005\tEsB\u0001B*=\u0011I\u0011fhz\u0002\u00115\f\u0007pX7j]\u0002\nQ!\\1y?\",\"Aa\u0017\u0010\u0005\tucdA\u0014\u0018\u007f\b1Q.\u0019=`Q\u0002\nQ!\\1y?\u0012,\"A!\u001a\u0010\u0005\t\u001dddA\u0001!\u0000\b1Q.\u0019=`I\u0002\u0002")
public final class FiniteDuration
extends Duration {
    private final long length;
    private final TimeUnit unit;

    public static FiniteDuration apply(long l, String string) {
        return FiniteDuration$.MODULE$.apply(l, string);
    }

    public static FiniteDuration apply(long l, TimeUnit timeUnit) {
        return new FiniteDuration(l, timeUnit);
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public TimeUnit unit() {
        return this.unit;
    }

    private boolean bounded(long max) {
        return -max <= this.length() && this.length() <= max;
    }

    @Override
    public long toNanos() {
        return this.unit().toNanos(this.length());
    }

    @Override
    public long toMicros() {
        return this.unit().toMicros(this.length());
    }

    @Override
    public long toMillis() {
        return this.unit().toMillis(this.length());
    }

    @Override
    public long toSeconds() {
        return this.unit().toSeconds(this.length());
    }

    @Override
    public long toMinutes() {
        return this.unit().toMinutes(this.length());
    }

    @Override
    public long toHours() {
        return this.unit().toHours(this.length());
    }

    @Override
    public long toDays() {
        return this.unit().toDays(this.length());
    }

    @Override
    public double toUnit(TimeUnit u) {
        return (double)this.toNanos() / (double)TimeUnit.NANOSECONDS.convert(1L, u);
    }

    public Deadline fromNow() {
        return Deadline$.MODULE$.now().$plus(this);
    }

    private String unitString() {
        return new StringBuilder(0).append((String)Duration$.MODULE$.timeUnitName().apply(this.unit())).append((Object)(this.length() == 1L ? "" : "s")).toString();
    }

    public String toString() {
        return new StringBuilder(1).append(this.length()).append(" ").append(this.unitString()).toString();
    }

    @Override
    public int compare(Duration other) {
        int n;
        if (other instanceof FiniteDuration) {
            FiniteDuration finiteDuration = (FiniteDuration)other;
            Long l = finiteDuration.toNanos();
            RichLong compare_this = new RichLong(this.toNanos());
            Object var4_4 = null;
            n = OrderedProxy.compare$(compare_this, l);
        } else {
            n = -other.compare(this);
        }
        return n;
    }

    private long safeAdd(long a, long b) {
        if (b > 0L && a > Long.MAX_VALUE - b || b < 0L && a < Long.MIN_VALUE - b) {
            throw new IllegalArgumentException("integer overflow");
        }
        return a + b;
    }

    private FiniteDuration add(long otherLength, TimeUnit otherUnit) {
        TimeUnit commonUnit = otherUnit.convert(1L, this.unit()) == 0L ? this.unit() : otherUnit;
        long totalLength = this.safeAdd(commonUnit.convert(this.length(), this.unit()), commonUnit.convert(otherLength, otherUnit));
        return new FiniteDuration(totalLength, commonUnit);
    }

    @Override
    public Duration $plus(Duration other) {
        Duration duration;
        if (other instanceof FiniteDuration) {
            FiniteDuration finiteDuration = (FiniteDuration)other;
            duration = this.add(finiteDuration.length(), finiteDuration.unit());
        } else {
            duration = other;
        }
        return duration;
    }

    @Override
    public Duration $minus(Duration other) {
        Duration duration;
        if (other instanceof FiniteDuration) {
            FiniteDuration finiteDuration = (FiniteDuration)other;
            duration = this.add(-finiteDuration.length(), finiteDuration.unit());
        } else {
            duration = other.unary_$minus();
        }
        return duration;
    }

    @Override
    public Duration $times(double factor) {
        if (!Double.valueOf(factor).isInfinite()) {
            return Duration$.MODULE$.fromNanos((double)this.toNanos() * factor);
        }
        if (Double.isNaN(factor)) {
            return Duration$.MODULE$.Undefined();
        }
        FiniteDuration $less_that = Duration$.MODULE$.Zero();
        Object var3_2 = null;
        if (factor > 0.0 ^ Ordered.$less$(this, $less_that)) {
            return Duration$.MODULE$.Inf();
        }
        return Duration$.MODULE$.MinusInf();
    }

    @Override
    public Duration $div(double divisor) {
        if (!Double.valueOf(divisor).isInfinite()) {
            return Duration$.MODULE$.fromNanos((double)this.toNanos() / divisor);
        }
        if (Double.isNaN(divisor)) {
            return Duration$.MODULE$.Undefined();
        }
        return Duration$.MODULE$.Zero();
    }

    private double minusZero() {
        return -0.0;
    }

    @Override
    public double $div(Duration divisor) {
        if (divisor.isFinite()) {
            return (double)this.toNanos() / (double)divisor.toNanos();
        }
        if (divisor == Duration$.MODULE$.Undefined()) {
            return Double.NaN;
        }
        if (this.length() < 0L ^ divisor.$greater(Duration$.MODULE$.Zero())) {
            return 0.0;
        }
        return -0.0;
    }

    public FiniteDuration $plus(FiniteDuration other) {
        return this.add(other.length(), other.unit());
    }

    public FiniteDuration $minus(FiniteDuration other) {
        return this.add(-other.length(), other.unit());
    }

    public FiniteDuration plus(FiniteDuration other) {
        return this.$plus(other);
    }

    public FiniteDuration minus(FiniteDuration other) {
        return this.$minus(other);
    }

    public FiniteDuration min(FiniteDuration other) {
        if (Ordered.$less$(this, other)) {
            return this;
        }
        return other;
    }

    public FiniteDuration max(FiniteDuration other) {
        if (Ordered.$greater$(this, other)) {
            return this;
        }
        return other;
    }

    public FiniteDuration $div(long divisor) {
        return Duration$.MODULE$.fromNanos(this.toNanos() / divisor);
    }

    public FiniteDuration $times(long factor) {
        return new FiniteDuration(this.safeMul(this.length(), factor), this.unit());
    }

    private long safeMul(long _a, long _b) {
        long l = Math.abs(_a);
        long l2 = Math.abs(_b);
        if (Long.numberOfLeadingZeros(l) + Long.numberOfLeadingZeros(l2) < 64) {
            throw new IllegalArgumentException("multiplication overflow");
        }
        long product = l * l2;
        if (product < 0L) {
            throw new IllegalArgumentException("multiplication overflow");
        }
        if (l == _a ^ l2 == _b) {
            return -product;
        }
        return product;
    }

    public FiniteDuration div(long divisor) {
        return this.$div(divisor);
    }

    public FiniteDuration mul(long factor) {
        return this.$times(factor);
    }

    @Override
    public FiniteDuration unary_$minus() {
        TimeUnit apply_unit = this.unit();
        long apply_length = -this.length();
        return new FiniteDuration(apply_length, apply_unit);
    }

    @Override
    public final boolean isFinite() {
        return true;
    }

    @Override
    public final FiniteDuration toCoarsest() {
        TimeUnit timeUnit = this.unit();
        TimeUnit timeUnit2 = TimeUnit.DAYS;
        if (!(timeUnit == null ? timeUnit2 != null : !((Object)((Object)timeUnit)).equals((Object)timeUnit2)) || this.length() == 0L) {
            return this;
        }
        return this.loop$1(this.length(), this.unit());
    }

    public boolean equals(Object other) {
        boolean bl;
        if (other instanceof FiniteDuration) {
            FiniteDuration finiteDuration = (FiniteDuration)other;
            bl = this.toNanos() == finiteDuration.toNanos();
        } else {
            bl = super.equals(other);
        }
        return bl;
    }

    public int hashCode() {
        return (int)this.toNanos();
    }

    public static final /* synthetic */ String $anonfun$new$1() {
        return "Duration is limited to +-(2^63-1)ns (ca. 292 years)";
    }

    private final FiniteDuration coarserOrThis$1(TimeUnit coarser, int divider, long length$1, TimeUnit unit$2) {
        if (length$1 % (long)divider == 0L) {
            return this.loop$1(length$1 / (long)divider, coarser);
        }
        TimeUnit timeUnit = unit$2;
        TimeUnit timeUnit2 = this.unit();
        if (!(timeUnit != null ? !((Object)((Object)timeUnit)).equals((Object)timeUnit2) : timeUnit2 != null)) {
            return this;
        }
        return new FiniteDuration(length$1, unit$2);
    }

    private final FiniteDuration loop$1(long length, TimeUnit unit) {
        FiniteDuration finiteDuration;
        if (((Object)((Object)TimeUnit.DAYS)).equals((Object)unit)) {
            finiteDuration = new FiniteDuration(length, unit);
        } else if (((Object)((Object)TimeUnit.HOURS)).equals((Object)unit)) {
            finiteDuration = this.coarserOrThis$1(TimeUnit.DAYS, 24, length, unit);
        } else if (((Object)((Object)TimeUnit.MINUTES)).equals((Object)unit)) {
            finiteDuration = this.coarserOrThis$1(TimeUnit.HOURS, 60, length, unit);
        } else if (((Object)((Object)TimeUnit.SECONDS)).equals((Object)unit)) {
            finiteDuration = this.coarserOrThis$1(TimeUnit.MINUTES, 60, length, unit);
        } else if (((Object)((Object)TimeUnit.MILLISECONDS)).equals((Object)unit)) {
            finiteDuration = this.coarserOrThis$1(TimeUnit.SECONDS, 1000, length, unit);
        } else if (((Object)((Object)TimeUnit.MICROSECONDS)).equals((Object)unit)) {
            finiteDuration = this.coarserOrThis$1(TimeUnit.MILLISECONDS, 1000, length, unit);
        } else if (((Object)((Object)TimeUnit.NANOSECONDS)).equals((Object)unit)) {
            finiteDuration = this.coarserOrThis$1(TimeUnit.MICROSECONDS, 1000, length, unit);
        } else {
            throw new MatchError((Object)unit);
        }
        return finiteDuration;
    }

    public FiniteDuration(long length, TimeUnit unit) {
        boolean bl;
        this.length = length;
        this.unit = unit;
        if (((Object)((Object)TimeUnit.NANOSECONDS)).equals((Object)unit)) {
            bl = this.bounded(Long.MAX_VALUE);
        } else if (((Object)((Object)TimeUnit.MICROSECONDS)).equals((Object)unit)) {
            bl = this.bounded(9223372036854775L);
        } else if (((Object)((Object)TimeUnit.MILLISECONDS)).equals((Object)unit)) {
            bl = this.bounded(9223372036854L);
        } else if (((Object)((Object)TimeUnit.SECONDS)).equals((Object)unit)) {
            bl = this.bounded(9223372036L);
        } else if (((Object)((Object)TimeUnit.MINUTES)).equals((Object)unit)) {
            bl = this.bounded(153722867L);
        } else if (((Object)((Object)TimeUnit.HOURS)).equals((Object)unit)) {
            bl = this.bounded(2562047L);
        } else if (((Object)((Object)TimeUnit.DAYS)).equals((Object)unit)) {
            bl = this.bounded(106751L);
        } else {
            long v = TimeUnit.DAYS.convert(length, unit);
            boolean bl2 = bl = -106751L <= v && v <= 106751L;
        }
        if (!bl) {
            throw new IllegalArgumentException(new StringBuilder(20).append("requirement failed: ").append((Object)"Duration is limited to +-(2^63-1)ns (ca. 292 years)").toString());
        }
    }
}

