/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.immutable;

import scala.collection.IndexedSeqOps;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.SeqOps;
import scala.collection.SortedIterableFactory;
import scala.collection.SortedSet;
import scala.collection.immutable.Range;
import scala.collection.immutable.RedBlackTree;
import scala.collection.immutable.RedBlackTree$;
import scala.collection.immutable.TreeSet;
import scala.collection.immutable.TreeSet$;
import scala.collection.mutable.ReusableBuilder;
import scala.math.Ordering;
import scala.math.Ordering$Int$;
import scala.runtime.ModuleSerializationProxy;

public final class TreeSet$
implements SortedIterableFactory<TreeSet> {
    public static final TreeSet$ MODULE$ = new TreeSet$();
    private static final long serialVersionUID = 3L;

    @Override
    public <A> TreeSet<A> empty(Ordering<A> evidence$1) {
        return new TreeSet<A>(evidence$1);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public <E> TreeSet<E> from(IterableOnce<E> it, Ordering<E> ordering) {
        void var3_9;
        if (it instanceof TreeSet) {
            TreeSet treeSet = (TreeSet)it;
            Ordering<E> ordering2 = ordering;
            Ordering ordering3 = treeSet.ordering();
            if (!(ordering2 != null ? !ordering2.equals(ordering3) : ordering3 != null)) {
                TreeSet treeSet2 = treeSet;
                return var3_9;
            }
        }
        if (it instanceof SortedSet) {
            SortedSet sortedSet = (SortedSet)it;
            Ordering<E> ordering4 = ordering;
            Ordering ordering5 = sortedSet.ordering();
            if (!(ordering4 != null ? !ordering4.equals(ordering5) : ordering5 != null)) {
                TreeSet treeSet = new TreeSet(RedBlackTree$.MODULE$.fromOrderedKeys(sortedSet.iterator(), sortedSet.size()), ordering);
                return var3_9;
            }
        }
        if (it instanceof Range) {
            Range range = (Range)it;
            if (ordering == Ordering$Int$.MODULE$ || Ordering.CachedReverse.isReverseOf$(Ordering$Int$.MODULE$, ordering)) {
                Iterator it2 = ordering == Ordering$Int$.MODULE$ == range.step() > 0 ? range.iterator() : IndexedSeqOps.reverseIterator$(range);
                RedBlackTree.Tree tree = RedBlackTree$.MODULE$.fromOrderedKeys(it2, SeqOps.size$(range));
                TreeSet treeSet = new TreeSet(tree, ordering);
                return var3_9;
            }
        }
        RedBlackTree.Tree<E, Object> t = null;
        Iterator<E> i = it.iterator();
        while (true) {
            if (!i.hasNext()) {
                TreeSet<E> treeSet = new TreeSet<E>(t, ordering);
                return var3_9;
            }
            t = RedBlackTree$.MODULE$.update(t, i.next(), null, false, ordering);
        }
    }

    @Override
    public <A> ReusableBuilder<A, TreeSet<A>> newBuilder(Ordering<A> ordering) {
        return new ReusableBuilder<A, TreeSet<A>>(ordering){
            private RedBlackTree.Tree<A, Object> tree;
            private final Ordering ordering$1;

            public anon.1 addOne(A elem) {
                this.tree = RedBlackTree$.MODULE$.update(this.tree, elem, null, false, this.ordering$1);
                return this;
            }

            /*
             * Enabled aggressive block sorting
             */
            public anon.1 addAll(IterableOnce<A> xs) {
                if (xs instanceof TreeSet) {
                    TreeSet treeSet = (TreeSet)xs;
                    Ordering ordering = this.ordering$1;
                    Ordering<A> ordering2 = treeSet.ordering();
                    if (!(ordering != null ? !ordering.equals(ordering2) : ordering2 != null)) {
                        this.tree = RedBlackTree$.MODULE$.union(this.tree, treeSet.tree(), this.ordering$1);
                        return this;
                    }
                }
                Iterator<A> it = xs.iterator();
                while (it.hasNext()) {
                    this.tree = RedBlackTree$.MODULE$.update(this.tree, it.next(), null, false, this.ordering$1);
                }
                return this;
            }

            public TreeSet<A> result() {
                if (this.tree == null) {
                    Ordering empty_evidence$1 = this.ordering$1;
                    return new TreeSet<A>(empty_evidence$1);
                }
                return new TreeSet<A>(this.tree, this.ordering$1);
            }

            public void clear() {
                this.tree = null;
            }
            {
                this.ordering$1 = ordering$1;
                this.tree = null;
            }
        };
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(TreeSet$.class);
    }

    private TreeSet$() {
    }
}

