/*
 * Decompiled with CFR 0.152.
 */
package org.tsugi.time;

import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.Date;
import org.apache.commons.httpclient.util.DateParseException;
import org.apache.commons.httpclient.util.DateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstantUtil {
    private static final Logger log = LoggerFactory.getLogger(InstantUtil.class);

    public static Instant parseGMTFormats(String dateString) {
        Instant retval = null;
        Date d = null;
        SimpleDateFormat format = null;
        try {
            retval = Instant.parse(dateString);
            if (retval != null) {
                return retval;
            }
        }
        catch (DateTimeParseException dateTimeParseException) {
            // empty catch block
        }
        try {
            format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
            d = format.parse(dateString);
            if (d != null && d.toInstant() != null) {
                return d.toInstant();
            }
        }
        catch (Exception e) {
            log.debug("Date parse error: {}", (Object)dateString);
        }
        try {
            d = DateUtil.parseDate((String)dateString);
            if (d != null && d.toInstant() != null) {
                return d.toInstant();
            }
        }
        catch (DateParseException e) {
            log.debug("Date parse error: {}", (Object)dateString);
        }
        return null;
    }
}

