/*
 * Decompiled with CFR 0.152.
 */
package net.oauth.client;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ExcerptInputStream
extends FilterInputStream {
    public static final byte[] ELLIPSIS = " ...".getBytes();
    private static final int LIMIT = 1024;
    private byte[] excerpt = new byte[1024 + ELLIPSIS.length];
    private int taken = 0;
    private int given = Integer.MAX_VALUE;

    public ExcerptInputStream(InputStream in) {
        super(in);
    }

    @Override
    public void close() throws IOException {
        super.close();
        byte[] complete = new byte[this.taken];
        System.arraycopy(this.excerpt, 0, complete, 0, this.taken);
        this.excerpt = complete;
    }

    public byte[] getExcerpt() throws IOException {
        if (this.taken < this.excerpt.length) {
            int mark = Math.min(this.given, this.taken);
            this.given = Integer.MAX_VALUE;
            while (this.taken < this.excerpt.length) {
                this.read(this.excerpt, this.taken, 1024 - this.taken);
            }
            this.given = mark;
        }
        return this.excerpt;
    }

    @Override
    public int read(byte[] b, int offset, int length) throws IOException {
        int r;
        int total = 0;
        if (this.given < this.taken) {
            int e = Math.min(length, this.taken - this.given);
            System.arraycopy(this.excerpt, this.given, b, offset, e);
            total += e;
            this.given += e;
            if (this.given < this.taken) {
                return total;
            }
            this.given = Integer.MAX_VALUE;
            offset += e;
            length -= e;
        }
        if ((r = super.read(b, offset, length)) > 0) {
            total += r;
            int e = Math.min(r, 1024 - this.taken);
            if (e >= 0) {
                System.arraycopy(b, offset, this.excerpt, this.taken, e);
                this.taken += e;
                if (this.taken >= 1024) {
                    System.arraycopy(ELLIPSIS, 0, this.excerpt, 1024, ELLIPSIS.length);
                    this.taken = this.excerpt.length;
                }
            }
        } else if (this.taken < this.excerpt.length) {
            byte[] complete = new byte[this.taken];
            System.arraycopy(this.excerpt, 0, complete, 0, this.taken);
            this.excerpt = complete;
        }
        return total > 0 ? total : r;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read() throws IOException {
        byte[] b = new byte[1];
        return this.read(b) <= 0 ? -1 : ExcerptInputStream.unsigned(b[0]);
    }

    public static byte[] copyAll(InputStream from, OutputStream into) throws IOException {
        ExcerptInputStream ex = new ExcerptInputStream(from);
        ex.copyAll(into);
        return ex.getExcerpt();
    }

    private void copyAll(OutputStream into) throws IOException {
        int n;
        byte[] b = new byte[1024];
        while (0 < (n = this.read(b))) {
            into.write(b, 0, n);
        }
    }

    private static int unsigned(byte b) {
        return b >= 0 ? b : b + 256;
    }
}

