/*
 * Decompiled with CFR 0.152.
 */
package org.sahli.asciidoc.confluence.publisher.converter;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringEscapeUtils;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.Options;
import org.asciidoctor.OptionsBuilder;
import org.asciidoctor.SafeMode;
import org.sahli.asciidoc.confluence.publisher.converter.AsciidocPagesStructureProvider;
import org.sahli.asciidoc.confluence.publisher.converter.NoOpPageTitlePostProcessor;
import org.sahli.asciidoc.confluence.publisher.converter.PageTitlePostProcessor;

public class AsciidocConfluencePage {
    private static final Pattern CDATA_PATTERN = Pattern.compile("<!\\[CDATA\\[.*?\\]\\]>", 32);
    private static final Pattern ATTACHMENT_PATH_PATTERN = Pattern.compile("<ri:attachment ri:filename=\"(.*?)\"");
    private static final Pattern PAGE_TITLE_PATTERN = Pattern.compile("<ri:page ri:content-title=\"(.*?)\"");
    private static final Asciidoctor ASCIIDOCTOR = Asciidoctor.Factory.create();
    private final String pageTitle;
    private final String htmlContent;
    private final Map<String, String> attachments;
    private final List<String> keywords;

    private AsciidocConfluencePage(String pageTitle, String htmlContent, Map<String, String> attachments, List<String> keywords) {
        this.pageTitle = pageTitle;
        this.htmlContent = htmlContent;
        this.attachments = attachments;
        this.keywords = keywords;
    }

    public String content() {
        return this.htmlContent;
    }

    public String pageTitle() {
        return this.pageTitle;
    }

    public Map<String, String> attachments() {
        return Collections.unmodifiableMap(this.attachments);
    }

    public List<String> keywords() {
        return Collections.unmodifiableList(this.keywords);
    }

    public static AsciidocConfluencePage newAsciidocConfluencePage(AsciidocPagesStructureProvider.AsciidocPage asciidocPage, Charset sourceEncoding, Path templatesDir, Path pageAssetsFolder) {
        return AsciidocConfluencePage.newAsciidocConfluencePage(asciidocPage, sourceEncoding, templatesDir, pageAssetsFolder, new NoOpPageTitlePostProcessor(), Collections.emptyMap(), "");
    }

    public static AsciidocConfluencePage newAsciidocConfluencePage(AsciidocPagesStructureProvider.AsciidocPage asciidocPage, Charset sourceEncoding, Path templatesDir, Path pageAssetsFolder, String spaceKey) {
        return AsciidocConfluencePage.newAsciidocConfluencePage(asciidocPage, sourceEncoding, templatesDir, pageAssetsFolder, new NoOpPageTitlePostProcessor(), Collections.emptyMap(), spaceKey);
    }

    public static AsciidocConfluencePage newAsciidocConfluencePage(AsciidocPagesStructureProvider.AsciidocPage asciidocPage, Charset sourceEncoding, Path templatesDir, Path pageAssetsFolder, Map<String, Object> userAttributes) {
        return AsciidocConfluencePage.newAsciidocConfluencePage(asciidocPage, sourceEncoding, templatesDir, pageAssetsFolder, new NoOpPageTitlePostProcessor(), userAttributes, "");
    }

    public static AsciidocConfluencePage newAsciidocConfluencePage(AsciidocPagesStructureProvider.AsciidocPage asciidocPage, Charset sourceEncoding, Path templatesDir, Path pageAssetsFolder, PageTitlePostProcessor pageTitlePostProcessor) {
        return AsciidocConfluencePage.newAsciidocConfluencePage(asciidocPage, sourceEncoding, templatesDir, pageAssetsFolder, pageTitlePostProcessor, Collections.emptyMap(), "");
    }

    public static AsciidocConfluencePage newAsciidocConfluencePage(AsciidocPagesStructureProvider.AsciidocPage asciidocPage, Charset sourceEncoding, Path templatesDir, Path pageAssetsFolder, PageTitlePostProcessor pageTitlePostProcessor, Map<String, Object> userAttributes) {
        return AsciidocConfluencePage.newAsciidocConfluencePage(asciidocPage, sourceEncoding, templatesDir, pageAssetsFolder, pageTitlePostProcessor, userAttributes, "");
    }

    public static AsciidocConfluencePage newAsciidocConfluencePage(AsciidocPagesStructureProvider.AsciidocPage asciidocPage, Charset sourceEncoding, Path templatesDir, Path pageAssetsFolder, PageTitlePostProcessor pageTitlePostProcessor, Map<String, Object> userAttributes, String spaceKey) {
        try {
            Path asciidocPagePath = asciidocPage.path();
            String asciidocContent = AsciidocConfluencePage.readIntoString(Files.newInputStream(asciidocPagePath, new OpenOption[0]), sourceEncoding);
            HashMap<String, String> attachmentCollector = new HashMap<String, String>();
            Map<String, Object> userAttributesWithMaskedNullValues = AsciidocConfluencePage.maskNullWithEmptyString(userAttributes);
            Options options = AsciidocConfluencePage.options(templatesDir, asciidocPagePath.getParent(), pageAssetsFolder, userAttributesWithMaskedNullValues);
            String pageContent = AsciidocConfluencePage.convertedContent(asciidocContent, options, asciidocPagePath, attachmentCollector, userAttributesWithMaskedNullValues, pageTitlePostProcessor, sourceEncoding, spaceKey);
            String pageTitle = AsciidocConfluencePage.pageTitle(asciidocContent, userAttributesWithMaskedNullValues, pageTitlePostProcessor);
            List<String> keywords = AsciidocConfluencePage.keywords(asciidocContent);
            return new AsciidocConfluencePage(pageTitle, pageContent, attachmentCollector, keywords);
        }
        catch (Exception e) {
            throw new RuntimeException("failed to create confluence page for asciidoc content in '" + asciidocPage.path().toAbsolutePath() + " '", e);
        }
    }

    private static String deriveAttachmentName(String path) {
        return path.contains("/") ? path.substring(path.lastIndexOf(47) + 1) : path;
    }

    private static String convertedContent(String adocContent, Options options, Path pagePath, Map<String, String> attachmentCollector, Map<String, Object> userAttributes, PageTitlePostProcessor pageTitlePostProcessor, Charset sourceEncoding, String spaceKey) {
        String content = ASCIIDOCTOR.convert(adocContent, options);
        String postProcessedContent = AsciidocConfluencePage.postProcessContent(content, AsciidocConfluencePage.replaceCrossReferenceTargets(pagePath, userAttributes, pageTitlePostProcessor, sourceEncoding, spaceKey), AsciidocConfluencePage.collectAndReplaceAttachmentFileNames(attachmentCollector), AsciidocConfluencePage.unescapeCdataHtmlContent());
        return postProcessedContent;
    }

    private static Function<String, String> unescapeCdataHtmlContent() {
        return content -> AsciidocConfluencePage.replaceAll(content, CDATA_PATTERN, matchResult -> StringEscapeUtils.unescapeHtml((String)matchResult.group()));
    }

    private static Function<String, String> collectAndReplaceAttachmentFileNames(Map<String, String> attachmentCollector) {
        return content -> AsciidocConfluencePage.replaceAll(content, ATTACHMENT_PATH_PATTERN, matchResult -> {
            String attachmentPath = matchResult.group(1);
            String attachmentFileName = AsciidocConfluencePage.deriveAttachmentName(attachmentPath);
            attachmentCollector.put(attachmentPath, attachmentFileName);
            return "<ri:attachment ri:filename=\"" + attachmentFileName + "\"";
        });
    }

    private static String replaceAll(String content, Pattern pattern, Function<MatchResult, String> replacer) {
        StringBuffer replacedContent = new StringBuffer();
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            matcher.appendReplacement(replacedContent, Matcher.quoteReplacement(replacer.apply(matcher.toMatchResult())));
        }
        matcher.appendTail(replacedContent);
        return replacedContent.toString();
    }

    @SafeVarargs
    private static String postProcessContent(String initialContent, Function<String, String> ... postProcessors) {
        return Arrays.stream(postProcessors).reduce(initialContent, (accumulator, postProcessor) -> (String)postProcessor.apply(accumulator), AsciidocConfluencePage.unusedCombiner());
    }

    private static String pageTitle(String pageContent, Map<String, Object> userAttributes, PageTitlePostProcessor pageTitlePostProcessor) {
        return Optional.ofNullable(ASCIIDOCTOR.readDocumentHeader(pageContent).getDocumentTitle()).map(title -> title.getMain()).map(title -> AsciidocConfluencePage.replaceUserAttributes(title, userAttributes)).map(pageTitle -> pageTitlePostProcessor.process((String)pageTitle)).orElseThrow(() -> new RuntimeException("top-level heading or title meta information must be set"));
    }

    private static Options options(Path templatesFolder, Path baseFolder, Path generatedAssetsTargetFolder, Map<String, Object> userAttributes) {
        if (!Files.exists(templatesFolder, new LinkOption[0])) {
            throw new RuntimeException("templateDir folder does not exist");
        }
        if (!Files.isDirectory(templatesFolder, new LinkOption[0])) {
            throw new RuntimeException("templateDir folder is not a folder");
        }
        HashMap<String, Object> attributes = new HashMap<String, Object>(userAttributes);
        attributes.put("imagesoutdir", generatedAssetsTargetFolder.toString());
        attributes.put("outdir", generatedAssetsTargetFolder.toString());
        attributes.put("source-highlighter", "none");
        return OptionsBuilder.options().backend("xhtml5").safe(SafeMode.UNSAFE).baseDir(baseFolder.toFile()).templateDirs(new File[]{templatesFolder.toFile()}).attributes(attributes).get();
    }

    private static Function<String, String> replaceCrossReferenceTargets(Path pagePath, Map<String, Object> userAttributes, PageTitlePostProcessor pageTitlePostProcessor, Charset sourceEncoding, String spaceKey) {
        return content -> AsciidocConfluencePage.replaceAll(content, PAGE_TITLE_PATTERN, matchResult -> {
            String htmlTarget = matchResult.group(1);
            Path referencedPagePath = pagePath.getParent().resolve(Paths.get(htmlTarget.substring(0, htmlTarget.lastIndexOf(46)) + ".adoc", new String[0]));
            try {
                String referencedPageContent = AsciidocConfluencePage.readIntoString(new FileInputStream(referencedPagePath.toFile()), sourceEncoding);
                String referencedPageTitle = AsciidocConfluencePage.pageTitle(referencedPageContent, userAttributes, pageTitlePostProcessor);
                return "<ri:page ri:content-title=\"" + referencedPageTitle + "\" ri:space-key=\"" + spaceKey + "\"";
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException("unable to find cross-referenced page '" + referencedPagePath + "'", e);
            }
        });
    }

    private static String replaceUserAttributes(String title, Map<String, Object> userAttributes) {
        return userAttributes.entrySet().stream().reduce(title, (accumulator, entry) -> accumulator.replace("{" + (String)entry.getKey() + "}", entry.getValue().toString()), AsciidocConfluencePage.unusedCombiner());
    }

    private static BinaryOperator<String> unusedCombiner() {
        return (a, b) -> a;
    }

    private static Map<String, Object> maskNullWithEmptyString(Map<String, Object> userAttributes) {
        return userAttributes.entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> entry.getValue() != null ? entry.getValue() : ""));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readIntoString(InputStream input, Charset encoding) {
        try (BufferedReader buffer = new BufferedReader(new InputStreamReader(input, encoding));){
            String string = buffer.lines().collect(Collectors.joining("\n"));
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read file content", e);
        }
    }

    private static List<String> keywords(String pageContent) {
        String keywords = (String)ASCIIDOCTOR.readDocumentHeader(pageContent).getAttributes().get("keywords");
        if (keywords == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(keywords.split(",")).map(String::trim).collect(Collectors.toList());
    }

    static {
        ASCIIDOCTOR.requireLibrary(new String[]{"asciidoctor-diagram"});
    }
}

