/*
 * Decompiled with CFR 0.152.
 */
package org.sahli.asciidoc.confluence.publisher.client.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.stream.Collectors;

public final class InputStreamUtils {
    private InputStreamUtils() {
        throw new UnsupportedOperationException("Utils class cannot be instantiated");
    }

    public static String inputStreamAsString(InputStream is, Charset encoding) {
        String string;
        BufferedReader buffer = new BufferedReader(new InputStreamReader(is, encoding));
        try {
            string = buffer.lines().collect(Collectors.joining("\n"));
        }
        catch (Throwable throwable) {
            try {
                try {
                    buffer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Could not convert InputStream to String ", e);
            }
        }
        buffer.close();
        return string;
    }

    public static String fileContent(String filePath, Charset encoding) {
        String string;
        FileInputStream fileInputStream = new FileInputStream(new File(filePath));
        try {
            string = InputStreamUtils.inputStreamAsString(fileInputStream, encoding);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Could not read file", e);
            }
        }
        fileInputStream.close();
        return string;
    }
}

