/*
 * Decompiled with CFR 0.152.
 */
package org.sahli.asciidoc.confluence.publisher.client.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.stream.Collectors;

public final class InputStreamUtils {
    private InputStreamUtils() {
        throw new UnsupportedOperationException("Utils class cannot be instantiated");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String inputStreamAsString(InputStream is, Charset encoding) {
        try (BufferedReader buffer = new BufferedReader(new InputStreamReader(is, encoding));){
            String string = buffer.lines().collect(Collectors.joining("\n"));
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not convert InputStream to String ", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String fileContent(String filePath, Charset encoding) {
        try (FileInputStream fileInputStream = new FileInputStream(new File(filePath));){
            String string = InputStreamUtils.inputStreamAsString(fileInputStream, encoding);
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read file", e);
        }
    }
}

