/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.storage.data;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.rundeck.storage.api.ContentFactory;
import org.rundeck.storage.api.ContentMeta;
import org.rundeck.storage.api.HasInputStream;
import org.rundeck.storage.data.DataContent;

public class DataUtil {
    public static DataContent dataWithText(String text) {
        return DataUtil.withText(text, DataUtil.contentFactory());
    }

    public static DataContent dataWithText(String text, Map<String, String> meta) {
        return DataUtil.withText(text, meta, DataUtil.contentFactory());
    }

    public static <T extends ContentMeta> T withText(String text, ContentFactory<T> factory) {
        return DataUtil.withText(text, null, factory);
    }

    public static <T extends ContentMeta> T withText(String text, Map<String, String> meta, ContentFactory<T> factory) {
        return (T)factory.create(DataUtil.lazyStream(new ByteArrayInputStream(text.getBytes())), meta);
    }

    public static DataContent dataWithBytes(byte[] data) {
        return DataUtil.withBytes(data, DataUtil.contentFactory());
    }

    public static <T extends ContentMeta> T withBytes(byte[] data, ContentFactory<T> factory) {
        return DataUtil.withBytes(data, null, factory);
    }

    public static <T extends ContentMeta> T withBytes(byte[] data, Map<String, String> meta, ContentFactory<T> factory) {
        return DataUtil.withStream(new ByteArrayInputStream(data), meta, factory);
    }

    public static <T extends ContentMeta> T withStream(InputStream source, ContentFactory<T> factory) {
        return DataUtil.withStream(source, new HashMap<String, String>(), factory);
    }

    public static <T extends ContentMeta> T withStream(InputStream source, Map<String, String> meta, ContentFactory<T> factory) {
        return (T)factory.create(DataUtil.lazyStream(source), meta);
    }

    public static HasInputStream lazyStream(final InputStream data) {
        return new HasInputStream(){

            public InputStream getInputStream() throws IOException {
                return data;
            }

            public long writeContent(OutputStream outputStream) throws IOException {
                return DataUtil.copyStream(data, outputStream);
            }
        };
    }

    public static ContentFactory<DataContent> contentFactory() {
        return new Factory();
    }

    public static long copyStream(InputStream in, OutputStream out) throws IOException {
        return DataUtil.copyStream(in, out, 10240);
    }

    public static long copyStream(InputStream in, OutputStream out, int bufsize) throws IOException {
        byte[] buffer = new byte[bufsize];
        long tot = 0L;
        int c = in.read(buffer);
        while (c >= 0) {
            if (c > 0) {
                out.write(buffer, 0, c);
                tot += (long)c;
            }
            c = in.read(buffer);
        }
        return tot;
    }

    public static HasInputStream lazyFileStream(final File data) {
        return new HasInputStream(){

            public InputStream getInputStream() throws IOException {
                return new FileInputStream(data);
            }

            public long writeContent(OutputStream outputStream) throws IOException {
                return DataUtil.copyStream(this.getInputStream(), outputStream);
            }
        };
    }

    private static class Factory
    implements ContentFactory<DataContent> {
        private Factory() {
        }

        public DataContent create(HasInputStream source, Map<String, String> meta) {
            return new DataContent(source, meta);
        }
    }
}

