/*
 * Decompiled with CFR 0.152.
 */
package org.romaframework.module.users.view.domain.portal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.romaframework.aspect.core.annotation.AnnotationConstants;
import org.romaframework.aspect.persistence.PersistenceAspect;
import org.romaframework.aspect.persistence.annotation.Persistence;
import org.romaframework.aspect.view.ViewCallback;
import org.romaframework.aspect.view.annotation.ViewField;
import org.romaframework.aspect.view.feature.ViewActionFeatures;
import org.romaframework.aspect.view.feature.ViewFieldFeatures;
import org.romaframework.aspect.view.portal.PortalPage;
import org.romaframework.aspect.view.portal.PortalPageContainer;
import org.romaframework.core.Roma;
import org.romaframework.core.schema.Feature;
import org.romaframework.core.schema.SchemaClassResolver;
import org.romaframework.frontend.domain.entity.ComposedEntityInstance;
import org.romaframework.frontend.domain.message.MessageOk;
import org.romaframework.module.users.domain.portal.PortalPreferences;
import org.romaframework.module.users.domain.portal.PortletList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletPreferencesConfiguration
extends ComposedEntityInstance<PortalPreferences>
implements ViewCallback {
    @ViewField(visible=AnnotationConstants.FALSE)
    protected String containerSelected;
    @ViewField(visible=AnnotationConstants.FALSE)
    protected String selectedPortletSelected;
    @ViewField(visible=AnnotationConstants.FALSE)
    protected String availablePortletSelected;
    @ViewField(render="list", selectionField="containerSelected", enabled=AnnotationConstants.FALSE)
    protected List<String> containers;
    @ViewField(render="list", selectionField="availablePortletSelected", enabled=AnnotationConstants.FALSE)
    protected List<String> availablePortlets = new ArrayList<String>();
    @ViewField(render="list", selectionField="selectedPortletSelected", enabled=AnnotationConstants.FALSE)
    protected List<String> selectedPortlets = new ArrayList<String>();
    @ViewField(visible=AnnotationConstants.FALSE)
    protected Map<String, String> classNamesMapper;

    public PortletPreferencesConfiguration(PortalPreferences iEntity) {
        super((Object)iEntity);
        this.containers = new ArrayList<String>();
        this.classNamesMapper = new HashMap<String, String>();
    }

    public List<String> getContainers() {
        return this.containers;
    }

    public String getContainerSelected() {
        return this.containerSelected;
    }

    public List<String> getAvailablePortlets() {
        return this.availablePortlets;
    }

    public String getSelectedPortletSelected() {
        return this.selectedPortletSelected;
    }

    public void setContainerSelected(String iContainerSelected) {
        if (this.containerSelected != null && this.containerSelected.equals(iContainerSelected)) {
            return;
        }
        if (iContainerSelected == null || iContainerSelected.equals("")) {
            Roma.setFeature((Object)((Object)this), (String)"availablePortlets", (Feature)ViewFieldFeatures.VISIBLE, (Object)Boolean.FALSE);
            Roma.setFeature((Object)((Object)this), (String)"selectedPortlets", (Feature)ViewFieldFeatures.VISIBLE, (Object)Boolean.FALSE);
        }
        this.containerSelected = iContainerSelected;
        Roma.setFeature((Object)((Object)this), (String)"availablePortlets", (Feature)ViewFieldFeatures.VISIBLE, (Object)Boolean.TRUE);
        Roma.setFeature((Object)((Object)this), (String)"selectedPortlets", (Feature)ViewFieldFeatures.VISIBLE, (Object)Boolean.TRUE);
        Roma.setFeature((Object)((Object)this), (String)"add", (Feature)ViewActionFeatures.VISIBLE, (Object)Boolean.TRUE);
        Roma.setFeature((Object)((Object)this), (String)"remove", (Feature)ViewActionFeatures.VISIBLE, (Object)Boolean.TRUE);
        Roma.setFeature((Object)((Object)this), (String)"addAll", (Feature)ViewActionFeatures.VISIBLE, (Object)Boolean.TRUE);
        Roma.setFeature((Object)((Object)this), (String)"removeAll", (Feature)ViewActionFeatures.VISIBLE, (Object)Boolean.TRUE);
        this.availablePortlets.clear();
        this.selectedPortlets.clear();
        this.availablePortletSelected = null;
        this.selectedPortletSelected = null;
        List portletSchemas = ((SchemaClassResolver)Roma.component(SchemaClassResolver.class)).getLanguageClassByInheritance(PortalPage.class);
        for (Class schema : portletSchemas) {
            String classLabel = Roma.i18n().get(schema.getSimpleName() + ".label", new Object[0]);
            if (classLabel == null || classLabel.equals("")) {
                classLabel = schema.getSimpleName();
            }
            this.classNamesMapper.put(classLabel, schema.getSimpleName());
            if (((PortalPreferences)this.entity).getPortletsInfos().get(this.classNamesMapper.get(this.containerSelected)) != null) {
                List<String> selected = ((PortalPreferences)this.entity).getPortletsInfos().get(this.classNamesMapper.get(this.containerSelected)).getPortlets();
                if (selected.contains(schema.getSimpleName())) {
                    this.selectedPortlets.add(classLabel);
                    continue;
                }
                this.availablePortlets.add(classLabel);
                continue;
            }
            this.availablePortlets.add(classLabel);
        }
        if (this.selectedPortlets.size() <= 0 || this.selectedPortlets.isEmpty()) {
            Roma.setFeature((Object)((Object)this), (String)"removeAll", (Feature)ViewActionFeatures.VISIBLE, (Object)Boolean.FALSE);
            Roma.setFeature((Object)((Object)this), (String)"addAll", (Feature)ViewActionFeatures.VISIBLE, (Object)Boolean.TRUE);
        }
        if (this.availablePortlets.size() <= 0 || this.availablePortlets.isEmpty()) {
            Roma.setFeature((Object)((Object)this), (String)"addAll", (Feature)ViewActionFeatures.VISIBLE, (Object)Boolean.FALSE);
            Roma.setFeature((Object)((Object)this), (String)"removeAll", (Feature)ViewActionFeatures.VISIBLE, (Object)Boolean.TRUE);
        }
        Roma.fieldChanged((Object)((Object)this), (String[])new String[]{"availablePortlets"});
        Roma.fieldChanged((Object)((Object)this), (String[])new String[]{"selectedPortlets"});
    }

    public void setSelectedPortletSelected(String portletSelected) {
        if (portletSelected != null) {
            this.selectedPortletSelected = portletSelected;
            this.setAvailablePortletSelected(null);
            Roma.setFeature((Object)((Object)this), (String)"add", (Feature)ViewActionFeatures.VISIBLE, (Object)Boolean.FALSE);
            Roma.setFeature((Object)((Object)this), (String)"remove", (Feature)ViewActionFeatures.VISIBLE, (Object)Boolean.TRUE);
            Roma.fieldChanged((Object)((Object)this), (String[])new String[]{"availablePortlets"});
        }
    }

    public String getAvailablePortletSelected() {
        return this.availablePortletSelected;
    }

    public void setAvailablePortletSelected(String availablePortletSelected) {
        if (availablePortletSelected != null) {
            this.availablePortletSelected = availablePortletSelected;
            this.setSelectedPortletSelected(null);
            Roma.setFeature((Object)((Object)this), (String)"add", (Feature)ViewActionFeatures.VISIBLE, (Object)Boolean.TRUE);
            Roma.setFeature((Object)((Object)this), (String)"remove", (Feature)ViewActionFeatures.VISIBLE, (Object)Boolean.FALSE);
            Roma.fieldChanged((Object)((Object)this), (String[])new String[]{"selectedPortlets"});
        }
    }

    public void onDispose() {
    }

    public void onShow() {
        this.availablePortlets.clear();
        this.containers.clear();
        List containerSchemas = ((SchemaClassResolver)Roma.component(SchemaClassResolver.class)).getLanguageClassByInheritance(PortalPageContainer.class);
        for (Class schema : containerSchemas) {
            String containerName = Roma.i18n().get(schema.getSimpleName() + ".label", new Object[0]);
            if (containerName == null || containerName.equals("")) {
                containerName = schema.getSimpleName();
            }
            this.classNamesMapper.put(containerName, schema.getSimpleName());
            this.containers.add(containerName);
        }
        if (this.containerSelected == null || this.containerSelected.equals("")) {
            Roma.setFeature((Object)((Object)this), (String)"availablePortlets", (Feature)ViewFieldFeatures.VISIBLE, (Object)Boolean.FALSE);
            Roma.setFeature((Object)((Object)this), (String)"selectedPortlets", (Feature)ViewFieldFeatures.VISIBLE, (Object)Boolean.FALSE);
            Roma.setFeature((Object)((Object)this), (String)"add", (Feature)ViewActionFeatures.VISIBLE, (Object)Boolean.FALSE);
            Roma.setFeature((Object)((Object)this), (String)"remove", (Feature)ViewActionFeatures.VISIBLE, (Object)Boolean.FALSE);
            Roma.setFeature((Object)((Object)this), (String)"addAll", (Feature)ViewActionFeatures.VISIBLE, (Object)Boolean.FALSE);
            Roma.setFeature((Object)((Object)this), (String)"removeAll", (Feature)ViewActionFeatures.VISIBLE, (Object)Boolean.FALSE);
        }
        Roma.fieldChanged((Object)((Object)this), (String[])new String[]{"containers"});
    }

    public void addAll() {
        ArrayList<String> availablePortlets = new ArrayList<String>();
        availablePortlets.addAll(this.availablePortlets);
        Iterator i$ = availablePortlets.iterator();
        while (i$.hasNext()) {
            String availablePortlet;
            this.availablePortletSelected = availablePortlet = (String)i$.next();
            this.add();
        }
    }

    public void removeAll() {
        ArrayList<String> selectedPortlets = new ArrayList<String>();
        selectedPortlets.addAll(this.selectedPortlets);
        Iterator i$ = selectedPortlets.iterator();
        while (i$.hasNext()) {
            String selectedPortlet;
            this.selectedPortletSelected = selectedPortlet = (String)i$.next();
            this.remove();
        }
    }

    public void add() {
        if (this.containerSelected != null) {
            if (this.availablePortletSelected != null && !this.availablePortletSelected.equals("")) {
                if (!((PortalPreferences)this.entity).getPortletsInfos().containsKey(this.classNamesMapper.get(this.containerSelected))) {
                    ArrayList<String> portlets = new ArrayList<String>();
                    portlets.add(this.classNamesMapper.get(this.selectedPortletSelected));
                    PortletList portletList = new PortletList();
                    portletList.setPortlets(portlets);
                    ((PortalPreferences)this.entity).getPortletsInfos().put(this.classNamesMapper.get(this.containerSelected), portletList);
                } else if (!((PortalPreferences)this.entity).getPortletsInfos().get(this.classNamesMapper.get(this.containerSelected)).getPortlets().contains(this.classNamesMapper.get(this.availablePortletSelected))) {
                    ((PortalPreferences)this.entity).getPortletsInfos().get(this.classNamesMapper.get(this.containerSelected)).getPortlets().add(this.classNamesMapper.get(this.availablePortletSelected));
                }
                this.selectedPortlets.add(this.availablePortletSelected);
                this.availablePortlets.remove(this.availablePortletSelected);
                this.availablePortletSelected = null;
                this.selectedPortletSelected = null;
                if (this.availablePortlets.size() <= 0 || this.availablePortlets.isEmpty()) {
                    Roma.setFeature((Object)((Object)this), (String)"add", (Feature)ViewActionFeatures.VISIBLE, (Object)Boolean.FALSE);
                    Roma.setFeature((Object)((Object)this), (String)"addAll", (Feature)ViewActionFeatures.VISIBLE, (Object)Boolean.FALSE);
                    Roma.setFeature((Object)((Object)this), (String)"removeAll", (Feature)ViewActionFeatures.VISIBLE, (Object)Boolean.TRUE);
                }
                Roma.fieldChanged((Object)((Object)this), (String[])new String[]{"availablePortlets"});
                Roma.fieldChanged((Object)((Object)this), (String[])new String[]{"selectedPortlets"});
            } else {
                this.showNoPortletSelectedMessage();
            }
        } else {
            this.showNoContainerSelectedMessage();
        }
    }

    public void remove() {
        if (this.containerSelected != null) {
            if (this.selectedPortletSelected != null && !this.selectedPortletSelected.equals("")) {
                while (((PortalPreferences)this.entity).getPortletsInfos().get(this.classNamesMapper.get(this.containerSelected)).getPortlets().contains(this.classNamesMapper.get(this.selectedPortletSelected))) {
                    ((PortalPreferences)this.entity).getPortletsInfos().get(this.classNamesMapper.get(this.containerSelected)).getPortlets().remove(this.classNamesMapper.get(this.selectedPortletSelected));
                }
                this.selectedPortlets.remove(this.selectedPortletSelected);
                this.availablePortlets.add(this.selectedPortletSelected);
                this.availablePortletSelected = null;
                this.selectedPortletSelected = null;
                if (this.selectedPortlets.size() <= 0 || this.selectedPortlets.isEmpty()) {
                    Roma.setFeature((Object)((Object)this), (String)"remove", (Feature)ViewActionFeatures.VISIBLE, (Object)Boolean.FALSE);
                    Roma.setFeature((Object)((Object)this), (String)"removeAll", (Feature)ViewActionFeatures.VISIBLE, (Object)Boolean.FALSE);
                    Roma.setFeature((Object)((Object)this), (String)"addAll", (Feature)ViewActionFeatures.VISIBLE, (Object)Boolean.TRUE);
                }
                Roma.fieldChanged((Object)((Object)this), (String[])new String[]{"availablePortlets"});
                Roma.fieldChanged((Object)((Object)this), (String[])new String[]{"selectedPortlets"});
            } else {
                this.showNoPortletSelectedMessage();
            }
        } else {
            this.showNoContainerSelectedMessage();
        }
    }

    @Persistence(mode="atomic")
    public void save() {
        PersistenceAspect db = this.getPersistenceAspect();
        Set<String> keys = ((PortalPreferences)this.entity).getPortletsInfos().keySet();
        for (String string : keys) {
            while (((PortalPreferences)this.entity).getPortletsInfos().get(string).getPortlets() != null && ((PortalPreferences)this.entity).getPortletsInfos().get(string).getPortlets().contains(null)) {
                ((PortalPreferences)this.entity).getPortletsInfos().get(string).getPortlets().remove(null);
            }
        }
        db.updateObject(this.entity);
        this.back();
    }

    public void cancel() {
        this.back();
    }

    protected void back() {
        Roma.flow().back();
    }

    private void showNoContainerSelectedMessage() {
        Roma.flow().popup((Object)new MessageOk("trackingModifyError", "Errore di selezione", null, "$PortletPreferencesConfiguration.noContainerSelected.error"));
    }

    private void showNoPortletSelectedMessage() {
        Roma.flow().popup((Object)new MessageOk("trackingModifyError", "Errore di selezione", null, "$PortletPreferencesConfiguration.noPortletSelected.error"));
    }

    public List<String> getSelectedPortlets() {
        return this.selectedPortlets;
    }

    private PersistenceAspect getPersistenceAspect() {
        return Roma.context().persistence();
    }
}

