/*
 * Decompiled with CFR 0.152.
 */
package org.romaframework.module.users.view.domain.baseaccount;

import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.romaframework.aspect.authentication.AuthenticationAspect;
import org.romaframework.aspect.core.annotation.AnnotationConstants;
import org.romaframework.aspect.persistence.Query;
import org.romaframework.aspect.persistence.QueryByFilter;
import org.romaframework.aspect.validation.CustomValidation;
import org.romaframework.aspect.validation.MultiValidationException;
import org.romaframework.aspect.validation.ValidationException;
import org.romaframework.aspect.validation.annotation.ValidationField;
import org.romaframework.aspect.view.annotation.ViewField;
import org.romaframework.core.Roma;
import org.romaframework.core.flow.ObjectContext;
import org.romaframework.frontend.domain.crud.CRUDInstance;
import org.romaframework.module.users.domain.BaseAccount;
import org.romaframework.module.users.domain.BaseAccountStatus;
import org.romaframework.module.users.domain.BaseGroup;
import org.romaframework.module.users.repository.BaseAccountStatusRepository;
import org.romaframework.module.users.view.domain.AccountManagementUtility;
import org.romaframework.module.users.view.domain.basegroup.BaseGroupSelectBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseAccountInstance
extends CRUDInstance<BaseAccount>
implements CustomValidation {
    private List<BaseAccountStatus> statuses;
    @ViewField(render="password")
    @ValidationField(required=AnnotationConstants.TRUE)
    protected String confirmPassword;
    protected boolean logoutAfterSave;
    @ViewField(render="objectembedded")
    protected BaseGroupSelectBox groups;
    @ViewField(render="password")
    protected String password;

    public void onShow() {
        super.onShow();
        this.statuses = ((BaseAccountStatusRepository)((Object)Roma.component(BaseAccountStatusRepository.class))).getAll();
        Roma.fieldChanged((Object)((Object)this), (String[])new String[]{"statuses"});
    }

    public void onCreate() {
        BaseAccount newAccount = new BaseAccount();
        this.setEntity(newAccount);
        ((BaseAccount)this.getEntity()).setSignedOn(new Date());
        ((BaseAccount)this.getEntity()).setLastModified(new Date());
        ((BaseAccount)this.getEntity()).setGroups(new HashSet<BaseGroup>());
        try {
            this.groups = new BaseGroupSelectBox(this.getEntity(), "groups");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        Roma.fieldChanged((Object)((Object)this), (String[])new String[]{"groups"});
        QueryByFilter qbf = new QueryByFilter(BaseAccountStatus.class);
        qbf.setStrategy((byte)2);
        qbf.addItem("name", QueryByFilter.FIELD_EQUALS, (Object)"Active");
        ((BaseAccount)this.getEntity()).setStatus((BaseAccountStatus)Roma.context().persistence().queryOne((Query)qbf));
        Roma.fieldChanged((Object)this.entity, (String[])new String[]{"status"});
    }

    public void onRead() {
        this.confirmPassword = ((BaseAccount)this.getEntity()).getPassword();
        this.password = ((BaseAccount)this.getEntity()).getPassword();
        Roma.fieldChanged((Object)((Object)this), (String[])new String[]{"confirmPassword"});
        try {
            this.groups = new BaseGroupSelectBox(this.getEntity(), "groups");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Roma.fieldChanged((Object)((Object)this), (String[])new String[]{"groups"});
    }

    public void onUpdate() {
        this.confirmPassword = ((BaseAccount)this.getEntity()).getPassword();
        this.password = ((BaseAccount)this.getEntity()).getPassword();
        Roma.fieldChanged((Object)((Object)this), (String[])new String[]{"confirmPassword"});
        BaseAccount current = (BaseAccount)((AuthenticationAspect)Roma.aspect(AuthenticationAspect.class)).getCurrentAccount();
        this.logoutAfterSave = current.equals(this.entity);
        try {
            this.groups = new BaseGroupSelectBox(this.getEntity(), "groups");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Roma.fieldChanged((Object)((Object)this), (String[])new String[]{"groups"});
    }

    public void validate() throws ValidationException {
        String encryptedPassword;
        MultiValidationException exs = new MultiValidationException();
        if (this.getPassword() != null && !this.getPassword().equals(this.confirmPassword)) {
            exs.addException(new ValidationException((Object)this, "confirmPassword", "$change.error", null));
        }
        if (!AccountManagementUtility.isPasswordMathedRegExpression(this.getPassword())) {
            exs.addException(new ValidationException((Object)this, "password", "$invalidPassword.error", null));
        }
        try {
            encryptedPassword = ((AuthenticationAspect)Roma.aspect(AuthenticationAspect.class)).encryptPassword(this.getPassword());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!AccountManagementUtility.isPasswordUnused((BaseAccount)this.getEntity(), encryptedPassword)) {
            exs.addException(new ValidationException((Object)this, "password", "$alreadyUsed.error", null));
        }
        if (exs.hasExceptions()) {
            throw exs;
        }
    }

    @ViewField(label="$status", render="select", selectionField="entity.status")
    public List<BaseAccountStatus> getStatuses() {
        return this.statuses;
    }

    public String getConfirmPassword() {
        return this.confirmPassword;
    }

    public void setConfirmPassword(String confirmPassword) throws NoSuchAlgorithmException {
        this.confirmPassword = confirmPassword;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public BaseGroupSelectBox getGroups() {
        return this.groups;
    }

    public void setGroups(BaseGroupSelectBox groups) {
        this.groups = groups;
    }

    public void save() {
        ((BaseAccount)this.entity).setPassword(this.password);
        super.save();
        if (this.logoutAfterSave) {
            ObjectContext.getInstance().logout();
        }
    }
}

