/*
 * Decompiled with CFR 0.152.
 */
package org.romaframework.module.users.view.domain.baseaccount;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.romaframework.aspect.authentication.AuthenticationAspect;
import org.romaframework.aspect.persistence.PersistenceAspect;
import org.romaframework.aspect.persistence.Query;
import org.romaframework.aspect.persistence.QueryByFilter;
import org.romaframework.aspect.persistence.QueryByFilterItem;
import org.romaframework.aspect.persistence.QueryByFilterItemGroup;
import org.romaframework.aspect.view.annotation.ViewClass;
import org.romaframework.core.Roma;
import org.romaframework.frontend.domain.crud.CRUDFilter;
import org.romaframework.frontend.domain.wrapper.SelectWrapper;
import org.romaframework.module.users.domain.BaseAccount;
import org.romaframework.module.users.domain.BaseGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ViewClass(label="")
public class BaseAccountFilter
extends CRUDFilter<BaseAccount> {
    protected SelectWrapper<BaseGroup> groups = this.loadGroupList();
    protected BaseGroup selectedGroup;

    public BaseAccountFilter() {
        super((Object)new BaseAccount());
    }

    public BaseAccountFilter(BaseAccount iAccount) {
        super((Object)iAccount);
    }

    private SelectWrapper<BaseGroup> loadGroupList() {
        PersistenceAspect db = Roma.context().persistence();
        Set<BaseGroup> userGroups = ((BaseAccount)db.refreshObject((Object)((BaseAccount)((AuthenticationAspect)Roma.component(AuthenticationAspect.class)).getCurrentAccount()), "full", (byte)2)).getGroups();
        if (userGroups == null || userGroups.size() == 0) {
            userGroups = new HashSet<BaseGroup>();
            QueryByFilter allGroupsQuery = new QueryByFilter(BaseGroup.class);
            allGroupsQuery.setStrategy((byte)2);
            List allGroups = db.query((Query)allGroupsQuery);
            if (allGroups != null && allGroups.size() > 0) {
                userGroups.addAll(allGroups);
            }
        }
        SelectWrapper result = new SelectWrapper(userGroups, (Object)this, "selectedGroup", true);
        return result;
    }

    public BaseGroup getSelectedGroup() {
        return this.selectedGroup;
    }

    public void setSelectedGroup(BaseGroup selectedGroup) {
        this.selectedGroup = selectedGroup;
    }

    public SelectWrapper<BaseGroup> getGroups() {
        return this.groups;
    }

    protected QueryByFilter getAdditionalFilter() {
        QueryByFilter query = super.getAdditionalFilter();
        if (query == null) {
            query = new QueryByFilter(BaseAccount.class);
        }
        if (this.getSelectedGroup() != null) {
            query.addItem("groups", QueryByFilter.FIELD_CONTAINS, (Object)this.getSelectedGroup());
        } else {
            Set<BaseGroup> userGroups = ((BaseAccount)Roma.context().persistence().refreshObject((Object)((BaseAccount)((AuthenticationAspect)Roma.component(AuthenticationAspect.class)).getCurrentAccount()), "full", (byte)2)).getGroups();
            if (userGroups != null && userGroups.size() > 0) {
                QueryByFilterItemGroup groupFilter = new QueryByFilterItemGroup("or");
                for (BaseGroup g : userGroups) {
                    groupFilter.addItem("groups", QueryByFilter.FIELD_CONTAINS, (Object)g);
                }
                query.addItem((QueryByFilterItem)groupFilter);
            }
        }
        if (((BaseAccount)this.getEntity()).getProfile() != null) {
            query.addItem("profile", QueryByFilter.FIELD_EQUALS, (Object)((BaseAccount)this.getEntity()).getProfile());
        }
        if (((BaseAccount)this.getEntity()).getName() != null) {
            query.addItem("name", QueryByFilter.FIELD_LIKE, (Object)((BaseAccount)this.getEntity()).getName());
        }
        if (((BaseAccount)this.getEntity()).getNotes() != null) {
            query.addItem("notes", QueryByFilter.FIELD_LIKE, (Object)((BaseAccount)this.getEntity()).getNotes());
        }
        if (query.getItems() == null || query.getItems().size() == 0) {
            return null;
        }
        return query;
    }
}

