/*
 * Decompiled with CFR 0.152.
 */
package org.romaframework.module.users.view.domain;

import java.security.NoSuchAlgorithmException;
import java.util.Date;
import org.romaframework.aspect.authentication.AuthenticationAspect;
import org.romaframework.aspect.core.annotation.CoreClass;
import org.romaframework.aspect.flow.FlowAspect;
import org.romaframework.aspect.i18n.I18NType;
import org.romaframework.aspect.session.SessionAccount;
import org.romaframework.aspect.view.annotation.ViewAction;
import org.romaframework.aspect.view.annotation.ViewField;
import org.romaframework.core.Roma;
import org.romaframework.frontend.domain.message.MessageOk;
import org.romaframework.frontend.domain.message.MessageResponseListener;
import org.romaframework.frontend.domain.page.Page;
import org.romaframework.module.users.UsersModule;
import org.romaframework.module.users.domain.BaseAccount;
import org.romaframework.module.users.repository.BaseAccountRepository;
import org.romaframework.module.users.view.domain.AccountManagementUtility;

@CoreClass(orderFields={"message oldPassword password confirmPassword"}, orderActions={"change cancel"})
public class ChangePassword
extends Page {
    @ViewField(render="password")
    private String oldPassword;
    @ViewField(render="password")
    private String password;
    @ViewField(render="password")
    private String confirmPassword;
    private MessageResponseListener listener;
    private BaseAccount account;

    public ChangePassword(BaseAccount iAccount, MessageResponseListener iListener) {
        this.account = iAccount;
        this.listener = iListener;
    }

    @ViewAction(render="button")
    public void cancel() {
        this.back();
    }

    @ViewAction(render="button")
    public void change() throws NoSuchAlgorithmException {
        if (this.password == null && this.confirmPassword == null) {
            return;
        }
        if (this.password == null || this.confirmPassword == null || !this.password.equals(this.confirmPassword)) {
            ((FlowAspect)Roma.aspect(FlowAspect.class)).popup((Object)new MessageOk("error", "", null, "$ChangePassword.change.error"));
            return;
        }
        String cypherOldPassword = null;
        if (this.oldPassword != null) {
            cypherOldPassword = ((AuthenticationAspect)Roma.aspect(AuthenticationAspect.class)).encryptPassword(this.oldPassword);
        }
        if (cypherOldPassword == null || !cypherOldPassword.equals(this.account.getPassword())) {
            Roma.flow().popup((Object)new MessageOk("error", "", null, "$ChangePassword.oldPassword.error"));
            return;
        }
        if (!AccountManagementUtility.isPasswordMathedRegExpression(this.password)) {
            Roma.flow().popup((Object)new MessageOk("error", "", null, "$ChangePassword.invalidPassword.error"));
            return;
        }
        if (!AccountManagementUtility.isPasswordUnused(this.account, this.password)) {
            Roma.flow().popup((Object)new MessageOk("error", "", null, "$ChangePassword.alreadyUsed.error"));
            return;
        }
        this.account.setPassword(this.password);
        this.account.setChangePasswordNextLogin(false);
        this.account.setLastModified(new Date());
        this.account.setLastPasswordUpdate(new Date());
        this.account = (BaseAccount)((BaseAccountRepository)((Object)Roma.component(BaseAccountRepository.class))).update(this.account, (byte)2);
        Roma.session().getActiveSessionInfo().setAccount((SessionAccount)this.account);
        String mess = "$ChangePassword.message.feature";
        Integer passwordPeriod = ((UsersModule)((Object)Roma.component(UsersModule.class))).getPasswordPeriod();
        Integer accountPeriod = ((UsersModule)((Object)Roma.component(UsersModule.class))).getAccountPeriod();
        if (passwordPeriod != null) {
            mess = mess + Roma.i18n().get(ChangePassword.class, "message.password", I18NType.LABEL, new Object[]{passwordPeriod});
        }
        if (accountPeriod != null) {
            Integer scadenza = Math.round(this.account.getLastModified().getTime() / 86400000L) + accountPeriod - Math.round(new Date().getTime() / 86400000L);
            mess = mess + Roma.i18n().get((Object)this, "message.account", I18NType.LABEL, new Object[]{scadenza});
        }
        Roma.flow().popup((Object)new MessageOk("CHANGE PASSWORD", "", null, mess));
        this.back();
        if (this.listener != null) {
            this.listener.responseMessage(null, (Object)Boolean.TRUE);
        }
    }

    @ViewField(render="label")
    public String getMessage() {
        return Roma.i18n().get("ChangePassword.message.text", new Object[0]);
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String userPassword) {
        this.password = userPassword;
    }

    public String getConfirmPassword() {
        return this.confirmPassword;
    }

    public void setConfirmPassword(String confirmPassword) {
        this.confirmPassword = confirmPassword;
    }

    public String getOldPassword() {
        return this.oldPassword;
    }

    public void setOldPassword(String oldPassword) {
        this.oldPassword = oldPassword;
    }
}

